/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.enums.model.PropTimeTypeEnum;
import kd.epm.epbs.common.enums.model.PropTypeEnum;
import kd.epm.epbs.common.model.cache.EpbsPropCacheHelper;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.formplugin.model.BaseMemberFormPlugin;
import kd.epm.epbs.formplugin.model.prop.vo.PropertyVo;

public class MemberPropFieldHelper {
    public static final String PROP_PREFIX = "prop_";

    public static PropertyVo buildPropertyVo(DynamicObject dynamicObject) {
        PropertyVo propertyVo = new PropertyVo();
        propertyVo.setNumber(dynamicObject.getString("number"));
        propertyVo.setName(dynamicObject.getString("name"));
        propertyVo.setScope(dynamicObject.getString("scope"));
        propertyVo.setType(dynamicObject.getString("datatype"));
        propertyVo.setBasedataId(dynamicObject.getLong("basedata"));
        propertyVo.setEnumId(dynamicObject.getLong("enum"));
        propertyVo.setRefdimensionId(dynamicObject.getLong("refdimension"));
        propertyVo.setTimetype(dynamicObject.getString("timetype"));
        propertyVo.setId(dynamicObject.getLong("id"));
        return propertyVo;
    }

    public static void initProp(BaseMemberFormPlugin formPlugin, Object bizModelId, Long dimensionId, Long viewId, boolean isCommon, Map<String, PropertyVo> propKeyMap) {
        String propAp = isCommon ? "commonproppanelap" : "privateproppanelap";
        FieldsetPanelAp fieldsetpanelap = new FieldsetPanelAp();
        fieldsetpanelap.setKey(propAp);
        fieldsetpanelap.setGrow(0);
        QFilter qFilter = new QFilter("dimension", "=", (Object)dimensionId);
        if (isCommon) {
            qFilter.and("scope", "=", (Object)"1");
        } else if (bizModelId != null && !Objects.equals(bizModelId, 0)) {
            qFilter.and(new QFilter("bizmodel", "=", bizModelId));
        } else {
            qFilter.and("scope", "=", (Object)"2");
        }
        DynamicObjectCollection propDys = QueryServiceHelper.query((String)formPlugin.getMetaDataEntity(formPlugin.getView(), "epbs_propertydefined"), (String)"id,number,name,scope,datatype,enum,basedata,refdimension,timetype", (QFilter[])qFilter.toArray(), (String)"createtime desc");
        for (DynamicObject dynamicObject : propDys) {
            PropertyVo propertyVo = MemberPropFieldHelper.buildPropertyVo(dynamicObject);
            EntryFieldAp propFieldAp = new EntryFieldAp();
            propFieldAp.setName(new LocaleString(propertyVo.getName()));
            if (PropTypeEnum.TIME.getValue().equals(propertyVo.getType())) {
                if (PropTimeTypeEnum.DATE.getValue().equals(propertyVo.getTimetype())) {
                    propFieldAp.setDisplayFormatString("yyyy-MM-dd");
                } else {
                    propFieldAp.setDisplayFormatString("yyyy-MM-dd HH:mm:ss");
                }
            }
            Field<?> field = MemberPropFieldHelper.getField(propertyVo, propKeyMap);
            propFieldAp.setKey(field.getKey());
            propFieldAp.setLabelDirection("v");
            propFieldAp.setShowTitle(true);
            propFieldAp.setField(field);
            propFieldAp.setFireUpdEvt(true);
            propFieldAp.setQuickAddNew(false);
            fieldsetpanelap.getItems().add(propFieldAp);
            formPlugin.addClickListeners(new String[]{field.getKey()});
        }
        formPlugin.getView().updateControlMetadata(propAp, fieldsetpanelap.createControl());
        formPlugin.getView().updateView(propAp);
    }

    public static Field<?> getField(PropertyVo propertyVo, Map<String, PropertyVo> propKeyMap) {
        BasedataField field;
        PropTypeEnum propTypeEnum = PropTypeEnum.getPropTypeEnum((String)propertyVo.getType());
        String number = propertyVo.getNumber().toLowerCase();
        String propKey = PROP_PREFIX + propTypeEnum.name().toLowerCase() + "_" + number;
        PropTimeTypeEnum timePropTypeEnum = null;
        if (propTypeEnum == PropTypeEnum.TIME) {
            String timetype = propertyVo.getTimetype();
            timePropTypeEnum = PropTimeTypeEnum.get((String)timetype);
            propKey = PROP_PREFIX + propTypeEnum.name().toLowerCase() + "_" + timePropTypeEnum.name().toLowerCase() + "_" + number;
        }
        propKeyMap.put(propKey, propertyVo);
        if (propTypeEnum.isHasPropValue()) {
            BasedataField basedataField = new BasedataField();
            basedataField.setViewDetail(false);
            field = basedataField;
        } else if (propTypeEnum == PropTypeEnum.TIME) {
            if (timePropTypeEnum == PropTimeTypeEnum.DATE) {
                field = new DateField();
            } else {
                DateTimeField timeField = new DateTimeField();
                timeField.setDefValue(null);
                field = timeField;
            }
        } else if (propTypeEnum == PropTypeEnum.NUMBER) {
            field = new IntegerField();
        } else {
            TextField textField = new TextField();
            textField.setEditStyle(0);
            textField.setMaxLength(255);
            field = textField;
        }
        field.setId(propKey);
        field.setKey(propKey);
        field.setFieldName(propertyVo.getName());
        return field;
    }

    public static void registDynamicProps(BaseMemberFormPlugin formPlugin, MainEntityType newMainType, Map<String, PropertyVo> propKeyMap) {
        for (Map.Entry<String, PropertyVo> entry : propKeyMap.entrySet()) {
            String propKey = entry.getKey();
            PropertyVo propertyVo = entry.getValue();
            String type = propertyVo.getType();
            PropTypeEnum propTypeEnum = PropTypeEnum.getPropTypeEnum((String)type);
            if (propTypeEnum.isHasPropValue()) {
                BasedataProp basedataProp = new BasedataProp();
                LongProp idprop = new LongProp();
                idprop.setDbIgnore(true);
                idprop.setName(propKey + "_id");
                basedataProp.setName(propKey);
                basedataProp.setBaseEntityId(formPlugin.getMetaDataEntity(formPlugin.getView(), "epbs_propertydefinedvalue"));
                basedataProp.setDbIgnore(true);
                basedataProp.setDisplayName(new LocaleString(propertyVo.getName()));
                basedataProp.setAlias("");
                basedataProp.setRefIdProp((IDataEntityProperty)idprop);
                basedataProp.setRefIdPropName(idprop.getName());
                basedataProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)basedataProp.getBaseEntityId()));
                newMainType.addProperty((DynamicProperty)((LongProp)basedataProp.getRefIdProp()));
                newMainType.registerComplexProperty((DynamicComplexProperty)basedataProp);
                continue;
            }
            if (PropTypeEnum.TIME == propTypeEnum) {
                DateProp fieldProp;
                if (PropTimeTypeEnum.DATE.getValue().equals(propertyVo.getTimetype())) {
                    fieldProp = MemberPropFieldHelper.getFieldProp(propertyVo, propKey, DateProp.class);
                    newMainType.registerSimpleProperty((DynamicSimpleProperty)fieldProp);
                    continue;
                }
                fieldProp = MemberPropFieldHelper.getFieldProp(propertyVo, propKey, DateTimeProp.class);
                newMainType.registerSimpleProperty((DynamicSimpleProperty)fieldProp);
                continue;
            }
            if (PropTypeEnum.NUMBER == propTypeEnum) {
                newMainType.registerSimpleProperty((DynamicSimpleProperty)MemberPropFieldHelper.getFieldProp(propertyVo, propKey, IntegerProp.class));
                continue;
            }
            newMainType.registerSimpleProperty((DynamicSimpleProperty)MemberPropFieldHelper.getFieldProp(propertyVo, propKey, TextProp.class));
        }
    }

    private static <T extends FieldProp> T getFieldProp(PropertyVo propertyVo, String propName, Class<T> clazz) {
        FieldProp prop;
        try {
            prop = (FieldProp)clazz.newInstance();
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        prop.setDisplayName(new LocaleString(propertyVo.getName()));
        prop.setName(propName);
        prop.setDbIgnore(true);
        return (T)prop;
    }

    public static void getEntityType(BaseMemberFormPlugin formPlugin, GetEntityTypeEventArgs e, Map<String, PropertyVo> propKeyMap) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDBizException(exp.getMessage());
        }
        MemberPropFieldHelper.registDynamicProps(formPlugin, newMainType, propKeyMap);
        e.setNewEntityType(newMainType);
    }

    public static void onGetControl(BaseMemberFormPlugin formPlugin, IFormView formView, IDataModel dataModel, OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if (ctrlKey.startsWith(PROP_PREFIX)) {
            Object fieldEdit;
            Map<String, PropertyVo> propKeyMap = formPlugin.getPropKeyMap();
            PropertyVo propertyVo = propKeyMap.get(ctrlKey);
            String type = propertyVo.getType();
            PropTypeEnum propTypeEnum = PropTypeEnum.getPropTypeEnum((String)type);
            if (propTypeEnum.isHasPropValue()) {
                BasedataEdit basedataEdit = new BasedataEdit();
                basedataEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                    QFilter qFilter = new QFilter("property", "=", (Object)propertyVo.getId());
                    ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
                });
                fieldEdit = basedataEdit;
            } else if (PropTypeEnum.TIME == propTypeEnum) {
                fieldEdit = PropTimeTypeEnum.DATE.getValue().equals(propertyVo.getTimetype()) ? new DateEdit() : new DateTimeEdit();
            } else {
                TextEdit edit = new TextEdit();
                edit.addClickListener((ClickListener)formPlugin);
                fieldEdit = edit;
            }
            fieldEdit.setKey(ctrlKey);
            fieldEdit.setModel(dataModel);
            fieldEdit.setView(formView);
            e.setControl((Control)fieldEdit);
        }
    }

    public static void saveProp(BaseMemberFormPlugin formPlugin, IDataModel dataModel, Map<String, PropertyVo> propKeyMap, Long memberId, Long dimensionId) {
        ArrayList<DynamicObject> propList = new ArrayList<DynamicObject>(propKeyMap.size());
        for (Map.Entry<String, PropertyVo> entry : propKeyMap.entrySet()) {
            String key = entry.getKey();
            PropertyVo propertyVo = entry.getValue();
            Object value = dataModel.getDataEntity(true).get(key);
            PropTypeEnum propTypeEnum = PropTypeEnum.getPropTypeEnum((String)propertyVo.getType());
            if (propTypeEnum.isHasPropValue()) {
                value = dataModel.getDataEntity(true).get(key + "_id");
                if (Objects.equals(0L, value)) continue;
            }
            if (value == null) continue;
            if (PropTypeEnum.TIME == propTypeEnum) {
                value = MemberPropFieldHelper.getDataFormat(propertyVo).format((Date)dataModel.getValue(key));
            }
            if (value instanceof String && StringUtils.isEmpty((String)((String)value))) continue;
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)formPlugin.getMetaDataEntity(formPlugin.getView(), "epbs_membpropval"));
            dynamicObject.set("model", dataModel.getValue("model"));
            dynamicObject.set("dimension", (Object)dimensionId);
            dynamicObject.set("memberid", (Object)memberId);
            dynamicObject.set("propertydefined", (Object)propertyVo.getId());
            dynamicObject.set("propval", value);
            propList.add(dynamicObject);
        }
        DeleteServiceHelper.delete((String)formPlugin.getMetaDataEntity(formPlugin.getView(), "epbs_membpropval"), (QFilter[])new QFilter("memberid", "=", (Object)memberId).toArray());
        if (!propList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])propList.toArray(new DynamicObject[0]));
        }
        EpbsPropCacheHelper.invalidate((long)dimensionId);
    }

    private static SimpleDateFormat getDataFormat(PropertyVo propertyVo) {
        SimpleDateFormat dateFormat = PropTimeTypeEnum.DATE.getValue().equals(propertyVo.getTimetype()) ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat;
    }

    public static void setPropValue(BaseMemberFormPlugin formPlugin, IDataModel dataModel, Map<String, PropertyVo> propKeyMap) {
        Long memberId = (Long)dataModel.getValue("member_id");
        if (IDUtils.isNotNull((Long)memberId)) {
            DynamicObjectCollection propValList = QueryServiceHelper.query((String)formPlugin.getMetaDataEntity(formPlugin.getView(), "epbs_membpropval"), (String)"propertydefined,propval", (QFilter[])new QFilter("memberid", "=", (Object)memberId).toArray());
            Map<Long, String> propValMap = propValList.stream().collect(Collectors.toMap(o -> o.getLong("propertydefined"), o -> o.getString("propval"), (existing, replacement) -> existing));
            for (Map.Entry<String, PropertyVo> entry : propKeyMap.entrySet()) {
                String propKey = entry.getKey();
                PropertyVo propertyVo = entry.getValue();
                String value = propValMap.get(propertyVo.getId());
                dataModel.setValue(propKey, (Object)value);
            }
        }
    }
}

