/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.enums.model.DayEnum;
import kd.epm.epbs.common.model.IMetaDataEntity;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;

public class PeriodMemberFormPlugin
extends AbstractFormPlugin
implements IMetaDataEntity {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)((Long)this.getModel().getValue("model_id")));
        DynamicObject member = (DynamicObject)this.getModel().getValue("member");
        if (member != null) {
            DimTypeBean dimTypeBean = modelCache.getDimTypeByDimensionId(((Long)this.getModel().getValue("dimension_id")).longValue());
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)member.getPkValue(), (String)dimTypeBean.getBaseMemberModel(), (String)"startyear,startmonth,startday,endyear,endmonth,endday");
            this.getModel().setValue("startyear", dynamicObject.get("startyear"));
            this.getModel().setValue("startmonth", dynamicObject.get("startmonth"));
            this.getModel().setValue("startday", dynamicObject.get("startday"));
            this.getModel().setValue("endyear", dynamicObject.get("endyear"));
            this.getModel().setValue("endmonth", dynamicObject.get("endmonth"));
            this.getModel().setValue("endday", dynamicObject.get("endday"));
        }
        String startMonth = (String)this.getModel().getValue("startmonth");
        String endMonth = (String)this.getModel().getValue("endmonth");
        this.createDayItem("startday", startMonth, false);
        this.createDayItem("endday", endMonth, false);
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("startmonth".equals(name)) {
            this.createDayItem("startday", (String)changeData.getNewValue(), true);
        } else if ("endmonth".equals(name)) {
            this.createDayItem("endday", (String)changeData.getNewValue(), true);
        }
    }

    private void createDayItem(String key, String monthStr, boolean setDefault) {
        if (StringUtils.isNotEmpty((String)monthStr)) {
            int month = Integer.parseInt(monthStr);
            int max = 31;
            if (month == 2) {
                max = 29;
            } else if (month == 4 || month == 6 || month == 9 || month == 11) {
                max = 30;
            }
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(max);
            ComboEdit control = (ComboEdit)this.getControl(key);
            for (int i = 1; i <= max; ++i) {
                String value = String.valueOf(i);
                items.add(new ComboItem(DayEnum.get((String)value).getBridge().getLocaleString(), value));
            }
            control.setComboItems(items);
            if (setDefault) {
                this.getModel().setValue(key, (Object)((ComboItem)items.get(0)).getValue());
            }
        }
    }
}

