/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.enums.model.DayEnum;
import kd.epm.epbs.common.enums.model.PeriodTypeEnum;
import kd.epm.epbs.common.util.DateBean;
import kd.epm.epbs.common.util.DateTimeUtils;
import kd.epm.epbs.formplugin.AbstractBaseFormPlugin;

public class PeriodViewFormPlugin
extends AbstractBaseFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String startMonth = (String)this.getModel().getValue("startmonth");
        if (formShowParameter.getStatus() == OperationStatus.ADDNEW) {
            long dimensionId = (Long)this.getModel().getValue("dimension_id");
            QFilter qFilter = new QFilter("dimension", "=", (Object)dimensionId).and("isgroup", "=", (Object)true);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.getMetaDataEntity(this.getView(), "epbs_period_view"), (String)"id", (QFilter[])qFilter.toArray());
            this.getModel().setValue("parent", (Object)dynamicObject.getLong("id"));
            this.createDayItem(startMonth, true, "startday");
            this.setDefaultNumber((String)this.getModel().getValue("periodtype"));
        } else if (formShowParameter.getStatus() == OperationStatus.EDIT) {
            this.getView().setEnable(Boolean.valueOf((Boolean)this.getModel().getValue("iscrehalf") == false), new String[]{"iscrehalf"});
            this.getView().setEnable(Boolean.valueOf((Boolean)this.getModel().getValue("iscrequarter") == false), new String[]{"iscrequarter"});
            this.createDayItem(startMonth, false, "startday");
        }
        this.createDayItem("12", false, "endday");
        this.getModel().setDataChanged(false);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("startmonth".equals(name)) {
            this.createDayItem((String)changeData.getNewValue(), true, "startday");
            this.setEndDate();
        } else if ("startday".equals(name) || "startyear".equals(name)) {
            this.setEndDate();
        } else if ("periodtype".equals(name)) {
            String periodType = (String)changeData.getNewValue();
            this.setDefaultNumber(periodType);
        }
    }

    private void setDefaultNumber(String periodType) {
        String number;
        long dimensionId = (Long)this.getModel().getValue("dimension_id");
        QFilter qFilter = new QFilter("dimension", "=", (Object)dimensionId).and("isdefault", "=", (Object)false);
        if (PeriodTypeEnum.CUSTOM.getValue().equals(periodType)) {
            number = "Z";
            qFilter.and("periodtype", "=", (Object)PeriodTypeEnum.CUSTOM.getValue());
        } else {
            number = "P";
            qFilter.and("periodtype", "!=", (Object)PeriodTypeEnum.CUSTOM.getValue());
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.getMetaDataEntity(this.getView(), "epbs_period_view"), (String)"number", (QFilter[])qFilter.toArray());
        int max = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            try {
                String _number = dynamicObject.getString("number");
                max = Math.max(max, Integer.parseInt(_number.substring(1)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        number = number + (max + 1);
        this.getModel().setValue("number", (Object)number);
    }

    private void setEndDate() {
        int year = Integer.parseInt((String)this.getModel().getValue("startyear"));
        int startMonth = Integer.parseInt((String)this.getModel().getValue("startmonth"));
        int startDay = Integer.parseInt((String)this.getModel().getValue("startday"));
        DateBean dateBean = DateTimeUtils.getPreviousDayOfNextYearSameDay((int)year, (int)startMonth, (int)startDay);
        this.getModel().setValue("endyear", (Object)String.valueOf(dateBean.getYear()));
        this.getModel().setValue("endmonth", (Object)String.valueOf(dateBean.getMonth()));
        this.getModel().setValue("endday", (Object)String.valueOf(dateBean.getDay()));
    }

    private void createDayItem(String monthStr, boolean setDefault, String key) {
        if (StringUtils.isNotEmpty((String)monthStr)) {
            int month = Integer.parseInt(monthStr);
            int max = 31;
            if (month == 2) {
                max = 29;
            } else if (month == 4 || month == 6 || month == 9 || month == 11) {
                max = 30;
            }
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(max);
            ComboEdit control = (ComboEdit)this.getControl(key);
            for (int i = 1; i <= max; ++i) {
                String value = String.valueOf(i);
                items.add(new ComboItem(DayEnum.get((String)value).getBridge().getLocaleString(), value));
            }
            control.setComboItems(items);
            if (setDefault) {
                this.getModel().setValue(key, (Object)((ComboItem)items.get(0)).getValue());
            }
        }
    }
}

