/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model;

import java.util.Objects;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.epm.epbs.common.enums.model.ViewScopeEnum;
import kd.epm.epbs.common.model.IMetaDataEntity;
import kd.epm.epbs.common.tree.DynamicTreeContext;
import kd.epm.epbs.formplugin.treelist.AbstractTreeListF7Plugin;

public class ViewTreeListF7Plugin
extends AbstractTreeListF7Plugin
implements IMetaDataEntity {
    protected DynamicTreeContext getDynamicTreeContext() {
        QFilter qFilter = this.getGroupFilter();
        DynamicTreeContext context = new DynamicTreeContext(this.getMetaDataEntity(this.getView(), "epbs_struct_view"));
        context.setSelectFields("id,number,name,parent");
        context.setOrderby("createtime");
        context.setqFilters(qFilter.toArray());
        context.setMultiRoot(true);
        context.setClickFirstChild(true);
        return context;
    }

    private QFilter getGroupFilter() {
        Object dimension = this.getView().getFormShowParameter().getCustomParam("dimensionId");
        QFilter qFilter = new QFilter("dimension", "=", dimension).and("isgroup", "=", (Object)true);
        QFilter typeFilter = new QFilter("type", "=", (Object)ViewScopeEnum.COMMOM.getValue());
        Object bizModelId = this.getView().getFormShowParameter().getCustomParam("bizModelId");
        if (bizModelId != null && !Objects.equals(bizModelId, 0)) {
            typeFilter.or("bizmodel", "=", bizModelId);
        }
        qFilter.and(typeFilter);
        return qFilter;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object dimension = this.getView().getFormShowParameter().getCustomParam("dimensionId");
        String focusNodeId = this.getFocusNodeId();
        e.addCustomQFilter(new QFilter("dimension", "=", dimension));
        e.addCustomQFilter(new QFilter("isgroup", "=", (Object)false));
        if (focusNodeId != null) {
            try {
                e.addCustomQFilter(new QFilter("parent", "=", (Object)Long.parseLong(focusNodeId)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

