/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.bizmodel;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.epm.epbs.business.model.bizmodel.BizModelServiceHelper;
import kd.epm.epbs.business.olap.OlapServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.DefaultDimensionEnum;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.enums.model.BizModelCreateTypeEnum;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.model.IMetaDataEntity;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.thread.EpbsThreadPools;
import kd.epm.epbs.common.util.GZIPUtils;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;
import kd.epm.epbs.common.util.QFBuilder;
import kd.epm.epbs.common.util.TXUtils;
import kd.epm.epbs.common.util.UserUtils;
import kd.epm.epbs.formplugin.AbstractBaseFormPlugin;
import kd.epm.epbs.formplugin.model.ViewTreeF7SelectListener;
import org.jetbrains.annotations.NotNull;

public class BizModelDomainFormPlugin
extends AbstractBaseFormPlugin
implements RowClickEventListener,
IMetaDataEntity {
    protected static final WatchLogger logger = EpbsLogFactory.getWatchLogInstance(BizModelDomainFormPlugin.class);
    public static final List<String> defaultDimList = Arrays.asList(DimTypeEnum.Entity.getValue(), DimTypeEnum.Account.getValue(), DimTypeEnum.Year.getValue(), DimTypeEnum.Period.getValue());
    public static final String DEFAULT_DIMTYPE_CACHE = "default_dimtype_cache";
    public static final String DEFAULT_DIMAINTYPE_CACHE = "default_dimaintype_cache";
    public static final String VIEW_CACHE = "view_cache";
    public static final String OLD_VIEW_CACHE = "old_view_cache";
    public static final String ID_CACHE = "id_cache";
    public static final String ID_CACHE_CHANGE = "id_cache_change";
    private static final String WD_ID_TEMP = "wd_id_temp";

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit dimview = (BasedataEdit)this.getControl("dimview");
        ViewTreeF7SelectListener viewTreeF7SelectListener = new ViewTreeF7SelectListener(this, this.getDimensionId());
        if (this.getMetaDataEntity(this.getView(), "epbs_bizmodel").equals(this.getModel().getValue("modelentity"))) {
            String idData = this.getPageCache().get(ID_CACHE);
            Long id = this.getId();
            if (!StringUtils.isBlank((CharSequence)idData)) {
                id = Long.parseLong(idData);
            }
            viewTreeF7SelectListener.setBizModelId(id);
        }
        viewTreeF7SelectListener.setSelectRows(new Object[0]);
        dimview.addBeforeF7SelectListener((BeforeF7SelectListener)viewTreeF7SelectListener);
        EntryGrid entryGrid = (EntryGrid)this.getControl("dimlist");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"advconbaritemap3", "advconbaritemap4"});
    }

    public boolean checkDimRefChanged(Boolean removeflag) {
        return this.checkDimRefChanged(removeflag, true);
    }

    public boolean checkDimRefChanged(Boolean removeflag, Boolean showMsgFlag) {
        String idCacheChange;
        if (removeflag.booleanValue()) {
            this.getPageCache().put(ID_CACHE_CHANGE, "");
            return true;
        }
        String bizmodelId = this.getPageCache().get(ID_CACHE);
        if (StringUtils.isNotBlank((CharSequence)bizmodelId) && StringUtils.isNotBlank((CharSequence)(idCacheChange = this.getPageCache().get(ID_CACHE_CHANGE))) && bizmodelId.equals(idCacheChange)) {
            if (showMsgFlag.booleanValue()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u8be5\u6a21\u578b\u5728\u7ef4\u5ea6\u7ba1\u7406\u5bf9\u7ef4\u5ea6\u8fdb\u884c\u4fee\u6539\uff0c\u5f53\u524d\u9875\u9762\u5df2\u5237\u65b0\u3002", (String)"BizModelDomainFormPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            }
            this.refreshDimListData();
            this.getPageCache().put(ID_CACHE_CHANGE, "");
            return false;
        }
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"disableflex", "enableflex"});
        this.createDimList();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"dimview", "aggoprttype"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"baseinfoap"});
        this.getModel().setDataChanged(false);
    }

    public void createDimList() {
        String modelentity = (String)this.getModel().getValue("modelentity");
        String idData = this.getPageCache().get(ID_CACHE);
        Long id = this.getId();
        if (!StringUtils.isBlank((CharSequence)idData)) {
            id = Long.parseLong(idData);
        }
        if (this.getMetaDataEntity(this.getView(), "epbs_businessdomain").equals(modelentity)) {
            this.getModel().deleteEntryData("dimlist");
            this.getPageCache().remove(DEFAULT_DIMAINTYPE_CACHE);
        }
        if (id != 0L) {
            DynamicObject dynamicObject;
            if (this.getMetaDataEntity(this.getView(), "epbs_businessdomain").equals(modelentity)) {
                dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)modelentity, (String)"number,name");
                this.getModel().setValue("number", dynamicObject.get("number"));
                this.getModel().setValue("name", dynamicObject.get("name"));
            } else {
                dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)modelentity, (String)"model,number,name,priority,cubenumber,enable");
                this.getModel().setValue("number", dynamicObject.get("number"));
                this.getModel().setValue("name", dynamicObject.get("name"));
                this.getModel().setValue("priorityvalue", dynamicObject.get("priority"));
                this.getModel().setValue("cubenumber", dynamicObject.get("cubenumber"));
                String enable = dynamicObject.getString("enable");
                if ("1".equals(enable)) {
                    this.lockOrUnlockView(true);
                    this.getModel().setValue("enable", (Object)"1");
                    this.setEnableflexVisible(true);
                } else if ("2".equals(enable)) {
                    this.lockOrUnlockView(false);
                    this.getModel().setValue("enable", (Object)"2");
                    this.setEnableflexVisible(false);
                } else {
                    this.lockOrUnlockView(false);
                    this.getModel().setValue("enable", (Object)"0");
                    this.setEnableflexVisible(false);
                }
            }
            DynamicObject[] dimRefs = BusinessDataServiceHelper.load((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"), (String)"dimension,aggoprttype,dimviews.view,sourcedim,createtype", (QFilter[])new QFilter(this.getMetaDataEntity(this.getView(), "epbs_businessdomain").equals(modelentity) ? "businessdomain" : "bizmodel", "=", (Object)id).toArray(), (String)"dseq");
            this.setDimListData(dimRefs, modelentity, "3");
        }
        if (this.getMetaDataEntity(this.getView(), "epbs_businessdomain").equals(modelentity)) {
            this.createLackDimList(DEFAULT_DIMAINTYPE_CACHE, BizModelServiceHelper.defaultDimainDimList);
        }
        this.getView().updateView("dimlist");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"baseinfoap"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"tipap"});
    }

    public void setEnableflexVisible(boolean flag) {
        if (flag) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"disableflex"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"enableflex"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"enableflex"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"disableflex"});
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"disableflex", "enableflex"});
    }

    public void setDimListData(DynamicObject[] dimRefs, String modelEntity, String type) {
        LinkedHashMap<Long, List<String>> result = new LinkedHashMap<Long, List<String>>(16);
        String dimtypeCacheStr = this.getPageCache().get(DEFAULT_DIMTYPE_CACHE);
        ArrayList<Object> dimtypeList = new ArrayList(4);
        if (!StringUtils.isBlank((CharSequence)dimtypeCacheStr)) {
            dimtypeList = new ArrayList<String>(Arrays.asList(dimtypeCacheStr.split(",")));
        }
        String dimaintypeCacheStr = this.getPageCache().get(DEFAULT_DIMAINTYPE_CACHE);
        ArrayList<Object> dimaintypeList = new ArrayList(4);
        if (!StringUtils.isBlank((CharSequence)dimaintypeCacheStr)) {
            dimaintypeList = new ArrayList<String>(Arrays.asList(dimaintypeCacheStr.split(",")));
        }
        if (dimRefs != null && dimRefs.length > 0) {
            int sourceSize = this.getModel().getEntryEntity("dimlist") == null ? 0 : this.getModel().getEntryEntity("dimlist").size();
            this.getModel().batchCreateNewEntryRow("dimlist", dimRefs.length);
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("dimlist");
            for (int i = 0; i < dimRefs.length; ++i) {
                DynamicObject dimRef = dimRefs[i];
                DynamicObject entry = (DynamicObject)dynamicObjects.get(sourceSize + i);
                DynamicObject dimension = dimRef.getDynamicObject("dimension");
                DynamicObject sourcedim = dimRef.getDynamicObject("sourcedim");
                long dimensionId = dimension.getLong("id");
                entry.set("id", (Object)dimension.getLong("id"));
                entry.set("dimnumber_l", dimension.get("number"));
                entry.set("dimname_l", dimension.get("name"));
                EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
                DimTypeBean dimType = modelCache.getDimTypeByDimensionId(dimensionId);
                DimensionBean dimensionBean = modelCache.getDimensionById(dimensionId);
                String dimtype = dimType.getType();
                if (defaultDimList.contains(dimtype) && !dimtypeList.contains(dimtype)) {
                    dimtypeList.add(dimtype);
                }
                if (BizModelServiceHelper.defaultDimainDimList.contains(dimtype) && !dimaintypeList.contains(dimtype)) {
                    dimaintypeList.add(dimtype);
                }
                entry.set("dimtype_l", (Object)(dimType.getNameString() + "(" + dimType.getShortNumber() + ")"));
                entry.set("dimtypevalue_l", (Object)dimType.getType());
                entry.set("aggoprttype_l", dimRef.get("aggoprttype"));
                entry.set("dimdescription_l", (Object)dimensionBean.getDesc());
                String createtype = dimRef.getString("createtype");
                if (sourcedim != null) {
                    entry.set("source_l", (Object)"1");
                    entry.set("createtype_l", (Object)BizModelCreateTypeEnum.BUSINESSDIM.getValue());
                } else {
                    entry.set("source_l", (Object)type);
                    if ("1".equals(type)) {
                        createtype = BizModelCreateTypeEnum.BUSINESSDIM.getValue();
                    } else if (StringUtils.isBlank((CharSequence)createtype)) {
                        createtype = BizModelCreateTypeEnum.SELECTDIM.getValue();
                    }
                    entry.set("createtype_l", (Object)createtype);
                }
                String viewStr = dimRef.getDynamicObjectCollection("dimviews").stream().map(o -> o.getString("view.id")).collect(Collectors.joining(","));
                entry.set("dimview_l", (Object)viewStr);
                String viewNameStr = dimRef.getDynamicObjectCollection("dimviews").stream().map(o -> o.getString("view.name")).collect(Collectors.joining(","));
                result.put(dimensionId, Arrays.asList(viewStr, viewNameStr));
            }
            if (result.size() > 0) {
                this.cacheViews(this.getPageCache(), result, VIEW_CACHE);
            }
        }
        this.getPageCache().put(DEFAULT_DIMTYPE_CACHE, String.join((CharSequence)",", dimtypeList));
        this.getPageCache().put(DEFAULT_DIMAINTYPE_CACHE, String.join((CharSequence)",", dimaintypeList));
    }

    protected Long getId() {
        Object id = this.getView().getFormShowParameter().getCustomParam("id");
        if (id != null) {
            return (Long)id;
        }
        return 0L;
    }

    private Long getDimensionId() {
        return (Long)this.getModel().getValue("dimid");
    }

    protected Long getBusinessdomainid() {
        Object businessdomainid = this.getView().getFormShowParameter().getCustomParam("businessdomainid");
        if (businessdomainid != null) {
            return (Long)businessdomainid;
        }
        return 0L;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("aggoprttype".equals(name) || "dimview".equals(name)) {
            this.setRowData(name);
        } else if ("dimname".equals(name)) {
            this.dimNameChanged();
        }
    }

    public void dimNameChanged() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("dimlist");
        this.getModel().setValue("dimname_l", this.getModel().getValue("dimname"), entryCurrentRowIndex);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (!this.checkDimRefChanged(false)) {
            args.setCancel(true);
            return;
        }
        String operation = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(operation)) {
            String number = (String)this.getModel().getValue("number");
            if (!"Default_Business_Domain".equals(number) && !BizModelServiceHelper.checkNumber((String)number)) {
                this.getView().showTipNotification(BizModelServiceHelper.getMessage());
                args.setCancel(true);
                return;
            }
            String modelentity = (String)this.getModel().getValue("modelentity");
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            String id = this.getPageCache().get(ID_CACHE);
            if (status.equals((Object)OperationStatus.ADDNEW) && StringUtils.isBlank((CharSequence)id) && QueryServiceHelper.exists((String)modelentity, (QFilter[])new QFilter("number", "=", (Object)number).and("model", "=", (Object)this.getModelId()).toArray())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u5185\u5df2\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u4e1a\u52a1\u6a21\u578b", (String)"BizModelDomainFormPlugin_23", (String)"epm-epbs-formplugin", (Object[])new Object[0]), number));
                args.setCancel(true);
                return;
            }
            String str = this.checkDim();
            if (!StringUtils.isBlank((CharSequence)str)) {
                this.getView().showTipNotification(str);
                args.setCancel(true);
                return;
            }
            Set Set2 = this.containerDefaultDim(BizModelServiceHelper.defaultDimainDimList);
            if (Set2 != null && Set2.size() > 0) {
                String nameStr = String.join((CharSequence)"\u3001", Set2);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u9700\u5305\u542b\u201c\u4e3b\u4f53\u3001\u8d22\u5e74\u3001\u671f\u95f4\u201d\u4e09\u4e2a\u7ef4\u5ea6\u7c7b\u578b\u7684\u5173\u8054\u5b57\u6bb5\uff0c\u9700\u589e\u52a0\u201c%s\u201d\u7ef4\u5ea6\u7c7b\u578b\u7684\u5173\u8054\u5b57\u6bb5\u3002", (String)"BizModelDomainFormPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]), nameStr));
                args.setCancel(true);
                return;
            }
        }
        if (args.getSource() instanceof DeleteEntry) {
            EntryGrid entryGrid;
            int[] selectRows;
            String idData = this.getPageCache().get(ID_CACHE);
            Long id = this.getId();
            if (!StringUtils.isBlank((CharSequence)idData)) {
                id = Long.parseLong(idData);
            }
            if ((selectRows = (entryGrid = (EntryGrid)this.getControl("dimlist")).getSelectRows()).length > 0 && id != 0L) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimlist");
                for (int i = 0; i < selectRows.length; ++i) {
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRows[i]);
                    long dimension = dynamicObject.getLong("id");
                    DynamicObjectCollection dataCollection = QueryServiceHelper.query((String)this.getMetaDataEntity(this.getView(), "epbs_relationmodelentity"), (String)"id,number,name,bizmodel,bizmodel.number,bizmodel.name", (QFilter[])new QFilter[]{new QFilter("dimensionid", "=", (Object)dimension).and(new QFilter("businessdomainid", "=", (Object)id))});
                    StringBuilder errorMsgBuf = new StringBuilder();
                    for (DynamicObject object : dataCollection) {
                        if (object == null) continue;
                        errorMsgBuf.append(object.getString("bizmodel.name")).append("(").append(object.getString("bizmodel.number")).append(")\u3001");
                    }
                    String errorMsg = errorMsgBuf.toString();
                    if (!StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
                    String errorMsgTmp = ResManager.loadKDString((String)"\u201d%1$s\u201c\u88ab\u5173\u7cfb\u6a21\u578b%2$s\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"BizModelDomainFormPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
                    String error = String.format(errorMsgTmp, dynamicObject.getString("dimname_l"), errorMsg.substring(0, errorMsg.length() - 1));
                    this.getView().showTipNotification(error);
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_refresh": {
                this.checkDimRefChanged(true);
                this.refreshDimListData();
                break;
            }
            case "btn_close": {
                this.checkDimRefChanged(true);
                this.closeDim();
                break;
            }
        }
    }

    private void closeDim() {
        boolean changeDimListData = this.isChangeDimListData();
        if (changeDimListData) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u7ef4\u5ea6\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BizModelDomainFormPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("btn_close", (IFormPlugin)this));
        } else {
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes == evt.getResult()) {
            switch (evt.getCallBackId()) {
                case "btn_refresh": {
                    this.createDimList();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"BizModelDomainFormPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "btn_close": {
                    this.getView().close();
                    break;
                }
            }
        }
    }

    public boolean isChangeDimListData() {
        boolean flag = false;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimlist");
        for (DynamicObject dim : entryEntity) {
            String changetype = dim.getString("changetype");
            if (!"2".equals(changetype)) continue;
            return true;
        }
        return flag;
    }

    public void refreshDimListData() {
        boolean changeDimListData = this.isChangeDimListData();
        if (changeDimListData) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u7ef4\u5ea6\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u5237\u65b0\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BizModelDomainFormPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("btn_refresh", (IFormPlugin)this));
        } else {
            this.createDimList();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"BizModelDomainFormPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("dim_add".equals(operateKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(this.getMetaDataEntity(this.getView(), "epbs_bizmodel_dim_select"));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            formShowParameter.setCustomParam("model", (Object)this.getModelId());
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimlist");
            List selectedIds = entryEntity.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            String idData = this.getPageCache().get(ID_CACHE);
            Long id = this.getId();
            if (!StringUtils.isBlank((CharSequence)idData)) {
                id = Long.parseLong(idData);
            }
            if (this.getMetaDataEntity(this.getView(), "epbs_bizmodel").equals(this.getModel().getValue("modelentity"))) {
                formShowParameter.setCustomParam("bizModelId", (Object)id);
                formShowParameter.setCustomParam("cubenumber", this.getModel().getValue("cubenumber"));
            } else {
                formShowParameter.setCustomParam("businessdomainid", (Object)id);
            }
            List<String> dimTypeList = this.getDimTypeList();
            formShowParameter.setCustomParam("dimTypeList", (Object)SerializationUtils.toJsonString(dimTypeList));
            formShowParameter.setCustomParam("selectedIds", selectedIds);
            this.getView().showForm(formShowParameter);
        } else if ("save".equals(operateKey)) {
            TXUtils.required(txhandle -> {
                DynamicObject domain;
                OperationStatus status = this.getView().getFormShowParameter().getStatus();
                String modelentity = (String)this.getModel().getValue("modelentity");
                String id = this.getPageCache().get(ID_CACHE);
                long domainId = GlobalIdUtil.genGlobalLongId();
                if (status.equals((Object)OperationStatus.ADDNEW) && StringUtils.isBlank((CharSequence)id)) {
                    domain = BusinessDataServiceHelper.newDynamicObject((String)modelentity);
                    domain.set("id", (Object)domainId);
                    domain.set("creator", (Object)UserUtils.getUserId());
                } else {
                    domainId = this.getId();
                    if (!StringUtils.isBlank((CharSequence)id)) {
                        domainId = Long.parseLong(id);
                    }
                    domain = BusinessDataServiceHelper.loadSingle((Object)domainId, (String)modelentity);
                }
                domain.set("number", this.getModel().getValue("number"));
                domain.set("name", this.getModel().getValue("name"));
                domain.set("model", (Object)this.getModelId());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{domain});
                long pkId = domain.getLong("id");
                this.getView().getFormShowParameter().setCustomParam("id", (Object)pkId);
                this.getPageCache().put(ID_CACHE, String.valueOf(domainId));
                this.saveDimList(pkId);
                EpbsModelCacheHelper.invalidateModelKeyById((Long)this.getModelId());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BizModelDomainFormPlugin_20", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
                String appNum = ModelCacheHelper.getModel((long)this.getModelId()).getSrcAppNum().toLowerCase(Locale.ENGLISH);
                OperationLogUtil.writeLog((String)appNum, (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.SAVE, (MultiLangEnumBridge)OperationMsgUtil.getSaveSucTipWithNumber((String)(this.getModel().getValue("number") + "")));
                this.getView().updateView();
            });
        } else if ("deleteentry".equals(operateKey)) {
            this.setDimInfo();
        } else if ("dowd".equals(operateKey)) {
            String str = this.checkDim();
            if (!StringUtils.isBlank((CharSequence)str)) {
                this.getView().showTipNotification(str);
                return;
            }
            boolean changeDimListData = this.isChangeDimListData();
            if (changeDimListData) {
                Long id = this.getBizModelId();
                if (id == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6a21\u578b\u3002", (String)"BizModelDomainFormPlugin_11", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_showdowdku", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u5bf9\u5f53\u524d\u754c\u9762\u6709\u6539\u52a8\uff0c\u662f\u5426\u4fdd\u5b58\u5f53\u524d\u6a21\u578b\uff1f", (String)"BizModelDomainFormPlugin_10", (String)"epm-epbs-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks, null, "");
            } else {
                this.showDoWdKu(null);
            }
        } else if ("moveup".equals(operateKey)) {
            this.click_moveUp((EventObject)afterDoOperationEventArgs);
        } else if ("movedown".equals(operateKey)) {
            this.click_moveDown((EventObject)afterDoOperationEventArgs);
        }
    }

    @NotNull
    private List<String> getDimTypeList() {
        DynamicObjectCollection dynamicObjectCollection = this.getView().getModel().getEntryEntity("dimlist");
        ArrayList dimTypeList = Lists.newArrayListWithExpectedSize((int)16);
        if (dynamicObjectCollection != null) {
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                dimTypeList.add(dynamicObject.getString("dimtypevalue_l"));
            }
        }
        return dimTypeList;
    }

    public void showDoWdKu(Long focusNodeId) {
        Long id = this.getBizModelId();
        if (id == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6a21\u578b\u3002", (String)"BizModelDomainFormPlugin_11", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = this.getView().getModel().getEntryEntity("dimlist");
        ArrayList dimList = Lists.newArrayListWithExpectedSize((int)16);
        if (dynamicObjectCollection != null) {
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                dimList.add(dynamicObject.getLong("id"));
            }
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(this.getMetaDataEntity(this.getView(), "epbs_dimension_manager"));
        formShowParameter.setPageId(this.getView().getPageId() + formShowParameter.getFormId() + id + SerializationUtils.toJsonString((Object)dimList));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("bizModelId", (Object)id);
        Long bizModelIdOrBusId = id;
        formShowParameter.setCustomParam("bizModelIdOrBusId", (Object)bizModelIdOrBusId);
        formShowParameter.setCustomParam("enable", this.getModel().getValue("enable"));
        if (dynamicObjectCollection != null) {
            formShowParameter.setCustomParam("enable", this.getModel().getValue("enable"));
        }
        if (focusNodeId != null) {
            formShowParameter.setCustomParam("focusNodeId", (Object)focusNodeId);
        }
        List<String> dimTypeList = this.getDimTypeList();
        formShowParameter.setCustomParam("dimTypeList", (Object)SerializationUtils.toJsonString(dimTypeList));
        OrmLocaleValue tilte = (OrmLocaleValue)this.getModel().getValue("name");
        formShowParameter.setCaption(ResManager.loadKDString((String)String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ba1\u7406-%s\u6a21\u578b", (String)"BizModelDomainFormPlugin_21", (String)"epm-epbs-formplugin", (Object[])new Object[0]), tilte.getDefaultItem()), (String)"BizModelDomainFormPlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showDoWdKu_close"));
        this.getView().showForm(formShowParameter);
    }

    public Long getBizModelId() {
        String idCache;
        Long id = this.getId();
        if (IDUtils.isNull((Long)id) && StringUtils.isNotBlank((CharSequence)(idCache = this.getPageCache().get(ID_CACHE)))) {
            id = Long.parseLong(idCache);
        }
        return id;
    }

    protected void saveDimList(Long mainId) {
        HashSet<Long> muitlIdSet = new HashSet<Long>(16);
        HashSet<Long> relationIdSet = new HashSet<Long>(16);
        Map<Long, Map<Long, List<Integer>>> muitlCollect = this.createIdSet(mainId, muitlIdSet, relationIdSet);
        String modelEntity = (String)this.getModel().getValue("modelentity");
        String mainKey = this.getMetaDataEntity(this.getView(), "epbs_businessdomain").equals(modelEntity) ? "businessdomain" : "bizmodel";
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimlist");
        LinkedHashMap<Long, List<String>> result = new LinkedHashMap<Long, List<String>>(16);
        HashSet<Long> dimIdSet = new HashSet<Long>(entryEntity.size());
        ArrayList<DynamicObject> dimRefList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> muitlDimRefList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> relationDimRefList = new ArrayList<DynamicObject>(10);
        int dseq = 1;
        for (DynamicObject dim : entryEntity) {
            DynamicObject dimRef = BusinessDataServiceHelper.newDynamicObject((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"));
            long dimRefId = GlobalIdUtil.genGlobalLongId();
            dimRef.set(mainKey, (Object)mainId);
            dimRef.set("id", (Object)dimRefId);
            long dimId = dim.getLong("id");
            this.saveDimNameAndId(dim, dimId);
            dimIdSet.add(dimId);
            dimRef.set("dimension", (Object)dimId);
            dimRef.set("model", (Object)this.getModelId());
            dimRef.set("aggoprttype", (Object)dim.getString("aggoprttype_l"));
            dimRef.set("createtype", (Object)dim.getString("createtype_l"));
            dimRef.set("dseq", (Object)dseq);
            DynamicObjectCollection dimviews = dimRef.getDynamicObjectCollection("dimviews");
            dimviews.clear();
            String dimviewStr = dim.getString("dimview_l");
            Long[] viewIds = this.getViewIds(dimviewStr);
            ArrayList<Object> viewNameList = new ArrayList<Object>(viewIds.length);
            for (Long viewId : viewIds) {
                DynamicObject viewRef = new DynamicObject(dimviews.getDynamicObjectType());
                viewRef.set("view", (Object)viewId);
                dimviews.add((Object)viewRef);
                viewNameList.add(viewRef.get("view.name"));
            }
            if (!this.getMetaDataEntity(this.getView(), "epbs_businessdomain").equals(modelEntity)) {
                String sourceL = dim.getString("source_l");
                if (!"1".equals(sourceL)) {
                    dimRefList.add(dimRef);
                }
            } else {
                dimRefList.add(dimRef);
            }
            String viewNameStr = String.join((CharSequence)",", viewNameList);
            result.put(dim.getLong("id"), Arrays.asList(dimviewStr, viewNameStr));
            this.createMuitlData(muitlIdSet, dimId, dim, viewIds, muitlDimRefList, muitlCollect);
            ++dseq;
        }
        this.createRelationData(mainId, relationIdSet, dimIdSet, relationDimRefList);
        if (result.size() > 0) {
            this.cacheViews(this.getPageCache(), result, VIEW_CACHE);
        }
        this.synchronizationBizModelDim(mainKey, mainId, dimRefList, dimIdSet, muitlIdSet, muitlDimRefList, relationIdSet, relationDimRefList);
        this.createDimList();
    }

    public void saveDimNameAndId(DynamicObject dim, long dimId) {
        Long refIdOld;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dimId, (String)this.getMetaDataEntity(this.getView(), "epbs_dimension"));
        if (this.checkDimNameView(dimId).booleanValue()) {
            dynamicObject.set("name", (Object)dim.getString("dimname_l"));
        }
        if (this.checkDimTmpId(dimId).booleanValue() && (refIdOld = Long.valueOf(dynamicObject.getLong("refid"))) == 0L) {
            String idData = this.getPageCache().get(ID_CACHE);
            Long id = this.getId();
            if (!StringUtils.isBlank((CharSequence)idData)) {
                id = Long.parseLong(idData);
            }
            dynamicObject.set("refid", (Object)id);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private Map<Long, Map<Long, List<Integer>>> createIdSet(Long mainId, Set<Long> muitlIdSet, Set<Long> relationIdSet) {
        QueryServiceHelper.query((String)this.getMetaDataEntity(this.getView(), "epbs_bizmodel"), (String)"id", (QFilter[])new QFilter("businessdomainid", "=", (Object)mainId).and("type", "=", (Object)"1").toArray()).stream().forEach(c -> muitlIdSet.add(c.getLong("id")));
        QueryServiceHelper.query((String)this.getMetaDataEntity(this.getView(), "epbs_bizmodel"), (String)"id", (QFilter[])new QFilter("businessdomainid", "=", (Object)mainId).and("type", "=", (Object)"2").toArray()).stream().forEach(c -> relationIdSet.add(c.getLong("id")));
        return Arrays.stream(BusinessDataServiceHelper.load((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"), (String)"bizmodel,dimension,dseq", (QFilter[])new QFilter("bizmodel.businessdomainid", "=", (Object)mainId).toArray())).collect(Collectors.groupingBy(e -> e.getLong("bizmodel.id"), Collectors.groupingBy(e -> e.getLong("dimension.id"), Collectors.mapping(a -> a.getInt("dseq"), Collectors.toList()))));
    }

    private void createRelationData(Long mainId, Set<Long> relationIdSet, Set<Long> dimIdSet, List<DynamicObject> relationDimRefList) {
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
        Map collect = Arrays.stream(BusinessDataServiceHelper.load((String)this.getMetaDataEntity(this.getView(), "epbs_relationmodelentity"), (String)"bizmodel,dimensionid", (QFilter[])new QFilter("bizmodel", "in", relationIdSet).and(new QFilter("businessdomainid", "=", (Object)mainId)).toArray())).collect(Collectors.groupingBy(e -> e.getLong("bizmodel.id"), Collectors.mapping(a -> a.getLong("dimensionid.id"), Collectors.toSet())));
        relationIdSet.forEach(c -> {
            Set dimCollect = new HashSet(16);
            if (collect.get(c) != null) {
                dimCollect = (Set)collect.get(c);
            }
            HashSet finalDimCollect = dimCollect;
            List<Long> filterDimCollect = dimIdSet.stream().filter(e -> !finalDimCollect.contains(e)).collect(Collectors.toList());
            filterDimCollect.forEach(dimId -> {
                DimensionBean dimensionBean = modelCache.getDimensionById(dimId.longValue());
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.getMetaDataEntity(this.getView(), "epbs_relationmodelentity"));
                String type = "2";
                long entryId = GlobalIdUtil.genGlobalLongId();
                dynamicObject.set("id", (Object)entryId);
                dynamicObject.set("model", (Object)this.getModelId());
                dynamicObject.set("bizmodel", c);
                dynamicObject.set("number", (Object)dimensionBean.getNumber());
                dynamicObject.set("name", (Object)dimensionBean.getName());
                dynamicObject.set("type", (Object)type);
                dynamicObject.set("dimensionid", (Object)dimensionBean.getId());
                dynamicObject.set("ismustinput", (Object)false);
                dynamicObject.set("isconnect", (Object)true);
                dynamicObject.set("businessdomainid", (Object)mainId);
                relationDimRefList.add(dynamicObject);
            });
        });
    }

    private void createMuitlData(Set<Long> muitlIdSet, long dimId, DynamicObject dim, Long[] viewIds, List<DynamicObject> muitlDimRefList, Map<Long, Map<Long, List<Integer>>> muitlCollect) {
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
        if (muitlIdSet.size() > 0) {
            muitlIdSet.forEach(c -> {
                String cubenumber;
                boolean exists;
                List dseqList;
                Map dimMap = (Map)muitlCollect.get(c);
                Integer dseq = 0;
                if (dimMap.size() > 0 && (dseqList = (List)dimMap.get(dimId)) != null && dseqList.size() > 0) {
                    dseq = (Integer)dseqList.get(0);
                }
                DynamicObject clone = BusinessDataServiceHelper.newDynamicObject((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"));
                BizModelBean bizModelBean = modelCache.getBizModelById(c.longValue());
                DimensionBean dimensionBean = modelCache.getDimensionById(dimId);
                if (bizModelBean != null && dimensionBean != null && (exists = OlapServiceHelper.isExistDimension((String)(cubenumber = bizModelBean.getCube()), (long)this.getModelId(), (String)dimensionBean.getNumber()))) {
                    clone.set("issync", (Object)"1");
                }
                long newId = GlobalIdUtil.genGlobalLongId();
                clone.set("id", (Object)newId);
                clone.set("bizmodel", c);
                clone.set("sourcedim", (Object)dimId);
                clone.set("dimension", (Object)dimId);
                clone.set("model", (Object)this.getModelId());
                clone.set("aggoprttype", (Object)dim.getString("aggoprttype_l"));
                clone.set("dseq", (Object)dseq);
                clone.set("createtype", (Object)BizModelCreateTypeEnum.BUSINESSDIM.getValue());
                DynamicObjectCollection cloneDimviews = clone.getDynamicObjectCollection("dimviews");
                cloneDimviews.clear();
                for (Long viewId : viewIds) {
                    DynamicObject viewRef = new DynamicObject(cloneDimviews.getDynamicObjectType());
                    viewRef.set("view", (Object)viewId);
                    cloneDimviews.add((Object)viewRef);
                }
                muitlDimRefList.add(clone);
            });
        }
    }

    public void synchronizationBizModelDim(String mainKey, Long mainId, List<DynamicObject> dimRefList, Set<Long> dimIdSet, Set<Long> muitlIdSet, List<DynamicObject> muitlDimRefList, Set<Long> relationIdSet, List<DynamicObject> relationDimRefList) {
        String modelEntity = (String)this.getModel().getValue("modelentity");
        TXUtils.required(txhandle -> {
            DeleteServiceHelper.delete((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"), (QFilter[])new QFilter(mainKey, "=", (Object)mainId).toArray());
            SaveServiceHelper.save((DynamicObject[])dimRefList.toArray(new DynamicObject[0]));
            if (this.getMetaDataEntity(this.getView(), "epbs_businessdomain").equals(modelEntity)) {
                if (muitlIdSet.size() > 0) {
                    MainEntityType dataEntityType;
                    DynamicObject[] tempObjs;
                    DeleteServiceHelper.delete((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"), (QFilter[])new QFilter("bizmodel.businessdomainid", "=", (Object)mainId).and("dimension", "in", (Object)dimIdSet).toArray());
                    SaveServiceHelper.save((DynamicObject[])muitlDimRefList.toArray(new DynamicObject[0]));
                    Object[] array = QueryServiceHelper.query((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"), (String)"id", (QFilter[])new QFilter("bizmodel.businessdomainid", "=", (Object)mainId).and("dimension", "not in", (Object)dimIdSet).and("sourcedim", "!=", (Object)0L).toArray()).stream().map(c -> c.getLong("id")).collect(Collectors.toSet()).toArray();
                    if (array.length > 0 && (tempObjs = BusinessDataServiceHelper.load((Object[])array, (DynamicObjectType)(dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"))))) != null) {
                        for (DynamicObject tempObj : tempObjs) {
                            tempObj.set("sourcedim", (Object)0);
                            tempObj.set("createtype", (Object)BizModelCreateTypeEnum.SELECTDIM.getValue());
                        }
                        SaveServiceHelper.save((DynamicObject[])tempObjs);
                    }
                }
                if (relationIdSet.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])relationDimRefList.toArray(new DynamicObject[0]));
                    DeleteServiceHelper.delete((String)this.getMetaDataEntity(this.getView(), "epbs_relationmodelentity"), (QFilter[])new QFilter("businessdomainid", "=", (Object)mainId).and("dimensionid", "not in", (Object)dimIdSet).toArray());
                }
            }
        });
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("dim_add".equals(actionId)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData != null) {
                Long dimensionId = (Long)returnData.get("dimension");
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimlist");
                for (DynamicObject dynamicObject : entryEntity) {
                    if (!Objects.equals(dimensionId, dynamicObject.getLong("id"))) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ef4\u5ea6\u5df2\u9009\uff0c\u4e0d\u5141\u8bb8\u9009\u62e9\u76f8\u540c\u7684\u7ef4\u5ea6\u3002", (String)"BizModelDomainFormPlugin_22", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject dimension = QueryServiceHelper.queryOne((String)this.getMetaDataEntity(this.getView(), "epbs_dimension"), (String)"id,number,name,description,dtypeid.name,dtypeid.shortnumber,dtypeid.type", (QFilter[])new QFilter("id", "=", (Object)dimensionId).toArray());
                String type = returnData.get("type").toString();
                if ("1".equals(type)) {
                    this.setDimTmpId(dimensionId);
                }
                int row = this.getModel().createNewEntryRow("dimlist");
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("dimlist", row);
                entryRowEntity.set("id", (Object)dimension.getLong("id"));
                entryRowEntity.set("dimnumber_l", (Object)dimension.getString("number"));
                entryRowEntity.set("dimname_l", (Object)dimension.getString("name"));
                entryRowEntity.set("dimdescription_l", (Object)dimension.getString("description"));
                entryRowEntity.set("changetype", (Object)"2");
                entryRowEntity.set("createtype_l", (Object)type);
                entryRowEntity.set("dimtype_l", (Object)(dimension.get("dtypeid.name") + "(" + dimension.getString("dtypeid.shortnumber") + ")"));
                entryRowEntity.set("dimtypevalue_l", dimension.get("dtypeid.type"));
                if ("1".equals(type)) {
                    entryRowEntity.set("dimview_l", (Object)returnData.get("dimviewId").toString());
                } else {
                    DynamicObjectCollection dimviews = (DynamicObjectCollection)returnData.get("dimview");
                    entryRowEntity.set("dimview_l", (Object)this.getViewIdStr(dimviews));
                }
                entryRowEntity.set("aggoprttype_l", (Object)"3");
                this.getView().updateView("dimlist");
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("dimlist");
                entryGrid.entryRowClick(Integer.valueOf(row));
                entryGrid.selectRows(row);
                this.setDimInfo();
            }
        } else if ("showDoWdKu_close".equals(actionId)) {
            this.checkDimRefChanged(false, false);
        }
    }

    private void setDimTmpId(Long dimensionId) {
        String strWdId = this.getPageCache().get(WD_ID_TEMP);
        if (StringUtils.isNotBlank((CharSequence)strWdId)) {
            List dimMapList = (List)SerializationUtils.fromJsonString((String)strWdId, List.class);
            dimMapList.add(dimensionId);
            String jsonString = SerializationUtils.toJsonString((Object)dimMapList);
            this.getPageCache().put(WD_ID_TEMP, jsonString);
        } else {
            ArrayList dimMapList = Lists.newArrayListWithExpectedSize((int)16);
            dimMapList.add(dimensionId);
            String jsonString = SerializationUtils.toJsonString((Object)dimMapList);
            this.getPageCache().put(WD_ID_TEMP, jsonString);
        }
    }

    private Boolean checkDimTmpId(Long dimensionId) {
        List dimMapList;
        Boolean flag = false;
        String strWdId = this.getPageCache().get(WD_ID_TEMP);
        if (StringUtils.isNotBlank((CharSequence)strWdId) && (dimMapList = (List)SerializationUtils.fromJsonString((String)strWdId, List.class)).contains(dimensionId)) {
            flag = true;
        }
        return flag;
    }

    public void entryRowClick(RowClickEvent evt) {
        String entryGridKey = ((EntryGrid)evt.getSource()).getKey();
        if ("dimlist".equals(entryGridKey)) {
            this.setDimInfo();
        }
    }

    private void setDimInfo() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("dimlist");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("dimlist", entryCurrentRowIndex);
        this.getModel().beginInit();
        if (entryRowEntity != null) {
            Object dimensionNum = entryRowEntity.get("dimnumber_l");
            Object dimensionId = entryRowEntity.get("id");
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"dimview", "aggoprttype"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tipap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"baseinfoap"});
            this.getModel().setValue("dimnumber", dimensionNum);
            this.getModel().setValue("dimname", entryRowEntity.get("dimname_l"));
            this.getModel().setValue("dimdescription", entryRowEntity.get("dimdescription_l"));
            this.getModel().setValue("dimid", dimensionId);
            this.getModel().setValue("aggoprttype", entryRowEntity.get("aggoprttype_l"));
            String dimviewStr = entryRowEntity.getString("dimview_l");
            Long[] viewIds = this.getViewIds(dimviewStr);
            this.getModel().setValue("dimview", (Object)viewIds);
            this.getView().setEnable(Boolean.valueOf(!this.getAggoprttypeEnable(dimensionNum.toString(), Long.parseLong(dimensionId.toString()), viewIds, entryRowEntity.getString("source_l"))), new String[]{"aggoprttype"});
            this.checkDimNameView(entryRowEntity.getLong("id"));
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"dimview", "aggoprttype"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"baseinfoap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tipap"});
            this.getModel().setValue("dimnumber", null);
            this.getModel().setValue("dimname", null);
            this.getModel().setValue("dimdescription", null);
            this.getModel().setValue("dimid", null);
            this.getModel().setValue("dimview", null);
            this.getModel().setValue("aggoprttype", null);
        }
        this.getModel().endInit();
        this.getView().updateView("splitpanel_right");
    }

    public boolean getAggoprttypeEnable(String dimensionNum, Long dimensionId, Long[] viewIds, String source) {
        String modelEntity = (String)this.getModel().getValue("modelentity");
        boolean flag = false;
        if (this.getMetaDataEntity(this.getView(), "epbs_businessdomain").equals(modelEntity)) {
            String idData = this.getPageCache().get(ID_CACHE);
            Long id = this.getId();
            if (!StringUtils.isBlank((CharSequence)idData)) {
                id = Long.parseLong(idData);
            }
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"), (String)"bizmodel,dimviews.view", (QFilter[])new QFilter("bizmodel.businessdomainid", "=", (Object)id).and("dimension.id", "=", (Object)dimensionId).toArray(), (String)"dseq");
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                for (int i = 0; i < dynamicObjects.length; ++i) {
                    DynamicObject dynamicObject = dynamicObjects[i];
                    Long bizmodelId = dynamicObject.getLong("bizmodel.id");
                    BizModelBean bizModelBean = modelCache.getBizModelById(bizmodelId.longValue());
                    if (bizModelBean != null) {
                        String cubeNum = bizModelBean.getCube();
                        List<Long> dimviews = dynamicObject.getDynamicObjectCollection("dimviews").stream().map(o -> o.getLong("view.id")).collect(Collectors.toList());
                        viewIds = dimviews.toArray(new Long[dimviews.size()]);
                        flag = this.hasOlapData(cubeNum, dimensionNum, dimensionId, viewIds);
                    }
                    if (!flag) continue;
                    return flag;
                }
            }
        } else {
            Object cubeNum = this.getModel().getValue("cubenumber");
            if (!"1".equals(source)) {
                flag = this.hasOlapData(cubeNum, dimensionNum, dimensionId, viewIds);
            }
        }
        return flag;
    }

    public boolean hasOlapData(Object cubeNum, String dimensionNum, Long dimensionId, Long[] viewIds) {
        boolean flag = false;
        Integer interval = 15000;
        int totalNumber = 0;
        if (!ObjectUtils.isEmpty((Object)cubeNum) && OlapServiceHelper.isExistCube((String)cubeNum.toString(), (long)this.getModelId())) {
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
            String memberTreemodel = modelCache.getMemberTreeModelByDimensionId(dimensionId.longValue());
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("dimension.id", "=", (Object)dimensionId);
            qfBuilder.add("view", "in", (Object)viewIds);
            DynamicObject totalObject = QueryServiceHelper.queryOne((String)modelCache.getMetaDataEntity(memberTreemodel), (String)"count(1) as totalNumber", (QFilter[])qfBuilder.toArray());
            if (!Objects.isNull(totalObject)) {
                totalNumber = totalObject.getInt("totalNumber");
            }
            if (totalNumber > 0 && totalNumber > interval) {
                flag = this.executorThread(interval, totalNumber, modelCache, memberTreemodel, qfBuilder, cubeNum, dimensionNum);
            } else {
                List memberNum = QueryServiceHelper.query((String)modelCache.getMetaDataEntity(memberTreemodel), (String)"number", (QFilter[])qfBuilder.toArray(), (String)"").stream().map(c -> c.getString("number")).collect(Collectors.toList());
                if (memberNum != null && memberNum.size() > 0) {
                    flag = OlapServiceHelper.hasOlapData((String)cubeNum.toString(), memberNum, (String)dimensionNum, (long)this.getModelId());
                }
            }
        }
        return flag;
    }

    private boolean executorThread(Integer interval, int totalNumber, EpbsModelCache modelCache, String memberTreemodel, QFBuilder qfBuilder, Object cubeNum, String dimensionNum) {
        boolean flag = false;
        int count = 1;
        if (totalNumber > interval) {
            count = totalNumber % interval > 0 ? totalNumber / interval + 1 : totalNumber / interval;
        }
        ArrayList result = new ArrayList(count);
        CountDownLatch latch = new CountDownLatch(count);
        int i = 0;
        while (i < count) {
            int page = i++;
            EpbsThreadPools.commonExecute(() -> {
                try {
                    List memberNum = Arrays.stream(BusinessDataServiceHelper.load((String)modelCache.getMetaDataEntity(memberTreemodel), (String)"number,aggoprt", (QFilter[])qfBuilder.toArray(), (String)"", (int)page, (int)interval)).map(c -> c.getString("number")).collect(Collectors.toList());
                    if (memberNum != null && memberNum.size() > 0) {
                        result.add(OlapServiceHelper.hasOlapData((String)cubeNum.toString(), memberNum, (String)dimensionNum, (long)this.getModelId()));
                    }
                }
                catch (Exception e) {
                    logger.error("BizModelDomainFormPlugin.executorThread execute  Interrupted", (Throwable)e);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
            if (result.contains(true)) {
                flag = true;
            }
        }
        catch (InterruptedException e) {
            logger.error("BizModelDomainFormPlugin.syncDimAndmember execute  Interrupted", (Throwable)e);
        }
        return flag;
    }

    private void setRowData(String field) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("dimlist");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("dimlist", entryCurrentRowIndex);
        if (entryRowEntity != null) {
            if ("dimview".equals(field)) {
                DynamicObjectCollection viewList = (DynamicObjectCollection)this.getModel().getValue(field);
                Set viewIds = viewList.stream().map(o -> o.getString("fbasedataid_id")).collect(Collectors.toSet());
                String viewStr = String.join((CharSequence)",", viewIds);
                this.getModel().setValue(field + "_l", (Object)viewStr, entryCurrentRowIndex);
            } else {
                this.getModel().setValue(field + "_l", this.getModel().getValue(field), entryCurrentRowIndex);
            }
            this.getModel().setValue("changetype", (Object)"2", entryCurrentRowIndex);
        }
    }

    String getViewIdStr(DynamicObjectCollection dimviews) {
        Set viewIds = dimviews.stream().map(o -> o.getString("fbasedataid_id")).collect(Collectors.toSet());
        return String.join((CharSequence)",", viewIds);
    }

    protected Long[] getViewIds(String dimviewStr) {
        if (StringUtils.isBlank((CharSequence)dimviewStr)) {
            return new Long[0];
        }
        String[] dimviews = dimviewStr.split(",");
        return (Long[])Arrays.stream(dimviews).map(Long::parseLong).toArray(Long[]::new);
    }

    public void cacheViews(@NotNull IPageCache pageCache, Map<Long, List<String>> selectDatas, String keyCache) {
        if (selectDatas == null || selectDatas.isEmpty()) {
            pageCache.remove(keyCache);
        } else {
            pageCache.put(keyCache, SerializationUtils.serializeToBase64((Object)GZIPUtils.compress((String)JSON.toJSONString(selectDatas))));
        }
    }

    LinkedHashMap<Long, List<String>> getViewsFromCache(@NotNull IPageCache pageCache, String keyCache) {
        LinkedHashMap selectDatas;
        String _cacheStr = pageCache.get(keyCache);
        if (StringUtils.isNotEmpty((CharSequence)_cacheStr)) {
            _cacheStr = GZIPUtils.uncompressToString((byte[])((byte[])SerializationUtils.deSerializeFromBase64((String)_cacheStr)));
            selectDatas = (LinkedHashMap)JSON.parseObject((String)_cacheStr, LinkedHashMap.class);
        } else {
            selectDatas = new LinkedHashMap();
        }
        return selectDatas;
    }

    public String checkDim() {
        String str = "";
        String modelentity = (String)this.getModel().getValue("modelentity");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimlist");
        if (entryEntity != null && entryEntity.size() > 0) {
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
            ArrayList<String> dimtypeList = new ArrayList<String>(16);
            for (DynamicObject dim : entryEntity) {
                String dimnameStr;
                long dimensionId = dim.getLong("id");
                DimTypeBean dimType = modelCache.getDimTypeByDimensionId(dimensionId);
                String type = dimType.getType();
                if (!BizModelServiceHelper.excludeDimList.contains(type)) {
                    if (dimtypeList.contains(type)) {
                        str = this.getMetaDataEntity(this.getView(), "epbs_businessdomain").equals(modelentity) ? ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u53ea\u6709\u201c\u4e3b\u4f53\u3001\u81ea\u5b9a\u4e49\u201d\u7ef4\u5ea6\u7c7b\u578b\u7684\u7ef4\u5ea6\u5141\u8bb8\u6709\u591a\u4e2a\uff0c\u5176\u5b83\u7ef4\u5ea6\u7c7b\u578b\u7684\u7ef4\u5ea6\u53ea\u5141\u8bb8\u6709\u4e00\u4e2a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizModelDomainFormPlugin_12", (String)"epm-epbs-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u591a\u7ef4\u6a21\u578b\u53ea\u6709\u201c\u4e3b\u4f53\u3001\u81ea\u5b9a\u4e49\u201d\u7ef4\u5ea6\u7c7b\u578b\u7684\u7ef4\u5ea6\u5141\u8bb8\u6709\u591a\u4e2a\uff0c\u5176\u5b83\u7ef4\u5ea6\u7c7b\u578b\u7684\u7ef4\u5ea6\u53ea\u5141\u8bb8\u6709\u4e00\u4e2a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizModelDomainFormPlugin_13", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
                        return str;
                    }
                    dimtypeList.add(type);
                }
                if (StringUtils.isBlank((CharSequence)(dimnameStr = dim.getString("dimname_l")))) {
                    return String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%s\u7684\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizModelDomainFormPlugin_14", (String)"epm-epbs-formplugin", (Object[])new Object[0]), dim.getString("dimnumber_l"));
                }
                String dimviewStr = dim.getString("dimview_l");
                if (StringUtils.isBlank((CharSequence)dimviewStr)) {
                    return String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%s\u7684\u89c6\u56fe\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizModelDomainFormPlugin_15", (String)"epm-epbs-formplugin", (Object[])new Object[0]), dim.getString("dimnumber_l"));
                }
                String idData = this.getPageCache().get(ID_CACHE);
                Long id = this.getId();
                if (!StringUtils.isBlank((CharSequence)idData)) {
                    id = Long.parseLong(idData);
                }
                Object cubenumber = "";
                Long businessdomainid = 0L;
                if (!this.getMetaDataEntity(this.getView(), "epbs_businessdomain").equals(modelentity)) {
                    cubenumber = this.getModel().getValue("cubenumber");
                } else {
                    businessdomainid = id;
                }
                boolean existCube = BizModelServiceHelper.isExistCube((Object)cubenumber, (Long)businessdomainid, (long)this.getModelId(), (String)this.getMetaDataEntity(this.getView(), "epbs_bizmodel"));
                String sourceL = dim.getString("source_l");
                if (existCube && "2".equals(sourceL) && !StringUtils.isBlank((CharSequence)(str = BizModelServiceHelper.checkExistCubeTypeList((long)0L, (long)dimensionId, (long)this.getModelId())))) {
                    return str;
                }
                String returnStr = this.getRefCheck(modelentity, dim, dimensionId, id);
                if (StringUtils.isBlank((CharSequence)returnStr)) continue;
                return returnStr;
            }
        }
        return str;
    }

    private String getRefCheck(String modelentity, DynamicObject dim, long dimensionId, Long id) {
        String returnStr = "";
        if (this.getMetaDataEntity(this.getView(), "epbs_businessdomain").equals(modelentity)) {
            String dimviewStr = dim.getString("dimview_l");
            String[] dimviews = dimviewStr.split(",");
            Set viewSet = Arrays.stream(dimviews).collect(Collectors.toSet());
            returnStr = BizModelServiceHelper.checkRelationNumber((Long)id, (String)this.getMetaDataEntity(this.getView(), "epbs_relationmodelentity"), (String)this.getMetaDataEntity(this.getView(), "epbs_dimension"), (long)this.getDimensionId());
            if (!StringUtils.isBlank((CharSequence)returnStr)) {
                return returnStr;
            }
            returnStr = BizModelServiceHelper.checkMuitlBizModelData((Long)id, (long)this.getModelId(), (String)String.valueOf(dimensionId), viewSet, (String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"));
            if (!StringUtils.isBlank((CharSequence)returnStr)) {
                return returnStr;
            }
            returnStr = BizModelServiceHelper.checkDimTypeData((Long)id, (long)this.getModelId(), (String)String.valueOf(dimensionId), viewSet, (String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"));
            if (!StringUtils.isBlank((CharSequence)returnStr)) {
                return returnStr;
            }
        }
        return returnStr;
    }

    void lockOrUnlockView(boolean flag) {
        if (flag) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"fieldsetpanelap", "baseinfoap", "dim_add", "advconbaritemap2", "advconbaritemap3", "advconbaritemap4", "btn_multisave", "saveenablemulti", "btn_enable"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"fieldsetpanelap", "baseinfoap", "dim_add", "advconbaritemap2", "advconbaritemap3", "advconbaritemap4", "btn_multisave", "saveenablemulti", "btn_enable"});
        }
    }

    public void createLackDimList(String cacheName, List<String> dimList) {
        String dimtypeCacheStr = this.getPageCache().get(cacheName);
        ArrayList<String> dimtypeList = new ArrayList(4);
        if (!StringUtils.isBlank((CharSequence)dimtypeCacheStr)) {
            dimtypeList = Arrays.asList(dimtypeCacheStr.split(","));
        }
        if (dimList.size() != dimtypeList.size()) {
            this.addLackDimListData(dimtypeList, dimList);
        }
    }

    public void addLackDimListData(List<String> dimtypeList, List<String> dimList) {
        ArrayList numberList = new ArrayList();
        if (dimList.size() == 0) {
            return;
        }
        List collect = dimList.stream().filter(c -> !dimtypeList.contains(c)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            collect.stream().forEach(c -> {
                String number = DefaultDimensionEnum.getNumberByType((String)c);
                numberList.add(number);
            });
            if (numberList.size() > 0) {
                DynamicObject[] dimRefs = BusinessDataServiceHelper.load((String)this.getMetaDataEntity(this.getView(), "epbs_dimension"), (String)"id,name,number", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and(new QFilter("number", "in", numberList)).toArray());
                if (dimRefs != null && dimRefs.length > 0) {
                    int sourceSize = this.getModel().getEntryEntity("dimlist") == null ? 0 : this.getModel().getEntryEntity("dimlist").size();
                    this.getModel().batchCreateNewEntryRow("dimlist", dimRefs.length);
                    DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("dimlist");
                    for (int i = 0; i < dimRefs.length; ++i) {
                        Long viewId;
                        DynamicObject dimRef = dimRefs[i];
                        DynamicObject entry = (DynamicObject)dynamicObjects.get(sourceSize + i);
                        Long dimensionId = dimRef.getLong("id");
                        entry.set("id", (Object)dimensionId);
                        entry.set("dimnumber_l", dimRef.get("number"));
                        entry.set("dimname_l", dimRef.get("name"));
                        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
                        DimTypeBean dimType = modelCache.getDimTypeByDimensionId(dimensionId.longValue());
                        DimensionBean dimensionBean = modelCache.getDimensionById(dimensionId.longValue());
                        ViewBean defaultView = modelCache.getDefaultView(dimensionId.longValue());
                        entry.set("dimtype_l", (Object)(dimType.getNameString() + "(" + dimType.getShortNumber() + ")"));
                        entry.set("dimtypevalue_l", (Object)dimType.getType());
                        entry.set("dimdescription_l", (Object)dimensionBean.getDesc());
                        entry.set("source_l", (Object)"2");
                        entry.set("aggoprttype_l", (Object)"3");
                        if (defaultView == null || (viewId = Long.valueOf(defaultView.getId())) == 0L) continue;
                        entry.set("dimview_l", (Object)viewId.toString());
                    }
                }
                this.getView().updateView("dimlist");
            }
        }
    }

    public Set containerDefaultDim(List<String> dimList) {
        List dimNameList = DefaultDimensionEnum.getDefaultDimainDimNameList();
        HashSet<String> resultSet = new HashSet<String>(4);
        HashSet resultNameSet = new HashSet(4);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimlist");
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
        for (DynamicObject dim : entryEntity) {
            long dimensionId = dim.getLong("id");
            DimTypeBean dimType = modelCache.getDimTypeByDimensionId(dimensionId);
            String type = dimType.getType();
            if (dimList.contains(type)) {
                resultSet.add(type);
            }
            if (resultSet.size() != dimList.size()) continue;
            return resultNameSet;
        }
        if (resultSet.size() != dimList.size()) {
            List collect = dimList.stream().filter(c -> !resultSet.contains(c)).collect(Collectors.toList());
            collect.stream().forEach(c -> resultNameSet.add(dimNameList.get(dimList.indexOf(c))));
        }
        return resultNameSet;
    }

    public Boolean checkDimNameView(Long dimId) {
        Boolean flag = false;
        String idData = this.getPageCache().get(ID_CACHE);
        Long id = this.getId();
        if (!StringUtils.isBlank((CharSequence)idData)) {
            id = Long.parseLong(idData);
        }
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"dimname"});
        if (modelCache != null) {
            DimensionBean dimension = modelCache.getDimensionById(dimId.longValue());
            if (dimension != null && this.checkDimTmpId(dimension.getId()).booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"dimname"});
                flag = true;
            } else if (dimension == null || dimension.getRefId() == 0L) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"dimname"});
            } else if (id.equals(dimension.getRefId())) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"dimname"});
                flag = true;
            }
            DimTypeBean dimType = modelCache.getDimTypeByDimensionId(dimId.longValue());
            if (!dimType.isShowView()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap11"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap11"});
            }
        }
        return flag;
    }

    protected void click_moveUp(EventObject evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("dimlist");
        if (entryGrid != null) {
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"BizModelDomainFormPlugin_16", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            } else {
                AtomicBoolean flag = new AtomicBoolean(true);
                Arrays.stream(rows).forEach(rowIndex -> {
                    if (rowIndex == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u5904\u4e8e\u7b2c\u4e00\u884c\uff0c\u65e0\u6cd5\u7ee7\u7eed\u4e0a\u79fb", (String)"BizModelDomainFormPlugin_17", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                        flag.set(false);
                        return;
                    }
                });
                this.getModel().moveEntryRowsUp("dimlist", rows);
                if (flag.get()) {
                    this.moveSetChange(entryGrid);
                }
            }
        }
    }

    protected void click_moveDown(EventObject evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("dimlist");
        if (entryGrid != null) {
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"BizModelDomainFormPlugin_16", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            } else {
                AtomicBoolean flag = new AtomicBoolean(true);
                int count = this.getModel().getEntryRowCount("dimlist");
                Arrays.stream(rows).forEach(rowIndex -> {
                    if (rowIndex == count - 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u5904\u4e8e\u6700\u540e\u4e00\u884c\uff0c\u65e0\u6cd5\u7ee7\u7eed\u4e0b\u79fb\u3002", (String)"BizModelDomainFormPlugin_18", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                        flag.set(false);
                        return;
                    }
                });
                this.getModel().moveEntryRowsDown("dimlist", rows);
                if (flag.get()) {
                    this.moveSetChange(entryGrid);
                }
            }
        }
    }

    private void moveSetChange(EntryGrid entryGrid) {
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null) {
            for (int selectRow : selectRows) {
                this.getModel().setValue("changetype", (Object)"2", selectRow);
            }
        }
    }
}

