/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.bizmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.epm.epbs.business.model.bizmodel.BizModelInitHelper;
import kd.epm.epbs.business.model.bizmodel.BizModelServiceHelper;
import kd.epm.epbs.business.model.bizmodel.er.BizModelErInitHelper;
import kd.epm.epbs.business.model.bizmodel.er.ModelErResponse;
import kd.epm.epbs.business.model.bizmodel.muitlref.BizModelMuitlRefParam;
import kd.epm.epbs.business.permission.model.ModelPermHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.DefaultDimensionEnum;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.tree.DynamicTreeContext;
import kd.epm.epbs.common.tree.LeftTreeSearch;
import kd.epm.epbs.common.tree.NoParentDynamicTreeBuilder;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;
import kd.epm.epbs.common.util.OperationResultUtil;
import kd.epm.epbs.common.util.TXUtils;
import kd.epm.epbs.common.util.UserUtils;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import org.apache.commons.lang3.StringUtils;

public class BizModelManagerListPlugin
extends AbstractBaseListPlugin
implements TreeNodeClickListener,
LeftTreeSearch,
SearchEnterListener {
    private static final String DOMAIN_TREE = "domaintree";

    public void initialize() {
        super.initialize();
        TreeView treeView = (TreeView)this.getView().getControl(DOMAIN_TREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        BillList domainlist = (BillList)this.getControl("domainlist");
        domainlist.addSetFilterListener(evt -> {
            evt.addCustomQFilter(new QFilter("model", "=", (Object)this.getModelId()));
            evt.setOrderBy("createtime");
        });
        BillList billList = (BillList)this.getControl("bismodellist");
        billList.addSetFilterListener(evt -> {
            String domainId = this.getView().getPageCache().get("domainId");
            if (domainId != null) {
                evt.addCustomQFilter(new QFilter("businessdomainid", "=", (Object)Long.parseLong(domainId)));
                evt.setOrderBy("createtime desc");
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"multiimageap", "multiadd", "relationimageap", "relationadd", "searchnext", "searchbefore", "btn_deldim", "btn_editdim", "btn_adddim"});
        BillList domainlist = (BillList)this.getControl("domainlist");
        domainlist.addHyperClickListener(hyperLinkClickEvent -> {
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
            String appPkId = AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getId();
            boolean permission = ModelPermHelper.checkPermission((long)this.getModelId(), (String)appPkId, (String)modelCache.getMetaDataEntity("epbs_modelingmanager"), (String)"4=/D/TPU5I=Q");
            if (!permission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6a21\u578b\u7ba1\u7406\u201d\u7684\u201c\u4e1a\u52a1\u6a21\u578b\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BizModelManagerListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            Object primaryKeyValue = ((BillListHyperLinkClickEvent)hyperLinkClickEvent).getCurrentRow().getPrimaryKeyValue();
            this.openDomainEdit((Long)primaryKeyValue);
        });
        BillList bismodellist = (BillList)this.getControl("bismodellist");
        bismodellist.addHyperClickListener(hyperLinkClickEvent -> {
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
            String appPkId = AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getId();
            boolean permission = ModelPermHelper.checkPermission((long)this.getModelId(), (String)appPkId, (String)modelCache.getMetaDataEntity("epbs_modelingmanager"), (String)"4=/MH2XXX62N");
            if (!permission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6a21\u578b\u7ba1\u7406\u201d\u7684\u201c\u6a21\u578b\u7f16\u8f91\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BizModelManagerListPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            Object primaryKeyValue = ((BillListHyperLinkClickEvent)hyperLinkClickEvent).getCurrentRow().getPrimaryKeyValue();
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.getMetaDataEntity(this.getView(), "epbs_bizmodel"), (String)"type", (QFilter[])new QFilter("id", "=", primaryKeyValue).toArray());
            if (dynamicObject != null) {
                String type = dynamicObject.getString("type");
                if ("1".equals(type)) {
                    this.showModelEdit(this.getMetaDataEntity(this.getView(), "epbs_multibizmodel_edit"), "multiimageap", (Long)primaryKeyValue);
                } else {
                    this.showModelEdit(this.getMetaDataEntity(this.getView(), "epbs_relationmodel_edit"), "relationimageap", (Long)primaryKeyValue);
                }
            }
        });
        Search control = (Search)this.getControl("searchap");
        control.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"modelflex", "btn_enable", "baritemdel"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"domainflex", "btn_adddomain", "btn_adddomain"});
        this.setDefaultModel();
        this.saveDefaultDomain();
        this.initDomainTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDefaultDomain() {
        if (this.getModelId() == 0L) {
            return;
        }
        DLock lock = DLock.create((String)"epbs_saveDefaultDomain", (String)ResManager.loadKDString((String)"\u4f01\u4e1a\u7ee9\u6548\u751f\u6210\u9ed8\u8ba4\u7684\u4e1a\u52a1\u6a21\u578b\u3002", (String)"BizModelManagerListPlugin_20", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        lock.lock();
        try {
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId()).and("number", "=", (Object)"Default_Business_Domain");
            String domainEntity = this.getMetaDataEntity(this.getView(), "epbs_businessdomain");
            if (!QueryServiceHelper.exists((String)domainEntity, (QFilter[])qFilter.toArray())) {
                long id = GlobalIdUtil.genGlobalLongId();
                DynamicObject domain = BusinessDataServiceHelper.newDynamicObject((String)domainEntity);
                domain.set("id", (Object)id);
                domain.set("number", (Object)"Default_Business_Domain");
                domain.set("name", (Object)ResManager.getLocaleString((String)"\u9ed8\u8ba4", (String)"BizModelManagerListPlugin_3", (String)"epm-epbs-formplugin"));
                domain.set("model", (Object)this.getModelId());
                domain.set("creator", (Object)UserUtils.getUserId());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{domain});
                this.addLackDimData(id);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void addLackDimData(Long mainId) {
        ArrayList numberList = new ArrayList();
        List collect = BizModelServiceHelper.defaultDimainDimList;
        ArrayList<DynamicObject> dimRefList = new ArrayList<DynamicObject>(10);
        if (CollectionUtils.isNotEmpty((Collection)collect)) {
            DynamicObject[] dimRefs;
            collect.stream().forEach(c -> {
                String number = DefaultDimensionEnum.getNumberByType((String)c);
                numberList.add(number);
            });
            if (numberList.size() > 0 && (dimRefs = BusinessDataServiceHelper.load((String)this.getMetaDataEntity(this.getView(), "epbs_dimension"), (String)"id,name,number", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and(new QFilter("number", "in", numberList)).toArray())) != null && dimRefs.length > 0) {
                for (int i = 0; i < dimRefs.length; ++i) {
                    Long viewId;
                    DynamicObject dim = dimRefs[i];
                    Long dimensionId = dim.getLong("id");
                    DynamicObject dimRef = BusinessDataServiceHelper.newDynamicObject((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"));
                    long dimRefId = GlobalIdUtil.genGlobalLongId();
                    dimRef.set("id", (Object)dimRefId);
                    dimRef.set("businessdomain", (Object)mainId);
                    dimRef.set("dimension", (Object)dimensionId);
                    dimRef.set("model", (Object)this.getModelId());
                    dimRef.set("aggoprttype", (Object)"3");
                    dimRef.set("createtype", (Object)"2");
                    dimRef.set("dseq", (Object)(i + 1));
                    DynamicObjectCollection dimviews = dimRef.getDynamicObjectCollection("dimviews");
                    dimviews.clear();
                    EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
                    ViewBean defaultView = modelCache.getDefaultView(dimensionId.longValue());
                    if (defaultView != null && (viewId = Long.valueOf(defaultView.getId())) != 0L) {
                        DynamicObject viewRef = new DynamicObject(dimviews.getDynamicObjectType());
                        viewRef.set("view", (Object)viewId);
                        dimviews.add((Object)viewRef);
                    }
                    dimRefList.add(dimRef);
                }
            }
        }
        if (dimRefList.size() > 0) {
            TXUtils.required(txhandle -> {
                DeleteServiceHelper.delete((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"), (QFilter[])new QFilter("businessdomain", "=", (Object)mainId).toArray());
                SaveServiceHelper.save((DynamicObject[])dimRefList.toArray(new DynamicObject[0]));
            });
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("model".equals(name)) {
            this.saveDefaultDomain();
            this.initDomainTree();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        TreeView tree = (TreeView)evt.getSource();
        if (DOMAIN_TREE.equals(tree.getKey())) {
            this.refreshList();
        }
    }

    protected Long getDomainId() {
        TreeView tree = (TreeView)this.getView().getControl(DOMAIN_TREE);
        String focusNodeId = tree.getTreeState().getFocusNodeId();
        if (focusNodeId == null) {
            return 0L;
        }
        try {
            return Long.parseLong(focusNodeId);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private void refreshList() {
        TreeView treeView = (TreeView)this.getView().getControl(DOMAIN_TREE);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if ("#".equals(focusNodeId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"modelflex", "btn_enable", "baritemdel"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"domainflex", "btn_adddomain", "btn_adddomain"});
            BillList billList = (BillList)this.getControl("domainlist");
            billList.clearSelection();
            billList.refresh();
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"domainflex", "btn_adddomain", "btn_adddomain"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"modelflex", "btn_enable", "baritemdel"});
            this.refreshBismodellist();
        }
    }

    private void initDomainTree() {
        TreeView treeView = (TreeView)this.getView().getControl(DOMAIN_TREE);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        long modelId = this.getModelId();
        if (modelId != 0L) {
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            DynamicTreeContext context = new DynamicTreeContext(this.getMetaDataEntity(this.getView(), "epbs_businessdomain"));
            context.setSelectFields("id,number,name");
            context.setOrderby("createtime");
            context.setRootName(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b", (String)"BizModelManagerListPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            context.setqFilters(qFilter.toArray());
            context.setFocusTreeId(focusNodeId);
            context.setClickFirstChild(true);
            AbstractTreeBuilder treeBuilder = new NoParentDynamicTreeBuilder(context).buildTree(treeView);
            treeBuilder.nodeClick();
        } else {
            treeView.deleteAllNodes();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"modelflex", "btn_enable", "baritemdel"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"domainflex", "btn_adddomain", "btn_adddomain"});
            BillList billList = (BillList)this.getControl("domainlist");
            billList.clearData();
            this.getView().updateView("domainlist");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if ("multiimageap".equals(key) || "multiadd".equals(key)) {
            this.showModelEdit(this.getMetaDataEntity(this.getView(), "epbs_multibizmodel_edit"), key, null);
        } else if ("relationimageap".equals(key) || "relationadd".equals(key)) {
            this.showModelEdit(this.getMetaDataEntity(this.getView(), "epbs_relationmodel_edit"), key, null);
        } else if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            TreeView treeView = (TreeView)this.getView().getControl(DOMAIN_TREE);
            this.leftSearchNext(treeView, key);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_enable": {
                this.setStatus(true);
                break;
            }
            case "btn_disable": {
                this.setStatus(false);
                break;
            }
            case "baritemdel": {
                this.actionDeleteBizModel();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("adddomain".equals(operateKey)) {
            this.openDomainEdit(null);
        } else if ("editdomain".equals(operateKey)) {
            this.openDomainEdit(this.getDomainId());
        } else if ("deldomain".equals(operateKey)) {
            TreeView treeView = (TreeView)this.getView().getControl(DOMAIN_TREE);
            Map focusNodeData = treeView.getTreeState().getFocusNode();
            if (focusNodeData != null && !Objects.equals(focusNodeData.get("id"), "#") && focusNodeData.size() > 0) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deldomain", (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u201c%s\u201d\u4e1a\u52a1\u6a21\u578b\u5417\uff1f", (String)"BizModelManagerListPlugin_17", (String)"epm-epbs-formplugin", (Object[])new Object[0]), focusNodeData.get("text")), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks, (Map)null, String.valueOf(focusNodeData.get("id")));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u4e1a\u52a1\u6a21\u578b\u3002", (String)"BizModelManagerListPlugin_18", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
        } else if ("refresh".equals(operateKey)) {
            this.initDomainTree();
        }
    }

    private void openDomainEdit(Long domainId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(this.getMetaDataEntity(this.getView(), "epbs_bizdomain_edit"));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editdomain"));
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        if (this.getModelId() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BizModelManagerListPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (domainId != null) {
            if (domainId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u7f16\u8f91\u7684\u4e1a\u52a1\u6a21\u578b\u3002", (String)"BizModelManagerListPlugin_19", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)domainId, (String)this.getMetaDataEntity(this.getView(), "epbs_businessdomain"), (String)"number");
            Boolean flagDefault = false;
            if (dynamicObject != null && "Default_Business_Domain".equals(dynamicObject.getString("number"))) {
                flagDefault = true;
            }
            formShowParameter.setPageId(this.getView().getPageId() + formShowParameter.getFormId() + domainId);
            formShowParameter.setCustomParam("id", (Object)domainId);
            formShowParameter.setCustomParam("flagDefault", (Object)flagDefault);
            formShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            formShowParameter.setStatus(OperationStatus.ADDNEW);
        }
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("deldomain".equals(actionId) || "editdomain".equals(actionId)) {
            this.initDomainTree();
        }
        if ("multiimageap".equals(actionId) || "multiadd".equals(actionId) || "relationimageap".equals(actionId)) {
            this.refreshBismodellist();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("deldomain".equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String customVaule = messageBoxClosedEvent.getCustomVaule();
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)this.getMetaDataEntity(this.getView(), "epbs_businessdomain"), (Object[])new Object[]{Long.parseLong(customVaule)}, (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BizModelManagerListPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                this.initDomainTree();
            } else {
                OperationResultUtil.showOperationResult((IFormView)this.getView(), (OperationResult)operationResult);
            }
        } else if ("baritemdel".equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.actionDeleteBizModelResult();
        }
    }

    private void actionDeleteBizModelResult() {
        BillList billList = (BillList)this.getView().getControl("bismodellist");
        Object[] ids = billList.getSelectedRows().getPrimaryKeyValues();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)this.getMetaDataEntity(this.getView(), "epbs_bizmodel"), (Object[])ids, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%s\u6761\u6570\u636e\u3002", (String)"BizModelManagerListPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]), ids.length));
        } else {
            OperationResultUtil.showOperationResult((IFormView)this.getView(), (OperationResult)operationResult);
        }
        this.refreshBismodellist();
    }

    private void showModelEdit(String formId, String key, Long id) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        formShowParameter.setCustomParam("businessdomainid", (Object)this.getDomainId());
        if (id != null) {
            formShowParameter.setPageId(this.getView().getPageId() + formId + id);
            formShowParameter.setCustomParam("id", (Object)id);
            formShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            formShowParameter.setStatus(OperationStatus.ADDNEW);
        }
        this.getView().showForm(formShowParameter);
    }

    private void setStatus(boolean status) {
        DynamicObject[] tempObjs = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"BizModelManagerListPlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        if (tempObjs != null) {
            TXUtils.required(txhandle -> {
                for (DynamicObject tempObj : tempObjs) {
                    ModelErResponse modelErResponse;
                    String type = tempObj.getString("type");
                    if ("1".equals(type)) {
                        if (status) {
                            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
                            long id = tempObj.getLong("id");
                            BizModelInitHelper.initOLAPBase((long)id, (EpbsModelCache)modelCache);
                            Object[] idArray = QueryServiceHelper.query((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"), (String)"id", (QFilter[])new QFilter("bizmodel.id", "=", (Object)id).and(new QFilter("issync", "=", (Object)"0")).toArray()).stream().map(c -> c.getLong("id")).collect(Collectors.toSet()).toArray();
                            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"));
                            DynamicObject[] refTempObjs = BusinessDataServiceHelper.load((Object[])idArray, (DynamicObjectType)dataEntityType);
                            if (refTempObjs != null) {
                                for (DynamicObject refTempObj : refTempObjs) {
                                    refTempObj.set("issync", (Object)"1");
                                }
                                SaveServiceHelper.save((DynamicObject[])refTempObjs);
                            }
                            BizModelMuitlRefParam params = new BizModelMuitlRefParam();
                            BizModelServiceHelper.creteBizModelMuitlRefParam((EpbsModelCache)modelCache, (Long)id, (BizModelMuitlRefParam)params);
                            BizModelServiceHelper.executeBizModelMuitlEnable((Long)this.getModelId(), (Long)id, (BizModelMuitlRefParam)params);
                        }
                    } else if (status && (modelErResponse = BizModelErInitHelper.initErBase((long)tempObj.getLong("id"), (long)this.getModelId(), (String)this.getMetaDataEntity(this.getView(), "epbs_relationmodelentity"))).getErrorMsg() != null) {
                        this.getView().showTipNotification(String.format(modelErResponse.getErrorMsg().loadKDString(), modelErResponse.getErrorNumbers()));
                        return;
                    }
                    tempObj.set("enable", (Object)(status ? "1" : "0"));
                }
                SaveServiceHelper.save((DynamicObject[])tempObjs);
                String appNum = ModelCacheHelper.getModel((long)this.getModelId()).getSrcAppNum().toLowerCase(Locale.ENGLISH);
                if (status) {
                    for (DynamicObject tempObj : tempObjs) {
                        OperationLogUtil.writeLog((String)appNum, (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.ENABLE, (MultiLangEnumBridge)OperationMsgUtil.getEnableSucWithNumber((String)tempObj.getString("number")));
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"BizModelManagerListPlugin_11", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                } else {
                    for (DynamicObject tempObj : tempObjs) {
                        OperationLogUtil.writeLog((String)appNum, (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.DISABLE, (MultiLangEnumBridge)OperationMsgUtil.getDisableSucWithNumber((String)tempObj.getString("number")));
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"BizModelManagerListPlugin_14", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                }
                EpbsModelCacheHelper.invalidateModelKeyById((Long)this.getModelId());
            });
            this.refreshBismodellist();
        }
    }

    public DynamicObject[] getSelectedTempDynaObjs(String noSelectedMsg) {
        BillList billList = (BillList)this.getView().getControl("bismodellist");
        if (billList.getSelectedRows().size() == 0) {
            if (StringUtils.isNotEmpty((CharSequence)noSelectedMsg)) {
                this.getView().showTipNotification(noSelectedMsg);
            }
            return null;
        }
        return BusinessDataServiceHelper.load((Object[])billList.getSelectedRows().getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType());
    }

    private void actionDeleteBizModel() {
        BillList billList = (BillList)this.getControl("bismodellist");
        Object[] selectedIds = billList.getSelectedRows().getPrimaryKeyValues();
        if (selectedIds == null || selectedIds.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"BizModelManagerListPlugin_15", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u201d%s\u201d\u6761\u8bb0\u5f55\uff0c\u5220\u9664\u6a21\u578b\u7684\u540c\u65f6\u4f1a\u5220\u9664\u5176\u5f15\u7528\u7684\u6240\u6709\u7ef4\u5ea6\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"BizModelManagerListPlugin_16", (String)"epm-epbs-formplugin", (Object[])new Object[0]), selectedIds.length), MessageBoxOptions.YesNo, new ConfirmCallBackListener("baritemdel", (IFormPlugin)this));
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        TreeView treeView = (TreeView)this.getView().getControl(DOMAIN_TREE);
        String text = searchEnterEvent.getText();
        this.leftSearch(treeView, text);
    }

    public void refreshBismodellist() {
        TreeView treeView = (TreeView)this.getView().getControl(DOMAIN_TREE);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        BillList billList = (BillList)this.getControl("bismodellist");
        this.getView().getPageCache().put("domainId", focusNodeId);
        if ("#".equals(focusNodeId)) {
            return;
        }
        billList.clearSelection();
        billList.refresh();
    }
}

