/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.bizmodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.epm.epbs.business.bd.manage.ManageTreeHelper;
import kd.epm.epbs.common.model.IMetaDataEntity;
import kd.epm.epbs.common.tree.LeftTreeSearch;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import org.jetbrains.annotations.NotNull;

public class BizModelPriorityFormPlugin
extends AbstractBaseListPlugin
implements RowClickEventListener,
IMetaDataEntity,
TreeNodeCheckListener,
LeftTreeSearch {
    private static final String DIMLIST = "dimlist";
    public static final String TREESEARCH = "treesearch";
    public static final String ENTRYENTITY = "entryentity";
    public static final String LEFTTREE = "lefttree";
    public static final String BTN_SURE = "btn_sure";
    private static final String CHECK_NODES = "checkNodes";
    public static final String BTN_MOVE_UP = "btn_moveup";
    public static final String BTN_MOVE_DOWN = "btn_movedown";
    public static final String BTN_CLEAR_SELECTED = "btn_clearselected";
    public static final String BTN_REMOVE = "btn_remove";
    public static final String SEARCH_LIST = "searchlist";
    public static final String SEARCH_LIST_UP = "listup";
    public static final String SEARCH_LIST_DOWN = "listdown";

    @Override
    public void registerListener(EventObject e) {
        Search search;
        super.registerListener(e);
        Search se = (Search)this.getControl(TREESEARCH);
        if (se != null) {
            se.addEnterListener(evt -> this.searchap(evt));
        }
        if ((search = (Search)this.getControl(SEARCH_LIST)) != null) {
            search.addEnterListener(evt -> this.searchapList(evt));
        }
        this.addClickListeners(new String[]{BTN_SURE});
        this.addClickListeners(new String[]{"searchbefore", "searchnext", BTN_MOVE_UP, BTN_MOVE_DOWN, BTN_CLEAR_SELECTED, SEARCH_LIST_UP, SEARCH_LIST_DOWN, BTN_REMOVE});
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        TreeView treeView = (TreeView)this.getView().getControl(LEFTTREE);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    private void searchapList(SearchEnterEvent evt) {
        String searchTxt = evt.getText();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)searchTxt)) {
            this.searchList(searchTxt, true);
        }
    }

    protected void searchList(String searchTxt, boolean isDown) {
        DynamicObjectCollection selMembers = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<Integer> selectRows = new ArrayList<Integer>();
        if (selMembers != null && !selMembers.isEmpty()) {
            DynamicObject selMember;
            int rowIndex;
            int selRowIndex = -1;
            String _selRowIndex = this.getPageCache().get("CACHE_LIST_ROW_INDEX");
            if (StringUtils.isNotEmpty((CharSequence)_selRowIndex)) {
                try {
                    selRowIndex = Integer.parseInt(_selRowIndex);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (isDown) {
                int in = selMembers.size();
                for (int i = rowIndex = selRowIndex != -1 ? selRowIndex + 1 : 0; i < in; ++i) {
                    selMember = (DynamicObject)selMembers.get(i);
                    if (selMember == null || !BizModelPriorityFormPlugin.equalsSearchText(selMember, searchTxt)) continue;
                    this.getPageCache().put("CACHE_LIST_ROW_INDEX", String.valueOf(i));
                    selectRows.add(i);
                    break;
                }
            } else {
                for (int i = rowIndex = selRowIndex != -1 ? selRowIndex - 1 : selMembers.size() - 1; i >= 0; --i) {
                    selMember = (DynamicObject)selMembers.get(i);
                    if (selMember == null || !BizModelPriorityFormPlugin.equalsSearchText(selMember, searchTxt)) continue;
                    this.getPageCache().put("CACHE_LIST_ROW_INDEX", String.valueOf(i));
                    selectRows.add(i);
                    break;
                }
            }
        }
        if (selectRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879", (String)"BizModelPriorityFormPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        } else {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
            if (entry != null) {
                int[] rows = selectRows.stream().mapToInt(x -> x).toArray();
                entry.selectRows(rows, 0);
            }
        }
    }

    public static boolean equalsSearchText(@NotNull DynamicObject member, @NotNull String searchTxt) {
        String name = member.getString("dimnumber_l1");
        String number = member.getString("dimname_l1");
        String _searchTxt = searchTxt.toLowerCase();
        return StringUtils.isNotEmpty((CharSequence)name) && name.contains(searchTxt) || StringUtils.isNotEmpty((CharSequence)number) && number.toLowerCase().contains(_searchTxt);
    }

    private void searchap(SearchEnterEvent evt) {
        String text = evt.getText().trim().toLowerCase();
        TreeNode root = ManageTreeHelper.getCacheLefTreeRoot((AbstractFormPlugin)this);
        TreeView treeView = (TreeView)this.getView().getControl(LEFTTREE);
        this.leftSearch(treeView, root, text);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String dimlistStr = (String)this.getView().getFormShowParameter().getCustomParam(DIMLIST);
        String cacheStr = (String)this.getView().getFormShowParameter().getCustomParam("priority_cache");
        ArrayList<String> checkNodeIds = new ArrayList<String>(16);
        LinkedHashSet<String> cacheStrSet = new LinkedHashSet<String>(16);
        if (StringUtils.isNotEmpty((CharSequence)cacheStr)) {
            cacheStrSet = new LinkedHashSet<String>(Arrays.asList(cacheStr.split(",")));
        }
        this.setSelectEntryentity(dimlistStr, cacheStrSet, checkNodeIds);
        this.initTree(dimlistStr, checkNodeIds);
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString(checkNodeIds));
        this.getModel().setDataChanged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        boolean checked = evt.getChecked();
        Object nodeId = evt.getNodeId();
        if (nodeId == null) {
            return;
        }
        if (evt.getSource() instanceof TreeView) {
            BizModelPriorityFormPlugin bizModelPriorityFormPlugin = this;
            synchronized (bizModelPriorityFormPlugin) {
                List checkNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CHECK_NODES), List.class);
                if (checked) {
                    if ("root".equals(nodeId)) {
                        TreeNode treeNode = ManageTreeHelper.getSelectedNode((String)nodeId.toString(), (AbstractFormPlugin)this);
                        List children = treeNode.getChildren();
                        children.forEach(c -> this.selectedNode(String.valueOf(c.getId()), checkNodes));
                        TreeView tree = (TreeView)this.getControl(LEFTTREE);
                        tree.checkNodes(children);
                    } else if (!checkNodes.contains(nodeId)) {
                        TreeView treeView = (TreeView)evt.getSource();
                        List nodes = treeView.getTreeState().getCheckedNodes();
                        Map node = null;
                        for (Map _node : nodes) {
                            if (!nodeId.equals(_node.get("id"))) continue;
                            node = _node;
                            break;
                        }
                        if (node != null) {
                            this.selectedNode(String.valueOf(node.get("id")), checkNodes);
                        }
                    }
                } else if ("root".equals(nodeId)) {
                    this.clearSelected(null);
                } else {
                    this.unSelectedNode(nodeId.toString(), checkNodes);
                }
            }
        }
    }

    private void unSelectedNode(String nodeId, List<String> checkNodes) {
        DynamicObjectCollection selDims = this.getModel().getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < selDims.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)selDims.get(i);
            if (!nodeId.equals(dynamicObject.getString("id"))) continue;
            this.getModel().deleteEntryRow(ENTRYENTITY, i);
            checkNodes.remove(nodeId);
            TreeView tree = (TreeView)this.getControl(LEFTTREE);
            tree.uncheckNode(nodeId);
            this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString(checkNodes));
        }
    }

    private void selectedNode(String id, @NotNull List<String> checkNodes) {
        TreeNode treeNode = ManageTreeHelper.getSelectedNode((String)id, (AbstractFormPlugin)this);
        Map dataMap = (Map)treeNode.getData();
        if (dataMap.size() > 0) {
            if (!checkNodes.contains(id)) {
                this.fillBillList(dataMap);
                checkNodes.add(id);
            }
            this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString(checkNodes));
        }
    }

    protected void fillBillList(@NotNull Map<String, String> dataMap) {
        int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY);
        this.getModel().setValue("id", (Object)dataMap.get("id"), rowIndex);
        this.getModel().setValue("dimnumber_l1", (Object)dataMap.get("dimnumber_l"), rowIndex);
        this.getModel().setValue("dimname_l1", (Object)dataMap.get("dimname_l"), rowIndex);
        this.getModel().setValue("dimtype_l1", (Object)dataMap.get("dimtype_l"), rowIndex);
        this.getView().updateView(ENTRYENTITY);
    }

    private void setSelectEntryentity(String dimlistStr, Set<String> cacheStrSet, List<String> checkNodeIds) {
        if (StringUtils.isNotEmpty((CharSequence)dimlistStr)) {
            List entryEntity = (List)SerializationUtils.fromJsonString((String)dimlistStr, List.class);
            if (entryEntity != null && entryEntity.size() > 0 && cacheStrSet.size() > 0) {
                Set<String> finalCacheStrSet = cacheStrSet;
                Map selectedMap = entryEntity.stream().filter(c -> finalCacheStrSet.contains(c.get("id").toString())).collect(Collectors.toMap(t -> t.get("id").toString(), Function.identity(), (k1, k2) -> k1));
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, cacheStrSet.size());
                DynamicObjectCollection refDynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
                ArrayList countList = new ArrayList();
                cacheStrSet.forEach(c -> {
                    Map dimRef = (Map)selectedMap.get(c);
                    DynamicObject entry = (DynamicObject)refDynamicObjects.get(countList.size());
                    if (dimRef.size() > 0) {
                        checkNodeIds.add(String.valueOf(dimRef.get("id")));
                        entry.set("id", dimRef.get("id"));
                        entry.set("dimnumber_l1", dimRef.get("dimnumber_l"));
                        entry.set("dimname_l1", dimRef.get("dimname_l"));
                        entry.set("dimtype_l1", dimRef.get("dimtype_l"));
                    }
                    countList.add("");
                });
            }
            this.getView().updateView(ENTRYENTITY);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.getView().updateView(ENTRYENTITY);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        Search search = (Search)this.getControl(SEARCH_LIST);
        String searchTxt = search.getSearchKey();
        switch (key) {
            case "listup": {
                if (StringUtils.isEmpty((CharSequence)search.getSearchKey())) {
                    return;
                }
                this.searchList(searchTxt, false);
                break;
            }
            case "listdown": {
                if (StringUtils.isEmpty((CharSequence)search.getSearchKey())) {
                    return;
                }
                this.searchList(searchTxt, true);
                break;
            }
            case "btn_sure": {
                HashMap<String, String> returnData = new HashMap<String, String>(16);
                Map<String, List<String>> selectedMembers = this.getRefRows();
                Set<String> keySet = selectedMembers.keySet();
                String selectData = String.join((CharSequence)",", keySet);
                returnData.put("selectData", selectData);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                break;
            }
            case "searchbefore": 
            case "searchnext": {
                TreeView treeView = (TreeView)this.getView().getControl(LEFTTREE);
                TreeNode root = ManageTreeHelper.getCacheLefTreeRoot((AbstractFormPlugin)this);
                this.leftSearchNext(treeView, root, "searchnext".equals(key));
                break;
            }
            case "btn_moveup": {
                this.click_moveUp(evt);
                break;
            }
            case "btn_movedown": {
                this.click_moveDown(evt);
                break;
            }
            case "btn_clearselected": {
                this.clearSelected(evt);
                break;
            }
            case "btn_remove": {
                this.click_remove(evt);
                break;
            }
        }
    }

    protected void clearSelected(EventObject evt) {
        List ids = this.getModel().getEntryEntity(ENTRYENTITY).stream().map(e -> e.getString("id")).collect(Collectors.toList());
        ids.add("root");
        this.getModel().deleteEntryData(ENTRYENTITY);
        TreeView tree = (TreeView)this.getControl(LEFTTREE);
        tree.uncheckNodes(ids);
        this.getView().updateView(ENTRYENTITY);
        ArrayList checkNodes = new ArrayList(16);
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString(checkNodes));
    }

    private Map<String, List<String>> getRefRows() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        LinkedHashMap selectedIds = Maps.newLinkedHashMapWithExpectedSize((int)entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            String id = IDUtils.toString((Object)dynamicObject.get("id"));
            String name = dynamicObject.getString("dimname_l1");
            selectedIds.put(id, Arrays.asList(id, name, i + "", null, "1"));
        }
        return selectedIds;
    }

    public void initTree(String dimlistStr, List<String> checkNodeIds) {
        ArrayList checkNodes = Lists.newArrayListWithExpectedSize((int)checkNodeIds.size());
        String headId = "root";
        TreeNode root = new TreeNode();
        root.setId(headId);
        root.setParentid("");
        root.setText(ResManager.loadKDString((String)"\u7ef4\u5ea6", (String)"BizModelPriorityFormPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("type", "root");
        root.setData((Object)dataMap);
        this.createNode(dimlistStr, root, headId, checkNodeIds, checkNodes);
        root.setIsOpened(true);
        this.getPageCache().put("treelist", SerializationUtils.serializeToBase64((Object)root));
        TreeView tree = (TreeView)this.getControl(LEFTTREE);
        tree.deleteAllNodes();
        tree.addNode(root);
        if (checkNodes.size() > 0) {
            tree.checkNodes((List)checkNodes);
        }
    }

    public void createNode(String dimlistStr, TreeNode root, String headId, List<String> checkNodeIds, List<TreeNode> checkNodes) {
        List entryEntity;
        if (StringUtils.isNotEmpty((CharSequence)dimlistStr) && (entryEntity = (List)SerializationUtils.fromJsonString((String)dimlistStr, List.class)) != null && entryEntity.size() > 0) {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>(entryEntity.size());
            if (entryEntity != null && entryEntity.size() > 0) {
                for (int i = 0; i < entryEntity.size(); ++i) {
                    Map dimRef = (Map)entryEntity.get(i);
                    TreeNode entry = new TreeNode();
                    String id = dimRef.get("id").toString();
                    entry.setParentid(headId);
                    entry.setId(id);
                    entry.setText(dimRef.get("dimnumber_l") + " " + dimRef.get("dimname_l"));
                    entry.setData((Object)dimRef);
                    if (checkNodeIds.contains(id)) {
                        checkNodes.add(entry);
                    }
                    children.add(entry);
                }
                root.setChildren(children);
            }
        }
    }

    protected void click_moveUp(EventObject evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        if (entryGrid != null) {
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"BizModelPriorityFormPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            } else {
                Arrays.stream(rows).forEach(rowIndex -> {
                    if (rowIndex == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u5904\u4e8e\u7b2c\u4e00\u884c\uff0c\u65e0\u6cd5\u7ee7\u7eed\u4e0a\u79fb", (String)"BizModelPriorityFormPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                        return;
                    }
                });
                this.getModel().moveEntryRowsUp(ENTRYENTITY, rows);
            }
        }
    }

    protected void click_moveDown(EventObject evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        if (entryGrid != null) {
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"BizModelPriorityFormPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            } else {
                int count = this.getModel().getEntryRowCount(ENTRYENTITY);
                Arrays.stream(rows).forEach(rowIndex -> {
                    if (rowIndex == count - 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u5904\u4e8e\u6700\u540e\u4e00\u884c\uff0c\u65e0\u6cd5\u7ee7\u7eed\u4e0b\u79fb\u3002", (String)"BizModelPriorityFormPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                        return;
                    }
                });
                this.getModel().moveEntryRowsDown(ENTRYENTITY, rows);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void click_remove(EventObject evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        if (entryGrid != null) {
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"BizModelPriorityFormPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            } else {
                ArrayList<String> unCheckedIds = new ArrayList<String>(rows.length);
                for (int row : rows) {
                    DynamicObject member = this.getModel().getEntryRowEntity(ENTRYENTITY, row);
                    if (member == null) continue;
                    unCheckedIds.add(member.getString("id"));
                }
                BizModelPriorityFormPlugin bizModelPriorityFormPlugin = this;
                synchronized (bizModelPriorityFormPlugin) {
                    int sourceSize;
                    List checkNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CHECK_NODES), List.class);
                    TreeView tree = (TreeView)this.getControl(LEFTTREE);
                    tree.uncheckNodes(unCheckedIds);
                    unCheckedIds.forEach(c -> checkNodes.remove(c));
                    this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)checkNodes));
                    this.getModel().deleteEntryRows(ENTRYENTITY, rows);
                    int n = sourceSize = this.getModel().getEntryEntity(ENTRYENTITY) == null ? 0 : this.getModel().getEntryEntity(ENTRYENTITY).size();
                    if (sourceSize == 0) {
                        tree.uncheckNode("root");
                    }
                }
            }
        }
    }
}

