/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.bizmodel;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.epm.epbs.business.model.bizmodel.BizModelServiceHelper;
import kd.epm.epbs.business.model.bizmodel.er.BizModelErInitHelper;
import kd.epm.epbs.business.model.bizmodel.er.ModelErResponse;
import kd.epm.epbs.business.model.dimension.DimensionServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.BizModelErTypeEnum;
import kd.epm.epbs.common.enums.ErTableColEnum;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.IMetaDataEntity;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.RelationFieldBean;
import kd.epm.epbs.common.model.bean.relation.RelationTypeEnum;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.GZIPUtils;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;
import kd.epm.epbs.common.util.TXUtils;
import kd.epm.epbs.formplugin.AbstractBaseFormPlugin;
import kd.epm.epbs.formplugin.model.memberf7.bean.EpbsSelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.bean.MultiF7Result;
import org.jetbrains.annotations.NotNull;

public abstract class BizModelRelationFormPlugin
extends AbstractBaseFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener,
HyperLinkClickListener,
IMetaDataEntity {
    public static final String BTN_ENABLE = "btn_enable";
    public static final String CONFIRM_BTN_ENABLE = "confirm_btn_enable";
    public static final String BTN_DISABLE = "btn_disable";
    public static final String ID_CACHE = "id_cache";
    public static final String SAVE_ID_CACHE = "save_id_cache";
    public static final String SAVE_UNIQ_ID_CACHE = "save_uniq_id_cache";
    public static final String DATA_CACHE = "data_cache";
    public static final String DELETE_CACHE = "delete_cache";
    public static final String NUMBER_CACHE = "number_cache";
    public static final String PRIORITY_CACHE = "priority_cache";
    public static final String MEMBER_CACHE = "member_cache";
    public static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dimension = (BasedataEdit)this.getControl("dimension");
        dimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizmodel = (BasedataEdit)this.getControl("bizmodel");
        bizmodel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dimensionref = (BasedataEdit)this.getControl("dimensionref");
        dimensionref.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit basedata = (BasedataEdit)this.getControl("basedata");
        basedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("dimlist");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid viewnameGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        viewnameGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"addmember", "delmember", "uniquecheck"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"disableflex", "enableflex"});
        this.createDimData();
        this.getModel().setDataChanged(false);
        this.saveUniqueCache();
    }

    private void createDimData() {
        Long businessdomainid;
        this.getModel().deleteEntryData("dimlist");
        String idData = this.getPageCache().get(ID_CACHE);
        Long id = this.getId();
        if (id != 0L) {
            this.getPageCache().put(ID_CACHE, String.valueOf(id));
        }
        if (!StringUtils.isBlank((CharSequence)idData)) {
            id = Long.parseLong(idData);
        }
        if ((businessdomainid = this.getBusinessdomainid()) != 0L) {
            DynamicObject[] dimRefs = BusinessDataServiceHelper.load((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"), (String)"dimension", (QFilter[])new QFilter("businessdomain", "=", (Object)businessdomainid).toArray());
            this.setDefaultDimListData(dimRefs, id);
        }
        if (id != 0L) {
            String modelentity = (String)this.getModel().getValue("modelentity");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)this.getMetaDataEntity(this.getView(), modelentity), (String)"model,number,name,uniquecheck,cubenumber,enable");
            this.getModel().setValue("number", dynamicObject.get("number"));
            this.getModel().setValue("name", dynamicObject.get("name"));
            this.getModel().setValue("uniquecheckvalue", dynamicObject.get("uniquecheck"));
            this.getModel().setValue("cubenumber", dynamicObject.get("cubenumber"));
            this.getModel().setValue("enable", dynamicObject.get("enable"));
            DynamicObject[] memberRefs = BusinessDataServiceHelper.load((String)this.getMetaDataEntity(this.getView(), "epbs_relationmodelentity"), (String)"id,number,name,description,type,dimensionid,selectmodelid,businessdomainid,basedataid,ismustinput,isconnect,datatye,dimmembers.memberid,dimmembers.scope,dimmembers.view,isenable", (QFilter[])new QFilter("bizmodel", "=", (Object)id).toArray(), (String)"dseq");
            this.setDimlistData(memberRefs);
            this.lockOrUnlockView();
            this.saveUniqueCache();
        }
        this.getView().updateView("dimlist");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"baseinfoap", "modelflexpanelap", "basedata", "datatye"});
        BizModelServiceHelper.setPriorityValue((AbstractFormPlugin)this, (String)"uniquecheckvalue");
        BizModelServiceHelper.setPriorityText((AbstractFormPlugin)this, (String)"uniquecheck", (boolean)false);
        this.setBtnEable();
    }

    public void setDefaultDimListData(DynamicObject[] dimRefs, Object id) {
        List<Object> listData = Arrays.asList(dimRefs);
        if (listData != null && listData.size() > 0) {
            if (id != null) {
                List collect = Arrays.stream(BusinessDataServiceHelper.load((String)this.getMetaDataEntity(this.getView(), "epbs_relationmodelentity"), (String)"dimensionid", (QFilter[])new QFilter("bizmodel", "=", id).and(new QFilter("businessdomainid", "=", (Object)this.getBusinessdomainid())).toArray())).map(e -> e.getLong("dimensionid.id")).collect(Collectors.toList());
                listData = Arrays.stream(dimRefs).filter(c -> !collect.contains(c.getLong("dimension.id"))).collect(Collectors.toList());
                if (listData == null || listData.size() == 0) {
                    return;
                }
            }
            LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
            int sourceSize = this.getModel().getEntryEntity("dimlist") == null ? 0 : this.getModel().getEntryEntity("dimlist").size();
            this.getModel().batchCreateNewEntryRow("dimlist", listData.size());
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("dimlist");
            for (int i = 0; i < listData.size(); ++i) {
                DynamicObject dimRef = listData.get(i);
                DynamicObject entry = (DynamicObject)dynamicObjects.get(sourceSize + i);
                DynamicObject dimension = dimRef.getDynamicObject("dimension");
                String type = "2";
                long entryId = GlobalIdUtil.genGlobalLongId();
                entry.set("id", (Object)entryId);
                entry.set("dimnumber_l", (Object)dimension.getString("number"));
                entry.set("dimname_l", dimension.get("name"));
                if (RelationTypeEnum.DIMLIB.getType().equals(type) || RelationTypeEnum.MODEL.getType().equals(type)) {
                    entry.set("type_l", (Object)RelationTypeEnum.DIMLIB.getType());
                    entry.set("sourcedim_l", (Object)type);
                } else {
                    entry.set("type_l", (Object)type);
                }
                entry.set("isconnect_l", (Object)true);
                entry.set("ismustinput_l", (Object)false);
                entry.set("businessdomainid_l", (Object)this.getBusinessdomainid());
                if (this.getBusinessdomainid() != 0L) {
                    entry.set("sourcedim_l", (Object)BizModelRelationFormPlugin.getSourceDimYwModel());
                }
                if (dimension != null) {
                    entry.set("dimension_l", (Object)dimension.getLong("id"));
                }
                String dimtableData = "";
                if (RelationTypeEnum.MODEL.getType().equals(type) && dimension != null) {
                    dimtableData = dimension.getString("number");
                }
                entry.set("dimtable_l", (Object)dimtableData);
                result.put(IDUtils.toString((Object)entryId), Arrays.asList(dimension.getString("number"), dimension.getString("name"), "2"));
            }
            if (result.size() > 0) {
                this.cacheSelect(this.getPageCache(), result, DATA_CACHE);
            }
        }
    }

    public void setDimlistData(DynamicObject[] dimRefs) {
        LinkedHashMap<String, List<List<String>>> memberResult = this.getMemberFromCache(this.getPageCache(), MEMBER_CACHE);
        if (dimRefs != null && dimRefs.length > 0) {
            LinkedHashMap<String, List<String>> result = this.getSelectedIdsFromCache(this.getPageCache(), DATA_CACHE);
            int sourceSize = this.getModel().getEntryEntity("dimlist") == null ? 0 : this.getModel().getEntryEntity("dimlist").size();
            this.getModel().batchCreateNewEntryRow("dimlist", dimRefs.length);
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("dimlist");
            for (int i = 0; i < dimRefs.length; ++i) {
                DynamicObject dimRef = dimRefs[i];
                DynamicObject entry = (DynamicObject)dynamicObjects.get(sourceSize + i);
                DynamicObject dimension = dimRef.getDynamicObject("dimensionid");
                DynamicObject businessdomain = dimRef.getDynamicObject("businessdomainid");
                DynamicObject selectmodel = dimRef.getDynamicObject("selectmodelid");
                DynamicObject basedata = dimRef.getDynamicObject("basedataid");
                DynamicObjectCollection dimmembers = dimRef.getDynamicObjectCollection("dimmembers");
                String type = dimRef.getString("type");
                if (RelationTypeEnum.DIMLIB.getType().equals(type)) {
                    this.createDimmembers(dimRef.getLong("id"), dimension, dimmembers, memberResult);
                }
                entry.set("source_l", (Object)"1");
                entry.set("id", (Object)dimRef.getLong("id"));
                entry.set("dimnumber_l", dimRef.get("number"));
                entry.set("dimname_l", dimRef.get("name"));
                entry.set("dimdescription_l", (Object)dimRef.getString("description"));
                if (RelationTypeEnum.DIMLIB.getType().equals(type) || RelationTypeEnum.MODEL.getType().equals(type)) {
                    entry.set("type_l", (Object)RelationTypeEnum.DIMLIB.getType());
                    entry.set("sourcedim_l", (Object)type);
                } else {
                    entry.set("type_l", (Object)type);
                }
                entry.set("isenable", (Object)dimRef.getString("isenable"));
                if (businessdomain != null) {
                    entry.set("businessdomainid_l", (Object)businessdomain.getLong("id"));
                    entry.set("sourcedim_l", (Object)BizModelRelationFormPlugin.getSourceDimYwModel());
                }
                if (dimension != null) {
                    entry.set("dimension_l", (Object)dimension.getLong("id"));
                }
                if (selectmodel != null) {
                    entry.set("bizmodel_l", (Object)selectmodel.getLong("id"));
                }
                if (basedata != null) {
                    entry.set("basedata_l", basedata.get("id"));
                }
                entry.set("isconnect_l", dimRef.get("isconnect"));
                entry.set("ismustinput_l", dimRef.get("ismustinput"));
                entry.set("datatye_l", dimRef.get("datatye"));
                entry.set("member_l", (Object)dimRef.getDynamicObjectCollection("dimmembers"));
                String dimtableData = "";
                if (RelationTypeEnum.DIMLIB.getType().equals(type) || RelationTypeEnum.MODEL.getType().equals(type)) {
                    if (dimension != null) {
                        dimtableData = dimension.getString("number");
                    }
                } else if (RelationTypeEnum.BASICDATA.getType().equals(type) && basedata != null) {
                    dimtableData = basedata.getString("number");
                }
                entry.set("dimtable_l", (Object)dimtableData);
                result.put(IDUtils.toString((Object)dimRef.get("id")), Arrays.asList(dimRef.getString("number"), dimRef.getString("name"), "1"));
            }
            if (result.size() > 0) {
                this.cacheSelect(this.getPageCache(), result, DATA_CACHE);
            }
            if (memberResult.size() > 0) {
                this.cacheMember(this.getPageCache(), memberResult, MEMBER_CACHE);
            }
        }
    }

    private void createDimmembers(Long id, DynamicObject dimension, DynamicObjectCollection dimmembers, Map<String, List<List<String>>> memberResult) {
        if (dimension == null || dimmembers == null || dimmembers.size() == 0) {
            return;
        }
        long dimensionId = dimension.getLong("id");
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
        DimTypeBean dimType = modelCache.getDimTypeByDimensionId(dimensionId);
        String memberTreemodel = dimType.getMemberTreemodel();
        ArrayList filterList = new ArrayList();
        dimmembers.forEach(c -> filterList.add(c.get("memberid")));
        DynamicObject[] memberRefs = BusinessDataServiceHelper.load((String)memberTreemodel, (String)"id,number,name,view", (QFilter[])new QFilter("id", "in", filterList).toArray());
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        for (DynamicObject member : dimmembers) {
            long memberid = member.getLong("memberid");
            String name = "";
            String number = "";
            List filterData = Arrays.stream(memberRefs).filter(c -> memberid == c.getLong("id")).collect(Collectors.toList());
            if (filterData != null && filterData.size() > 0) {
                DynamicObject dynamicObject = (DynamicObject)filterData.get(0);
                name = dynamicObject.getString("name");
                number = dynamicObject.getString("number");
            }
            list.add(Arrays.asList(member.getString("memberid"), name, number, member.getString("view.id"), member.getString("view.name"), member.getString("scope")));
        }
        if (dimmembers != null && dimmembers.size() > 0) {
            memberResult.put(String.valueOf(id), list);
        }
    }

    public void setMemberlistData(List<EpbsSelectedMember> list) {
        LinkedHashMap<String, List<List<String>>> memberFromCache = this.getMemberFromCache(this.getPageCache(), MEMBER_CACHE);
        String id = this.getModel().getValue("id").toString();
        ArrayList<List<String>> cacheList = new ArrayList<List<String>>();
        if (list != null && list.size() > 0) {
            ArrayList idList = new ArrayList();
            list.forEach(c -> idList.add(c.getId()));
            HashMap map = new HashMap();
            Long dimensionId = Long.parseLong(this.getModel().getValue("dimension_id").toString());
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
            DimTypeBean dimType = modelCache.getDimTypeByDimensionId(dimensionId.longValue());
            String memberTreemodel = dimType.getMemberTreemodel();
            Arrays.stream(BusinessDataServiceHelper.load((String)memberTreemodel, (String)"id,view", (QFilter[])new QFilter("id", "in", idList).toArray())).forEach(c -> map.put(c.getString("id"), c.getDynamicObject("view")));
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, list.size());
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
            for (int i = 0; i < list.size(); ++i) {
                EpbsSelectedMember selectedMember = list.get(i);
                DynamicObject dynamicObject = (DynamicObject)map.get(selectedMember.getId().toString());
                DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                entry.set("memberid", (Object)selectedMember.getId());
                entry.set("membername", (Object)selectedMember.getName());
                entry.set("membernumber", (Object)selectedMember.getNumber());
                entry.set("viewid", (Object)dynamicObject.getLong("id"));
                entry.set("viewname", (Object)dynamicObject.getString("name"));
                entry.set("scope", (Object)selectedMember.getScope());
                cacheList.add(Arrays.asList(selectedMember.getId().toString(), selectedMember.getName(), selectedMember.getNumber(), dynamicObject.getString("id"), dynamicObject.getString("name"), selectedMember.getScope() + ""));
            }
            memberFromCache.put(String.valueOf(id), cacheList);
        } else {
            memberFromCache.remove(String.valueOf(id));
        }
        this.cacheMember(this.getPageCache(), memberFromCache, MEMBER_CACHE);
        this.getView().updateView(ENTRYENTITY);
    }

    public void setMemberlistInfo() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        LinkedHashMap<String, List<List<String>>> memberFromCache = this.getMemberFromCache(this.getPageCache(), MEMBER_CACHE);
        String id = this.getModel().getValue("id").toString();
        List<List<String>> listData = memberFromCache.get(id);
        if (listData != null && listData.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, listData.size());
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
            for (int i = 0; i < listData.size(); ++i) {
                List<String> data = listData.get(i);
                DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                entry.set("memberid", (Object)Long.parseLong(data.get(0)));
                entry.set("membername", (Object)data.get(1));
                entry.set("membernumber", (Object)data.get(2));
                entry.set("viewid", (Object)Long.parseLong(data.get(3)));
                entry.set("viewname", (Object)data.get(4));
                entry.set("scope", (Object)data.get(5));
            }
        }
        this.getView().updateView(ENTRYENTITY);
    }

    protected Long getId() {
        Object id = this.getView().getFormShowParameter().getCustomParam("id");
        if (id != null) {
            return (Long)id;
        }
        return 0L;
    }

    protected Long getBusinessdomainid() {
        Object businessdomainid = this.getView().getFormShowParameter().getCustomParam("businessdomainid");
        if (businessdomainid != null) {
            return (Long)businessdomainid;
        }
        return 0L;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Object newData;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("type".equals(name) || "sourcedim".equals(name)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"sourcedim_yw"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"sourcedim"});
            DimensionServiceHelper.setVisibleFlex((AbstractFormPlugin)this, (boolean)true, (String)name);
        }
        List<String> list = Arrays.asList("number", "name", "uniquecheck", "uniquecheckvalue", "scope", "enable", "cubenumber", "changetype", "isenable");
        if ("uniquecheck".equals(name) && StringUtils.isBlank((Object)(newData = e.getChangeSet()[0].getNewValue()))) {
            this.getView().getModel().setValue("uniquecheckvalue", (Object)"");
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"ismustinput"});
            this.getPageCache().put(PRIORITY_CACHE, "");
        }
        if ("dimension".equals(name)) {
            this.getModel().deleteEntryData(ENTRYENTITY);
            LinkedHashMap<String, List<List<String>>> memberResult = this.getMemberFromCache(this.getPageCache(), MEMBER_CACHE);
            String id = this.getModel().getValue("id").toString();
            memberResult.remove(id);
            this.cacheMember(this.getPageCache(), memberResult, MEMBER_CACHE);
        }
        if ("scope".equals(name)) {
            String id;
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            LinkedHashMap<String, List<List<String>>> memberResult = this.getMemberFromCache(this.getPageCache(), MEMBER_CACHE);
            List<List<String>> listData = memberResult.get(id = this.getModel().getValue("id").toString());
            if (listData != null && listData.size() > 0) {
                List<String> currentList = listData.get(entryCurrentRowIndex);
                currentList.set(5, e.getChangeSet()[0].getNewValue().toString());
            }
            memberResult.put(id, listData);
            this.cacheMember(this.getPageCache(), memberResult, MEMBER_CACHE);
        }
        if (!name.contains("_l") && !list.contains(name)) {
            this.setRowData(name);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operation = ((FormOperate)args.getSource()).getOperateKey();
        if ("savemulti".equals(operation) || "saveenablemulti".equals(operation)) {
            String number = (String)this.getModel().getValue("number");
            if (this.beforeCheckNullView()) {
                args.setCancel(true);
                return;
            }
            if (!BizModelServiceHelper.checkNumber((String)number)) {
                this.getView().showTipNotification(BizModelServiceHelper.getMessage());
                args.setCancel(true);
                return;
            }
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            String id = this.getPageCache().get(ID_CACHE);
            if (status.equals((Object)OperationStatus.ADDNEW) && StringUtils.isBlank((CharSequence)id) && QueryServiceHelper.exists((String)this.getMetaDataEntity(this.getView(), "epbs_bizmodel"), (QFilter[])new QFilter("number", "=", (Object)number).and("model", "=", (Object)this.getModelId()).toArray())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\u7f16\u7801\u4e3a\u201d%s\u201c\u7684\u6a21\u578b\u3002", (String)"BizModelRelationFormPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), number));
                args.setCancel(true);
                return;
            }
            this.preSaveData(args);
        }
        if (args.getSource() instanceof DeleteEntry) {
            EntryGrid entryGrid;
            DeleteEntry deleteEntry = (DeleteEntry)args.getSource();
            String operateKey = deleteEntry.getOperateKey();
            if ("deleteentrymember".equals(operateKey)) {
                entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
                int[] selectRows = entryGrid.getSelectRows();
                LinkedHashMap<String, List<List<String>>> memberResult = this.getMemberFromCache(this.getPageCache(), MEMBER_CACHE);
                String id = this.getModel().getValue("id").toString();
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
                List<List<String>> listData = memberResult.get(id);
                for (int i = 0; i < selectRows.length; ++i) {
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRows[i]);
                    String memberid = dynamicObject.get("memberid").toString();
                    listData = listData.stream().filter(c -> !memberid.equals(c.get(0))).collect(Collectors.toList());
                }
                memberResult.put(id, listData);
                this.cacheMember(this.getPageCache(), memberResult, MEMBER_CACHE);
            } else {
                entryGrid = (EntryGrid)this.getControl("dimlist");
                int[] selectRows = entryGrid.getSelectRows();
                ArrayList<String> errorMsgInheritList = new ArrayList<String>();
                ArrayList<String> errorMsgCreateList = new ArrayList<String>();
                if (selectRows.length > 0) {
                    Set<String> deleteSet = this.getDataSet(DELETE_CACHE);
                    Set<String> numberSet = this.getDataSet(NUMBER_CACHE);
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimlist");
                    LinkedHashMap<String, List<String>> result = this.getSelectedIdsFromCache(this.getPageCache(), DATA_CACHE);
                    for (int i = 0; i < selectRows.length; ++i) {
                        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRows[i]);
                        Long businessdomainidL = dynamicObject.getLong("businessdomainid_l");
                        if (businessdomainidL != 0L) {
                            errorMsgInheritList.add(dynamicObject.getString("dimname_l"));
                            continue;
                        }
                        String isEnable = dynamicObject.getString("isenable");
                        if ("true".equals(isEnable)) {
                            errorMsgCreateList.add(dynamicObject.getString("dimname_l"));
                            continue;
                        }
                        Object id = dynamicObject.get("id");
                        deleteSet.add(IDUtils.toString((Object)id));
                        numberSet.remove(dynamicObject.getString("dimnumber_l"));
                        result.remove(IDUtils.toString((Object)id));
                    }
                    if (CollectionUtils.isNotEmpty(errorMsgInheritList)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201d%s\u201c\u662f\u4ece\u4e1a\u52a1\u6a21\u578b\u7ee7\u627f\u7684\u7ef4\u5ea6\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"BizModelRelationFormPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", errorMsgInheritList)));
                        args.setCancel(true);
                        return;
                    }
                    if (CollectionUtils.isNotEmpty(errorMsgCreateList)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201d%s\u201c\u7684\u5b57\u6bb5\u5df2\u5efa\u7acb\u5173\u7cfb\u8868\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BizModelRelationFormPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", errorMsgCreateList)));
                        args.setCancel(true);
                        return;
                    }
                    this.cacheSelect(this.getPageCache(), result, DATA_CACHE);
                    this.getPageCache().put(DELETE_CACHE, String.join((CharSequence)",", deleteSet));
                    this.getPageCache().put(NUMBER_CACHE, String.join((CharSequence)",", numberSet));
                    String _cacheStr = this.getPageCache().get(PRIORITY_CACHE);
                    if (StringUtils.isNotEmpty((CharSequence)_cacheStr)) {
                        _cacheStr = GZIPUtils.uncompressToString((byte[])((byte[])SerializationUtils.deSerializeFromBase64((String)_cacheStr)));
                        LinkedHashMap selectDatas = (LinkedHashMap)JSON.parseObject((String)_cacheStr, LinkedHashMap.class);
                        Set keySet = selectDatas.keySet();
                        String collect = keySet.stream().filter(c -> !deleteSet.contains(c)).collect(Collectors.joining(","));
                        this.getModel().setValue("uniquecheckvalue", (Object)collect);
                        BizModelServiceHelper.setPriorityValue((AbstractFormPlugin)this, (String)"uniquecheckvalue");
                    }
                }
            }
        }
    }

    private boolean beforeCheckNullView() {
        String number = (String)this.getModel().getValue("number");
        String name = ((OrmLocaleValue)this.getModel().getValue("name")).getDefaultItem();
        String uniquecheck = (String)this.getModel().getValue("uniquecheck");
        String errorMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"BizModelRelationFormPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
        String errorMsgDetail = "";
        if (StringUtils.isBlank((CharSequence)number)) {
            errorMsgDetail = errorMsgDetail + ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u3001", (String)"BizModelRelationFormPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
        }
        if (ObjectUtils.isEmpty((Object)name)) {
            errorMsgDetail = errorMsgDetail + ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u3001", (String)"BizModelRelationFormPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
        }
        errorMsg = StringUtils.isBlank((CharSequence)errorMsgDetail) ? "" : String.format(errorMsg, errorMsgDetail.substring(0, errorMsgDetail.length() - 1));
        if (StringUtils.isBlank((CharSequence)uniquecheck)) {
            int sourceSize = this.getModel().getEntryEntity("dimlist") == null ? 0 : this.getModel().getEntryEntity("dimlist").size();
            errorMsg = sourceSize > 0 ? errorMsg + ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u552f\u4e00\u6027\u6821\u9a8c\u201c\u3002", (String)"BizModelRelationFormPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]) : errorMsg + ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u5b57\u6bb5\u5e76\u7ef4\u62a4\u201c\u552f\u4e00\u6027\u6821\u9a8c\u201c\u3002", (String)"BizModelRelationFormPlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            this.getView().showTipNotification(errorMsg);
            return true;
        }
        if (name.length() > 50) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u6700\u591a\u53ef\u5f55\u516550\u4e2a\u5b57\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BizModelRelationFormPlugin_9", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("dimlist");
        return this.checkList(entryEntity) != false;
    }

    private void preSaveData(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimlist");
        this.checkIngoreNumber(entryEntity, args);
        if (this.checkList(entryEntity).booleanValue()) {
            args.setCancel(true);
        }
    }

    private Boolean checkList(DynamicObjectCollection entryEntity) {
        Boolean flag = false;
        if (entryEntity == null) {
            return flag;
        }
        for (DynamicObject dim : entryEntity) {
            String number = dim.getString("dimnumber_l");
            LinkedHashMap<String, List<List<String>>> memberResult = this.getMemberFromCache(this.getPageCache(), MEMBER_CACHE);
            String type = dim.get("type_l").toString();
            if (RelationTypeEnum.DIMLIB.getType().equals(type) || RelationTypeEnum.MODEL.getType().equals(type)) {
                long dimensionL;
                type = this.convertSourceDimToType(dim.get("sourcedim_l").toString());
                if (RelationTypeEnum.MODEL.getType().equals(type)) {
                    long businessdomainidL = dim.getLong("businessdomainid_l");
                    long bizmodelL = dim.getLong("bizmodel_l");
                    if (bizmodelL == 0L && businessdomainidL == 0L) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201d%s\u201d\u7684\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizModelRelationFormPlugin_10", (String)"epm-epbs-formplugin", (Object[])new Object[0]), number));
                        return true;
                    }
                } else {
                    long id = dim.getLong("id");
                    List<List<String>> listData = memberResult.get(String.valueOf(id));
                    if (listData == null || listData.size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u53ef\u9009\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizModelRelationFormPlugin_11", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                        return true;
                    }
                }
                if ((dimensionL = dim.getLong("dimension_l")) != 0L) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201d%s\u201d\u7684\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizModelRelationFormPlugin_12", (String)"epm-epbs-formplugin", (Object[])new Object[0]), number));
                return true;
            }
            if (RelationTypeEnum.BASICDATA.getType().equals(type)) {
                long basedataL = dim.getLong("basedata_l");
                if (basedataL != 0L) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201d%s\u201d\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizModelRelationFormPlugin_13", (String)"epm-epbs-formplugin", (Object[])new Object[0]), number));
                return true;
            }
            if (!RelationTypeEnum.NOTHING.getType().equals(type)) continue;
        }
        return flag;
    }

    private void checkIngoreNumber(DynamicObjectCollection entryEntity, BeforeDoOperationEventArgs args) {
        HashMap<String, String> existMaps = new HashMap<String, String>(entryEntity.size());
        for (Object dim : entryEntity) {
            String string = dim.getString("dimnumber_l");
            if (existMaps.containsKey(string.toLowerCase())) {
                String repeatCode = (String)existMaps.get(string.toLowerCase());
                repeatCode = repeatCode + "," + string;
                existMaps.put(string.toLowerCase(Locale.ENGLISH), repeatCode);
                continue;
            }
            existMaps.put(string.toLowerCase(Locale.ENGLISH), string);
        }
        ArrayList errorMsg = new ArrayList();
        for (Map.Entry entry : existMaps.entrySet()) {
            String[] array = ((String)entry.getValue()).split(",");
            if (array.length <= 1) continue;
            errorMsg.add(entry.getValue());
        }
        if (CollectionUtils.isNotEmpty(errorMsg)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201d%s\u201d\u5927\u5c0f\u5199\u4e0d\u80fd\u91cd\u590d\u3002", (String)"BizModelRelationFormPlugin_14", (String)"epm-epbs-formplugin", (Object[])new Object[0]), String.join((CharSequence)";", errorMsg)));
            args.setCancel(true);
        }
        ArrayList<String> matchNumberList = new ArrayList<String>(entryEntity.size());
        for (DynamicObject dim : entryEntity) {
            String number = dim.getString("dimnumber_l");
            matchNumberList.add(number);
        }
        String string = ErTableColEnum.getMatchingCodes(matchNumberList);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201d%s\u201d\u4e3a\u7cfb\u7edf\u9884\u5236\u5b57\u6bb5\uff0c\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u66f4\u6362\u7f16\u7801\u3002", (String)"BizModelRelationFormPlugin_15", (String)"epm-epbs-formplugin", (Object[])new Object[0]), string));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if ("dim_add".equals(operateKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(this.getMetaDataEntity(this.getView(), "epbs_relationmodel_select"));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            formShowParameter.setCustomParam("model", (Object)this.getModelId());
            formShowParameter.setCustomParam("businessdomainid", (Object)this.getBusinessdomainid());
            String cubeNumber = (String)this.getModel().getValue("cubeNumber");
            formShowParameter.setCustomParam("cubeNumber", (Object)cubeNumber);
            formShowParameter.setCustomParam(NUMBER_CACHE, (Object)this.getAllDimNum());
            formShowParameter.setCustomParam("id", (Object)this.getId());
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u5b57\u6bb5", (String)"BizModelRelationFormPlugin_16", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            this.getView().showForm(formShowParameter);
        } else if ("savemulti".equals(operateKey) || "saveenablemulti".equals(operateKey)) {
            TXUtils.required(txhandle -> this.saveAndOpenDimList(status, operateKey));
        } else if ("deleteentry".equals(operateKey)) {
            this.setDimInfo();
            BizModelServiceHelper.setPriorityText((AbstractFormPlugin)this, (String)"uniquecheck", (boolean)false);
        }
    }

    private void saveAndOpenDimList(OperationStatus status, String operateKey) {
        DynamicObject bizModel = null;
        long bizModelId = GlobalIdUtil.genGlobalLongId();
        String id = this.getPageCache().get(ID_CACHE);
        if (status.equals((Object)OperationStatus.ADDNEW) && StringUtils.isBlank((CharSequence)id)) {
            bizModel = BusinessDataServiceHelper.newDynamicObject((String)this.getMetaDataEntity(this.getView(), "epbs_bizmodel"));
            bizModel.set("id", (Object)bizModelId);
            bizModel.set("number", this.getModel().getValue("number"));
            bizModel.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
            bizModel.set("createtime", (Object)TimeServiceHelper.now());
            bizModel.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
            bizModel.set("modifytime", (Object)TimeServiceHelper.now());
            bizModel.set("businessdomainid", (Object)this.getBusinessdomainid());
            bizModel.set("model", (Object)this.getModelId());
            bizModel.set("enable", (Object)"0");
        } else {
            Object soucreId = id;
            if (StringUtils.isBlank((CharSequence)id)) {
                soucreId = this.getView().getFormShowParameter().getCustomParam("id");
            }
            bizModelId = Long.parseLong(soucreId.toString());
            bizModel = BusinessDataServiceHelper.loadSingle((Object)soucreId, (String)this.getMetaDataEntity(this.getView(), "epbs_bizmodel"));
            bizModel.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
            bizModel.set("modifytime", (Object)TimeServiceHelper.now());
        }
        bizModel.set("name", this.getModel().getValue("name"));
        bizModel.set("uniquecheck", this.getModel().getValue("uniquecheckvalue"));
        bizModel.set("type", (Object)"2");
        if ("savemulti".equals(operateKey)) {
            String cubeNumber = bizModel.getString("cubeNumber");
            if (StringUtils.isBlank((CharSequence)cubeNumber)) {
                bizModel.set("enable", (Object)"2");
            } else {
                bizModel.set("enable", (Object)"0");
            }
        } else {
            bizModel.set("enable", (Object)"0");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizModel});
        this.getPageCache().put(ID_CACHE, String.valueOf(bizModelId));
        this.saveDimList(bizModel.getLong("id"));
        this.setBtnEable();
        if ("saveenablemulti".equals(operateKey)) {
            ModelErResponse modelErResponse = BizModelErInitHelper.initErBase((long)bizModelId, (long)this.getModelId(), (String)this.getMetaDataEntity(this.getView(), "epbs_relationmodelentity"));
            if (this.checkAndRefreshDimEnableCols(modelErResponse)) {
                EpbsModelCacheHelper.invalidateModelKeyById((Long)this.getModelId());
                return;
            }
            this.getModel().setValue("cubenumber", (Object)modelErResponse.getTableName());
            this.getModel().setValue("enable", (Object)"1");
            this.lockOrUnlockView();
        }
        EpbsModelCacheHelper.invalidateModelKeyById((Long)this.getModelId());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BizModelRelationFormPlugin_17", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        this.saveUniqueCache();
        String appNum = ModelCacheHelper.getModel((long)this.getModelId()).getSrcAppNum().toLowerCase(Locale.ENGLISH);
        OperationLogUtil.writeLog((String)appNum, (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.SAVE, (MultiLangEnumBridge)OperationMsgUtil.getSaveSucTipWithNumber((String)((String)this.getModel().getValue("number"))));
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        this.updateMapStatus();
    }

    private void saveUniqueCache() {
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(this.getModel().getValue("cubenumber")))) {
            String jsonString = SerializationUtils.toJsonString(this.createDimMap());
            this.getPageCache().put(SAVE_ID_CACHE, jsonString);
            this.getPageCache().put(SAVE_UNIQ_ID_CACHE, (String)this.getModel().getValue("uniquecheckvalue"));
        }
    }

    private boolean alertCreateError(String tbName) {
        if (StringUtils.isBlank((CharSequence)tbName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521b\u5efa\u8868\u5931\u8d25\u3002", (String)"BizModelRelationFormPlugin_20", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void updateMapStatus() {
        LinkedHashMap<String, List<String>> result = this.getSelectedIdsFromCache(this.getPageCache(), DATA_CACHE);
        if (result.size() > 0) {
            result.entrySet().forEach(c -> {
                List value = (List)c.getValue();
                if (value != null && value.size() > 0) {
                    value.set(2, "1");
                }
            });
        }
        this.cacheSelect(this.getPageCache(), result, DATA_CACHE);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if ("uniquecheck".equals(key)) {
            this.showPriorityEdit(key);
        }
        if ("addmember".equals(key)) {
            DimensionServiceHelper.addMember((AbstractFormPlugin)this, (AbstractMemberF7Parameter)this.getMemberF7Paramter());
        }
    }

    protected abstract AbstractMemberF7Parameter getMemberF7Paramter();

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_enable": {
                Object sourceId;
                String id = this.getPageCache().get(ID_CACHE);
                if (StringUtils.isBlank((CharSequence)id) && StringUtils.isBlank((Object)(sourceId = this.getView().getFormShowParameter().getCustomParam("id")))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BizModelRelationFormPlugin_21", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.beforeCheckNullView()) {
                    return;
                }
                boolean changeDimListData = this.isChangeDimListData();
                if (changeDimListData) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u672a\u4fdd\u5b58\u7684\u4fee\u6539\uff0c\u662f\u5426\u4fdd\u5b58\u4fee\u6539\u5e76\u542f\u7528\uff1f", (String)"BizModelRelationFormPlugin_22", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_BTN_ENABLE, (IFormPlugin)this));
                    break;
                }
                this.enableData();
                break;
            }
            case "btn_disable": {
                String resStatus = BizModelServiceHelper.setStatus((boolean)false, (AbstractFormPlugin)this, (String)this.getMetaDataEntity(this.getView(), "epbs_bizmodel"));
                if (StringUtils.isBlank((CharSequence)resStatus)) {
                    return;
                }
                this.getModel().setValue("enable", (Object)resStatus);
                this.lockOrUnlockView();
                EpbsModelCacheHelper.invalidateModelKeyById((Long)this.getModelId());
                String appNum = ModelCacheHelper.getModel((long)this.getModelId()).getSrcAppNum().toLowerCase(Locale.ENGLISH);
                if (StringUtils.isBlank((CharSequence)resStatus)) break;
                OperationLogUtil.writeLog((String)appNum, (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.DISABLE, (MultiLangEnumBridge)OperationMsgUtil.getDisableSucWithNumber((String)((String)this.getModel().getValue("number"))));
                break;
            }
            case "btn_refresh": {
                this.refreshDimListData();
                break;
            }
            case "btn_close": {
                this.closeDim();
                break;
            }
        }
    }

    private void closeDim() {
        boolean changeDimListData = this.isChangeDimListData();
        if (changeDimListData) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u7ef4\u5ea6\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BizModelRelationFormPlugin_25", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("btn_close", (IFormPlugin)this));
        } else {
            this.getView().close();
        }
    }

    private void enableData() {
        String id = this.getPageCache().get(ID_CACHE);
        ModelErResponse modelErResponse = BizModelErInitHelper.initErBase((long)Long.parseLong(id), (long)this.getModelId(), (String)this.getMetaDataEntity(this.getView(), "epbs_relationmodelentity"));
        if (this.checkAndRefreshDimEnableCols(modelErResponse)) {
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"BizModelRelationFormPlugin_26", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("cubenumber", (Object)modelErResponse.getTableName());
        this.getModel().setValue("enable", (Object)"1");
        this.lockOrUnlockView();
        EpbsModelCacheHelper.invalidateModelKeyById((Long)this.getModelId());
        this.saveUniqueCache();
        String appNum = ModelCacheHelper.getModel((long)this.getModelId()).getSrcAppNum().toLowerCase(Locale.ENGLISH);
        OperationLogUtil.writeLog((String)appNum, (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.ENABLE, (MultiLangEnumBridge)OperationMsgUtil.getEnableSucWithNumber((String)((String)this.getModel().getValue("number"))));
    }

    private boolean checkAndRefreshDimEnableCols(ModelErResponse modelErResponse) {
        if (modelErResponse.getErrorMsg() != null) {
            this.getView().showTipNotification(String.format(modelErResponse.getErrorMsg().loadKDString(), modelErResponse.getErrorNumbers()));
            return true;
        }
        if (CollectionUtils.isNotEmpty((Collection)modelErResponse.getRefreshCols())) {
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("dimlist");
            for (DynamicObject dynamicObject : dynamicObjects) {
                String fColNumber = dynamicObject.getString("dimnumber_l");
                if (!modelErResponse.getRefreshCols().contains(fColNumber)) continue;
                dynamicObject.set("isenable", (Object)"true");
            }
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes == evt.getResult()) {
            switch (evt.getCallBackId()) {
                case "btn_refresh": {
                    this.createDimData();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"BizModelRelationFormPlugin_29", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "btn_enable": {
                    this.enableData();
                    break;
                }
                case "confirm_btn_enable": {
                    if (this.beforeCheckNullView()) {
                        return;
                    }
                    this.saveAndOpenDimList(OperationStatus.EDIT, "saveenablemulti");
                    break;
                }
                case "btn_close": {
                    this.getView().close();
                    break;
                }
            }
        }
    }

    public void refreshDimListData() {
        boolean changeDimListData = this.isChangeDimListData();
        if (changeDimListData) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u7ef4\u5ea6\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u5237\u65b0\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BizModelRelationFormPlugin_30", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("btn_refresh", (IFormPlugin)this));
        } else {
            this.createDimData();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"BizModelRelationFormPlugin_29", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
    }

    public boolean isChangeDimListData() {
        String id;
        boolean flag = false;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimlist");
        for (DynamicObject dim : entryEntity) {
            String changetype = dim.getString("changetype");
            if (!"2".equals(changetype)) continue;
            return true;
        }
        String soucreId = id = this.getPageCache().get(ID_CACHE);
        if (StringUtils.isBlank((CharSequence)id)) {
            soucreId = (String)this.getView().getFormShowParameter().getCustomParam("id");
        }
        if (StringUtils.isNotBlank((CharSequence)soucreId)) {
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
            BizModelBean bizModelBean = modelCache.getBizModelById(Long.parseLong(soucreId));
            String strUniqueCheckBefore = bizModelBean.getUniquecheck();
            String strUniqueCheck = (String)this.getModel().getValue("uniquecheckvalue");
            if (StringUtils.isNotBlank((CharSequence)strUniqueCheckBefore) && StringUtils.isNotBlank((CharSequence)strUniqueCheck)) {
                List<String> strUniqueCheckList;
                List<String> strUniqueCheckBeforeList = Arrays.asList(strUniqueCheckBefore.split(","));
                boolean isEqual = strUniqueCheckBeforeList.containsAll(strUniqueCheckList = Arrays.asList(strUniqueCheck.split(","))) && strUniqueCheckList.containsAll(strUniqueCheckBeforeList);
                return !isEqual;
            }
        }
        return flag;
    }

    protected void saveDimList(Long mainId) {
        LinkedHashMap<String, List<String>> result = this.getSelectedIdsFromCache(this.getPageCache(), DATA_CACHE);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimlist");
        int i = 0;
        ArrayList<DynamicObject> dimRefList = new ArrayList<DynamicObject>(10);
        for (DynamicObject dim : entryEntity) {
            List list;
            DynamicObject dimRef = null;
            long id = dim.getLong("id");
            boolean flag = false;
            if (result.size() > 0 && (list = (List)result.get(Long.toString(id))) != null && list.size() > 0) {
                String type = (String)list.get(2);
                if (RelationTypeEnum.DIMLIB.getType().equals(type)) {
                    flag = true;
                }
            }
            if (id == 0L || !flag) {
                dimRef = BusinessDataServiceHelper.newDynamicObject((String)this.getMetaDataEntity(this.getView(), "epbs_relationmodelentity"));
                dimRef.set("id", (Object)id);
            } else {
                dimRef = BusinessDataServiceHelper.loadSingle((Object)id, (String)this.getMetaDataEntity(this.getView(), "epbs_relationmodelentity"));
            }
            String type = dim.get("type_l").toString();
            DynamicObjectCollection dimmembers = dimRef.getDynamicObjectCollection("dimmembers");
            dimmembers.clear();
            if (RelationTypeEnum.DIMLIB.getType().equals(type) || RelationTypeEnum.MODEL.getType().equals(type)) {
                LinkedHashMap<String, List<List<String>>> memberResult;
                List<List<String>> listData;
                type = this.convertSourceDimToType(dim.get("sourcedim_l").toString());
                if (RelationTypeEnum.DIMLIB.getType().equals(type) && (listData = (memberResult = this.getMemberFromCache(this.getPageCache(), MEMBER_CACHE)).get(String.valueOf(id))) != null && listData.size() > 0) {
                    for (int s = 0; s < listData.size(); ++s) {
                        List<String> list2 = listData.get(s);
                        DynamicObject viewRef = new DynamicObject(dimmembers.getDynamicObjectType());
                        viewRef.set("memberid", (Object)Long.parseLong(list2.get(0)));
                        viewRef.set("view", (Object)Long.parseLong(list2.get(3)));
                        viewRef.set("scope", (Object)list2.get(5));
                        dimmembers.add((Object)viewRef);
                    }
                }
            }
            dimRef.set("model", (Object)this.getModelId());
            dimRef.set("bizmodel", (Object)mainId);
            dimRef.set("number", dim.get("dimnumber_l"));
            dimRef.set("name", dim.get("dimname_l"));
            dimRef.set("description", dim.get("dimdescription_l"));
            dimRef.set("type", (Object)type);
            dimRef.set("basedataid", (Object)dim.getLong("basedata_l"));
            dimRef.set("selectmodelid", (Object)dim.getLong("bizmodel_l"));
            dimRef.set("dimensionid", (Object)dim.getLong("dimension_l"));
            dimRef.set("ismustinput", dim.get("ismustinput_l"));
            dimRef.set("isconnect", dim.get("isconnect_l"));
            if (RelationTypeEnum.NOTHING.getType().equals(type)) {
                dimRef.set("datatye", dim.get("datatye_l"));
            } else {
                dimRef.set("datatye", (Object)BizModelErTypeEnum.STRING.getCode());
            }
            dimRef.set("businessdomainid", (Object)dim.getLong("businessdomainid_l"));
            dimRef.set("dseq", (Object)i);
            ++i;
            dimRefList.add(dimRef);
        }
        Set<String> deleteSet = this.getDataSet(DELETE_CACHE);
        if (deleteSet.size() > 0) {
            HashSet set = new HashSet();
            deleteSet.stream().forEach(c -> set.add(Long.parseLong(c)));
            DeleteServiceHelper.delete((String)this.getMetaDataEntity(this.getView(), "epbs_relationmodelentity"), (QFilter[])new QFilter("id", "in", set).toArray());
        }
        SaveServiceHelper.save((DynamicObject[])dimRefList.toArray(new DynamicObject[0]));
        this.createDimData();
    }

    @NotNull
    private static String getSourceDimYwModel() {
        return "13";
    }

    private String convertSourceDimToType(String type) {
        if (BizModelRelationFormPlugin.getSourceDimYwModel().equals(type)) {
            type = RelationTypeEnum.MODEL.getType();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"sourcedim_yw"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"sourcedim_yw"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"sourcedim"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"sourcedim"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"sourcedim_yw"});
        }
        return type;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if ("dimension".equals(propName)) {
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
        } else if ("bizmodel".equals(propName)) {
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("model", "=", (Object)this.getModelId()).and(new QFilter("type", "=", (Object)"1")));
        } else if ("dimensionref".equals(propName)) {
            Long multiModelId = this.getMultiModelId();
            if (multiModelId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6a21\u578b\u3002", (String)"BizModelRelationFormPlugin_31", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList idList = new ArrayList();
            String metaDataEntity = this.getMetaDataEntity(this.getView(), "epbs_dimmodelref");
            Arrays.stream(BusinessDataServiceHelper.load((String)metaDataEntity, (String)"dimension_id", (QFilter[])new QFilter("businessdomain", "=", (Object)this.getBusinessdomainid()).toArray())).forEach(c -> idList.add(c.getLong("dimension_id")));
            Arrays.stream(BusinessDataServiceHelper.load((String)metaDataEntity, (String)"dimension_id", (QFilter[])new QFilter("bizmodel", "=", (Object)multiModelId).toArray())).forEach(c -> idList.add(c.getLong("dimension_id")));
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("model", "=", (Object)this.getModelId()).and(new QFilter("id", "in", idList)));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        MultiF7Result multiF7Result;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("dim_add".equals(actionId)) {
            Map map;
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData != null && (map = (Map)returnData.get("data")) != null && map.size() > 0) {
                int row = this.getModel().createNewEntryRow("dimlist");
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("dimlist", row);
                long id = GlobalIdUtil.genGlobalLongId();
                entryRowEntity.set("id", (Object)id);
                entryRowEntity.set("changetype", (Object)"2");
                String type = map.get("type").toString();
                if (RelationTypeEnum.DIMLIB.getType().equals(type)) {
                    Object member;
                    type = map.get("sourcedim").toString();
                    if (RelationTypeEnum.DIMLIB.getType().equals(type) && (member = (List)map.get("member")).size() > 0) {
                        this.addMemberData(id, (List<Map<String, String>>)member);
                    }
                }
                for (Map.Entry entry : map.entrySet()) {
                    entryRowEntity.set((String)entry.getKey() + "_l", entry.getValue());
                }
                LinkedHashMap<String, List<String>> result = this.getSelectedIdsFromCache(this.getPageCache(), DATA_CACHE);
                result.put(IDUtils.toString((Object)id), Arrays.asList(map.get("dimnumber").toString(), map.get("dimname").toString(), "2"));
                this.cacheSelect(this.getPageCache(), result, DATA_CACHE);
                Set<String> numberSet = this.getDataSet(NUMBER_CACHE);
                numberSet.add(map.get("dimnumber").toString());
                this.getPageCache().put(NUMBER_CACHE, String.join((CharSequence)",", numberSet));
                this.getView().updateView("dimlist");
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("dimlist");
                entryGrid.entryRowClick(Integer.valueOf(row));
                entryGrid.selectRows(row);
                this.setDimInfo();
                this.lockOrUnlockView();
            }
        } else if ("uniquecheck".equals(actionId)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData != null && returnData.size() > 0) {
                String _cacheStr = returnData.get("selectData") == null ? "" : (String)returnData.get("selectData");
                this.getModel().setValue("uniquecheckvalue", (Object)_cacheStr);
                BizModelServiceHelper.setPriorityValue((AbstractFormPlugin)this, (String)"uniquecheckvalue");
                BizModelServiceHelper.setPriorityText((AbstractFormPlugin)this, (String)"uniquecheck", (boolean)false);
                this.setIsMustInputAfterChoose(_cacheStr);
            }
        } else if ("addmember".equals(actionId) && (multiF7Result = (MultiF7Result)closedCallBackEvent.getReturnData()) != null) {
            this.getModel().deleteEntryData(ENTRYENTITY);
            List<EpbsSelectedMember> list = multiF7Result.getSelectedMemberList();
            this.setMemberlistData(list);
        }
    }

    private void setIsMustInputAfterChoose(String _cacheStr) {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("dimlist");
        for (DynamicObject dynamicObject : dynamicObjects) {
            List uniqueList = Arrays.stream(_cacheStr.split(",")).collect(Collectors.toList());
            if (!uniqueList.contains(dynamicObject.getString("id"))) continue;
            dynamicObject.set("ismustinput_l", (Object)true);
            if (!uniqueList.contains(this.getModel().getValue("idref"))) continue;
            this.getModel().setValue("ismustinput", (Object)true);
        }
        this.lockOrUnlockView();
    }

    private void addMemberData(long id, List<Map<String, String>> member) {
        LinkedHashMap<String, List<List<String>>> memberResult = this.getMemberFromCache(this.getPageCache(), MEMBER_CACHE);
        ArrayList<List<String>> listData = new ArrayList<List<String>>(member.size());
        for (int i = 0; i < member.size(); ++i) {
            Map<String, String> map = member.get(i);
            listData.add(Arrays.asList(map.get("memberid"), map.get("membername"), map.get("membernumber"), map.get("viewid"), map.get("viewname"), map.get("scope")));
        }
        memberResult.put(String.valueOf(id), listData);
        this.cacheMember(this.getPageCache(), memberResult, MEMBER_CACHE);
    }

    public void entryRowClick(RowClickEvent evt) {
        String entryGridKey = ((EntryGrid)evt.getSource()).getKey();
        if ("dimlist".equals(entryGridKey)) {
            this.setDimInfo();
            this.lockOrUnlockView();
        } else if (ENTRYENTITY.equals(entryGridKey)) {
            String id;
            int dimlistRowIndex = this.getModel().getEntryCurrentRowIndex("dimlist");
            DynamicObject dimlistRowEntity = this.getModel().getEntryRowEntity("dimlist", dimlistRowIndex);
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, entryCurrentRowIndex);
            if (entryRowEntity == null) {
                return;
            }
            Long membernumber = entryRowEntity.getLong("memberid");
            String soucreId = id = this.getPageCache().get(ID_CACHE);
            if (StringUtils.isBlank((CharSequence)id)) {
                soucreId = (String)this.getView().getFormShowParameter().getCustomParam("id");
            }
            if (StringUtils.isNotBlank((CharSequence)soucreId)) {
                EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
                BizModelBean bizModelBean = modelCache.getBizModelById(Long.parseLong(soucreId));
                if (bizModelBean == null) {
                    this.setDelBtnTrue();
                    return;
                }
                RelationFieldBean relationFieldBean = (RelationFieldBean)bizModelBean.getRelationFieldMap().get(Long.valueOf((String)dimlistRowEntity.get("id")));
                if (relationFieldBean == null) {
                    this.setDelBtnTrue();
                    return;
                }
                List dimMembers = relationFieldBean.getDimMembers();
                if (dimMembers.stream().anyMatch(q -> q.getMemberId().equals(membernumber))) {
                    this.setDelBtnFlase();
                } else {
                    this.setDelBtnTrue();
                }
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String column = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        if ("dimtable_l".equals(column)) {
            String idCache;
            Long id = this.getId();
            if (IDUtils.isNull((Long)id) && StringUtils.isNotBlank((CharSequence)(idCache = this.getPageCache().get(ID_CACHE)))) {
                id = Long.parseLong(idCache);
            }
            if (IDUtils.isNotNull((Long)id)) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("dimlist", rowIndex);
                Object dimensionL = entryRowEntity.get("dimension_l");
                Object basedata_l = entryRowEntity.get("basedata_l");
                if (!ObjectUtils.isEmpty((Object)dimensionL) && !Objects.equals(dimensionL, 0L)) {
                    String type = entryRowEntity.getString("type_l");
                    String bizmodelL = entryRowEntity.getString("bizmodel_l");
                    if ("2".equals(type) && (StringUtils.isBlank((CharSequence)bizmodelL) || Long.parseLong(bizmodelL) == 0L)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6a21\u578b\u3002", (String)"BizModelRelationFormPlugin_31", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    long dimId = Long.parseLong(dimensionL.toString());
                    FormShowParameter formShowParameter = new FormShowParameter();
                    formShowParameter.setFormId(this.getMetaDataEntity(this.getView(), "epbs_dimension_manager"));
                    formShowParameter.setPageId(this.getView().getPageId() + formShowParameter.getFormId() + id + dimId);
                    formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    formShowParameter.setCustomParam("bizModelId", (Object)id);
                    formShowParameter.setCustomParam("dimensionId", (Object)dimId);
                    formShowParameter.setCustomParam("refBizModelId", (Object)bizmodelL);
                    formShowParameter.setCustomParam("type", (Object)type);
                    this.getView().showForm(formShowParameter);
                }
                if (!ObjectUtils.isEmpty((Object)basedata_l) && Objects.equals(basedata_l, 0L)) {
                    FormShowParameter formShowParameter = new FormShowParameter();
                    formShowParameter.setFormId("epbs_basedatalist");
                    formShowParameter.setPageId(this.getView().getPageId() + formShowParameter.getFormId() + id + basedata_l);
                    formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    formShowParameter.setCustomParam("basedataId", basedata_l);
                    this.getView().showForm(formShowParameter);
                }
            }
        }
    }

    private void setDimInfo() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("dimlist");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("dimlist", entryCurrentRowIndex);
        this.getModel().beginInit();
        if (entryRowEntity != null) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"dimensionref", "type"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tipap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"baseinfoap"});
            this.getModel().setValue("idref", entryRowEntity.get("id"));
            this.getModel().setValue("dimnumber", entryRowEntity.get("dimnumber_l"));
            this.getModel().setValue("dimname", entryRowEntity.get("dimname_l"));
            this.getModel().setValue("dimdescription", entryRowEntity.get("dimdescription_l"));
            String type = entryRowEntity.getString("type_l");
            if (RelationTypeEnum.DIMLIB.getType().equals(type)) {
                type = this.convertSourceDimToType(entryRowEntity.getString("sourcedim_l"));
            }
            if (RelationTypeEnum.DIMLIB.getType().equals(type)) {
                this.getModel().setValue("type", (Object)RelationTypeEnum.DIMLIB.getType());
                this.getModel().setValue("dimension", entryRowEntity.get("dimension_l"));
                this.getModel().setValue("sourcedim", (Object)type);
                DimensionServiceHelper.setVisibleFlex((AbstractFormPlugin)this, (boolean)true, (String)"sourcedim");
                this.setMemberlistInfo();
            } else if (RelationTypeEnum.MODEL.getType().equals(type)) {
                this.getModel().setValue("type", (Object)RelationTypeEnum.DIMLIB.getType());
                this.getModel().setValue("sourcedim", (Object)type);
                DimensionServiceHelper.setVisibleFlex((AbstractFormPlugin)this, (boolean)true, (String)"sourcedim");
                Object businessdomainidL = entryRowEntity.get("businessdomainid_l");
                if (!ObjectUtils.isEmpty((Object)businessdomainidL)) {
                    this.getModel().setValue("businessdomainid", businessdomainidL);
                    this.getModel().setValue("sourcedim_yw", (Object)BizModelRelationFormPlugin.getSourceDimYwModel());
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"businessdomainid"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"bizmodel"});
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"dimensionref", "type"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"businessdomainid"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"bizmodel"});
                    this.getModel().setValue("dimensionref", null);
                }
                this.getModel().setValue("dimensionref", entryRowEntity.get("dimension_l"));
            } else {
                this.getModel().setValue("type", (Object)type);
                DimensionServiceHelper.setVisibleFlex((AbstractFormPlugin)this, (boolean)true, (String)"type");
            }
            this.getModel().setValue("bizmodel", entryRowEntity.get("bizmodel_l"));
            this.getModel().setValue("basedata", entryRowEntity.get("basedata_l"));
            this.getModel().setValue("isconnect", entryRowEntity.get("isconnect_l"));
            this.getModel().setValue("ismustinput", entryRowEntity.get("ismustinput_l"));
            this.getModel().setValue("datatye", entryRowEntity.get("datatye_l"));
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"baseinfoap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tipap"});
            this.getModel().setValue("dimnumber", null);
            this.getModel().setValue("dimname", null);
            this.getModel().setValue("dimdescription", null);
            this.getModel().deleteEntryData(ENTRYENTITY);
        }
        this.getModel().endInit();
        this.getView().updateView("splitpanel_right");
    }

    private void lockOrUnlockView() {
        String cubeNumber;
        if ("1".equals(String.valueOf(this.getModel().getValue("enable")))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"fieldsetpanelap", "splitcontainer_outside", "btn_multisave", "saveenablemulti", BTN_ENABLE});
            HashMap<String, String> map2 = new HashMap<String, String>(1);
            map2.put("fc", "#999");
            this.getView().updateControlMetadata("addmember", map2);
            this.getView().updateControlMetadata("delmember", map2);
            this.setEnableflexVisible(true);
        } else {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimlist");
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"fieldsetpanelap", "splitcontainer_outside", "btn_multisave"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"datatye"});
            if (!entryEntity.isEmpty()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"saveenablemulti", BTN_ENABLE});
            }
            HashMap<String, String> map3 = new HashMap<String, String>(1);
            map3.put("fc", "#3987ed");
            this.getView().updateControlMetadata("addmember", map3);
            this.getView().updateControlMetadata("delmember", map3);
            this.setEnableflexVisible(false);
        }
        DynamicObject businessdomainid = (DynamicObject)this.getModel().getValue("businessdomainid");
        String isEnable = (String)this.getModel().getValue("isenable");
        if (isEnable != null) {
            if (businessdomainid != null || "true".equals(isEnable)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"type", "datatye", "sourcedim", "bizmodel", "dimensionref", "dimension"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"type", "datatye", "sourcedim", "bizmodel", "dimensionref", "dimension"});
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(cubeNumber = (String)this.getModel().getValue("cubeNumber")))) {
            String uniqStrs = this.getPageCache().get(SAVE_UNIQ_ID_CACHE);
            if (StringUtils.isNotBlank((CharSequence)uniqStrs)) {
                String dimMapStr = this.getPageCache().get(SAVE_ID_CACHE);
                List dimMapList = (List)SerializationUtils.fromJsonString((String)dimMapStr, List.class);
                List beforeNotMustList = dimMapList.stream().filter(map -> map.containsKey("ismustinput_l") && ((String)map.get("ismustinput_l")).equals("false")).map(map -> (String)map.get("id")).collect(Collectors.toList());
                List beforeList = dimMapList.stream().map(map -> (String)map.get("id")).collect(Collectors.toList());
                String strId = (String)this.getModel().getValue("id");
                String curUniqueStr = (String)this.getModel().getValue("uniquecheckvalue");
                List<String> curUniqueList = Arrays.asList(curUniqueStr.split(","));
                if (curUniqueList.contains(strId) || beforeNotMustList.contains(strId) || StringUtils.isBlank((CharSequence)isEnable)) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"ismustinput"});
                } else {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"ismustinput"});
                }
            }
        } else {
            String strId = (String)this.getModel().getValue("id");
            String curUniqueStr = (String)this.getModel().getValue("uniquecheckvalue");
            List<String> curUniqueList = Arrays.asList(curUniqueStr.split(","));
            if (curUniqueList.contains(strId)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"ismustinput"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"ismustinput"});
            }
        }
    }

    private void setDelBtnTrue() {
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"delmember"});
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("fc", "#3987ed");
        this.getView().updateControlMetadata("delmember", map);
    }

    private void setDelBtnFlase() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"delmember"});
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("fc", "#999");
        this.getView().updateControlMetadata("delmember", map);
    }

    public void setEnableflexVisible(boolean flag) {
        if (flag) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"disableflex"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"enableflex"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"enableflex"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"disableflex"});
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"disableflex", "enableflex"});
    }

    private void setBtnEable() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimlist");
        if ("1".equals(String.valueOf(this.getModel().getValue("enable"))) || entryEntity.isEmpty()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ENABLE});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_ENABLE});
        }
    }

    private void setRowData(String field) {
        List<String> list = Arrays.asList("dimension", "bizmodel", "dimensionref", "basedata");
        List<String> mulistList = Arrays.asList("dimnumber", "dimname");
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("dimlist");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("dimlist", entryCurrentRowIndex);
        if (entryRowEntity != null) {
            DynamicObject basedata;
            if (mulistList.contains(field)) {
                String str;
                Object value = this.getModel().getValue(field);
                if (ObjectUtils.isEmpty((Object)value)) {
                    return;
                }
                if ("dimnumber".equals(field) && StringUtils.isNotBlank((CharSequence)(str = this.checkNumber(entryRowEntity.getString("dimnumber_l"), field)))) {
                    this.getView().showTipNotification(str);
                    return;
                }
            }
            String realField = field;
            if (list.contains(field)) {
                realField = realField + "_id";
            }
            if ("dimensionref".equals(field)) {
                this.getModel().setValue("dimension_l", this.getModel().getValue(realField), entryCurrentRowIndex);
            } else {
                this.getModel().setValue(field + "_l", this.getModel().getValue(realField), entryCurrentRowIndex);
                if ("bizmodel".equals(field)) {
                    this.getModel().setValue("dimensionref", null);
                    this.getModel().setValue("dimension_l", (Object)"", entryCurrentRowIndex);
                }
            }
            Object type = this.getModel().getValue("type");
            if (RelationTypeEnum.DIMLIB.getType().equals(type)) {
                Object sourcedim;
                type = sourcedim = this.getModel().getValue("sourcedim");
            }
            String dimtableData = "";
            if (RelationTypeEnum.DIMLIB.getType().equals(type)) {
                DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
                if (dimension != null) {
                    dimtableData = dimension.getString("number");
                }
            } else if (RelationTypeEnum.MODEL.getType().equals(type)) {
                DynamicObject dimensionref = (DynamicObject)this.getModel().getValue("dimensionref");
                if (dimensionref != null) {
                    dimtableData = dimensionref.getString("number");
                }
            } else if (RelationTypeEnum.BASICDATA.getType().equals(type) && (basedata = (DynamicObject)this.getModel().getValue("basedata")) != null) {
                dimtableData = basedata.getString("number");
            }
            this.getModel().setValue("dimtable_l", (Object)dimtableData, entryCurrentRowIndex);
            this.getModel().setValue("changetype", (Object)"2", entryCurrentRowIndex);
        }
    }

    private String checkNumber(String dimnumber_l, String field) {
        String msg = "";
        String newNumber = this.getModel().getValue(field).toString();
        if (!dimnumber_l.equals(newNumber)) {
            Set<String> numberSet = this.getDataSet(NUMBER_CACHE);
            if (numberSet.contains(newNumber)) {
                msg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201c\u4e0d\u80fd\u91cd\u590d\u3002", (String)"BizModelRelationFormPlugin_32", (String)"epm-epbs-formplugin", (Object[])new Object[0]), newNumber);
            } else {
                numberSet.remove(dimnumber_l);
                this.getPageCache().put(NUMBER_CACHE, String.join((CharSequence)",", numberSet));
            }
        }
        return msg;
    }

    private Long getMultiModelId() {
        return (Long)this.getModel().getValue("bizmodel_id");
    }

    LinkedHashMap<String, List<String>> getSelectedIdsFromCache(@NotNull IPageCache pageCache, String keyCache) {
        LinkedHashMap selectDatas;
        String _cacheStr = pageCache.get(keyCache);
        if (StringUtils.isNotEmpty((CharSequence)_cacheStr)) {
            _cacheStr = GZIPUtils.uncompressToString((byte[])((byte[])SerializationUtils.deSerializeFromBase64((String)_cacheStr)));
            selectDatas = (LinkedHashMap)JSON.parseObject((String)_cacheStr, LinkedHashMap.class);
        } else {
            selectDatas = new LinkedHashMap();
        }
        return selectDatas;
    }

    public void cacheSelect(@NotNull IPageCache pageCache, Map<String, List<String>> selectDatas, String keyCache) {
        if (selectDatas == null || selectDatas.isEmpty()) {
            pageCache.remove(keyCache);
        } else {
            pageCache.put(keyCache, SerializationUtils.serializeToBase64((Object)GZIPUtils.compress((String)JSON.toJSONString(selectDatas))));
        }
    }

    LinkedHashMap<String, List<List<String>>> getMemberFromCache(@NotNull IPageCache pageCache, String keyCache) {
        LinkedHashMap selectDatas;
        String _cacheStr = pageCache.get(keyCache);
        if (StringUtils.isNotEmpty((CharSequence)_cacheStr)) {
            _cacheStr = GZIPUtils.uncompressToString((byte[])((byte[])SerializationUtils.deSerializeFromBase64((String)_cacheStr)));
            selectDatas = (LinkedHashMap)JSON.parseObject((String)_cacheStr, LinkedHashMap.class);
        } else {
            selectDatas = new LinkedHashMap();
        }
        return selectDatas;
    }

    public void cacheMember(@NotNull IPageCache pageCache, LinkedHashMap<String, List<List<String>>> selectDatas, String keyCache) {
        if (selectDatas == null || selectDatas.isEmpty()) {
            pageCache.remove(keyCache);
        } else {
            pageCache.put(keyCache, SerializationUtils.serializeToBase64((Object)GZIPUtils.compress((String)JSON.toJSONString(selectDatas))));
        }
    }

    public String getAllDimNum() {
        HashSet<String> numberSet = new HashSet<String>();
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("dimlist");
        for (DynamicObject dynamicObject : entryEntity) {
            String numberL = dynamicObject.getString("dimnumber_l");
            numberSet.add(numberL);
        }
        return String.join((CharSequence)",", numberSet);
    }

    public Set<String> getDataSet(String cacheName) {
        String numberStr = this.getPageCache().get(cacheName);
        HashSet<String> numberSet = new HashSet<String>();
        if (StringUtils.isNotEmpty((CharSequence)numberStr)) {
            numberSet = new HashSet<String>(Arrays.asList(numberStr.split(",")));
        }
        return numberSet;
    }

    private void showPriorityEdit(String key) {
        String jsonString = SerializationUtils.toJsonString(this.createDimMap());
        String saveIds = this.getPageCache().get(SAVE_UNIQ_ID_CACHE);
        if (StringUtils.isNotBlank((CharSequence)saveIds)) {
            String dimMapStr = this.getPageCache().get(SAVE_ID_CACHE);
            List dimMapList = (List)SerializationUtils.fromJsonString((String)dimMapStr, List.class);
            ArrayList<Map> dimMapListAtLast = new ArrayList<Map>();
            List<String> saveList = Arrays.asList(saveIds.split(","));
            for (Map stringStringMap : dimMapList) {
                String id = (String)stringStringMap.get("id");
                if (!saveList.contains(id)) continue;
                dimMapListAtLast.add(stringStringMap);
            }
            jsonString = SerializationUtils.toJsonString(dimMapListAtLast);
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(this.getMetaDataEntity(this.getView(), "epbs_uniquecheckref"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        formShowParameter.setCustomParam("dimlist", (Object)jsonString);
        formShowParameter.setCustomParam(PRIORITY_CACHE, this.getModel().getValue("uniquecheckvalue"));
        formShowParameter.setCustomParam("type", (Object)"1");
        formShowParameter.setPageId(this.getView().getPageId() + formShowParameter.getFormId());
        formShowParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(formShowParameter);
    }

    private List<Map<String, String>> createDimMap() {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dimlist");
        for (DynamicObject dim : entryEntity) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", dim.get("id"));
            map.put("dimnumber_l", dim.get("dimnumber_l"));
            map.put("dimname_l", dim.get("dimname_l"));
            map.put("type_l", dim.get("type_l"));
            map.put("sourcedim_l", dim.get("sourcedim_l"));
            map.put("dimtable_l", dim.get("dimtable_l"));
            map.put("dimdescription_l", dim.get("dimdescription_l"));
            map.put("ismustinput_l", dim.get("ismustinput_l"));
            result.add(map);
        }
        return result;
    }
}

