/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.bizmodel;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.epm.epbs.common.model.IMetaDataEntity;
import kd.epm.epbs.common.util.GZIPUtils;
import kd.epm.epbs.common.util.IDUtils;
import org.jetbrains.annotations.NotNull;

public class BizModelUniquecheckFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
IMetaDataEntity {
    private static final String F7SELECTEDLISTAP = "f7selectedlistap";
    private static final String CACHE_SELECT = "cache_select";
    private static final String DIMLIST = "dimlist";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(DIMLIST);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7SELECTEDLISTAP);
        f7SelectedList.addF7SelectedListRemoveListener(f7SelectedListRemoveEvent -> this.clearSelection(f7SelectedListRemoveEvent.getParam().toString()));
        f7SelectedList.addF7SelectedListRemoveAllListener(new F7SelectedListRemoveListener(){

            public void RemoveClick(F7SelectedListRemoveEvent f7SelectedListRemoveEvent) {
                BizModelUniquecheckFormPlugin.this.clearAllSelection();
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LinkedHashMap<String, List<String>> newSelectDatas = new LinkedHashMap<String, List<String>>();
        String dimlistStr = (String)this.getView().getFormShowParameter().getCustomParam(DIMLIST);
        String cacheStr = (String)this.getView().getFormShowParameter().getCustomParam("priority_cache");
        Object type = this.getView().getFormShowParameter().getCustomParam("type");
        LinkedHashSet<Object> cacheStrSet = new LinkedHashSet();
        if (StringUtils.isNotEmpty((CharSequence)cacheStr)) {
            cacheStrSet = new LinkedHashSet<String>(Arrays.asList(cacheStr.split(",")));
        }
        if (StringUtils.isNotEmpty((CharSequence)dimlistStr)) {
            List entryEntity = (List)SerializationUtils.fromJsonString((String)dimlistStr, List.class);
            if (entryEntity != null && entryEntity.size() > 0) {
                this.getModel().batchCreateNewEntryRow(DIMLIST, entryEntity.size());
                DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(DIMLIST);
                if (ObjectUtils.isEmpty((Object)type)) {
                    for (int i = 0; i < entryEntity.size(); ++i) {
                        Map dimRef = (Map)entryEntity.get(i);
                        DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                        entry.set("id", dimRef.get("id"));
                        entry.set("dimnumber_l", dimRef.get("dimnumber_l"));
                        entry.set("dimname_l", dimRef.get("dimname_l"));
                        entry.set("dimtype_l", dimRef.get("dimtype_l"));
                        entry.set("aggoprttype_l", dimRef.get("aggoprttype_l"));
                        entry.set("dimdescription_l", dimRef.get("dimdescription_l"));
                        entry.set("source_l", dimRef.get("source_l"));
                        entry.set("dimview_l", dimRef.get("dimview_l"));
                        newSelectDatas.put(IDUtils.toString(dimRef.get("id")), Arrays.asList(IDUtils.toString(dimRef.get("id")), entry.getString("dimname_l"), i + "", null, "1"));
                    }
                } else {
                    for (int i = 0; i < entryEntity.size(); ++i) {
                        Map dimRef = (Map)entryEntity.get(i);
                        DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                        entry.set("id", dimRef.get("id"));
                        entry.set("dimnumber_l", dimRef.get("dimnumber_l"));
                        entry.set("dimname_l", dimRef.get("dimname_l"));
                        entry.set("type_l", dimRef.get("type_l"));
                        entry.set("dimtable_l", dimRef.get("dimtable_l"));
                        entry.set("sourcedim_l", dimRef.get("sourcedim_l"));
                        entry.set("dimdescription_l", dimRef.get("dimdescription_l"));
                        newSelectDatas.put(IDUtils.toString(dimRef.get("id")), Arrays.asList(IDUtils.toString(dimRef.get("id")), entry.getString("dimname_l"), i + "", null, "1"));
                    }
                }
            }
            this.getView().updateView(DIMLIST);
            if (cacheStrSet.size() > 0) {
                LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)cacheStrSet.size());
                cacheStrSet.stream().forEach(c -> {
                    List list = (List)newSelectDatas.get(c);
                    if (list != null && list.size() > 0) {
                        result.put(c, newSelectDatas.get(c));
                    }
                });
                this.cacheSelect(this.getPageCache(), result);
                this.updateSelected();
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setSelectRow();
    }

    public void setSelectRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(DIMLIST);
        LinkedHashMap<String, List<String>> result = this.getSelectedIdsFromCache(this.getPageCache());
        if (result.size() > 0) {
            int[] array = new int[result.size()];
            int i = 0;
            for (Map.Entry entry : result.entrySet()) {
                int row;
                List list = (List)entry.getValue();
                array[i] = row = Integer.parseInt((String)list.get(2));
                ++i;
            }
            entryGrid.selectRows(array, 0);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                HashMap<String, String> returnData = new HashMap<String, String>(16);
                LinkedHashMap<String, List<String>> selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
                Set keySet = selectedMembers.keySet();
                String selectData = String.join((CharSequence)",", keySet);
                returnData.put("selectData", selectData);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        LinkedHashMap<String, List<String>> selectedIds = this.getSelectedIdsFromCache(this.getPageCache());
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(DIMLIST);
        int[] selectRows = entryGrid.getSelectRows();
        HashSet removeIds = new HashSet(selectedIds.size());
        Map<String, List<String>> _selectedIds = this.getSelectRows(selectRows);
        for (Map.Entry entry : selectedIds.entrySet()) {
            if (_selectedIds.containsKey(entry.getKey())) continue;
            removeIds.add(entry.getKey());
        }
        for (String removeId : removeIds) {
            selectedIds.remove(removeId);
        }
        selectedIds.putAll(_selectedIds);
        this.cacheSelect(this.getPageCache(), selectedIds);
        this.updateSelected();
    }

    private Map<String, List<String>> getSelectRows(int[] selectRows) {
        if (selectRows == null || selectRows.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap selectedIds = Maps.newLinkedHashMapWithExpectedSize((int)selectRows.length);
        for (int i = 0; i < selectRows.length; ++i) {
            int selectRow = selectRows[i];
            DynamicObject row = this.getModel().getEntryRowEntity(DIMLIST, selectRow);
            String id = IDUtils.toString((Object)row.get("id"));
            String name = row.getString("dimname_l");
            selectedIds.put(id, Arrays.asList(id, name, selectRow + "", null, "1"));
        }
        return selectedIds;
    }

    public void cacheSelect(@NotNull IPageCache pageCache, Map<String, List<String>> selectDatas) {
        if (selectDatas == null || selectDatas.isEmpty()) {
            pageCache.remove(CACHE_SELECT);
        } else {
            pageCache.put(CACHE_SELECT, SerializationUtils.serializeToBase64((Object)GZIPUtils.compress((String)JSON.toJSONString(selectDatas))));
        }
    }

    private void clearSelection(String key) {
        LinkedHashMap<String, List<String>> selectedIds = this.getSelectedIdsFromCache(this.getPageCache());
        selectedIds.remove(key);
        this.cacheSelect(this.getPageCache(), selectedIds);
        this.updateSelected();
        this.setSelectRow();
    }

    public void clearAllSelection() {
        this.cacheSelect(this.getPageCache(), null);
        this.updateSelected();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(DIMLIST);
        entryGrid.clearEntryState();
    }

    protected void updateSelected() {
        F7SelectedList selectedF7 = (F7SelectedList)this.getControl(F7SELECTEDLISTAP);
        LinkedHashMap<String, List<String>> selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(selectedMembers.size());
        for (List member : selectedMembers.values()) {
            valueTextItems.add(new ValueTextItem((String)member.get(0), (String)member.get(1)));
        }
        selectedF7.addItems(valueTextItems);
    }

    LinkedHashMap<String, List<String>> getSelectedIdsFromCache(@NotNull IPageCache pageCache) {
        LinkedHashMap selectDatas;
        String _cacheStr = pageCache.get(CACHE_SELECT);
        if (StringUtils.isNotEmpty((CharSequence)_cacheStr)) {
            _cacheStr = GZIPUtils.uncompressToString((byte[])((byte[])SerializationUtils.deSerializeFromBase64((String)_cacheStr)));
            selectDatas = (LinkedHashMap)JSON.parseObject((String)_cacheStr, LinkedHashMap.class);
        } else {
            selectDatas = new LinkedHashMap();
        }
        return selectDatas;
    }
}

