/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.bizmodel;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.epm.epbs.business.model.bizmodel.BizModelServiceHelper;
import kd.epm.epbs.business.model.dimension.DimensionServiceHelper;
import kd.epm.epbs.business.permission.model.ModelPermHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.ModelBean;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.model.IMetaDataEntity;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;
import kd.epm.epbs.formplugin.model.ViewTreeF7SelectListener;

public class DimSelectFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IMetaDataEntity {
    private static final Log LOG = LogFactory.getLog(DimSelectFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dimension = (BasedataEdit)this.getControl("dimension");
        dimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        dimension.addAfterF7SelectListener(event -> {
            this.getModel().setValue("dimview", (Object)"");
            ListSelectedRowCollection listSelectedRowCollection = event.getListSelectedRowCollection();
            Object dimensionId = listSelectedRowCollection.isEmpty() ? event.getInputValue() : listSelectedRowCollection.get(0).getPrimaryKeyValue();
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
            DimTypeBean dimType = modelCache.getDimTypeByDimensionId(Long.parseLong(dimensionId.toString()));
            if (!dimType.isShowView()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"dimview"});
                try {
                    ViewBean viewBean = modelCache.getDefaultView(Long.parseLong(dimensionId.toString()));
                    QFilter qFilter1 = new QFilter("id", "=", (Object)viewBean.getId());
                    DynamicObject[] load = BusinessDataServiceHelper.load((String)this.getMetaDataEntity(this.getView(), "epbs_struct_view"), (String)"id,name,number", (QFilter[])new QFilter[]{qFilter1});
                    MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = new MulBasedataDynamicObjectCollection();
                    for (DynamicObject dynamicObject : load) {
                        mulBasedataDynamicObjectCollection.add(dynamicObject);
                    }
                    this.getModel().setValue("dimview", (Object)mulBasedataDynamicObjectCollection);
                }
                catch (Exception ex) {
                    LOG.error(ex.getMessage(), (Object)e);
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"dimview"});
            }
        });
        BasedataEdit dimview = (BasedataEdit)this.getControl("dimview");
        ViewTreeF7SelectListener viewTreeF7SelectListener = new ViewTreeF7SelectListener(this, this.getDimensionId());
        Object bizModelId = this.getView().getFormShowParameter().getCustomParam("bizModelId");
        if (bizModelId != null && !Objects.equals(bizModelId, 0)) {
            viewTreeF7SelectListener.setBizModelId((Long)bizModelId);
        }
        viewTreeF7SelectListener.setSelectRows(new Object[0]);
        dimview.addBeforeF7SelectListener((BeforeF7SelectListener)viewTreeF7SelectListener);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
        ModelBean model = modelCache.getModel();
        QFilter qFilter = new QFilter("appnumber", "=", (Object)model.getSrcAppNum()).and("status", "=", (Object)"1");
        Object cubenumber = this.getView().getFormShowParameter().getCustomParam("cubenumber");
        Long businessdomainid = this.getBusinessdomainid();
        boolean existCube = BizModelServiceHelper.isExistCube((Object)cubenumber, (Long)businessdomainid, (long)this.getModelId(), (String)this.getMetaDataEntity(this.getView(), "epbs_bizmodel"));
        if (existCube) {
            qFilter.and("type", "in", (Object)BizModelServiceHelper.existCubeTypeList);
        } else {
            Object dimTypeList = this.getView().getFormShowParameter().getCustomParam("dimTypeList");
            if (dimTypeList != null) {
                List dimList = (List)SerializationUtils.fromJsonString((String)((String)dimTypeList), List.class);
                List typeList = BizModelServiceHelper.queryDimTypeByRemoveList((long)this.getModelId(), (List)dimList);
                if (CollectionUtils.isNotEmpty((Collection)typeList)) {
                    qFilter.and("type", "in", (Object)typeList);
                }
            }
        }
        DynamicObjectCollection dimTypes = QueryServiceHelper.query((String)"epbs_dimtype", (String)"id,number,name", (QFilter[])qFilter.toArray(), (String)"desq");
        ComboEdit comboEdit = (ComboEdit)this.getControl("dimtype");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        for (DynamicObject dimType : dimTypes) {
            data.add(new ComboItem(new LocaleString(dimType.getString("name")), dimType.getString("id")));
        }
        comboEdit.setComboItems(data);
        this.getModel().setDataChanged(false);
    }

    private Long getModelId() {
        Object model = this.getView().getFormShowParameter().getCustomParam("model");
        if (model != null) {
            return (Long)model;
        }
        return 0L;
    }

    private Long getDimensionId() {
        return (Long)this.getModel().getValue("dimension_id");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.getView().getModel().updateCache();
        String opType = ((FormOperate)args.getSource()).getType();
        if ("donothing".equals(opType)) {
            String type = (String)this.getModel().getValue("type");
            if ("1".equals(type)) {
                EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
                String appPkId = AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getId();
                boolean permission = ModelPermHelper.checkPermission((long)this.getModelId(), (String)appPkId, (String)modelCache.getMetaDataEntity("epbs_dimension_manager"), (String)"49XZWXPSYI7J");
                if (!permission) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u7ef4\u5ea6\u7ba1\u7406\u201d\u7684\u201c\u7ef4\u5ea6\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DimSelectFormPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String msg = DimensionServiceHelper.checkAddData((AbstractFormPlugin)this);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    this.getView().showTipNotification(msg);
                    args.setCancel(true);
                    return;
                }
            }
            this.checkData(type, args);
        }
    }

    private void checkData(String type, BeforeDoOperationEventArgs args) {
        String returnStr = "";
        Object cubenumber = this.getView().getFormShowParameter().getCustomParam("cubenumber");
        DynamicObject modelobj = this.getModel().getDataEntity();
        long dimtype = modelobj.getLong("dimtype");
        Long businessdomainid = this.getBusinessdomainid();
        boolean existCube = BizModelServiceHelper.isExistCube((Object)cubenumber, (Long)businessdomainid, (long)this.getModelId(), (String)this.getMetaDataEntity(this.getView(), "epbs_bizmodel"));
        if (existCube && !StringUtils.isBlank((CharSequence)(returnStr = BizModelServiceHelper.checkExistCubeTypeList((long)dimtype, (long)this.getDimensionId(), (long)this.getModelId())))) {
            this.getView().showTipNotification(returnStr);
            args.setCancel(true);
            return;
        }
        if ("1".equals(type)) {
            BizModelServiceHelper.checkDimTypeData((Long)this.getBusinessdomainid(), (long)this.getModelId(), (String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"), (long)dimtype);
        } else {
            Set<Object> viewSet = new HashSet(16);
            Object dimview = this.getModel().getValue("dimview");
            DynamicObjectCollection dimviews = (DynamicObjectCollection)dimview;
            viewSet = dimviews.stream().map(o -> o.getString("fbasedataid_id")).collect(Collectors.toSet());
            returnStr = BizModelServiceHelper.checkRelationNumber((Long)this.getBusinessdomainid(), (String)this.getMetaDataEntity(this.getView(), "epbs_relationmodelentity"), (String)this.getMetaDataEntity(this.getView(), "epbs_dimension"), (long)this.getDimensionId());
            if (!StringUtils.isBlank((CharSequence)returnStr)) {
                this.getView().showTipNotification(returnStr);
                args.setCancel(true);
                return;
            }
            returnStr = BizModelServiceHelper.checkMuitlBizModelData((Long)this.getBusinessdomainid(), (long)this.getModelId(), (String)String.valueOf(this.getDimensionId()), viewSet, (String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"));
            if (!StringUtils.isBlank((CharSequence)returnStr)) {
                this.getView().showTipNotification(returnStr);
                args.setCancel(true);
                return;
            }
            returnStr = BizModelServiceHelper.checkDimTypeData((Long)this.getBusinessdomainid(), (long)this.getModelId(), (String)String.valueOf(this.getDimensionId()), viewSet, (String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"));
            if (!StringUtils.isBlank((CharSequence)returnStr)) {
                this.getView().showTipNotification(returnStr);
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("btnok".equals(operateKey)) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            String type = (String)this.getModel().getValue("type");
            returnData.put("type", type);
            if ("1".equals(type)) {
                DynamicObject dimension = this.createDimension();
                JSONObject jsonObject = DimensionServiceHelper.saveData((DynamicObject)dimension);
                String appNum = ModelCacheHelper.getModel((long)this.getModelId()).getSrcAppNum().toLowerCase(Locale.ENGLISH);
                OperationLogUtil.writeLog((String)appNum, (String)this.getMetaDataEntity(this.getView(), "epbs_dimension"), (IOperationTypeInfo)OperationTypeEnum.SAVE, (MultiLangEnumBridge)OperationMsgUtil.getSaveSucTipWithNumber((String)dimension.getString("number")));
                returnData.put("dimension", jsonObject.get((Object)"dimId"));
                Object viewId = jsonObject.get((Object)"viewId");
                returnData.put("dimviewId", viewId);
            } else {
                Object dimview = this.getModel().getValue("dimview");
                returnData.put("dimension", this.getDimensionId());
                returnData.put("dimview", dimview);
            }
            this.getView().returnDataToParent(returnData);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if ("dimension".equals(propName)) {
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
            List selectedIds = (List)this.getView().getFormShowParameter().getCustomParam("selectedIds");
            Object cubenumber = this.getView().getFormShowParameter().getCustomParam("cubenumber");
            Long businessdomainid = this.getBusinessdomainid();
            boolean existCube = BizModelServiceHelper.isExistCube((Object)cubenumber, (Long)businessdomainid, (long)this.getModelId(), (String)this.getMetaDataEntity(this.getView(), "epbs_bizmodel"));
            if (existCube) {
                EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
                ModelBean model = modelCache.getModel();
                QFilter qFilter = new QFilter("appnumber", "=", (Object)model.getSrcAppNum()).and("status", "=", (Object)"1").and("type", "in", (Object)BizModelServiceHelper.existCubeTypeList);
                Set typeSet = QueryServiceHelper.query((String)"epbs_dimtype", (String)"id", (QFilter[])qFilter.toArray()).stream().map(c -> c.getLong("id")).collect(Collectors.toSet());
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "not in", (Object)selectedIds).and("dtypeid", "in", typeSet));
            }
            if (!selectedIds.isEmpty() && !existCube) {
                HashSet typeSet = new HashSet(16);
                EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
                selectedIds.forEach(c -> {
                    DimensionBean dimension = modelCache.getDimensionById(c.longValue());
                    DimTypeBean dimType = modelCache.getDimTypeByDimensionId(c.longValue());
                    String type = dimType.getType();
                    if (!DimTypeEnum.Entity.getValue().equals(type) && !DimTypeEnum.Custom.getValue().equals(type)) {
                        typeSet.add(dimension.getDimTypeId());
                    }
                });
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "not in", (Object)selectedIds).and("dtypeid", "not in", typeSet));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    public DynamicObject createDimension() {
        DynamicObject dimension = BusinessDataServiceHelper.newDynamicObject((String)this.getMetaDataEntity(this.getView(), "epbs_dimension"));
        DynamicObject modelobj = this.getModel().getDataEntity();
        String number = modelobj.getString("dimnumber");
        Object name = modelobj.get("dimname");
        String shortnumber = modelobj.getString("dimshortnumber");
        Object description = modelobj.get("description");
        if (name instanceof Map) {
            dimension.set("name", (Object)LocaleString.fromMap((Map)((Map)name)));
        } else {
            dimension.set("name", (Object)name.toString());
        }
        if (description instanceof Map) {
            dimension.set("description", (Object)LocaleString.fromMap((Map)((Map)description)));
        } else {
            dimension.set("description", (Object)description.toString());
        }
        dimension.set("number", (Object)number);
        dimension.set("shortnumber", (Object)shortnumber);
        dimension.set("type", (Object)"2");
        dimension.set("model", this.getView().getFormShowParameter().getCustomParam("model"));
        dimension.set("dtypeid", (Object)modelobj.getLong("dimtype"));
        dimension.set("issysdimension", (Object)0);
        Long businessId = this.getBusinessdomainid();
        if (businessId == 0L) {
            dimension.set("reftype", (Object)2);
            dimension.set("refid", this.getView().getFormShowParameter().getCustomParam("bizModelId"));
        } else {
            dimension.set("reftype", (Object)3);
            dimension.set("refid", (Object)businessId);
        }
        return dimension;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map data;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("dimview_select".equals(actionId) && (data = (Map)closedCallBackEvent.getReturnData()) != null) {
            this.getModel().setValue("dimview", data.get("id"));
        }
    }

    protected Long getBusinessdomainid() {
        Object businessdomainid = this.getView().getFormShowParameter().getCustomParam("businessdomainid");
        if (businessdomainid != null) {
            return Long.parseLong(businessdomainid.toString());
        }
        return 0L;
    }
}

