/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.bizmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.business.model.bizmodel.BizModelServiceHelper;
import kd.epm.epbs.business.model.dimension.DimensionServiceHelper;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.IMetaDataEntity;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.relation.RelationTypeEnum;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.formplugin.model.memberf7.bean.EpbsSelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.bean.MultiF7Result;

public abstract class RelationSelectFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IMetaDataEntity {
    public static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dimension = (BasedataEdit)this.getControl("dimension");
        dimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizmodel = (BasedataEdit)this.getControl("bizmodel");
        bizmodel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dimensionref = (BasedataEdit)this.getControl("dimensionref");
        dimensionref.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit basedata = (BasedataEdit)this.getControl("basedata");
        basedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"addmember", "delmember"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"businessdomainid", "bizmodel", "dimensionref", "basedata", "datatye"});
        this.getModel().setDataChanged(false);
        String cubNumber = (String)this.getView().getFormShowParameter().getCustomParam("cubeNumber");
        if (StringUtils.isNotBlank((CharSequence)cubNumber)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"ismustinput"});
        }
    }

    protected Long getModelId() {
        Object model = this.getView().getFormShowParameter().getCustomParam("model");
        if (model != null) {
            return (Long)model;
        }
        return 0L;
    }

    private Long getDimensionId() {
        return (Long)this.getModel().getValue("dimension_id");
    }

    private Long getMultiModelId() {
        return (Long)this.getModel().getValue("bizmodel_id");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.getView().getModel().updateCache();
        String opType = ((FormOperate)args.getSource()).getType();
        if ("donothing".equals(opType)) {
            HashSet<String> set;
            String number = (String)this.getModel().getValue("number");
            String errorMsg = ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u5e94\u4e3a3\u523050\u4e2a\u5b57\u7b26\uff0c\u4ec5\u53ef\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\uff0c\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u3002\u8bf7\u907f\u514d\u4f7f\u7528\u4fdd\u7559\u5b57\u6bb5\uff1aall\u3001other\u3001none\u3002", (String)"RelationSelectFormPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
            if (this.checkRelNumberByDb()) {
                this.getView().showTipNotification(errorMsg);
                args.setCancel(true);
                return;
            }
            if (!BizModelServiceHelper.checkNumber((String)number)) {
                this.getView().showTipNotification(errorMsg);
                args.setCancel(true);
                return;
            }
            Object numberCache = this.getView().getFormShowParameter().getCustomParam("number_cache");
            if (!ObjectUtils.isEmpty((Object)numberCache) && (set = new HashSet<String>(Arrays.asList(numberCache.toString().toLowerCase(Locale.ENGLISH).split(",")))).contains(number.toLowerCase(Locale.ENGLISH))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201d%s\u201c\u7f16\u7801\u91cd\u590d\u3002", (String)"ManageObjectPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]), number));
                args.setCancel(true);
                return;
            }
            Object type = this.getModel().getValue("type");
            if (!ObjectUtils.isEmpty((Object)type) && RelationTypeEnum.DIMLIB.getType().equals(type)) {
                DynamicObjectCollection entryEntity;
                type = this.getModel().getValue("sourcedim");
                if (RelationTypeEnum.DIMLIB.getType().equals(type) && ((entryEntity = this.getModel().getEntryEntity(ENTRYENTITY)) == null || entryEntity.size() == 0)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u53ef\u9009\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RelationSelectFormPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("btnok".equals(operateKey)) {
            StringBuilder errorCkNumber = new StringBuilder();
            HashMap<String, Map<String, Object>> returnData = new HashMap<String, Map<String, Object>>(16);
            this.createRelationData();
            returnData.put("data", this.createRelationData());
            this.getView().returnDataToParent(returnData);
        }
    }

    private boolean checkRelNumberByDb() {
        String regex;
        String number = (String)this.getModel().getValue("number");
        return !number.matches(regex = "^[a-zA-Z0-9_]+$");
    }

    private Map<String, Object> createRelationData() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        DynamicObject modelobj = this.getModel().getDataEntity();
        String number = modelobj.getString("number");
        Object name = modelobj.get("name");
        Object description = modelobj.get("description");
        long dimensionId = this.getDimensionId();
        long refdimensionId = modelobj.getLong("dimensionref_id");
        if (name instanceof Map) {
            resultMap.put("dimname", LocaleString.fromMap((Map)((Map)name)));
        } else {
            resultMap.put("dimname", name.toString());
        }
        if (description instanceof Map) {
            resultMap.put("dimdescription", LocaleString.fromMap((Map)((Map)description)));
        } else {
            resultMap.put("dimdescription", description.toString());
        }
        resultMap.put("dimnumber", number);
        String type = modelobj.getString("type");
        if (dimensionId != 0L) {
            resultMap.put("dimension", dimensionId);
        }
        if (refdimensionId != 0L) {
            resultMap.put("dimension", refdimensionId);
        }
        resultMap.put("bizmodel", modelobj.getLong("bizmodel_id"));
        resultMap.put("basedata", modelobj.getLong("basedata_id"));
        resultMap.put("isconnect", modelobj.getString("isconnect"));
        resultMap.put("ismustinput", modelobj.getString("ismustinput"));
        resultMap.put("datatye", modelobj.getString("datatye"));
        if (RelationTypeEnum.DIMLIB.getType().equals(type)) {
            resultMap.put("type", type);
            type = modelobj.getString("sourcedim");
            resultMap.put("sourcedim", type);
        } else {
            resultMap.put("type", type);
        }
        if (RelationTypeEnum.DIMLIB.getType().equals(type)) {
            DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
            resultMap.put("dimtable", dimension.get("number"));
            resultMap.put("member", this.createMemberMap());
        } else if (RelationTypeEnum.MODEL.getType().equals(type)) {
            DynamicObject dimensionref = (DynamicObject)this.getModel().getValue("dimensionref");
            resultMap.put("dimtable", dimensionref.get("number"));
        } else if (RelationTypeEnum.BASICDATA.getType().equals(type)) {
            DynamicObject basedata = (DynamicObject)this.getModel().getValue("basedata");
            resultMap.put("dimtable", basedata.get("number"));
        } else if (RelationTypeEnum.NOTHING.getType().equals(type)) {
            resultMap.put("dimtable", "");
        }
        return resultMap;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if ("dimension".equals(propName)) {
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
        } else if ("bizmodel".equals(propName)) {
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("model", "=", (Object)this.getModelId()).and(new QFilter("type", "=", (Object)"1")));
        } else if ("dimensionref".equals(propName)) {
            Long multiModelId = this.getMultiModelId();
            if (multiModelId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6a21\u578b", (String)"RelationSelectFormPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList idList = new ArrayList();
            Arrays.stream(BusinessDataServiceHelper.load((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"), (String)"dimension_id", (QFilter[])new QFilter("businessdomain", "=", (Object)this.getBusinessdomainid()).toArray())).forEach(c -> idList.add(c.getLong("dimension_id")));
            Arrays.stream(BusinessDataServiceHelper.load((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"), (String)"dimension_id", (QFilter[])new QFilter("bizmodel", "=", (Object)multiModelId).toArray())).forEach(c -> idList.add(c.getLong("dimension_id")));
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("model", "=", (Object)this.getModelId()).and(new QFilter("id", "in", idList)));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("type".equals(name) || "sourcedim".equals(name)) {
            DimensionServiceHelper.setVisibleFlex((AbstractFormPlugin)this, (boolean)true, (String)name);
        }
        if ("dimension".equals(name)) {
            this.getModel().deleteEntryData(ENTRYENTITY);
        }
        if ("bizmodel".equals(name)) {
            this.getModel().setValue("dimensionref", null);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if ("addmember".equals(key)) {
            DimensionServiceHelper.addMember((AbstractFormPlugin)this, (AbstractMemberF7Parameter)this.getMemberF7Paramter());
        }
    }

    protected abstract AbstractMemberF7Parameter getMemberF7Paramter();

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        MultiF7Result multiF7Result;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("addmember".equals(actionId) && (multiF7Result = (MultiF7Result)closedCallBackEvent.getReturnData()) != null) {
            this.getModel().deleteEntryData(ENTRYENTITY);
            List<EpbsSelectedMember> list = multiF7Result.getSelectedMemberList();
            this.setMemberlistData(list);
        }
    }

    public void setMemberlistData(List<EpbsSelectedMember> list) {
        if (list != null && list.size() > 0) {
            ArrayList idList = new ArrayList();
            list.forEach(c -> idList.add(c.getId()));
            HashMap map = new HashMap();
            Long dimensionId = Long.parseLong(this.getModel().getValue("dimension_id").toString());
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
            DimTypeBean dimType = modelCache.getDimTypeByDimensionId(dimensionId.longValue());
            String memberTreemodel = dimType.getMemberTreemodel();
            Arrays.stream(BusinessDataServiceHelper.load((String)memberTreemodel, (String)"id,view", (QFilter[])new QFilter("id", "in", idList).toArray())).forEach(c -> map.put(c.getString("id"), c.getDynamicObject("view")));
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, list.size());
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
            for (int i = 0; i < list.size(); ++i) {
                EpbsSelectedMember selectedMember = list.get(i);
                DynamicObject dynamicObject = (DynamicObject)map.get(selectedMember.getId().toString());
                DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                entry.set("memberid", (Object)selectedMember.getId());
                entry.set("membername", (Object)selectedMember.getName());
                entry.set("membernumber", (Object)selectedMember.getNumber());
                entry.set("viewid", (Object)dynamicObject.getLong("id"));
                entry.set("viewname", (Object)dynamicObject.getString("name"));
                entry.set("scope", (Object)selectedMember.getScope());
            }
        }
        this.getView().updateView(ENTRYENTITY);
    }

    protected Long getBusinessdomainid() {
        Object businessdomainid = this.getView().getFormShowParameter().getCustomParam("businessdomainid");
        if (businessdomainid != null) {
            return (Long)businessdomainid;
        }
        return 0L;
    }

    private List<Map<String, String>> createMemberMap() {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject dim : entryEntity) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("memberid", dim.getString("memberid"));
            map.put("membernumber", dim.getString("membernumber"));
            map.put("membername", dim.getString("membername"));
            map.put("viewid", dim.getString("viewid"));
            map.put("viewname", dim.getString("viewname"));
            map.put("scope", dim.getString("scope"));
            result.add(map);
        }
        return result;
    }
}

