/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.importplugin;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.model.bizmodel.BizModelInitHelper;
import kd.epm.epbs.business.model.view.context.MemberOperEnum;
import kd.epm.epbs.business.model.view.context.SaveMemberContext;
import kd.epm.epbs.business.model.view.handler.MemberExcelImportHandler;
import kd.epm.epbs.business.model.view.valid.ValidResult;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.OperationTypeInfo;
import kd.epm.epbs.common.enums.ImportEnum;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.excelimport.POIUtils;
import kd.epm.epbs.common.fileImport.FileImportUtils;
import kd.epm.epbs.common.fileImport.entity.Header;
import kd.epm.epbs.common.fileImport.entity.ImportEntity;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.thread.EpbsThreadPools;
import kd.epm.epbs.common.util.CommonServiceHelper;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.ImportUtil;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epbs.formplugin.model.importplugin.ImportContext;
import kd.epm.epbs.formplugin.model.importplugin.ImportTemplateHeader;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class DimMemImportBasePlugin
extends AbstractBaseListPlugin
implements UploadListener {
    protected static Log log = LogFactory.getLog(DimMemImportBasePlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndownload"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.doImport();
        } else if ("btndownload".equals(key)) {
            this.downImportTemplate();
        }
    }

    protected void doImport() {
        log.info("begin-import.");
        try {
            this.$doImport();
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
        }
        finally {
            log.info("end-import.");
        }
    }

    private void $doImport() {
        Long dimensionId;
        EpbsModelCache modelCache = this.getModelCache();
        DimensionBean dimension = modelCache.getDimensionById((dimensionId = this.getDimensionId()).longValue());
        if (dimension == null) {
            return;
        }
        DimTypeBean dimType = modelCache.getDimTypeById(dimension.getDimTypeId());
        SaveMemberContext saveCtx = new SaveMemberContext(modelCache, dimension.getNumber(), dimType.getMemberTreemodel(), dimType.getMemberTreemodel(), this.getViewId());
        saveCtx.setOperationType(this.isAddNew() ? MemberOperEnum.ADD : MemberOperEnum.ADD_AND_UPDATE);
        ArrayList rows = Lists.newArrayListWithExpectedSize((int)16);
        List<ImportEntity> importHeads = null;
        ArrayList<ValidResult<String>> workBookValid = new ArrayList<ValidResult<String>>();
        ValidResult valid = new ValidResult();
        MemberExcelImportHandler handle = new MemberExcelImportHandler(saveCtx);
        importHeads = this.beforeDo(new ImportContext(this.getPageCache(), modelCache, dimension.getNumber(), dimension.getNameString(), dimType.getMemberTreemodel()), rows);
        try {
            handle.execute((List)rows, workBookValid);
            this.afterDo(saveCtx, rows, importHeads, (ValidResult<String>)valid, workBookValid);
            rows.clear();
            workBookValid.clear();
        }
        catch (Throwable ex) {
            try {
                throw new KDBizException(CommonServiceHelper.getStackTraceStr((Throwable)ex));
            }
            catch (Throwable throwable) {
                this.afterDo(saveCtx, rows, importHeads, (ValidResult<String>)valid, workBookValid);
                rows.clear();
                workBookValid.clear();
                MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5bfc\u5165\u6210\u5458\u7f16\u7801\uff1a%s\u3002", "DimMemImportBasePlugin_2", "epm-epbs-formplugin", new Object[]{String.join((CharSequence)",", handle.getSaveMemberNumbers())});
                this.writeLog((IOperationTypeInfo)new OperationTypeInfo("dimmemberimport", new MultiLangEnumBridge("\u7ef4\u5ea6\u6210\u5458\u6279\u91cf\u5bfc\u5165", "DimMemImportBasePlugin_1", "epm-epbs-formplugin")), opDescription);
                throw throwable;
            }
        }
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5bfc\u5165\u6210\u5458\u7f16\u7801\uff1a%s\u3002", "DimMemImportBasePlugin_2", "epm-epbs-formplugin", new Object[]{String.join((CharSequence)",", handle.getSaveMemberNumbers())});
        this.writeLog((IOperationTypeInfo)new OperationTypeInfo("dimmemberimport", new MultiLangEnumBridge("\u7ef4\u5ea6\u6210\u5458\u6279\u91cf\u5bfc\u5165", "DimMemImportBasePlugin_1", "epm-epbs-formplugin")), opDescription);
    }

    protected List<ImportEntity> beforeDo(ImportContext context, List<Map<Integer, String>> rows) {
        String fileUrl = this.getPageCache().get("file_url");
        if (StringUtils.isEmpty((String)fileUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u5bfc\u5165\u6587\u4ef6\u3002", (String)"DimMemImportBasePlugin_10", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        List urls = (List)SerializationUtils.fromJsonString((String)fileUrl, List.class);
        BeforeDoCheck check = new BeforeDoCheck(context);
        check.execute(urls);
        rows.addAll(check.getRows());
        return check.getImportHeads();
    }

    protected void afterDo(SaveMemberContext context, List<Map<Integer, String>> rows, List<ImportEntity> importHeads, @NotNull ValidResult<String> valid, @NotNull List<ValidResult<String>> validResults) {
        boolean result = valid.isOk();
        for (ValidResult<String> _valid : validResults) {
            result = result && _valid.isOk();
        }
        if (result) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"DimMemImportBasePlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            this.getView().close();
            Long dimensionId = this.getDimensionId();
            EpbsMemberCacheHelper.invalidate((long)dimensionId);
            EpbsThreadPools.commonExecute(() -> BizModelInitHelper.updateOLAPBase((long)this.getModelId(), (long)dimensionId));
        } else {
            this.downErrorFile(rows, importHeads.get(0), valid, validResults);
        }
    }

    private void downImportTemplate() {
        Long dimensionId;
        EpbsModelCache modelCache = this.getModelCache();
        DimensionBean dimension = modelCache.getDimensionById((dimensionId = this.getDimensionId()).longValue());
        if (dimension == null) {
            return;
        }
        DimTypeBean dimType = modelCache.getDimTypeById(dimension.getDimTypeId());
        ImportContext context = new ImportContext(this.getPageCache(), this.getModelCache(), dimension.getNumber(), dimension.getNameString(), dimType.getMemberTreemodel());
        ImportEntity importEntity = ImportTemplateHeader.get(context).getTemplateData(true);
        FileImportUtils instance = FileImportUtils.getInstance((ImportEntity)importEntity);
        String url = instance.saveFileAsUrl(instance.createImportTemplate(), importEntity.getTemplateName());
        if (StringUtils.isNotEmpty((String)url)) {
            POIUtils.downloadFile((IFormView)this.getView(), (String)url);
        }
    }

    protected void downErrorFile(List<Map<Integer, String>> rows, ImportEntity importEntity, ValidResult<String> valid, @NotNull List<ValidResult<String>> validResults) {
        try {
            Cell errorCell;
            ValidResult<String> _valid = validResults.get(0);
            if (!_valid.isOk() && rows.size() > 5000) {
                Map validResultMap = _valid.getValidResultMap();
                ArrayList<String> errMsg = new ArrayList<String>(validResultMap.size());
                for (Map.Entry entry : validResultMap.entrySet()) {
                    errMsg.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s", (String)"DimMemImportBasePlugin_11", (String)"epm-epbs-formplugin", (Object[])new Object[0]), entry.getKey(), entry.getValue()));
                }
                this.getView().showMessage(String.join((CharSequence)" ", errMsg));
                return;
            }
            FileImportUtils fileImportUtils = FileImportUtils.getInstance((ImportEntity)importEntity);
            XSSFWorkbook errorBook = new XSSFWorkbook();
            fileImportUtils.createImportSheetIndex((Workbook)errorBook, 1);
            Sheet sheet = errorBook.getSheetAt(0);
            for (int i = 3; i < rows.size(); ++i) {
                Map<Integer, String> rowData = rows.get(i);
                Row row = fileImportUtils.getRow(sheet, i);
                for (Map.Entry<Integer, String> data : rowData.entrySet()) {
                    Cell cell = fileImportUtils.getCell(row, data.getKey() + 1);
                    fileImportUtils.setCellStringValue(cell, data.getValue());
                }
            }
            CellStyle errorStyle = POIUtils.getErrorStyle((Workbook)errorBook);
            POIUtils.POIConfig config = new POIUtils.POIConfig();
            config.getSheetConfig((int)0).COPY_ColBeginIndex = 1;
            if (!_valid.isOk()) {
                for (Map.Entry entry : _valid.getValidResultMap().entrySet()) {
                    errorCell = POIUtils.getCell((Sheet)sheet, (int)Integer.parseInt((String)entry.getKey()), (int)0);
                    if (errorCell == null) continue;
                    errorCell.setCellStyle(errorStyle);
                    errorCell.setCellValue((String)entry.getValue());
                }
            }
            if (StringUtils.isNotEmpty((String)valid.getErrMsg()) && (errorCell = POIUtils.getCell((Sheet)sheet, (int)2, (int)0)) != null) {
                errorCell.setCellStyle(errorStyle);
                errorCell.setCellValue(valid.getErrMsg());
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u3002", (String)"DimMemImportBasePlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            POIUtils.downloadFile((IFormView)this.getView(), (Workbook)errorBook);
        }
        catch (Throwable ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String file_url = this.getPageCache().get("file_url");
        List urls = null;
        urls = file_url == null ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        if (!urls.isEmpty()) {
            this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
        }
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        String file_url = this.getPageCache().get("file_url");
        if (file_url == null) {
            return;
        }
        List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
    }

    protected boolean isAddNew() {
        return ImportEnum.IMPORTTYPE_NEW.getIndex().equals(this.getModel().getValue("radiogroupfield"));
    }

    protected boolean isAddAndUpdate() {
        return ImportEnum.IMPORTTYPE_ADDANDUPADTA.getIndex().equals(this.getModel().getValue("radiogroupfield"));
    }

    protected Long getDimensionId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("dimensionId");
    }

    protected Long getViewId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("viewId"));
    }

    static class BeforeDoCheck {
        private final ImportContext context;
        private List<Map<Integer, String>> rows = null;
        private List<ImportEntity> importHeads = new ArrayList<ImportEntity>();

        protected ImportContext getContext() {
            return this.context;
        }

        public List<Map<Integer, String>> getRows() {
            return this.rows;
        }

        public void setRows(List<Map<Integer, String>> rows) {
            this.rows = rows;
        }

        public List<ImportEntity> getImportHeads() {
            return this.importHeads;
        }

        public BeforeDoCheck(ImportContext context) {
            this.context = context;
        }

        public void execute(List<String> urls) {
            this.checkInputStream(urls);
            ExcelReader reader = new ExcelReader();
            final ArrayList<Map<Integer, String>> rows = new ArrayList<Map<Integer, String>>(10000);
            List inputStreams = ImportUtil.getImportStreams(urls);
            try {
                SheetHandler sheetHandler = new SheetHandler(){

                    public void handleRow(SheetHandler.ParsedRow parsedRow) {
                        Map data = parsedRow.getData();
                        rows.add(data);
                    }
                };
                sheetHandler.setReadOriginalNum(Boolean.TRUE);
                reader.read((InputStream)inputStreams.get(0), sheetHandler);
            }
            catch (Exception ex) {
                if (ex instanceof NotOfficeXmlFileException) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u7f13\u5b58\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u4f7f\u7528\u3002", (String)"DimMemImportBasePlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u4e0d\u6b63\u786e\u7684\u683c\u5f0f\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemImportBasePlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
            finally {
                POIUtils.safeClose((Iterable)inputStreams);
            }
            if (rows.size() > 500000) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u4ee5\u5bfc\u5165500000\u884c\u6570\u636e\u3002", (String)"DimMemImportBasePlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
            this.setRows(rows);
            this.checkWorkBookStyle(rows);
        }

        protected void checkInputStream(List<String> urls) {
            if (urls == null || urls.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u8981\u5bfc\u5165\u7684\u6570\u636e\u6587\u4ef6\u3002", (String)"DimMemImportBasePlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
        }

        protected void checkWorkBookStyle(List<Map<Integer, String>> rows) {
            try {
                Map<Integer, String> headRow = rows.get(this.getDefaultRowIndex());
                if (headRow == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\u7f3a\u5c11\u8868\u5934\u4fe1\u606f\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemImportBasePlugin_9", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                }
                ImportEntity importHead = ImportTemplateHeader.get(this.getContext()).getTemplateData(true);
                this.getImportHeads().add(importHead);
                Map sheetHeaderMap = importHead.getSheetHeaderMap();
                for (Map.Entry entry : sheetHeaderMap.entrySet()) {
                    String _fileHead;
                    int colNum = Integer.parseInt((String)entry.getKey());
                    String _headStr = ((Header)entry.getValue()).getHeader();
                    if (_headStr != null) {
                        _headStr = _headStr.trim();
                    }
                    if ((_fileHead = headRow.get(colNum).trim()).equals(_headStr)) continue;
                    log.info("head1=" + _fileHead + ", head2=" + _headStr);
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u4e0d\u6b63\u786e\u7684\u683c\u5f0f\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemImportBasePlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                }
            }
            catch (KDBizException ex) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u4e0d\u6b63\u786e\u7684\u683c\u5f0f\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemImportBasePlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
            catch (Throwable ex) {
                log.error("checkWorkBookStyle-error", (Object)CommonServiceHelper.getStackTraceStr((Throwable)ex));
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u4e0d\u6b63\u786e\u7684\u683c\u5f0f\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemImportBasePlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
        }

        protected int getDefaultRowIndex() {
            return 2;
        }
    }
}

