/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.importplugin;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.epbs.common.fileImport.entity.Header;
import kd.epm.epbs.common.fileImport.entity.ImportEntity;
import kd.epm.epbs.formplugin.model.importplugin.ImportContext;

public class ImportTemplateHeader {
    public static final String CACHE_TEMPLATE_DATA = "templateDataCache";
    private final ImportContext context;

    public static ImportTemplateHeader get(ImportContext context) {
        return new ImportTemplateHeader(context);
    }

    protected ImportContext getContext() {
        return this.context;
    }

    public ImportTemplateHeader(ImportContext context) {
        this.context = context;
    }

    public ImportEntity getTemplateData(boolean isImport) {
        ImportEntity importEntity;
        if (this.getContext().getPageCache() != null) {
            String cache = this.getContext().getPageCache().get(CACHE_TEMPLATE_DATA);
            if (cache != null) {
                importEntity = (ImportEntity)SerializationUtils.deSerializeFromBase64((String)cache);
            } else {
                importEntity = this.createTemplateData(isImport);
                this.getContext().getPageCache().put(CACHE_TEMPLATE_DATA, SerializationUtils.serializeToBase64((Object)importEntity));
            }
        } else {
            importEntity = this.createTemplateData(isImport);
        }
        return importEntity;
    }

    protected ImportEntity createTemplateData(boolean isImport) {
        ImportEntity importData = new ImportEntity();
        if (isImport) {
            importData.setTemplateName(String.format(ResManager.loadKDString((String)"%s\u5bfc\u5165\u6a21\u677f", (String)"ImportTemplateHeader_26", (String)"epm-epbs-formplugin", (Object[])new Object[0]), this.getContext().getDimName()));
            importData.setSheetTitle(String.format(ResManager.loadKDString((String)"%s\u2014\u5bfc\u5165", (String)"ImportTemplateHeader_25", (String)"epm-epbs-formplugin", (Object[])new Object[0]), this.getContext().getDimName()));
        } else {
            importData.setTemplateName(String.format(ResManager.loadKDString((String)"%s\u5bfc\u51fa\u6570\u636e", (String)"ImportTemplateHeader_24", (String)"epm-epbs-formplugin", (Object[])new Object[0]), this.getContext().getDimName()));
            importData.setSheetTitle(String.format(ResManager.loadKDString((String)"%s\u2014\u5bfc\u51fa", (String)"ImportTemplateHeader_23", (String)"epm-epbs-formplugin", (Object[])new Object[0]), this.getContext().getDimName()));
        }
        importData.setSheetHeaderMap(this.getHeaderData());
        importData.setSheetNotes(ResManager.loadKDString((String)"\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\uff0c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002\u66f4\u65b0\u65f6\uff0c\u7f16\u7801\u4e0d\u53ef\u66f4\u6539\u3002", (String)"ImportTemplateHeader_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        this.dealDimImportEntity(importData);
        return importData;
    }

    protected void dealDimImportEntity(ImportEntity importData) {
        Map comboBoxList = importData.getComboBoxList();
        HashMap headerMap = Maps.newHashMapWithExpectedSize((int)importData.getSheetHeaderMap().size());
        for (Map.Entry _header : importData.getSheetHeaderMap().entrySet()) {
            headerMap.put(((Header)_header.getValue()).getColumnNum(), Integer.parseInt((String)_header.getKey()));
        }
        Integer index = (Integer)headerMap.get("aggoprt");
        if (index != null) {
            comboBoxList.put(index, new String[]{ResManager.loadKDString((String)"\u52a0(+)", (String)"ImportTemplateHeader_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u51cf(-)", (String)"ImportTemplateHeader_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ffd\u7565(~)", (String)"ImportTemplateHeader_4", (String)"epm-epbs-formplugin", (Object[])new Object[0])});
        }
    }

    protected Map<String, Header> getHeaderData() {
        return this.getDefaultHeaderData();
    }

    protected Map<String, Header> getDefaultHeaderData() {
        LinkedHashMap<String, Header> headerData = new LinkedHashMap<String, Header>();
        int size = 0;
        headerData.put(String.valueOf(size++), new Header("number", ResManager.loadKDString((String)"*\u7f16\u7801", (String)"ImportTemplateHeader_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b\u9879", (String)"ImportTemplateHeader_6", (String)"epm-epbs-formplugin", (Object[])new Object[0])));
        headerData.put(String.valueOf(size++), new Header("name", ResManager.loadKDString((String)"*\u540d\u79f0", (String)"ImportTemplateHeader_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b\u9879", (String)"ImportTemplateHeader_6", (String)"epm-epbs-formplugin", (Object[])new Object[0])));
        headerData.put(String.valueOf(size++), new Header("parent.number", ResManager.loadKDString((String)"\u4e0a\u7ea7\u7f16\u7801", (String)"ImportTemplateHeader_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]), this.getParentNumberTips()));
        headerData.put(String.valueOf(size++), new Header("shortname", ResManager.loadKDString((String)"\u7b80\u79f0", (String)"ImportTemplateHeader_9", (String)"epm-epbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879", (String)"ImportTemplateHeader_10", (String)"epm-epbs-formplugin", (Object[])new Object[0])));
        headerData.put(String.valueOf(size++), new Header("aggoprt", ResManager.loadKDString((String)"\u805a\u5408\u7b97\u6cd5", (String)"ImportTemplateHeader_11", (String)"epm-epbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u9ed8\u8ba4\u52a0(+)", (String)"ImportTemplateHeader_12", (String)"epm-epbs-formplugin", (Object[])new Object[0])));
        headerData.put(String.valueOf(size++), new Header("description", ResManager.loadKDString((String)"\u8bf4\u660e", (String)"ImportTemplateHeader_13", (String)"epm-epbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u9ed8\u8ba4\u65e0", (String)"ImportTemplateHeader_14", (String)"epm-epbs-formplugin", (Object[])new Object[0])));
        String comment = ResManager.loadKDString((String)"\u4ec5\u4f9b\u67e5\u770b\uff0c\u5bfc\u5165\u65e0\u6548\u3002", (String)"ImportTemplateHeader_15", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
        headerData.put(String.valueOf(size++), new Header("creator.name", ResManager.loadKDString((String)"\u521b\u5efa\u4eba", (String)"ImportTemplateHeader_16", (String)"epm-epbs-formplugin", (Object[])new Object[0]), comment));
        headerData.put(String.valueOf(size++), new Header("createtime", ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"ImportTemplateHeader_17", (String)"epm-epbs-formplugin", (Object[])new Object[0]), comment));
        headerData.put(String.valueOf(size++), new Header("modifier.name", ResManager.loadKDString((String)"\u6700\u540e\u4fee\u6539\u4eba", (String)"ImportTemplateHeader_18", (String)"epm-epbs-formplugin", (Object[])new Object[0]), comment));
        headerData.put(String.valueOf(size++), new Header("modifytime", ResManager.loadKDString((String)"\u6700\u540e\u4fee\u6539\u65f6\u95f4", (String)"ImportTemplateHeader_19", (String)"epm-epbs-formplugin", (Object[])new Object[0]), comment));
        headerData.put(String.valueOf(size++), new Header("disable", ResManager.loadKDString((String)"\u72b6\u6001", (String)"ImportTemplateHeader_20", (String)"epm-epbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ec5\u4f9b\u67e5\u770b\uff0c\u5982\u9700\u4fee\u6539\u8bf7\u4f7f\u7528\u7cfb\u7edf\u7684\u542f\u7528\u7981\u7528\u529f\u80fd\uff0c\u5bfc\u5165\u65e0\u6548", (String)"ImportTemplateHeader_21", (String)"epm-epbs-formplugin", (Object[])new Object[0])));
        return headerData;
    }

    protected String getParentNumberTips() {
        return ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u9ed8\u8ba4\u6839\u8282\u70b9", (String)"ImportTemplateHeader_22", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
    }
}

