/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.memberf7;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.business.model.f7.MemberF7Parameter;
import kd.epm.epbs.business.model.f7.SelectedDimMember;
import kd.epm.epbs.common.enums.RangeEnum;
import kd.epm.epbs.common.enums.RangeF7PropertyCataEnum;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.formplugin.member.f7.MemberRangeF7;
import kd.epm.epbs.formplugin.member.f7.SelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.bean.EpbsSelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.bean.PeriodSelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.face.IEpbsSelectedF7Cache;
import org.jetbrains.annotations.NotNull;

public class EpbsMemberRangeF7
extends MemberRangeF7
implements IEpbsSelectedF7Cache {
    @Override
    public void initialize() {
        super.initialize();
        MemberF7Parameter f7Parameter = (MemberF7Parameter)this.loadF7Parameter(this.getView(), this.getPageCache());
        Label caption = (Label)this.getControl("caption");
        if (caption != null && f7Parameter != null) {
            caption.setText(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458", (String)"EpbsMemberRangeF7_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void returnData(@NotNull IFormView view, Map<String, SelectedMember> selectData, @NotNull AbstractMemberF7Parameter f7Param, Map<String, Object> dataParams) {
        DynamicObject viewObj = (DynamicObject)this.getView().getModel().getValue("view");
        if (viewObj != null) {
            f7Param.setViewNumber(viewObj.getString("number"));
        }
        this.getView().returnDataToParent(this.getReturnData(f7Param, selectData, dataParams));
    }

    @Override
    protected void addMember(@NotNull IFormView view, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull String controlKey, @NotNull AbstractMemberF7Parameter f7Param) {
        super.addMember(view, dataModel, pageCache, controlKey, f7Param);
        Map<Long, Map<Long, Integer>> dimSelectedData = this.getDimSelectedData((MemberF7Parameter)f7Param);
        if (dimSelectedData.isEmpty()) {
            return;
        }
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)f7Param.getModelId());
        ArrayList selMembers = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry<Long, Map<Long, Integer>> entry : dimSelectedData.entrySet()) {
            selMembers.addAll(this.getSelectedMember(modelCache, entry.getKey(), entry.getValue(), f7Param));
        }
        this.fillMember(controlKey, f7Param, selMembers);
    }

    protected List<EpbsSelectedMember> getSelectedMember(EpbsModelCache modelCache, Long dimensionId, Map<Long, Integer> selectedData, AbstractMemberF7Parameter f7Param) {
        DimTypeBean dimTypeBean;
        ArrayList selMembers = Lists.newArrayListWithExpectedSize((int)16);
        if (!selectedData.isEmpty() && (dimTypeBean = modelCache.getDimTypeByDimensionId(dimensionId.longValue())) != null) {
            QFilter qFilter = new QFilter("id", "in", selectedData.keySet());
            Map memberMap = BusinessDataServiceHelper.loadFromCache((String)dimTypeBean.getMemberTreemodel(), (String)"id,name,number,longnumber,shownumber,dimension,view,parent", (QFilter[])qFilter.toArray());
            Map propValueMap = BusinessDataServiceHelper.loadFromCache((String)f7Param.getCustomPropertyValueForm(), (String)"id,name,number, property", (QFilter[])qFilter.toArray());
            for (Map.Entry<Long, Integer> selectData : selectedData.entrySet()) {
                String type = "1";
                DynamicObject dynamicObject = (DynamicObject)memberMap.get(selectData.getKey());
                if (dynamicObject == null) {
                    dynamicObject = (DynamicObject)propValueMap.get(selectData.getKey());
                    type = "2";
                }
                if (dynamicObject == null) continue;
                EpbsSelectedMember member = new EpbsSelectedMember().of(dynamicObject, type);
                member.setScope(selectedData.get(member.getId()));
                selMembers.add(member);
            }
        }
        return selMembers;
    }

    @NotNull
    private Map<Long, Map<Long, Integer>> getDimSelectedData(MemberF7Parameter f7Param) {
        Map selectedData;
        LinkedHashMap<Long, Map<Long, Integer>> dimSelectedData = new LinkedHashMap<Long, Map<Long, Integer>>(16);
        List selectedDimMemberList = f7Param.getSelectedDimMemberList();
        if (selectedDimMemberList != null) {
            for (SelectedDimMember selectedDimMember : selectedDimMemberList) {
                Map selectedData2 = dimSelectedData.computeIfAbsent(selectedDimMember.getDimId(), k -> new HashMap(16));
                selectedData2.put(selectedDimMember.getMemberId(), selectedDimMember.getScope());
            }
        }
        if ((selectedData = f7Param.getSelectedData()) != null) {
            dimSelectedData.computeIfAbsent(f7Param.getDimensionId(), k -> new LinkedHashMap(16)).putAll(selectedData);
        }
        return dimSelectedData;
    }

    protected void fillMember(@NotNull String controlKey, AbstractMemberF7Parameter f7Param, List<? extends EpbsSelectedMember> selMembers) {
        IFormView view = this.getView();
        IDataModel dataModel = this.getModel();
        IPageCache pageCache = this.getPageCache();
        boolean isLockRange = f7Param.isLockRangeSelect();
        boolean isShowLevel = f7Param.isShowLevel();
        int index = 0;
        LinkedHashMap selectedMembers = Maps.newLinkedHashMapWithExpectedSize((int)selMembers.size());
        if (!selMembers.isEmpty()) {
            dataModel.beginInit();
            int[] rows = dataModel.batchCreateNewEntryRow(controlKey, selMembers.size());
            for (EpbsSelectedMember epbsSelectedMember : selMembers) {
                RangeF7PropertyCataEnum typeEnum;
                Integer rangeLevel;
                int rowIndex = rows[index++];
                dataModel.setValue("memberid", (Object)epbsSelectedMember.getId(), rowIndex);
                if (epbsSelectedMember instanceof PeriodSelectedMember) {
                    PeriodSelectedMember periodSelectedMember = (PeriodSelectedMember)epbsSelectedMember;
                    this.getModel().setValue("yearmemberid", (Object)periodSelectedMember.getYearId(), rowIndex);
                    this.getModel().setValue("yearnumber", (Object)periodSelectedMember.getYearNumber(), rowIndex);
                    this.getModel().setValue("yearshownumber", (Object)periodSelectedMember.getYearShowNumber(), rowIndex);
                    this.getModel().setValue("yearname", (Object)periodSelectedMember.getYearName(), rowIndex);
                    this.getModel().setValue("number", (Object)(periodSelectedMember.getYearNumber() + epbsSelectedMember.getNumber()), rowIndex);
                    this.getModel().setValue("shownumber", (Object)(periodSelectedMember.getYearShowNumber() + epbsSelectedMember.getShowNumber()), rowIndex);
                    this.getModel().setValue("name", (Object)(periodSelectedMember.getYearName() + epbsSelectedMember.getName()), rowIndex);
                    this.getModel().setValue("dimid", (Object)epbsSelectedMember.getDimId(), rowIndex);
                    this.getModel().setValue("dimname", (Object)epbsSelectedMember.getDimName(), rowIndex);
                    this.getModel().setValue("viewid", (Object)epbsSelectedMember.getViewId(), rowIndex);
                } else {
                    dataModel.setValue("name", (Object)epbsSelectedMember.getName(), rowIndex);
                    dataModel.setValue("number", (Object)epbsSelectedMember.getNumber(), rowIndex);
                    this.getModel().setValue("dimid", (Object)epbsSelectedMember.getDimId(), rowIndex);
                    this.getModel().setValue("dimname", (Object)epbsSelectedMember.getDimName(), rowIndex);
                    this.getModel().setValue("viewid", (Object)epbsSelectedMember.getViewId(), rowIndex);
                }
                epbsSelectedMember.setRowIndex(rowIndex);
                if ("1".equals(epbsSelectedMember.getType())) {
                    this.getModel().setValue("shownumber", (Object)epbsSelectedMember.getShowNumber(), epbsSelectedMember.getRowIndex());
                }
                dataModel.setValue("type", (Object)epbsSelectedMember.getType(), rowIndex);
                RangeEnum range = RangeEnum.getRangeByVal((int)epbsSelectedMember.getScope());
                dataModel.setValue("scope", (Object)String.valueOf(range.getIndex()), rowIndex);
                if (isShowLevel) {
                    view.setEnable(Boolean.valueOf(range == RangeEnum.LEVEL || range == RangeEnum.LEVEL_EXCLUDE), new String[]{"level"});
                }
                if (isLockRange || "2".equals(epbsSelectedMember.getType())) {
                    view.setEnable(Boolean.FALSE, rowIndex, new String[]{"scope"});
                }
                if (f7Param.isShowLevel() && f7Param.getRangeLevel() != null && (rangeLevel = (Integer)f7Param.getRangeLevel().get(epbsSelectedMember.getId())) != null && rangeLevel > 0) {
                    epbsSelectedMember.setLevel(rangeLevel);
                    dataModel.setValue("level", (Object)epbsSelectedMember.getLevel(), rowIndex);
                }
                if (f7Param.isShowExclude() && f7Param.getExcludeMemberIds() != null && f7Param.getExcludeMemberIds().contains(epbsSelectedMember.getId())) {
                    epbsSelectedMember.setExclude(true);
                    dataModel.setValue("exclude", (Object)Boolean.TRUE, rowIndex);
                }
                if ((typeEnum = RangeF7PropertyCataEnum.of((String)epbsSelectedMember.getType())) != null) {
                    dataModel.setValue("type", (Object)typeEnum.getIndex(), rowIndex);
                }
                this.putSelectedMemberNew(selectedMembers, epbsSelectedMember);
            }
            dataModel.endInit();
            view.updateView(controlKey);
        }
        this.cacheSelectMemberNew(pageCache, selectedMembers);
    }

    @Override
    protected void initUI(EventObject e) {
        super.initUI(e);
        MemberF7Parameter f7Parameter = (MemberF7Parameter)this.getF7Parameter();
        this.getView().setVisible(Boolean.valueOf(f7Parameter.isEnableDimension()), new String[]{"dimname", "dimid", "viewid"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"shownumber"});
    }
}

