/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.memberf7;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Search;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.epm.epbs.business.model.f7.PeriodMemberF7Parameter;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.bean.BaseMemberBean;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.YearPeriod;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.formplugin.member.f7.F7CommonUtils;
import kd.epm.epbs.formplugin.model.memberf7.EpbsMemberListF7;
import kd.epm.epbs.formplugin.model.memberf7.face.IPeriodSelectedF7Cache;
import kd.epm.epbs.formplugin.model.memberf7.face.IYear;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class EpbsPeriodMemberListF7
extends EpbsMemberListF7
implements IYear,
IPeriodSelectedF7Cache {
    @Override
    public String getCacheNodeId(@NotNull IPageCache pageCache) {
        String nodeId = super.getCacheNodeId(pageCache);
        String[] split = nodeId.split("@");
        nodeId = split.length > 1 ? split[1] : split[0];
        return nodeId;
    }

    private MemberBean getYearMember() {
        PeriodMemberF7Parameter f7Param = this.getF7Parameter();
        EpbsMemberCache epbsMemberCache = EpbsMemberCacheHelper.get((long)f7Param.getModelId(), (long)f7Param.getYearDimId());
        try {
            return epbsMemberCache.getMember(Long.parseLong(super.getCacheNodeId(this.getPageCache()).split("@")[0]));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public PeriodMemberF7Parameter getF7Parameter() {
        return (PeriodMemberF7Parameter)super.getF7Parameter();
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        try {
            final MemberBean yearMember = this.getYearMember();
            if (yearMember != null) {
                args.setListDataProvider((IListDataProvider)new ListDataProvider(){

                    public DynamicObjectCollection getData(int arg0, int arg1) {
                        DynamicObjectCollection collection = super.getData(arg0, arg1);
                        PeriodMemberF7Parameter f7Parameter = EpbsPeriodMemberListF7.this.getF7Parameter();
                        Map yearPeriodIdMap = f7Parameter.getYearPeriodIdMap();
                        HashMap idMap = new HashMap(yearPeriodIdMap.size());
                        for (Map.Entry yearPeriodEntry : yearPeriodIdMap.entrySet()) {
                            YearPeriod yearPeriod = (YearPeriod)yearPeriodEntry.getValue();
                            idMap.put(yearPeriod.getYearId() + "@" + yearPeriod.getPeriodId(), yearPeriodEntry.getKey());
                        }
                        for (DynamicObject dynamicObject : collection) {
                            long periodId = dynamicObject.getLong("id");
                            Long id = (Long)idMap.get(yearMember.getId() + "@" + periodId);
                            if (id == null) {
                                id = GlobalIdUtil.genGlobalLongId();
                                yearPeriodIdMap.put(id, new YearPeriod(yearMember.getId(), periodId, yearMember.getNumber()));
                            }
                            dynamicObject.set("id", (Object)id);
                            dynamicObject.set("number", (Object)(yearMember.getNumber() + dynamicObject.getString("number")));
                            dynamicObject.set("shownumber", (Object)(yearMember.getShowNumber() + dynamicObject.getString("shownumber")));
                            dynamicObject.set("name", (Object)(yearMember.getNameString() + dynamicObject.getString("name")));
                        }
                        EpbsPeriodMemberListF7.this.cacheF7Parameter(EpbsPeriodMemberListF7.this.getView().getPageCache(), (AbstractMemberF7Parameter)f7Parameter);
                        return collection;
                    }
                });
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void packageData(PackageDataEvent e) {
        PeriodMemberF7Parameter f7Parameter = this.getF7Parameter();
        Long modelId = f7Parameter.getModelId();
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        DimTypeBean dimTypeBean = modelCache.getDimTypeByDimensionId(f7Parameter.getDimensionId().longValue());
        if (DimTypeEnum.Period.getValue().equals(dimTypeBean.getType())) {
            DynamicObject dyObject = e.getRowData();
            AbstractColumnDesc column = (AbstractColumnDesc)e.getSource();
            String fieldKey = column.getFieldKey();
            try {
                if (fieldKey.equals("startdate") || fieldKey.equals("enddate")) {
                    BaseMemberBean baseMemberBean;
                    long periodId;
                    MemberBean member;
                    long id;
                    EpbsMemberCache memberCache = this.getMemberCache();
                    Map yearPeriodIdMap = f7Parameter.getYearPeriodIdMap();
                    YearPeriod yearPeriod = (YearPeriod)yearPeriodIdMap.get(id = dyObject.getLong("id"));
                    if (yearPeriod != null && (member = memberCache.getMember(periodId = yearPeriod.getPeriodId())) != null && (baseMemberBean = member.getBaseMemberBean()) != null) {
                        if (fieldKey.equals("startdate")) {
                            e.setFormatValue((Object)baseMemberBean.getStartDate(yearPeriod));
                        } else {
                            e.setFormatValue((Object)baseMemberBean.getEndDate(yearPeriod));
                        }
                    }
                } else {
                    super.packageData(e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected QFilter getSearchFilter() {
        String _searchText;
        Search search = (Search)this.getControl("searchlist");
        if (search != null && StringUtils.isNotEmpty((CharSequence)(_searchText = search.getSearchKey()))) {
            QFilter searchFilter;
            MemberBean year = this.getYearMember();
            if (year != null) {
                String yearName;
                String yearNumber = year.getNumber();
                if (_searchText.startsWith(yearNumber)) {
                    _searchText = _searchText.replace(yearNumber, "");
                }
                if (_searchText.startsWith(yearName = year.getNameString())) {
                    _searchText = _searchText.replace(yearName, "");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)_searchText) && (searchFilter = F7CommonUtils.getSearchFilter(_searchText)) != null) {
                return searchFilter;
            }
        }
        return null;
    }
}

