/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.memberf7;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.business.model.f7.PeriodMemberF7Parameter;
import kd.epm.epbs.business.model.f7.SelectedPeriod;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.formplugin.member.f7.SelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.EpbsMemberRangeF7;
import kd.epm.epbs.formplugin.model.memberf7.bean.PeriodSelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.face.IPeriodSelectedF7Cache;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class EpbsPeriodMemberRangeF7
extends EpbsMemberRangeF7
implements IPeriodSelectedF7Cache {
    public PeriodMemberF7Parameter getF7Parameter() {
        return (PeriodMemberF7Parameter)super.getF7Parameter();
    }

    @Override
    protected Map<String, SelectedMember> getSelectedData() {
        LinkedHashMap cacheSelected = this.getSelectedIdsFromCache(this.getPageCache());
        LinkedHashMap selectDatas = Maps.newLinkedHashMapWithExpectedSize((int)cacheSelected.size());
        DynamicObjectCollection selectedObj = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject selected : selectedObj) {
            String memberId = selected.getString("yearmemberid") + "@" + selected.getString("memberid");
            SelectedMember selectData = (SelectedMember)cacheSelected.get(memberId);
            if (selectData == null) continue;
            selectDatas.put(memberId, selectData);
        }
        return selectDatas;
    }

    @Override
    protected void initData() {
        PeriodMemberF7Parameter f7Param = this.getF7Parameter();
        if (f7Param != null && CollectionUtils.isNotEmpty((Collection)f7Param.getSelectedPeriodList())) {
            this.addMember(this.getView(), this.getModel(), this.getPageCache(), "entryentity", (AbstractMemberF7Parameter)f7Param);
        }
    }

    @Override
    protected void addMember(@NotNull IFormView view, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull String controlKey, @NotNull AbstractMemberF7Parameter f7Param) {
        PeriodMemberF7Parameter periodF7Param = (PeriodMemberF7Parameter)f7Param;
        List selectedData = periodF7Param.getSelectedPeriodList();
        if (selectedData == null || selectedData.isEmpty()) {
            return;
        }
        ArrayList selMembers = Lists.newArrayListWithExpectedSize((int)selectedData.size());
        EpbsMemberCache epbsMemberCache = EpbsMemberCacheHelper.get((long)f7Param.getModelId(), (long)((PeriodMemberF7Parameter)f7Param).getYearDimId());
        QFilter qFilter = new QFilter("id", "in", selectedData.stream().map(SelectedPeriod::getPeriodId).collect(Collectors.toList()));
        Map memberMap = BusinessDataServiceHelper.loadFromCache((String)f7Param.getEntityNumber(), (String)"id,name,number,longnumber,shownumber,dimension,view,parent", (QFilter[])qFilter.toArray());
        for (SelectedPeriod selectedPeriod : selectedData) {
            DynamicObject dynamicObject = (DynamicObject)memberMap.get(selectedPeriod.getPeriodId());
            if (dynamicObject == null) continue;
            PeriodSelectedMember periodSelectedMember = new PeriodSelectedMember().of(dynamicObject, "1");
            MemberBean yearMember = epbsMemberCache.getMember(selectedPeriod.getYearId());
            if (yearMember != null) {
                periodSelectedMember.initYear(yearMember);
            }
            periodSelectedMember.setScope(selectedPeriod.getScope());
            selMembers.add(periodSelectedMember);
        }
        this.fillMember(controlKey, f7Param, selMembers);
    }

    @Override
    protected Set<String> getIds(int[] rows) {
        HashSet<String> unCheckedIds = new HashSet<String>(rows.length);
        for (int row : rows) {
            DynamicObject member = this.getModel().getEntryRowEntity("entryentity", row);
            if (member == null) continue;
            unCheckedIds.add(member.getString("yearmemberid") + "@" + member.getString("memberid"));
        }
        return unCheckedIds;
    }

    @Override
    protected void clearSelect(Set<String> unCheckedIds) {
        PeriodMemberF7Parameter f7Parameter = this.getF7Parameter();
        List selectedPeriodList = f7Parameter.getSelectedPeriodList();
        if (selectedPeriodList != null) {
            HashSet<SelectedPeriod> removes = new HashSet<SelectedPeriod>(selectedPeriodList.size());
            block0: for (SelectedPeriod selectedPeriod : selectedPeriodList) {
                for (String unCheckedId : unCheckedIds) {
                    if (!selectedPeriod.toString().startsWith(unCheckedId + "@")) continue;
                    removes.add(selectedPeriod);
                    continue block0;
                }
            }
            if (!removes.isEmpty()) {
                selectedPeriodList.removeAll(removes);
                this.cacheF7Parameter(this.getPageCache(), (AbstractMemberF7Parameter)f7Parameter);
            }
        }
    }
}

