/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.memberf7;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ValueTextItem;
import kd.bos.list.F7SelectedList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.business.model.f7.PeriodMemberF7Parameter;
import kd.epm.epbs.business.model.f7.SelectedPeriod;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.formplugin.member.f7.SelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.EpbsMemberSelectedF7;
import kd.epm.epbs.formplugin.model.memberf7.bean.PeriodSelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.face.IPeriodSelectedF7Cache;
import org.apache.commons.collections4.CollectionUtils;

public class EpbsPeriodMemberSelectedF7
extends EpbsMemberSelectedF7
implements IPeriodSelectedF7Cache {
    @Override
    protected void initData() {
        PeriodMemberF7Parameter _f7Param = (PeriodMemberF7Parameter)this.getF7Parameter();
        List selectedPeriodList = _f7Param.getSelectedPeriodList();
        if (CollectionUtils.isNotEmpty((Collection)_f7Param.getSelectedPeriodList())) {
            LinkedHashMap<String, PeriodSelectedMember> selectedIds = new LinkedHashMap<String, PeriodSelectedMember>(selectedPeriodList.size());
            Set _memberIds = selectedPeriodList.stream().map(SelectedPeriod::getPeriodId).collect(Collectors.toSet());
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", _memberIds)};
            EpbsMemberCache epbsMemberCache = EpbsMemberCacheHelper.get((long)_f7Param.getModelId(), (long)_f7Param.getYearDimId());
            Map members = BusinessDataServiceHelper.loadFromCache((String)_f7Param.baseEntityNumber(), (String)"id,name,number", (QFilter[])filters, null);
            for (SelectedPeriod selectedPeriod : selectedPeriodList) {
                long periodId = selectedPeriod.getPeriodId();
                DynamicObject selValue = (DynamicObject)members.get(periodId);
                if (selValue == null) continue;
                PeriodSelectedMember periodSelectedMember = new PeriodSelectedMember();
                String pk = selValue.getString("id");
                String number = selValue.getString("number");
                String name = selValue.getString("name");
                MemberBean yearMember = epbsMemberCache.getMember(selectedPeriod.getYearId());
                if (yearMember != null) {
                    long id = GlobalIdUtil.genGlobalLongId();
                    periodSelectedMember.setId(id);
                    pk = String.valueOf(id);
                    periodSelectedMember.initYear(yearMember);
                }
                periodSelectedMember.setNumber(number);
                periodSelectedMember.setName(name);
                periodSelectedMember.setType("1");
                selectedIds.put(pk, periodSelectedMember);
            }
            this.cacheF7Parameter(this.getPageCache(), (AbstractMemberF7Parameter)_f7Param);
            this.cacheSelectMemberNew(this.getPageCache(), selectedIds);
            this.updateSelected();
        }
    }

    @Override
    protected void updateSelected() {
        F7SelectedList selectedF7 = (F7SelectedList)this.getControl("rightselect");
        LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(selectedMembers.size());
        for (SelectedMember member : selectedMembers.values()) {
            PeriodSelectedMember selectedMember = (PeriodSelectedMember)member;
            valueTextItems.add(new ValueTextItem(selectedMember.getYearId() + "@" + selectedMember.getId(), selectedMember.getYearPeriodName() + "(" + selectedMember.getYearPeriodNumber() + ")"));
        }
        selectedF7.addItems(valueTextItems);
    }
}

