/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.memberf7;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.epm.epbs.business.model.f7.PeriodMemberF7Parameter;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.formplugin.member.f7.SelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.EpbsMemberTreeRangeF7;
import kd.epm.epbs.formplugin.model.memberf7.bean.PeriodSelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.face.IMemberTreeSearch;
import kd.epm.epbs.formplugin.model.memberf7.face.IPeriodSelectedF7Cache;
import kd.epm.epbs.formplugin.model.memberf7.face.IYear;
import org.jetbrains.annotations.NotNull;

public class EpbsPeriodMemberTreeRangeF7
extends EpbsMemberTreeRangeF7
implements IMemberTreeSearch,
IYear,
IPeriodSelectedF7Cache {
    public PeriodMemberF7Parameter getF7Parameter() {
        return (PeriodMemberF7Parameter)super.getF7Parameter();
    }

    @Override
    protected void searchTree(Search search, String searchText) {
        this.searchTree(this.getView(), searchText);
    }

    @Override
    protected void click_TreeSearchUp(EventObject evt) {
        this.click_TreeSearchUp(this.getView());
    }

    @Override
    protected void click_TreeSearchDown(EventObject evt) {
        this.click_TreeSearchDown(this.getView());
    }

    @Override
    protected String getNodeId(String nodeId) {
        String[] split = nodeId.split("@");
        nodeId = split.length > 1 ? split[1] : split[0];
        return nodeId;
    }

    @Override
    protected void init_leftTree(AbstractMemberF7Parameter f7Param) {
        if (f7Param == null) {
            f7Param = this.getF7Parameter();
        }
        f7Param.getTreeBuilder(f7Param).buildTree((TreeView)this.getControl("lefttree"), this.getPageCache());
    }

    @Override
    protected PeriodSelectedMember getSelectedMember(Map<String, Object> node, String type) {
        String[] split = ((String)node.get("id")).split("@");
        long yearId = 0L;
        long periodId = 0L;
        if (split.length > 1) {
            yearId = Long.parseLong(split[0]);
            periodId = Long.parseLong(split[1]);
        }
        PeriodMemberF7Parameter f7Parameter = this.getF7Parameter();
        PeriodSelectedMember selectedMember = new PeriodSelectedMember().loadMember(periodId, type, (AbstractMemberF7Parameter)f7Parameter);
        selectedMember.setYearId(yearId);
        EpbsMemberCache epbsMemberCache = EpbsMemberCacheHelper.get((long)f7Parameter.getModelId(), (long)f7Parameter.getYearDimId());
        MemberBean year = epbsMemberCache.getMember(yearId);
        if (year != null) {
            selectedMember.setYearId(year.getId());
            selectedMember.setYearNumber(year.getNumber());
            selectedMember.setYearShowNumber(year.getShowNumber());
            selectedMember.setYearName(year.getNameString());
        }
        return selectedMember;
    }

    @Override
    protected void fillBillList(@NotNull SelectedMember selectedMember) {
        super.fillBillList(selectedMember);
        PeriodSelectedMember periodSelectedMember = (PeriodSelectedMember)selectedMember;
        int rowIndex = periodSelectedMember.getRowIndex();
        this.getModel().setValue("yearmemberid", (Object)periodSelectedMember.getYearId(), rowIndex);
        this.getModel().setValue("yearnumber", (Object)periodSelectedMember.getYearNumber(), rowIndex);
        this.getModel().setValue("yearshownumber", (Object)periodSelectedMember.getYearShowNumber(), rowIndex);
        this.getModel().setValue("yearname", (Object)periodSelectedMember.getYearName(), rowIndex);
        this.getModel().setValue("number", (Object)periodSelectedMember.getYearPeriodNumber(), rowIndex);
        this.getModel().setValue("shownumber", (Object)periodSelectedMember.getYearPeriodShowNumber(), rowIndex);
        this.getModel().setValue("name", (Object)periodSelectedMember.getYearPeriodName(), rowIndex);
    }

    @Override
    protected void unSelectedNode(@NotNull Object nodeId, @NotNull LinkedHashMap<String, SelectedMember> selectedMembers) {
        HashSet rowIndex = Sets.newHashSetWithExpectedSize((int)selectedMembers.size());
        DynamicObjectCollection selMembers = this.getModel().getEntryEntity("entryentity");
        int in = selMembers.size();
        for (int i = 0; i < in; ++i) {
            DynamicObject selMember = (DynamicObject)selMembers.get(i);
            if (!Objects.equals(selMember.getString("yearmemberid") + "@" + selMember.getString("memberId"), nodeId)) continue;
            rowIndex.add(i);
            selectedMembers.remove(IDUtils.toString((Object)nodeId));
        }
        if (!rowIndex.isEmpty()) {
            int[] _rowIndex = rowIndex.stream().mapToInt(x -> x).toArray();
            this.getModel().deleteEntryRows("entryentity", _rowIndex);
        }
        this.cacheSelectMemberNew(this.getPageCache(), selectedMembers);
    }
}

