/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.memberf7.bean;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.formplugin.member.f7.SelectedMember;
import org.jetbrains.annotations.NotNull;

public class EpbsSelectedMember
extends SelectedMember {
    private static final Log LOG = LogFactory.getLog(EpbsSelectedMember.class);
    private String showNumber;
    private String dimName;
    private long dimId;
    private long viewId;
    private String viewNumber;
    private String parentNumber;

    public String getShowNumber() {
        return this.showNumber;
    }

    public void setShowNumber(String showNumber) {
        this.showNumber = showNumber;
    }

    public String getDimName() {
        return this.dimName;
    }

    public void setDimName(String dimName) {
        this.dimName = dimName;
    }

    public long getDimId() {
        return this.dimId;
    }

    public long getViewId() {
        return this.viewId;
    }

    public void setViewId(long viewId) {
        this.viewId = viewId;
    }

    public void setDimId(long dimId) {
        this.dimId = dimId;
    }

    public String getViewNumber() {
        return this.viewNumber;
    }

    public void setViewNumber(String viewNumber) {
        this.viewNumber = viewNumber;
    }

    public String getParentNumber() {
        return this.parentNumber;
    }

    public void setParentNumber(String parentNumber) {
        this.parentNumber = parentNumber;
    }

    @Override
    public EpbsSelectedMember of(@NotNull DynamicObject object, @NotNull String type) {
        super.of(object, type);
        if ("1".equals(type)) {
            this.setShowNumber(object.getString("shownumber"));
            this.setDimName(object.getDynamicObject("dimension").getLocaleString("name").getLocaleValue());
            this.setDimId(object.getLong("dimension_id"));
            this.setViewId(object.getLong("view_id"));
            this.setViewNumber(object.getDynamicObject("view").getString("number"));
            if (object.getDynamicObject("parent") != null) {
                this.setParentNumber(object.getDynamicObject("parent").getString("number"));
            }
        } else if ("2".equals(type)) {
            DynamicObject dimension = object.getDynamicObject("property.dimension");
            this.setDimId(dimension.getLong("id"));
            this.setDimName(dimension.getLocaleString("name").getLocaleValue());
        }
        return this;
    }

    @Override
    public EpbsSelectedMember loadMember(Long id, String type, AbstractMemberF7Parameter f7Parameter) {
        DynamicObject member = null;
        if ("1".equals(type)) {
            member = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)f7Parameter.getEntityNumber(), (String)"id,name,number,longnumber,shownumber,dimension,view,parent");
        } else if ("2".equals(type)) {
            member = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)f7Parameter.getCustomPropertyValueForm(), (String)"id,name,number, property.number");
        }
        if (member == null) {
            LOG.error(String.format("%s\u4e2d\u3010id=%s\u3011\u7684\u6210\u5458\u672a\u627e\u5230", f7Parameter.getEntityNumber(), id));
            return null;
        }
        EpbsSelectedMember epbsSelectedMember = this.loadMember(member, type);
        if ("2".equals(type)) {
            epbsSelectedMember.setDimId(f7Parameter.getDimensionId());
            epbsSelectedMember.setDimName(f7Parameter.getDimensionName());
        }
        return epbsSelectedMember;
    }

    @Override
    public EpbsSelectedMember loadMember(DynamicObject member, String type) {
        super.loadMember(member, type);
        if ("2".equals(type)) {
            this.setLongNumber(member.getString("property.number") + "!" + this.getNumber());
            DynamicObject dimension = member.getDynamicObject("property.dimension");
            this.setDimId(dimension.getLong("id"));
            this.setDimName(dimension.getLocaleString("name").getLocaleValue());
        } else if ("1".equals(type)) {
            this.setShowNumber(member.getString("shownumber"));
            this.setDimId(member.getLong("dimension_id"));
            this.setDimName(member.getDynamicObject("dimension").getLocaleString("name").getLocaleValue());
            this.setViewId(member.getLong("view_id"));
            this.setViewNumber(member.getDynamicObject("view").getString("number"));
            this.setParentNumber(member.getString("parent.number"));
        }
        return this;
    }
}

