/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.memberf7.face;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.epbs.business.model.f7.PeriodMemberF7Parameter;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.YearPeriod;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.formplugin.member.f7.SelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.bean.EpbsSelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.bean.MultiF7Result;
import kd.epm.epbs.formplugin.model.memberf7.bean.PeriodSelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.face.IEpbsSelectedF7Cache;
import kd.epm.epbs.formplugin.model.memberf7.util.F7ReturnDataUtil;
import org.jetbrains.annotations.NotNull;

public interface IPeriodSelectedF7Cache
extends IEpbsSelectedF7Cache {
    @Override
    default public TypeReference getSelectMemberType() {
        return new TypeReference<LinkedHashMap<String, PeriodSelectedMember>>(){};
    }

    @Override
    default public String getSelectMemberPk(SelectedMember member) {
        PeriodSelectedMember periodSelectedMember = (PeriodSelectedMember)member;
        String pk = IDUtils.toString((Object)periodSelectedMember.getId());
        pk = periodSelectedMember.getYearId() + "@" + pk;
        return pk;
    }

    @Override
    default public PeriodSelectedMember newSelectMember(DynamicObject member, String memberType) {
        return new PeriodSelectedMember().of(member, memberType);
    }

    @Override
    default public PeriodSelectedMember newSelectMember(Long id, String memberType, AbstractMemberF7Parameter f7Parameter) {
        PeriodMemberF7Parameter periodMemberF7Parameter = (PeriodMemberF7Parameter)f7Parameter;
        YearPeriod yearPeriod = (YearPeriod)periodMemberF7Parameter.getYearPeriodIdMap().get(id);
        if (yearPeriod != null) {
            id = yearPeriod.getPeriodId();
            PeriodSelectedMember epbsSelectedMember = new PeriodSelectedMember().loadMember(id, memberType, f7Parameter);
            EpbsMemberCache epbsMemberCache = EpbsMemberCacheHelper.get((long)periodMemberF7Parameter.getModelId(), (long)periodMemberF7Parameter.getYearDimId());
            MemberBean member = epbsMemberCache.getMember(yearPeriod.getYearId());
            if (member != null) {
                epbsSelectedMember.initYear(member);
            }
            return epbsSelectedMember;
        }
        return null;
    }

    @Override
    default public void putSelectedMemberNew(@NotNull Map<String, SelectedMember> selectMembers, Collection<?> objects, @NotNull String memberType) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        SelectedMember selectedMember = new SelectedMember();
        for (Object _object : objects) {
            if (!(_object instanceof DynamicObject)) {
                throw new IllegalStateException();
            }
            DynamicObject member = (DynamicObject)_object;
            String pk = member.getString("id");
            selectedMember.setId(Long.parseLong(pk));
            selectedMember.setNumber(member.getString("number"));
            selectedMember.setName(member.getString("name"));
            selectedMember.setType(memberType);
            selectMembers.put(pk, selectedMember);
        }
    }

    @Override
    default public Object getReturnData(AbstractMemberF7Parameter f7Param, Map<String, SelectedMember> selectData, Map<String, Object> dataParams) {
        Object returnData = F7ReturnDataUtil.getReturnData(f7Param, selectData, dataParams, PeriodSelectedMember.class);
        if (returnData instanceof MultiF7Result) {
            MultiF7Result multiF7Result = (MultiF7Result)returnData;
            List<EpbsSelectedMember> selectedMemberList = multiF7Result.getSelectedMemberList();
            EpbsMemberCache epbsMemberCache = EpbsMemberCacheHelper.get((long)f7Param.getModelId(), (long)((PeriodMemberF7Parameter)f7Param).getYearDimId());
            for (EpbsSelectedMember selectedMember : selectedMemberList) {
                PeriodSelectedMember periodSelectedMember = (PeriodSelectedMember)selectedMember;
                MemberBean yearMember = epbsMemberCache.getMember(periodSelectedMember.getYearId());
                if (yearMember == null) continue;
                periodSelectedMember.setYearNumber(yearMember.getNumber());
                periodSelectedMember.setYearName(yearMember.getNameString());
                periodSelectedMember.setYearShowNumber(yearMember.getShowNumber());
            }
        }
        return returnData;
    }
}

