/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model.prop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.model.f7.MemberF7Parameter;
import kd.epm.epbs.business.model.memberf7.MemberF7Utils;
import kd.epm.epbs.business.model.memberref.MemberRefHelper;
import kd.epm.epbs.business.model.memberref.MemberRefResult;
import kd.epm.epbs.business.model.memberref.RefBean;
import kd.epm.epbs.common.enums.model.PropScopeEnum;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsPropCacheHelper;
import kd.epm.epbs.common.util.UserUtils;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epbs.formplugin.model.DimensionF7SelectListener;
import kd.epm.epbs.formplugin.model.memberf7.bean.EpbsSelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.bean.MultiF7Result;

public abstract class PropertyDefinedFormPlugin
extends AbstractBaseListPlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit refDimension = (BasedataEdit)this.getControl("refdimension");
        refDimension.addBeforeF7SelectListener((BeforeF7SelectListener)new DimensionF7SelectListener((AbstractFormPlugin)this, this.getModelId()));
        this.addClickListeners(new String[]{"sourcenumber"});
    }

    protected Long getDimensionId() {
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        if (dimension == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"PropertyDefinedFormPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        return dimension.getLong("id");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            Boolean isCopy;
            DynamicObject dynamicObject;
            Object bizModel = this.getView().getFormShowParameter().getCustomParam("bizModel");
            if (bizModel != null && !Objects.equals(bizModel, 0) && (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bizModel, (String)this.getMetaDataEntity(this.getView(), "epbs_bizmodel"), (String)"id")) != null) {
                this.getModel().setValue("bizmodel", bizModel);
                this.getModel().setValue("scope", (Object)PropScopeEnum.PRIVATE.getValue());
            }
            if (this.getModel().getValue("dimension") == null) {
                Object dimension = this.getView().getFormShowParameter().getCustomParam("dimension");
                if (dimension != null) {
                    DynamicObject dynamicObject2 = BusinessDataServiceHelper.loadSingleFromCache((Object)dimension, (String)this.getMetaDataEntity(this.getView(), "epbs_dimension"), (String)"model");
                    if (dynamicObject2 != null) {
                        this.getModel().setValue("dimension", dimension);
                        this.getModel().setValue("model", dynamicObject2.get("model"));
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"PropertyDefinedFormPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (Objects.equals(isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy"), true)) {
                this.getModel().setValue("number", (Object)(this.getModel().getValue("number") + "copy"));
                this.getModel().setValue("name", (Object)(this.getModel().getValue("name") + "copy"));
            }
            this.getModel().setDataChanged(false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("deleteentry".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("propvalues");
            IDataModel dataModel = this.getModel();
            long propId = dataModel.getDataEntity().getLong("id");
            if (propId == 0L) {
                return;
            }
            int[] selectRows = entryGrid.getSelectRows();
            HashMap<Long, Integer> propValueMap = new HashMap<Long, Integer>(selectRows.length);
            for (int selectRow : selectRows) {
                DynamicObject entryRowEntity = dataModel.getEntryRowEntity("propvalues", selectRow);
                long id = entryRowEntity.getLong("id");
                if (id == 0L) continue;
                propValueMap.put(id, selectRow);
            }
            long modelId = this.getModelId();
            Long dimensionId = this.getDimensionId();
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
            QFilter qFilter = new QFilter("propertydefined", "=", (Object)propId).and("propval", "in", propValueMap.keySet().stream().map(String::valueOf).collect(Collectors.toSet()));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)modelCache.getMetaDataEntity("epbs_membpropval"), (String)"memberid,propval", (QFilter[])qFilter.toArray());
            if (!dynamicObjects.isEmpty()) {
                EpbsMemberCache epbsMemberCache = EpbsMemberCacheHelper.get((long)modelId, (long)dimensionId);
                ArrayList<String> msgList = new ArrayList<String>(dynamicObjects.size());
                for (DynamicObject dynamicObject : dynamicObjects) {
                    long propVal = dynamicObject.getLong("propval");
                    long memberId = dynamicObject.getLong("memberid");
                    List members = epbsMemberCache.getMembersByBaseMemberIds(Collections.singletonList(memberId), null);
                    if (!CollectionUtils.isNotEmpty((Collection)members)) continue;
                    MemberBean memberBean = (MemberBean)members.get(0);
                    msgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5df2\u7ecf\u88ab\u6210\u5458\u201c%2$s %3$s\u201d\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PropertyDefinedFormPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), (Integer)propValueMap.get(propVal) + 1, memberBean.getNumber(), memberBean.getNameString()));
                }
                this.getView().showTipNotification(String.join((CharSequence)" ", msgList));
                args.setCancel(true);
            }
            MemberRefHelper memberRefHelper = MemberRefHelper.getInstance((long)modelId, (long)dimensionId);
            memberRefHelper.setPropValue(true);
            MemberRefResult memberRefResult = memberRefHelper.hasRef(new ArrayList(propValueMap.keySet()));
            if (memberRefResult.isHasRef()) {
                List hasRefList = memberRefResult.getHasRefList();
                ArrayList<String> msgList = new ArrayList<String>(dynamicObjects.size());
                if (hasRefList != null) {
                    for (RefBean refBean : hasRefList) {
                        msgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5df2\u7ecf\u88ab\u6210\u5458\u201c%2$s\u201d\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PropertyDefinedFormPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]), (Integer)propValueMap.get(refBean.getMemberId()) + 1, refBean.getBizMsg()));
                    }
                }
                this.getView().showTipNotification(String.join((CharSequence)" ", msgList));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        if ("save".equals(operateKey) || "delete".equals(operateKey)) {
            EpbsPropCacheHelper.invalidate((long)this.getDimensionId());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals("sourcenumber")) {
            Long sourceId = (Long)this.getModel().getValue("sourceid");
            MemberF7Parameter f7Param = this.getMemberF7Paramter();
            if (f7Param != null) {
                f7Param.setShowCustomProperty(true);
                f7Param.setEnableView(true);
                f7Param.setCanSelectRoot(false);
                f7Param.setSelectId(sourceId);
                MemberF7Utils.openF7((IFormView)this.getView(), (AbstractMemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "sourcenumber"));
            }
        }
    }

    protected abstract MemberF7Parameter getMemberF7Paramter();

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        MultiF7Result multiF7Result;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("sourcenumber".equals(actionId) && (multiF7Result = (MultiF7Result)closedCallBackEvent.getReturnData()) != null) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("propvalues");
            List<EpbsSelectedMember> list = multiF7Result.getSelectedMemberList();
            DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("propvalues");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("propvalues", entryCurrentRowIndex);
            Set numberSet = entries.stream().map(o -> o.getString("sourcenumber")).collect(Collectors.toSet());
            numberSet.remove(entryRowEntity.getString("sourcenumber"));
            Iterator<EpbsSelectedMember> iterator = list.iterator();
            boolean exist = false;
            while (iterator.hasNext()) {
                EpbsSelectedMember next = iterator.next();
                if (numberSet.add(next.getNumber())) continue;
                iterator.remove();
                exist = true;
            }
            if (exist) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u81ea\u52a8\u53bb\u9664\u91cd\u590d\u7684\u7f16\u7801\u3002", (String)"PropertyDefinedFormPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
            this.getModel().beginInit();
            if (list.size() > 1) {
                this.getModel().batchInsertEntryRow("propvalues", entryCurrentRowIndex, list.size() - 1);
            }
            for (int i = 0; i < list.size(); ++i) {
                DynamicObject rowEntity;
                EpbsSelectedMember selectedMember = list.get(i);
                if (i == 0) {
                    rowEntity = this.getModel().getEntryRowEntity("propvalues", entryCurrentRowIndex);
                } else {
                    rowEntity = new DynamicObject(entries.getDynamicObjectType());
                    entries.add(++entryCurrentRowIndex, rowEntity);
                }
                rowEntity.set("sourcenumber", (Object)selectedMember.getNumber());
                rowEntity.set("sourcename", (Object)selectedMember.getName());
                rowEntity.set("sourceid", (Object)selectedMember.getId());
                Long userId = UserUtils.getUserId();
                this.getModel().setValue("creator1", (Object)userId, entryCurrentRowIndex);
                this.getModel().setValue("modifier1", (Object)userId, entryCurrentRowIndex);
            }
            this.getModel().endInit();
            this.getView().updateView("propvalues");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("sourcenumber".equals(name)) {
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isEmpty((String)newValue)) {
                this.getModel().setValue("sourcename", (Object)"");
            }
        } else if ("refdimension".equals(name)) {
            this.getModel().deleteEntryData("propvalues");
        }
    }
}

