/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.pageinteraction;

import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.FieldAp;
import kd.epm.epbs.business.page.model.BaseEditElement;
import kd.epm.epbs.business.page.model.ButtonElement;
import kd.epm.epbs.business.page.model.CheckBox;
import kd.epm.epbs.business.page.model.ComboEditElement;
import kd.epm.epbs.business.page.model.DecimalEditElement;
import kd.epm.epbs.business.page.model.Element;
import kd.epm.epbs.business.page.model.LabelElement;
import kd.epm.epbs.business.page.model.MultiBaseEditElement;
import kd.epm.epbs.business.page.model.Page;
import kd.epm.epbs.business.page.model.TextEditElement;
import kd.epm.epbs.common.util.ObjectSerialUtil;

public interface DynamicPage {
    public AbstractFormPlugin getPlugin();

    default public Page getPage(IFormView curview) {
        return (Page)ThreadCache.get((Object)(curview.getPageId() + "page"), () -> {
            if (this.getPageCache(curview) == null) {
                return null;
            }
            String cac = this.getPageCache(curview).get("page");
            if (cac != null) {
                return (Page)ObjectSerialUtil.deSerializedBytes((String)cac);
            }
            return null;
        });
    }

    default public void setPage(IFormView curview, Page page) {
        this.setPage(curview, page, false);
    }

    default public void setPage(IFormView curview, Page page, boolean isaddElement) {
        if (this.getPageCache(curview) == null) {
            return;
        }
        if (isaddElement) {
            curview.getModel().getDataEntity(true);
        }
        page.getAreaList().forEach(a -> a.getElementListList().forEach(e -> e.check(curview)));
        ThreadCache.put((Object)(curview.getPageId() + "page"), (Object)page);
        this.getPageCache(curview).put("page", ObjectSerialUtil.toByteSerialized((Object)page));
    }

    default public IPageCache getPageCache(IFormView curview) {
        FormViewPluginProxy curproxy = (FormViewPluginProxy)curview.getService(FormViewPluginProxy.class);
        IPageCache pageCache = null;
        for (IFormPlugin pl : curproxy.getPlugIns()) {
            if (!AbstractFormPlugin.class.isAssignableFrom(pl.getClass())) continue;
            pageCache = ((AbstractFormPlugin)AbstractFormPlugin.class.cast(pl)).getPageCache();
        }
        if (pageCache == null) {
            return null;
        }
        return pageCache;
    }

    default public boolean needCache() {
        return true;
    }

    default public void dynamicInit() {
        Page page = this.getPage(this.getPlugin().getView());
        if (page != null) {
            if (page.isChangeable()) {
                this.getPlugin().getView().getModel().getDataEntity();
            }
            this.getPage(this.getPlugin().getView()).bindCtrlMapping(this.getPlugin().getView());
        }
    }

    default public void getDynamicEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType copy = (MainEntityType)e.getOriginalEntityType().clone();
            e.setNewEntityType(copy);
            Page page = this.getPage(this.getPlugin().getView());
            if (page != null) {
                page.cacheMainProp(this.getPlugin().getPageCache(), copy.getProperties());
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    default public void getDynamicControl(OnGetControlArgs e) {
        Element ele;
        Page page = this.getPage(this.getPlugin().getView());
        if (page != null && (ele = page.findElementBySign(e.getKey())) != null) {
            e.setControl(ele.getControl(this.getPlugin().getView()));
        }
    }

    default public void dynamicProChange(PropertyChangedArgs e) {
        Element ele;
        Page page;
        String propertyName = e.getProperty().getName();
        if (this.needCache() && (page = this.getPage(this.getPlugin().getView())) != null && (ele = page.findElementBySign(propertyName)) != null) {
            ele.setValue(this.getPlugin().getPageCache(), e.getChangeSet()[0].getNewValue());
            this.setPage(this.getPlugin().getView(), page);
        }
    }

    default public Object getDynamicValue(String sign) {
        if (this.needCache()) {
            Page page = this.getPage(this.getPlugin().getView());
            if (null == page) {
                return null;
            }
            Element ele = page.findElementBySign(sign);
            if (ele != null) {
                Object ori = this.getPlugin().getView().getModel().getValue(sign);
                if (ori instanceof DynamicObjectCollection) {
                    List relist = (List)ele.getValue(this.getPlugin().getPageCache());
                    if (relist == null) {
                        return this.getPlugin().getView().getModel().getValue(sign);
                    }
                    DynamicObjectCollection result = (DynamicObjectCollection)ori;
                    result.clear();
                    for (DynamicObject oo : relist) {
                        DynamicObject addnew = result.addNew();
                        addnew.set("fbasedataid", (Object)oo);
                    }
                    return result;
                }
                return ele.getValue(this.getPlugin().getPageCache());
            }
        }
        return this.getPlugin().getView().getModel().getValue(sign);
    }

    default public void setDynamicValue(String sign, Object value, boolean cachePage) {
        Page page;
        Element ele;
        if (this.needCache() && (ele = (page = this.getPage(this.getPlugin().getView())).findElementBySign(sign)) != null) {
            ele.setValue(this.getPlugin().getPageCache(), this.getPlugin().getView().getModel().getValue(sign));
            if (cachePage) {
                this.setPage(this.getPlugin().getView(), page);
            }
        }
    }

    default public <T extends Element> T getDynamicElememt(String name, String elementSign, String entityNumber, Class<T> clazz) {
        Object element = null;
        element = clazz == BaseEditElement.class ? new BaseEditElement(name, elementSign, entityNumber) : (clazz == TextEditElement.class ? new TextEditElement(name, elementSign, entityNumber) : (clazz == MultiBaseEditElement.class ? new MultiBaseEditElement(name, elementSign, entityNumber) : (clazz == DecimalEditElement.class ? new DecimalEditElement(name, elementSign, entityNumber) : (clazz == ComboEditElement.class ? new ComboEditElement(elementSign, name, null) : (clazz == CheckBox.class ? new CheckBox(name, elementSign) : (clazz == LabelElement.class ? new LabelElement(elementSign, name) : (clazz == ButtonElement.class ? new ButtonElement(elementSign, name) : new LabelElement(elementSign, name))))))));
        element.setCustomStyle(ap -> this.defaultStyle((ControlAp)ap));
        return (T)element;
    }

    default public void defaultStyle(ControlAp ap) {
        if (ap instanceof FieldAp) {
            ((FieldAp)ap).setQuickAddNew(false);
            ((FieldAp)ap).setFireUpdEvt(true);
            ((FieldAp)ap).setFieldTextAlign("center");
            ((FieldAp)ap).setLabelDirection("h");
        }
        ap.setTextAlign("left");
        ap.setHeight(new LocaleString("40px"));
        ap.setFontSize(14);
        Style style = new Style();
        Margin margin = new Margin();
        Padding padding = new Padding();
        padding.setTop("14px");
        padding.setRight("14px");
        padding.setLeft("14px");
        margin.setTop("1px");
        margin.setBottom("10px");
        margin.setLeft("30px");
        margin.setRight("1px");
        style.setMargin(margin);
        style.setPadding(padding);
        ap.setStyle(style);
    }
}

