/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.pageinteraction;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.epbs.formplugin.ISupportPageCacheProxy;
import kd.epm.epbs.formplugin.pageinteraction.CommandParam;
import kd.epm.epbs.formplugin.pageinteraction.InteractivePage;
import kd.epm.epbs.formplugin.pageinteraction.PageListenerRegister;
import org.apache.commons.lang.RandomStringUtils;

public interface MainPage
extends InteractivePage {
    public static final Log logger = LogFactory.getLog(MainPage.class);

    default public void disPatchMsg(IFormView curview, CommandParam com) {
        if (curview == null) {
            return;
        }
        FormViewPluginProxy curproxy = (FormViewPluginProxy)curview.getService(FormViewPluginProxy.class);
        if (curproxy == null) {
            return;
        }
        IPageCache pageCache = null;
        for (IFormPlugin pl : curproxy.getPlugIns()) {
            if (!AbstractFormPlugin.class.isAssignableFrom(pl.getClass())) continue;
            pageCache = ((AbstractFormPlugin)AbstractFormPlugin.class.cast(pl)).getPageCache();
        }
        if (pageCache == null) {
            return;
        }
        Map<String, String> map = this.getPagePool(pageCache);
        map.put(curview.getPageId(), curview.getFormShowParameter().getFormId());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            IFormView cv;
            if (entry.getValue().equals(com.getSender()) || StringUtils.isNotEmpty((String)com.getReceiver()) && !com.getReceiver().equals(entry.getValue()) || (cv = curview.getView(entry.getKey())) == null || !com.addCompletedReceiver(cv.getPageId())) continue;
            FormViewPluginProxy proxy = (FormViewPluginProxy)cv.getService(FormViewPluginProxy.class);
            PageListenerRegister re = this.getListener(pageCache);
            proxy.getPlugIns().forEach(e -> {
                if (InteractivePage.class.isAssignableFrom(e.getClass())) {
                    if (com.isModule()) {
                        if (re.check(com.getParam().get(0).toString(), com.getParam().get(1).toString(), com.getOperation())) {
                            try {
                                Method method = e.getClass().getDeclaredMethod(com.getOperation(), com.getParam().get(2).getClass());
                                method.invoke(e, com.getParam().get(2));
                            }
                            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                                logger.info(ex.getMessage());
                            }
                        }
                    } else if (com.isReFlect()) {
                        try {
                            Class[] classes = new Class[com.getParam().size()];
                            for (int i = 0; i < com.getParam().size(); ++i) {
                                classes[i] = com.getParam().get(i).getClass();
                            }
                            Method method = e.getClass().getDeclaredMethod(com.getOperation(), classes);
                            method.invoke(e, com.getParam().toArray());
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                            logger.info(ex.getMessage());
                        }
                    } else {
                        ((InteractivePage)InteractivePage.class.cast(e)).dealMsg(com);
                        ((InteractivePage)InteractivePage.class.cast(e)).afterDealMsg(com);
                    }
                }
                if (ISupportPageCacheProxy.class.isAssignableFrom(e.getClass())) {
                    ((AbstractFormPlugin)AbstractFormPlugin.class.cast(e)).destory();
                }
            });
            curview.sendFormAction(cv);
        }
    }

    @Override
    default public void sendMsg(IFormView curview, CommandParam com) {
        this.disPatchMsg(curview, com);
    }

    default public String getPageIdAndCache(IPageCache pageCache, String formId) {
        return this.getPageIdAndCache(pageCache, formId, false);
    }

    default public String getPageIdAndCache(IPageCache pageCache, String formId, boolean isDistinct) {
        String pageId = formId + RandomStringUtils.randomAlphanumeric((int)10);
        String cache = pageCache.get("pagePool");
        Map map = new HashMap<String, String>();
        if (cache != null) {
            map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
            if (isDistinct) {
                map.entrySet().removeIf(p -> Objects.equals(formId, p.getValue()));
            }
        }
        map.put(pageId, formId);
        pageCache.put("pagePool", SerializationUtils.toJsonString(map));
        return pageId;
    }

    default public Map<String, String> getPagePool(IPageCache pageCache) {
        String cache = pageCache.get("pagePool");
        Map<String, String> map = new HashMap<String, String>();
        if (cache != null) {
            map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        }
        return map;
    }
}

