/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.param.edit;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.business.paramsetting.enums.PsControlTypeEnum;
import kd.epm.epbs.business.paramsetting.model.ParamSetControl;
import kd.epm.epbs.business.paramsetting.util.PsControlFieldUtils;
import kd.epm.epbs.common.util.NumberRuleUtils;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import org.apache.commons.lang3.tuple.Pair;

public class CommonParamFromStyleSetPlugin
extends AbstractFormPlugin {
    private static final String CHANGE_FIELD_CACHE = "change_field_cache";

    protected ParamSetControl getParamSetControl() {
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("controlset")))) {
            return PsControlFieldUtils.castJson2Control((String)((String)this.getView().getFormShowParameter().getCustomParam("controlset")));
        }
        return new ParamSetControl();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ParamSetControl paramSetControl = this.getParamSetControl();
        this.getModel().setValue("controlkey", (Object)paramSetControl.getNumberWithDefault());
        this.getModel().setValue("controlName", (Object)paramSetControl.getNameWithDefault());
        this.getModel().setValue("controltips", (Object)paramSetControl.getTips());
        List<String> changeFieldCache = this.getChangeFieldCache();
        if (StringUtils.isNotEmpty((CharSequence)paramSetControl.getNumber())) {
            changeFieldCache.add("controlkey");
        }
        if (paramSetControl.getName() != null) {
            changeFieldCache.add("controlname");
        }
        if (paramSetControl.getTips() != null) {
            changeFieldCache.add("controltips");
        }
        if (paramSetControl.getStyles() != null && !paramSetControl.getStyles().isEmpty()) {
            paramSetControl.getStyles().forEach((k, v) -> {
                if (k.equals("comboxItems")) {
                    ((List)v).forEach(a -> {
                        int row = this.getModel().createNewEntryRow("comboxentryentity");
                        this.getModel().setValue("comboxtitle", a.get("title"), row);
                        this.getModel().setValue("comboxvalue", a.get("value"), row);
                    });
                    changeFieldCache.add("comboxadvconap");
                } else {
                    this.getModel().setValue(k.toLowerCase(Locale.ENGLISH), v);
                    changeFieldCache.add(k.toLowerCase(Locale.ENGLISH));
                }
            });
        }
        if (!changeFieldCache.isEmpty()) {
            this.getPageCache().put(CHANGE_FIELD_CACHE, ObjectSerialUtil.toByteSerialized(changeFieldCache));
        }
        ArrayList controlkeys = Lists.newArrayList((Object[])new String[]{"password", "minlength", "maxlength", "datascope", "scale", "precision", "comboxadvconap", "baseentityid", "zeroshow"});
        this.getView().setVisible(Boolean.valueOf(false), controlkeys.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(true), (String[])this.getControlStyleKey().stream().map(a -> a.toLowerCase(Locale.ENGLISH)).toArray(String[]::new));
    }

    public List<String> getControlStyleKey() {
        ArrayList<String> list = new ArrayList<String>(10);
        PsControlTypeEnum psControlType = this.getPsControlType();
        if (TextField.class.isAssignableFrom(psControlType.getClazz())) {
            list.add("minLength");
            list.add("maxLength");
            if (psControlType == PsControlTypeEnum.TEXT) {
                list.add("password");
            }
        } else if (DecimalField.class.isAssignableFrom(psControlType.getClazz())) {
            list.add("dataScope");
            list.add("zeroShow");
            if (psControlType == PsControlTypeEnum.DECIMAL) {
                list.add("scale");
                list.add("precision");
            }
        } else if (ComboField.class.isAssignableFrom(psControlType.getClazz())) {
            list.add("comboxadvconap");
        } else if (psControlType == PsControlTypeEnum.BASEDATA || psControlType == PsControlTypeEnum.MULBASEDATA) {
            list.add("baseEntityId");
        }
        return list;
    }

    private PsControlTypeEnum getPsControlType() {
        return PsControlTypeEnum.getEnumByIndex((int)this.getParamSetControl().getType());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel", "controltips"});
    }

    private List<String> getChangeFieldCache() {
        String fieldcache = this.getPageCache().get(CHANGE_FIELD_CACHE);
        if (StringUtils.isNotEmpty((CharSequence)fieldcache)) {
            return (List)ObjectSerialUtil.deSerializedBytes((String)fieldcache);
        }
        return new ArrayList<String>();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        List<String> changeFieldCache = this.getChangeFieldCache();
        if (!changeFieldCache.contains(key = e.getProperty().getName())) {
            if (key.equals("comboxtitle") || key.equals("comboxvalue")) {
                key = "comboxadvconap";
            }
            this.getModel().setDataChanged(true);
            changeFieldCache.add(key);
            this.getPageCache().put(CHANGE_FIELD_CACHE, ObjectSerialUtil.toByteSerialized(changeFieldCache));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            ParamSetControl paramSetControl = new ParamSetControl(this.getPsControlType().getIndex());
            List<String> controlStyleKeys = this.getControlStyleKey();
            List<String> changeFieldCache = this.getChangeFieldCache();
            controlStyleKeys.add("controlKey");
            controlStyleKeys.add("controlName");
            controlStyleKeys.add("controltips");
            controlStyleKeys.add("mustInput");
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            for (String controlStyleKey : controlStyleKeys) {
                if (!changeFieldCache.contains(controlStyleKey.toLowerCase(Locale.ENGLISH))) continue;
                if (controlStyleKey.equals("comboxadvconap")) {
                    DynamicObjectCollection comboxentryentity = this.getModel().getEntryEntity("comboxentryentity");
                    ArrayList comboxList = new ArrayList(16);
                    for (DynamicObject e : comboxentryentity) {
                        if (ObjectUtils.isEmpty((Object)e.get("comboxtitle")) ^ ObjectUtils.isEmpty((Object)e.get("comboxvalue"))) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5b8c\u6574\u7b2c%s\u884c\u6570\u636e\u3002", (String)"CommonParamFromStyleSetPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), e.getString("seq")));
                            return;
                        }
                        if (ObjectUtils.isEmpty((Object)e.get("comboxtitle")) && ObjectUtils.isEmpty((Object)e.get("comboxvalue"))) continue;
                        if (!NumberRuleUtils.checkNumber((String)e.getString("comboxvalue"))) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5b8c\u6574\u7b2c%s\u884c\u503c\u4e0d\u7b26\u5408\u8981\u6c42\u3002", (String)"CommonParamFromStyleSetPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), e.getString("seq")));
                            return;
                        }
                        HashMap<String, Object> item = new HashMap<String, Object>();
                        item.put("title", e.get("comboxtitle"));
                        item.put("value", e.get("comboxvalue"));
                        comboxList.add(item);
                    }
                    map.put("comboxItems", comboxList);
                    continue;
                }
                Object val = this.getModel().getValue(controlStyleKey.toLowerCase(Locale.ENGLISH));
                if (val == null) continue;
                map.put(controlStyleKey, val);
            }
            paramSetControl.setNumber((String)map.remove("controlKey"));
            if (!NumberRuleUtils.checkNumber((String)paramSetControl.getNumberWithDefault())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63a7\u4ef6\u7f16\u7801\u4e0d\u5408\u7b26\u8981\u6c42\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"CommonParamFromStyleSetPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            paramSetControl.setName(map.containsKey("controlName") ? LocaleString.fromMap((Map)((Map)map.remove("controlName"))) : null);
            if (paramSetControl.getName() != null && (paramSetControl.getName().isEmpty() || StringUtils.isEmpty((CharSequence)paramSetControl.getName().getLocaleValue()))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63a7\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonParamFromStyleSetPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            paramSetControl.setTips((String)map.remove("controltips"));
            if (!this.validateData(map, controlStyleKeys)) {
                return;
            }
            if (!map.isEmpty()) {
                paramSetControl.setStyles(map);
            }
            this.getView().returnDataToParent((Object)Pair.of((Object)this.getView().getFormShowParameter().getCustomParam("fromsource"), (Object)paramSetControl));
            this.getView().close();
        } else if ("controltips".equals(key)) {
            Object value = this.getModel().getValue("controltips");
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setParentPageId(this.getView().getPageId());
            formShowParameter.setFormId("epbs_paramset_helptext");
            formShowParameter.setCustomParam("value", value);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tipsAction"));
            this.getView().showForm(formShowParameter);
        }
    }

    private boolean validatenumber(Map<String, Object> map, String minkey, Integer minvalue, String maxKey, Integer defaultvalue) {
        return this.validatenumber(map, minkey, minvalue, maxKey, defaultvalue, (max, min) -> true);
    }

    private boolean validatenumber(Map<String, Object> map, String minkey, Integer minvalue, String maxKey, Integer defaultvalue, BiFunction<Integer, Integer, Boolean> biFunction) {
        if (map.containsKey(minkey) || map.containsKey(maxKey)) {
            Integer maxlength = (Integer)map.get(maxKey);
            maxlength = maxlength == null ? defaultvalue : maxlength;
            Integer minlength = (Integer)map.get(minkey);
            Integer n = minlength = minlength == null ? minvalue : minlength;
            if (maxlength < minlength) {
                return false;
            }
            if (maxlength == 0 || maxlength.equals(defaultvalue)) {
                map.remove(maxKey);
            }
            if (minlength == 0 || minlength.equals(minvalue)) {
                map.remove(minkey);
            }
            return biFunction.apply(maxlength, minlength);
        }
        return true;
    }

    private boolean validateData(Map<String, Object> map, List<String> controlStyleKeys) {
        String dataScope;
        if (!this.validatenumber(map, "minLength", 0, "maxLength", 50)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u5927\u957f\u5ea6\u548c\u6700\u5c0f\u957f\u5ea6\u4e0d\u7b26\u5408\u8981\u6c42", (String)"CommonParamFromStyleSetPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!(!map.containsKey("dataScope") || !StringUtils.isNotEmpty((CharSequence)((String)map.get("dataScope"))) || (dataScope = ((String)map.get("dataScope")).trim()).length() > 3 && (dataScope.startsWith("[") && dataScope.endsWith("]") || dataScope.startsWith("(") && dataScope.endsWith(")")) && dataScope.substring(1, dataScope.length() - 1).matches("-{0,1}\\d+,\\d*"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u503c\u8303\u56f4\u4e0d\u6ee1\u8db3\u683c\u5f0f\u8981\u6c42\u3002", (String)"CommonParamFromStyleSetPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (controlStyleKeys.contains("baseEntityId")) {
            if (!map.containsKey("baseEntityId") || StringUtils.isEmpty((CharSequence)((CharSequence)map.get("baseEntityId")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonParamFromStyleSetPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return false;
            }
            try {
                dataScope = BusinessDataServiceHelper.newDynamicObject((String)((String)map.get("baseEntityId")));
            }
            catch (Exception e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u4e0d\u53ef\u7528\u3002", (String)"CommonParamFromStyleSetPlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (!this.validatenumber(map, "scale", 10, "precision", 23, (max, min) -> {
            if (max - min < 2) {
                return false;
            }
            return true;
        })) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6574\u4f53\u7cbe\u5ea6\u548c\u5c0f\u6570\u7cbe\u5ea6\u4e0d\u7b26\u5408\u8981\u6c42", (String)"CommonParamFromStyleSetPlugin_9", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("tipsAction".equals(e.getActionId()) && e.getReturnData() != null) {
            Map returnData = (Map)e.getReturnData();
            String s = PsControlFieldUtils.toJsonString(returnData.get("value"));
            this.getView().getModel().setValue("controltips", (Object)s);
        }
    }
}

