/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.param.edit;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.paramsetting.enums.PsDataTypeEnum;
import kd.epm.epbs.business.paramsetting.enums.PsFormTypeEnum;
import kd.epm.epbs.business.paramsetting.model.ParamSetControl;
import kd.epm.epbs.business.paramsetting.model.ParamSetFormModel;
import kd.epm.epbs.business.paramsetting.model.ParamSettingModel;
import kd.epm.epbs.business.paramsetting.util.ParamSettingUtils;
import kd.epm.epbs.business.paramsetting.util.PsControlFieldUtils;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.util.EpbsOperationResult;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.formplugin.param.edit.ParamSetEditPage;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CommonParamSetAddPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Pattern PATTERN = Pattern.compile("epbs_param_set_.*tpl.*");

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (ParamSettingUtils.isDevModel()) {
            this.getView().getModel().setValue("issys", (Object)"1");
        }
        ParamSettingModel paramSettingModel = this.getParamSettingModel();
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT) {
            this.getModel().setValue("isolate", (Object)(paramSettingModel.isIsolate() ? "1" : "0"));
            this.getModel().setValue("issys", (Object)paramSettingModel.isSys());
            this.getModel().setValue("type", (Object)paramSettingModel.getType().getIndex());
            this.getModel().setValue("formtype", (Object)paramSettingModel.getFormType());
            ParamSetFormModel formModel = paramSettingModel.getFormModel();
            this.getModel().setValue("formid", (Object)formModel.getFormId());
            this.getModel().setValue("formplugin", (Object)formModel.getFormPlugin());
            if (PsFormTypeEnum.COMMON.getIndex() == paramSettingModel.getFormType()) {
                for (ParamSetControl con : formModel.getControls()) {
                    this.setControlRowValue(this.getModel().createNewEntryRow("entryentity"), con);
                }
            }
            this.lockControl();
        }
        if (!CollectionUtils.isEmpty((Collection)paramSettingModel.getNodes())) {
            this.getModel().setValue("category", (Object)paramSettingModel.getNodes().toArray());
        }
        this.setControlTypeComboxVisable();
        if (!ParamSettingUtils.isDevModel()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"issys"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"formplugin"});
        }
    }

    private ParamSettingModel getParamSettingModel() {
        if (this.getView().getFormShowParameter().getCustomParam("epbs_paramsetting_model") == null) {
            return new ParamSettingModel();
        }
        return (ParamSettingModel)ObjectSerialUtil.deSerializedBytes((String)((String)this.getView().getFormShowParameter().getCustomParam("epbs_paramsetting_model")));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_view", "btn_close"});
        BasedataEdit category = (BasedataEdit)this.getControl("category");
        if (category != null) {
            category.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public ParamSetFormModel getParamSetFormModel() {
        List collect;
        String formplugin;
        ParamSetFormModel paramSetFormModel = new ParamSetFormModel();
        HashSet<String> numbers = new HashSet<String>(16);
        numbers.addAll(Arrays.asList("number", "name", "desc"));
        for (DynamicObject dy : this.getModel().getEntryEntity("entryentity")) {
            if (StringUtils.isEmpty((String)dy.getString("controltypevalue"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u6570\u636e\u8bf7\u8bbe\u7f6e\u6837\u5f0f\u3002", (String)"CommonParamSetAddPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), dy.getInt("seq")));
            }
            if (numbers.contains(dy.getString("controlnumber"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u6570\u636e\u7f16\u7801\u5df2\u91cd\u590d\u3002", (String)"CommonParamSetAddPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), dy.getInt("seq")));
            }
            numbers.add(dy.getString("controlnumber"));
        }
        String formId = (String)this.getModel().getValue("formid");
        if (StringUtils.isNotEmpty((String)formId)) {
            paramSetFormModel.setFormId(formId);
        }
        if (StringUtils.isNotEmpty((String)(formplugin = (String)this.getModel().getValue("formplugin")))) {
            paramSetFormModel.setFormPlugin(formplugin);
        }
        if (CollectionUtils.isNotEmpty(collect = this.getModel().getEntryEntity("entryentity").stream().map(e -> PsControlFieldUtils.castJson2Control((String)e.getString("controltypevalue"))).collect(Collectors.toList()))) {
            paramSetFormModel.setControls(collect);
        }
        return paramSetFormModel;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_view".equals(key)) {
            DynamicObject dy = this.getModel().getDataEntity();
            ParamSettingModel paramSettingModel = new ParamSettingModel();
            paramSettingModel.setFormType(dy.getInt("formtype"));
            ParamSetFormModel paramSetFormModel = this.getParamSetFormModel();
            paramSettingModel.setFormWithFormModel(paramSetFormModel);
            paramSettingModel.setIsolate(dy.getBoolean("isolate"));
            paramSettingModel.setSys(dy.getBoolean("issys"));
            paramSettingModel.setType(PsDataTypeEnum.getByIndex((int)dy.getInt("type")));
            ParamSettingModel oldParamModel = this.getParamSettingModel();
            paramSettingModel.setId(oldParamModel.getId());
            paramSettingModel.setDesc(oldParamModel.getDesc());
            paramSettingModel.setName(oldParamModel.getName());
            paramSettingModel.setNumber(oldParamModel.getNumber());
            paramSettingModel.setParams(oldParamModel.getParams());
            paramSettingModel.setNodes(dy.getDynamicObjectCollection("category").stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList()));
            if (PsFormTypeEnum.CUSTOM.getIndex() == paramSettingModel.getFormType() && !this.checkFormId(paramSetFormModel.getFormId())) {
                return;
            }
            if (PsFormTypeEnum.COMMON.getIndex() == paramSettingModel.getFormType() && CollectionUtils.isEmpty((Collection)paramSettingModel.getFormModel().getControls())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63a7\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonParamSetAddPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            if (CollectionUtils.isEmpty((Collection)paramSettingModel.getNodes())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u7c7b\u3002", (String)"CommonParamSetAddPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            ParamSetEditPage.createEditPage(paramSettingModel, OperationStatus.ADDNEW).show(this.getView(), new CloseCallBack((IFormPlugin)this, "actionSave"));
        }
    }

    private boolean checkFormId(String formId) {
        if (StringUtils.isEmpty((String)formId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonParamSetAddPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject form = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"inheritpath", (QFilter[])new QFilter("number", "=", (Object)formId).toArray());
        if (form == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5143\u6570\u636e\u4e0d\u5b58\u5728", (String)"CommonParamSetAddPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]), formId));
            return false;
        }
        String inheritpath = form.getString("inheritpath");
        String[] inheritpaths = inheritpath.split(",");
        DynamicObjectCollection parentForms = QueryServiceHelper.query((String)"bos_formmeta", (String)"number", (QFilter[])new QFilter("id", "in", (Object)inheritpaths).toArray());
        boolean inheritStandardForm = parentForms.stream().anyMatch(f -> PATTERN.matcher(f.getString("number")).find());
        if (!inheritStandardForm) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u7f16\u7801\u3010%s\u3011\u65e0\u6548\uff0c\u9700\u7ee7\u627f\u53c2\u6570\u6a21\u677f\u3002", (String)"CommonParamSetAddPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]), formId));
        }
        return inheritStandardForm;
    }

    private void openStyleSettingPage(String actionId, Consumer<FormShowParameter> consumer) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("ebps_control_paramset");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.setCustomParam("formtype", this.getModel().getValue("formtype"));
        if (consumer != null) {
            consumer.accept((Object)formShowParameter);
        } else {
            ParamSetControl paramSetControl = new ParamSetControl(Integer.parseInt(this.getModel().getValue("controltype").toString()));
            formShowParameter.setCustomParam("controlset", (Object)PsControlFieldUtils.toJsonString((Object)paramSetControl));
            formShowParameter.setCustomParam("fromsource", (Object)"0");
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(formShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("controlstylereset")) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            String controltype = (String)this.getView().getModel().getValue("controltype", selectRows[0]);
            this.openStyleSettingPage(args.getOperateKey(), (Consumer<FormShowParameter>)((Consumer)e -> {
                String stylevalue = (String)this.getModel().getValue("controltypevalue", selectRows[0]);
                if (StringUtils.isNotEmpty((String)stylevalue)) {
                    e.setStatus(OperationStatus.EDIT);
                } else {
                    ParamSetControl paramSetControl = new ParamSetControl();
                    paramSetControl.setType(Integer.parseInt(controltype));
                    stylevalue = PsControlFieldUtils.toJsonString((Object)paramSetControl);
                    e.setStatus(OperationStatus.ADDNEW);
                }
                e.setCustomParam("controlset", (Object)stylevalue);
                e.setCustomParam("fromsource", (Object)"1");
            }));
        } else if ("deleteentry".equals(args.getOperateKey())) {
            this.lockControl();
        } else if ("newentry".equals(args.getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            PsDataTypeEnum type = PsDataTypeEnum.getByIndex((int)Integer.parseInt(this.getModel().getValue("type").toString()));
            String controlType = (String)type.getControlRange().stream().min((o1, o2) -> o1.length() < o2.length() || o1.compareTo((String)o2) <= 0 ? -1 : 1).get();
            this.getView().getModel().setValue("controltype", (Object)controlType, selectRows[0]);
            this.lockControl();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (("actionStyleSet".equals(e.getActionId()) || "entryentitycolset".equals(e.getActionId()) || "controlstylereset".equals(e.getActionId())) && e.getReturnData() != null && e.getReturnData() instanceof Pair) {
            Pair returnData = (Pair)e.getReturnData();
            this.actionStyleSet((String)returnData.getKey(), (ParamSetControl)returnData.getValue());
        } else if ("actionSave".equals(e.getActionId()) && e.getReturnData() != null && ((EpbsOperationResult)e.getReturnData()).isSuccess()) {
            this.getView().returnDataToParent(e.getReturnData());
            this.getView().close();
        }
    }

    private void actionStyleSet(String fromsource, ParamSetControl res) {
        if ("2".equals(fromsource) || res == null) {
            return;
        }
        int row = -1;
        if ("0".equals(fromsource) && res != null) {
            row = this.getModel().createNewEntryRow("entryentity");
        } else if ("1".equals(fromsource) && res != null) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            row = entryGrid.getSelectRows()[0];
        }
        this.setControlRowValue(row, res);
    }

    private void setControlRowValue(int row, ParamSetControl res) {
        if (row > -1) {
            this.getModel().setValue("controltype", (Object)res.getType(), row);
            this.getModel().setValue("controlnumber", (Object)res.getNumberWithDefault(), row);
            this.getModel().setValue("controlname", (Object)res.getNameWithDefault(), row);
            this.getModel().setValue("controltypevalue", (Object)PsControlFieldUtils.toJsonString((Object)res), row);
        }
    }

    private void lockControl() {
        DynamicObject dy = this.getModel().getDataEntity();
        this.getView().setEnable(Boolean.valueOf(dy.getDynamicObjectCollection("entryentity").isEmpty()), new String[]{"type", "formtype"});
        if (dy.getInt("type") != PsDataTypeEnum.JSON.getIndex()) {
            this.getView().setEnable(Boolean.valueOf(dy.getDynamicObjectCollection("entryentity").isEmpty()), new String[]{"btn_add"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("formtype".equals(key) || "type".equals(key)) {
            this.setControlTypeComboxVisable();
        }
    }

    private void setControlTypeComboxVisable() {
        DynamicObject dy = this.getModel().getDataEntity();
        int formtype = dy.getInt("formtype");
        if (PsFormTypeEnum.COMMON.getIndex() == formtype) {
            PsDataTypeEnum type = PsDataTypeEnum.getByIndex((int)dy.getInt("type"));
            ComboEdit ce = (ComboEdit)this.getControl("controltype");
            ComboProp ctProp = (ComboProp)this.getModel().getProperty("controltype");
            List comboItems = ctProp.getComboItems();
            Set controlRange = type.getControlRange();
            List collect = comboItems.stream().map(a -> {
                ComboItem c = new ComboItem(a.getName(), a.getValue());
                c.setItemVisible(controlRange.contains(a.getValue()));
                return c;
            }).collect(Collectors.toList());
            ce.setComboItems(collect);
        } else if (PsFormTypeEnum.DEFAULT.getIndex() == formtype) {
            this.getModel().setValue("type", (Object)(PsDataTypeEnum.BOOL.getIndex() + ""));
        } else {
            this.getModel().setValue("type", (Object)(PsDataTypeEnum.JSON.getIndex() + ""));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (key.equals("category")) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setF7ClickByFilter(false);
            QFilter qFilter = new QFilter("parent", "!=", (Object)0L);
            String appId = (String)this.getView().getFormShowParameter().getCustomParam("fromAppId");
            List appIds = AppTypeEnum.getApps((String)appId).stream().map(e -> e.getAppNum()).collect(Collectors.toList());
            qFilter.and("appnum", "in", appIds);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }
}

