/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.param.edit;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FieldTip;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.epbs.business.paramsetting.ParamSetSaveOp;
import kd.epm.epbs.business.paramsetting.model.ParamSettingModel;
import kd.epm.epbs.business.paramsetting.model.PsResultModel;
import kd.epm.epbs.business.paramsetting.util.ParamSettingUtils;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.util.EpbsOperationResult;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ParamSetEditOperation
extends AbstractFormPlugin {
    protected static final String BTN_OK = "btnok";
    protected static final List<String> DefaultIgnoreProperties = Lists.newArrayList((Object[])new String[]{"number", "name", "desc", "multilanguagetext", "model"});
    private ParamSettingModel paramSettingModel;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setParamSettingModel();
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (BTN_OK.equals(((Control)evt.getSource()).getKey())) {
            if (this.getParamSettingModel().getType() == null) {
                return;
            }
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW || this.validateBeforeSave()) {
                this.actionSaveParam(this.getCustomParams());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.getModel().setDataChanged(true);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getModel().getDataChanged()) {
            HashMap<Integer, String> btnNames = new HashMap<Integer, String>(2);
            btnNames.put(2, OperationTypeEnum.BACK_EDIT.getNameString());
            btnNames.put(6, OperationTypeEnum.EXIT.getNameString());
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ParamSetEditOperation_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("treeClick_confirm", (IFormPlugin)this), btnNames);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String confirmId = messageBoxClosedEvent.getCallBackId();
        if ("treeClick_confirm".equals(confirmId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private void setParamSettingModel() {
        ParamSettingModel paramSettingModel = this.getParamSettingModel();
        if (paramSettingModel != null) {
            this.getModel().setValue("name", (Object)paramSettingModel.getName());
            this.getModel().setValue("number", (Object)paramSettingModel.getNumber());
            this.getModel().setValue("desc", (Object)paramSettingModel.getDesc());
            if (this.getControl("model") != null) {
                this.getModel().setValue("model", (Object)paramSettingModel.getModelId());
            }
            this.setParams();
        }
    }

    protected void setParams() {
        Object params = this.getParamSettingModel().getParamsWithDateType();
        if (this.paramSettingModel.getType() == null) {
            return;
        }
        if (this.paramSettingModel.getType().isSingleParam()) {
            this.getModel().setValue("params", params);
        } else {
            List<String> ignoreProperties = this.getIgnoreProperties();
            for (IDataEntityProperty property : this.getModel().getDataEntityType().getProperties()) {
                if (ignoreProperties.contains(property.getName())) continue;
                this.setParamByJson((JSONObject)params, property);
            }
        }
    }

    public final ParamSettingModel getParamSettingModel() {
        String paramsettingModel;
        if (this.paramSettingModel == null && (paramsettingModel = (String)this.getView().getFormShowParameter().getCustomParam("epbs_paramsetting_model")) != null) {
            this.paramSettingModel = (ParamSettingModel)ObjectSerialUtil.deSerializedBytes((String)paramsettingModel);
        }
        if (this.paramSettingModel == null) {
            this.paramSettingModel = new ParamSettingModel();
        }
        return this.paramSettingModel;
    }

    public void beforeActionSaveParam() {
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
            ParamSettingModel paramSettingModel = this.getParamSettingModel();
            paramSettingModel.setNumber(this.getModel().getValue("number").toString());
            paramSettingModel.setName((ILocaleString)this.getModel().getValue("name"));
            paramSettingModel.setDesc((ILocaleString)this.getModel().getValue("desc"));
        }
    }

    public void actionSaveParam(PsResultModel res) {
        this.beforeActionSaveParam();
        ParamSettingModel paramSettingModel = this.getParamSettingModel();
        paramSettingModel.setParamsWithDateType(res.getParams());
        paramSettingModel.setShow(res.isShow());
        EpbsOperationResult save = new ParamSetSaveOp(OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus(), paramSettingModel, res.getOperationLogs()).save();
        if (save.isSuccess()) {
            this.afterSave();
            this.getView().returnDataToParent((Object)new EpbsOperationResult());
            this.getModel().setDataChanged(false);
            this.getView().close();
        } else {
            this.getView().showTipNotification(save.getMsg());
        }
    }

    protected List<String> getIgnoreProperties() {
        return DefaultIgnoreProperties;
    }

    protected void setParamByJson(JSONObject jsonObj, IDataEntityProperty property) {
        String name = property.getName();
        if (null == jsonObj || null == this.getControl(name)) {
            return;
        }
        Object[] value = jsonObj.get((Object)name);
        if (!(property instanceof EntryProp) && null != value) {
            if (property instanceof DateTimeProp) {
                value = new Date((Long)value);
            } else if (property instanceof MulBasedataProp) {
                value = ((JSONArray)value).toArray();
            }
            this.getModel().setValue(name.toLowerCase(Locale.ROOT), (Object)value);
        }
    }

    protected PsResultModel getCustomParams() {
        if (this.getParamSettingModel().getType().isSingleParam()) {
            IDataEntityProperty property = this.getModel().getProperty("params");
            String s = ParamSettingUtils.formatPropString((Object)this.getModel().getValue("params"), (IDataEntityProperty)property);
            String displayName = property.getDisplayName() == null ? property.getName() : property.getDisplayName().getLocaleValue();
            return new PsResultModel(this.getModel().getValue("params"), ParamSettingUtils.isShow((IDataEntityProperty)property), Collections.singletonList(displayName + ":" + s));
        }
        List<String> ignoreProperties = this.getIgnoreProperties();
        HashMap customParams = Maps.newHashMap();
        StringJoiner opLogs = new StringJoiner(";");
        DataEntityPropertyCollection propertyCollection = this.getModel().getDataEntity().getDynamicObjectType().getProperties();
        Set baseIdProps = propertyCollection.stream().filter(e -> e instanceof BasedataProp).map(e -> e.getName() + "_id").collect(Collectors.toSet());
        for (IDataEntityProperty property : propertyCollection) {
            String key;
            String propName = property.getName();
            if (ignoreProperties.contains(propName) || baseIdProps.contains(propName)) continue;
            Object propValue = this.getModel().getValue(propName);
            if (property instanceof BasedataProp) {
                DynamicObject dyn = (DynamicObject)propValue;
                customParams.put(propName, null != dyn ? dyn.getPkValue() : Long.valueOf(0L));
            } else if (property instanceof MulBasedataProp) {
                MulBasedataDynamicObjectCollection list = (MulBasedataDynamicObjectCollection)propValue;
                customParams.put(propName, list.stream().map(e -> e.get("fbasedataid_id")).collect(Collectors.toList()));
            } else if (!(property instanceof EntryProp)) {
                customParams.put(propName, propValue);
            }
            String showParam = ParamSettingUtils.formatPropString((Object)propValue, (IDataEntityProperty)property, (IClientViewProxy)((IClientViewProxy)this.getView().getService(IClientViewProxy.class)));
            String string = key = property.getDisplayName() == null ? propName : property.getDisplayName().getLocaleValue();
            if (propertyCollection.size() - baseIdProps.size() == 5) {
                opLogs.add(showParam);
                continue;
            }
            opLogs.add(key + ":" + showParam);
        }
        return new PsResultModel((Object)customParams, Collections.singletonList(opLogs.toString()));
    }

    protected boolean validateBeforeSave() {
        return this.validateMustInput();
    }

    protected boolean validateMustInput() {
        return this.validateMustInput(this.getMustInputKey());
    }

    public final List<FieldTip> getMustInputKey() {
        ArrayList keys = Lists.newArrayList();
        DataEntityPropertyCollection props = this.getModel().getDataEntity().getDataEntityType().getProperties();
        props.forEach(e -> {
            FieldTip fieldTip = this.getMustInputKey((IDataEntityProperty)e);
            if (null != fieldTip) {
                keys.add(this.getMustInputKey((IDataEntityProperty)e));
            }
        });
        return keys;
    }

    public final FieldTip getMustInputKey(String propName) {
        DataEntityPropertyCollection props = this.getModel().getDataEntity().getDataEntityType().getProperties();
        IDataEntityProperty prop = props.stream().filter(e -> Objects.equals(propName, e.getName())).findFirst().orElseGet(() -> null);
        return null != prop ? this.getMustInputKey(prop) : null;
    }

    private FieldTip getMustInputKey(IDataEntityProperty prop) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FieldTip mustInputKey = null;
        if (!(prop instanceof BooleanProp)) {
            String propName = prop.getName();
            boolean isPropNull = StringUtils.isBlank((Object)dataEntity.get(propName));
            if (prop instanceof FieldProp) {
                if (((FieldProp)prop).isMustInput() && isPropNull) {
                    mustInputKey = this.buildNullFieldTip(propName);
                }
            } else if (prop instanceof BasedataProp) {
                if (((BasedataProp)prop).isMustInput() && isPropNull) {
                    mustInputKey = this.buildNullFieldTip(propName);
                }
            } else if (prop instanceof MulBasedataProp && ((MulBasedataProp)prop).isMustInput() && CollectionUtils.isEmpty((Collection)((ArrayList)dataEntity.get(propName)))) {
                mustInputKey = this.buildNullFieldTip(propName);
            }
        }
        return mustInputKey;
    }

    private FieldTip buildNullFieldTip(String propName) {
        return new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.notNull, propName, new LocaleString(ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"ParamSetEditOperation_2", (String)"epm-epbs-formplugin", (Object[])new Object[0])).getLocaleValue());
    }

    protected boolean validateMustInput(List<FieldTip> fieldKeys) {
        DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDataEntityType().getProperties();
        if (fieldKeys.size() != 0) {
            StringBuilder errorDesc = new StringBuilder().append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199", (String)"ParamSetEditOperation_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            for (FieldTip fieldKey : fieldKeys) {
                String paramKey = fieldKey.getFieldKey();
                String paramName = ((IDataEntityProperty)properties.get((Object)paramKey)).getDisplayName().getLocaleValue();
                errorDesc.append("\u201c").append(paramName).append("\u201d,");
            }
            errorDesc.setCharAt(errorDesc.length() - 1, '\u3002');
            this.getView().showTipNotification(errorDesc.toString());
            return false;
        }
        return true;
    }

    protected void afterSave() {
    }

    public final long getModelId() {
        return this.getParamSettingModel().getModelId();
    }
}

