/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.param.edit;

import java.util.Collection;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.business.paramsetting.enums.PsFormTypeEnum;
import kd.epm.epbs.business.paramsetting.model.ParamSetFormModel;
import kd.epm.epbs.business.paramsetting.model.ParamSettingModel;
import kd.epm.epbs.business.paramsetting.util.ParamSettingUtils;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ParamSetEditPage {
    public static final String PARAM_SETTING = "epbs_paramsetting_model";
    private ParamSettingModel paramSettingModel;
    private OperationStatus status;
    private boolean isQuery;

    private ParamSetEditPage(ParamSettingModel paramSettingModel, OperationStatus status) {
        this.paramSettingModel = paramSettingModel;
        this.status = status;
    }

    private void initData(boolean isDesign) {
        if (this.paramSettingModel.getId() == 0L || !this.isQuery) {
            return;
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)this.paramSettingModel.getId(), (String)"epbs_preset_param");
        if (dy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u53ef\u7528\u7684\u8bb0\u5f55\u3002", (String)"ParamSetEditPage_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        long modelId = this.paramSettingModel.getModelId();
        this.paramSettingModel = ParamSettingModel.createInstance((DynamicObject)dy, (long)(isDesign ? 0L : modelId));
    }

    public static ParamSetEditPage createEditPage(Long id, Long modelId) {
        ParamSettingModel paramSettingModel = new ParamSettingModel();
        paramSettingModel.setId(id.longValue());
        paramSettingModel.setModelId(modelId.longValue());
        ParamSetEditPage page = new ParamSetEditPage(paramSettingModel, OperationStatus.EDIT);
        page.isQuery = true;
        return page;
    }

    public static ParamSetEditPage createEditPage(ParamSettingModel model, OperationStatus status) {
        return new ParamSetEditPage(model, status);
    }

    public void show(IFormView formView, CloseCallBack closeCallBack) {
        this.initData(false);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(this.status);
        formShowParameter.setFormId(this.paramSettingModel.getFormId());
        String caption = ResManager.loadKDString((String)"\u53c2\u6570", (String)"ParamSetEditPage_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
        if (this.status == OperationStatus.EDIT && this.paramSettingModel.isIsolate()) {
            caption = caption + "-" + ModelCacheHelper.getModel((long)this.paramSettingModel.getModelId()).getNameString();
        }
        formShowParameter.setCaption(caption);
        if (StringUtils.isNotEmpty((CharSequence)this.paramSettingModel.getForm()) && PsFormTypeEnum.CUSTOM.getIndex() != this.paramSettingModel.getFormType()) {
            ParamSetFormModel form = this.paramSettingModel.getFormModel();
            if (PsFormTypeEnum.COMMON.getIndex() == this.paramSettingModel.getFormType()) {
                StyleCss css = new StyleCss();
                if (CollectionUtils.isNotEmpty((Collection)form.getControls())) {
                    int heigth = 400 + 50 * (form.getControls().size() / 2);
                    css.setHeight((heigth > 700 ? 700 : heigth) + "px");
                    formShowParameter.getOpenStyle().setInlineStyleCss(css);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)form.getFormPlugin())) {
                formShowParameter.addCustPlugin(form.getFormPlugin());
            }
        }
        formShowParameter.setCustomParam(PARAM_SETTING, (Object)ObjectSerialUtil.toByteSerialized((Object)this.paramSettingModel));
        formShowParameter.setCloseCallBack(closeCallBack);
        formView.showForm(formShowParameter);
    }

    public void showDesign(IFormView formView, CloseCallBack closeCallBack) {
        this.initData(true);
        if (!ParamSettingUtils.isDevModel() && this.paramSettingModel.getId() > 0L && this.paramSettingModel.isSys()) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u53c2\u6570\u4e0d\u53ef\u4ee5\u7f16\u8f91\u3002", (String)"ParamSetEditPage_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        if (this.paramSettingModel.getId() > 0L) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91\u53c2\u6570\u8bbe\u7f6e", (String)"ParamSetEditPage_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setParentPageId(formView.getPageId());
        formShowParameter.setStatus(this.status);
        formShowParameter.setFormId("ebps_param_set_dev");
        formShowParameter.setCustomParam("fromAppId", (Object)formView.getFormShowParameter().getAppId());
        formShowParameter.setCustomParam(PARAM_SETTING, (Object)ObjectSerialUtil.toByteSerialized((Object)this.paramSettingModel));
        formShowParameter.setCloseCallBack(closeCallBack);
        formView.showForm(formShowParameter);
    }
}

