/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.admin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.util.IDUtils;

public class CreaterTransUserSelectPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String TARUSER = "taruser";
    private static final String BTN_SURE = "sure";
    private static final Log log = LogFactory.getLog(CreaterTransUserSelectPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(TARUSER);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{BTN_SURE});
    }

    public void afterCreateNewData(EventObject e) {
        Label labelap = (Label)this.getControl("labelap");
        String createrStr = (String)this.getView().getFormShowParameter().getCustomParam("creator");
        if (StringUtils.isNotEmpty((CharSequence)createrStr)) {
            DynamicObject creater = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)createrStr);
            String userName = creater.getString("name");
            labelap.setText(ResManager.loadResFormat((String)"%1\u4e3a\u4f53\u7cfb\u521b\u5efa\u4eba ,\u5c06\u8be5\u4f53\u7cfb\u521b\u5efa\u4eba\u6743\u9650\u8f6c\u79fb\u81f3:", (String)"CreaterTransUserSelectPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[]{userName}));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (TARUSER.equals(name)) {
            String idsStr = (String)this.getView().getFormShowParameter().getCustomParam("ids");
            QFilter qf = new QFilter("id", "in", Arrays.stream(idsStr.split(",")).map(IDUtils::toLong).collect(Collectors.toList()));
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            param.getListFilterParameter().setFilter(qf);
            param.setHasRight(true);
            param.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals(BTN_SURE)) {
            DynamicObject dynamicObject;
            String createrStr = (String)this.getView().getFormShowParameter().getCustomParam("creator");
            String userName = "";
            if (StringUtils.isNotEmpty((CharSequence)createrStr)) {
                DynamicObject creater = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)createrStr);
                userName = creater.getString("name");
            }
            if ((dynamicObject = (DynamicObject)this.getModel().getValue(TARUSER)) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u8f6c\u79fb\u6743\u9650\u7684\u76ee\u6807\u7528\u6237\u3002", (String)"CreaterTransUserSelectPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            String tarName = dynamicObject.getString("name");
            this.getView().showConfirm(ResManager.loadResFormat((String)"\u662f\u5426\u5c06\u4f53\u7cfb:%1$s \u7684\u521b\u5efa\u4eba\u6743\u9650\u7531\uff1a%2$s \u8f6c\u4ea4\u7ed9\uff1a%3$s\uff1f", (String)"CreaterTransUserSelectPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[]{ModelCacheHelper.getModelName((long)((Long)this.getView().getFormShowParameter().getCustomParam("modelId"))), userName, tarName}), MessageBoxOptions.YesNo, new ConfirmCallBackListener("transfer", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("transfer".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            DynamicObject users = (DynamicObject)this.getModel().getValue(TARUSER);
            this.getView().returnDataToParent((Object)users.getLong("id"));
            this.getView().close();
        }
    }

    public Long getModelId() {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
        if (StringUtils.isNotEmpty((CharSequence)modelId)) {
            return Long.valueOf(modelId);
        }
        return 0L;
    }
}

