/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.admin;

import java.util.Collection;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.epm.epbs.business.bd.model.ModelF7ParamContext;
import kd.epm.epbs.business.bd.model.ModelListHelper;
import kd.epm.epbs.business.permission.model.ModelPermHelper;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.AppTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class ModelAdminAssignHelper {
    public static void openPage(IFormView formView, long modelId, CloseCallBack closeCallBack) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setParentPageId(formView.getPageId());
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u7ba1\u7406 - %s", (String)"ModelAdminAssignHelper_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), ModelCacheHelper.getModelName((long)modelId)));
        formShowParameter.setFormId("epbs_modeladmin_assign");
        formShowParameter.setCustomParam("modelId", (Object)modelId);
        formShowParameter.setCloseCallBack(closeCallBack);
        formView.showForm(formShowParameter);
    }

    public static boolean validateModelAdmin(PreOpenFormEventArgs e) {
        boolean isModelAdmin = false;
        try {
            FormShowParameter formShowParameter = e.getFormShowParameter();
            String appId = formShowParameter.getAppId();
            if (AppTypeEnum.isCMApp((String)appId) || AppTypeEnum.isEbApp((String)appId)) {
                ModelF7ParamContext ctx = ModelListHelper.createTempModelF7Ctx((FormShowParameter)e.getFormShowParameter());
                isModelAdmin = CollectionUtils.isNotEmpty((Collection)ctx.getLimitedModelIds());
            } else {
                AppTypeEnum[] apps = (AppTypeEnum[])AppTypeEnum.getApps((String)appId).stream().toArray(AppTypeEnum[]::new);
                if (AppTypeEnum.RPT.getAppNum().equals(appId)) {
                    apps = new AppTypeEnum[]{AppTypeEnum.RPT};
                }
                boolean bl = isModelAdmin = !ModelPermHelper.getLimitedModelListByUser((AppTypeEnum[])apps).isEmpty();
            }
            if (!isModelAdmin) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u4f53\u7cfb\u7ba1\u7406\u5458\u6743\u9650\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ModelAdminAssignHelper_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
        }
        catch (KDBizException ex) {
            e.setCancel(true);
            e.setCancelMessage(ex.getMessage());
        }
        return isModelAdmin;
    }
}

