/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.bd.model.UserDistributeServiceHelper;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epbs.formplugin.permission.admin.ModelAdminAssignHelper;
import org.apache.commons.collections.CollectionUtils;

public class ModelManagerPlugin
extends AbstractBaseListPlugin
implements CreateListDataProviderListener {
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        billList.addSetFilterListener(this::setFilter);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ArrayList<QFilter> list = new ArrayList<QFilter>(16);
        Collection modelIds = this.querModelAdmin(UserDistributeServiceHelper.queryGroupIdsWithUser2UserId());
        for (QFilter qFilter : e.getQFilters()) {
            for (QFilter qf : qFilter.recombine()) {
                if (qf.getProperty().equals("number")) {
                    modelIds = CollectionUtils.retainAll(modelIds, this.queryModelAdminByUserAndUserGroupByName(new QFilter("name", qf.getCP(), qf.getValue()).toArray()));
                    continue;
                }
                list.add(qf);
            }
        }
        list.add(new QFilter("id", "in", modelIds));
        e.getQFilters().clear();
        e.getQFilters().addAll(list);
    }

    private Collection<Long> queryModelAdminByUserAndUserGroupByName(QFilter[] qfs) {
        List bosUserIds = QueryServiceHelper.queryPrimaryKeys((String)"bos_user", (QFilter[])qfs, null, (int)-1);
        List userGroupIds = QueryServiceHelper.queryPrimaryKeys((String)"bos_usergroup", (QFilter[])qfs, null, (int)-1);
        ArrayList ar = new ArrayList(bosUserIds.size() + userGroupIds.size());
        ar.addAll(bosUserIds);
        ar.addAll(userGroupIds);
        return this.querModelAdmin(ar);
    }

    private Collection<Long> querModelAdmin(Collection userIds) {
        QFilter qf = new QFilter("user", "in", (Object)userIds);
        return QueryServiceHelper.query((String)"epbs_model_admin", (String)"model_id", (QFilter[])qf.toArray()).stream().map(e -> e.getLong("model_id")).collect(Collectors.toSet());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("distribute".equals(key)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows) || selectedRows.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u7ba1\u7406\u5458\u6307\u5b9a\u3002", (String)"ModelManagerPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            Long modelid = (Long)selectedRows.get(0).getPrimaryKeyValue();
            ModelAdminAssignHelper.openPage(this.getView(), modelid, new CloseCallBack((IFormPlugin)this, "distribute"));
        } else if ("bar_refresh".equals(key)) {
            this.billListRefresh();
        }
    }

    private void billListRefresh() {
        BillList control = (BillList)this.getControl("billlistap");
        control.clearSelection();
        control.refresh();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (actionId.equals("distribute") && e.getReturnData() != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u5b8c\u6210\u3002", (String)"ModelManagerPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        this.billListRefresh();
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.validateModelAdmin(e);
    }

    private void getNames(String entityId, Collection<Long> ids, Map<Long, String> id2Names) {
        QueryServiceHelper.query((String)entityId, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}).forEach(e -> id2Names.put(e.getLong("id"), e.getString("name")));
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dys = super.getData(start, limit);
                if (!dys.isEmpty()) {
                    HashMap model2UserIds = new HashMap(16);
                    List ids = dys.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                    HashSet userids = new HashSet(16);
                    QueryServiceHelper.query((String)"epbs_model_admin", (String)"model_id,usertype,user", (QFilter[])new QFilter[]{new QFilter("model_id", "in", ids)}).forEach(a -> {
                        model2UserIds.computeIfAbsent(a.getLong("model_id"), b -> new ArrayList(10)).add(a.getLong("user"));
                        userids.add(a.getLong("user"));
                    });
                    HashMap id2names = new HashMap(16);
                    ModelManagerPlugin.this.getNames("bos_user", userids, id2names);
                    ModelManagerPlugin.this.getNames("bos_usergroup", userids, id2names);
                    dys = dys.stream().map(e -> {
                        DynamicObject d = new DynamicObject(e.getDynamicObjectType());
                        for (IDataEntityProperty p2 : e.getDynamicObjectType().getProperties()) {
                            d.set(p2.getName(), e.get(p2.getName()));
                        }
                        String names = model2UserIds.getOrDefault(e.getLong("id"), Collections.emptyList()).stream().map(p -> id2names.getOrDefault(p, "")).collect(Collectors.joining(";"));
                        d.set("number", (Object)names);
                        return d;
                    }).collect(Collectors.toCollection(DynamicObjectCollection::new));
                }
                return dys;
            }

            public void setListFields(List<ListField> listFields) {
                BillList billList = (BillList)ModelManagerPlugin.this.getView().getControl("billlistap");
                super.setListFields(listFields);
            }
        });
    }
}

