/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.permission.util.AuthSetUtils;
import kd.epm.epbs.business.permission.util.DataRoleUtils;
import kd.epm.epbs.business.spi.inet.InetPluginProviderService;
import kd.epm.epbs.common.bean.EpbsContext;
import kd.epm.epbs.common.bean.IContext;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.configuration.enums.AppConfigPropEnum;
import kd.epm.epbs.common.configuration.enums.IAppConfigProp;
import kd.epm.epbs.common.configuration.factory.ConfigurationContext;
import kd.epm.epbs.common.page.InteractivePageUtil;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.tree.TreeChangneHelper;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.Pair;
import kd.epm.epbs.formplugin.permission.data.DataRoleLeftTreeListener;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class DataRoleLeftTreePlugin
extends AbstractBasePlugIn
implements DataRoleLeftTreeListener,
InetPluginProviderService<Map<String, Object>, DynamicObjectCollection> {
    public void initialize() {
        super.initialize();
        this.getTreeView().addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_addnew", "btn_edit", "btn_delete", "btn_moveup", "btn_movedown"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "btn_addnew": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("epbs_auth_model");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btn_addnew"));
                this.getView().showForm(formShowParameter);
                break;
            }
            case "btn_delete": {
                this.deleteNode(true);
                break;
            }
            case "btn_moveup": 
            case "btn_movedown": {
                new TreeChangneHelper(this.getTreeView()).addAfterRefreshOp(focusNode -> DataRoleLeftTreePlugin.rightAuthFlexChange(focusNode, this.getPageCache(), this.getView())).move("btn_moveup".equals(control.getKey()));
                break;
            }
        }
    }

    private boolean isRootNode() {
        return DataRoleUtils.getFocusTreeNode((TreeView)this.getTreeView()).getData() == null;
    }

    private void deleteNode(boolean validate) {
        new TreeChangneHelper(this.getTreeView()).addBeforeOp((focusNode, parentNode) -> {
            if (validate && this.hasDataAuth((TreeNode)focusNode)) {
                String entityNumberName = this.getTreeEntityDisplayName();
                String confirmMessage = String.format(ResManager.loadKDString((String)"\u8be5%1$s\u5df2\u7ecf\u6dfb\u52a0\u6570\u636e\u6743\u9650\u8bb0\u5f55\uff0c\u5982\u679c\u5220\u9664%2$s\uff0c\u5c06\u6e05\u9664\u5df2\u6709\u7684\u6570\u636e\u6743\u9650\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DataRoleLeftTreePlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), entityNumberName, entityNumberName);
                this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("btn_delete", (IFormPlugin)this));
                return false;
            }
            return true;
        }).addAftereOp((delNode, parentnode) -> {
            HashMap<String, Object> data = new HashMap<String, Object>();
            EpbsContext context = new EpbsContext("deleteNode", data);
            data.put("isOnlyRoot", CollectionUtils.isEmpty((Collection)AbstractTreeBuilder.getRootWithCache((TreeView)this.getTreeView()).getChildren()));
            data.put("leftTreeBizModelId", parentnode.getId());
            data.put("deleteLeftTreeBizModelId", delNode.getId());
            this.sendMessage(this.getPageCache().get(AppConfigPropEnum.DATA_ROLE_RIGHTAUTH_FORM.getKey()), (IContext)context);
            String pageId = this.getPageCache().get("pageIdList");
            IFormView view = this.getView().getViewNoPlugin(pageId);
            view.close();
            this.getView().sendFormAction(view);
            this.getPageCache().remove(AppConfigPropEnum.DATA_ROLE_RIGHTAUTH_FORM.getKey());
            this.getView().getPageCache().put("DATA_CHANGED", "1");
            return parentnode;
        }).delete();
    }

    private static void rightAuthFlexChange(TreeNode focusTreeNode, IPageCache pageCache, IFormView view) {
        Object data = focusTreeNode.getData();
        pageCache.put("focusNodeData", data == null ? "" : data.toString());
        view.setVisible(Boolean.valueOf(data != null), new String[]{"flexpanelap5", "flexpanelap8"});
        pageCache.put("focusNodeId", focusTreeNode.getId());
    }

    private void openEditPage() {
        FormShowParameter editFormShowParameter = new FormShowParameter();
        editFormShowParameter.setFormId("epbs_auth_model");
        editFormShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        editFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btn_edit"));
        if (this.isModelNode()) {
            editFormShowParameter.setCustomParam("modelId", (Object)this.getTreeView().getTreeState().getFocusNodeId());
        } else {
            Map focusNode = this.getTreeView().getTreeState().getFocusNode();
            editFormShowParameter.setCustomParam("modelId", focusNode.get("parentid"));
            editFormShowParameter.setCustomParam("businessModelId", focusNode.get("id"));
        }
        this.getView().showForm(editFormShowParameter);
    }

    private boolean isModelNode() {
        TreeNode focusNode = DataRoleUtils.getFocusTreeNode((TreeView)this.getTreeView());
        return "epbs_model".equals(focusNode.getData());
    }

    private String getTreeEntityDisplayName() {
        TreeNode focusNode = DataRoleUtils.getFocusTreeNode((TreeView)this.getTreeView());
        if (!"0".equals(focusNode.getId())) {
            String entityNumber = (String)DataRoleUtils.genTreeNodeData((TreeNode)focusNode).p2;
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            return dataEntityType.getDisplayName().getLocaleValue();
        }
        return "NULL";
    }

    private boolean hasDataAuth(TreeNode node) {
        ArrayList permTreeIds = new ArrayList(10);
        if (node.getData() != null) {
            node.iterate(10, e -> {
                if (node.getData() != null) {
                    permTreeIds.add(IDUtils.toLong((Object)DataRoleUtils.genTreeNodeData((TreeNode)e).p1));
                }
            });
        }
        return QueryServiceHelper.exists((String)"epbs_dataperm_assign", (QFilter[])new QFilter("permtree", "in", permTreeIds).toArray());
    }

    @Override
    public TreeView getTreeView() {
        return (TreeView)this.getView().getControl("treeviewap");
    }

    @Override
    public String getRootId() {
        return "0";
    }

    @Override
    public QFilter[] filters() {
        return new QFilter("role", "=", (Object)this.getRoleId()).toArray();
    }

    private long getRoleId() {
        long roleId;
        long l = roleId = this.getView().getFormShowParameter().getCustomParam("roleId") == null ? 0L : (Long)this.getView().getFormShowParameter().getCustomParam("roleId");
        if (roleId == 0L) {
            return IDUtils.toLong((Object)this.getView().getPageCache().get("roleId"));
        }
        return roleId;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        if ("0".equals(nodeId)) {
            evt.setCancel(true);
            return;
        }
        this.treeNodeClick(nodeId);
    }

    private void treeNodeClick(String nodeId) {
        TreeNode focusTreeNode = DataRoleUtils.getFocusTreeNode((TreeView)this.getTreeView());
        Pair pair = DataRoleUtils.genTreeNodeData((TreeNode)focusTreeNode);
        Long bizModelId = IDUtils.toLong((Object)nodeId);
        String entityNumber = (String)pair.p2;
        String appNum = null;
        long modelId = DataRoleUtils.getEpbsModelId((TreeNode)AbstractTreeBuilder.getRootWithCache((TreeView)this.getTreeView()), (TreeNode)focusTreeNode);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("KEY_MODEL_ID", modelId);
        param.put("leftTreeBizModelId", bizModelId);
        param.put("leftTreeEntityNumber", entityNumber);
        if ("epbs_model".equals(entityNumber)) {
            appNum = ModelCacheHelper.getModel((long)NumberUtils.toLong((String)nodeId)).getSrcAppNum();
        } else {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            appNum = dataEntityType.getAppId();
        }
        String formId = ConfigurationContext.INSTANCE.loadProp(appNum, (IAppConfigProp)AppConfigPropEnum.DATA_ROLE_RIGHTAUTH_FORM);
        if (StringUtils.equals((CharSequence)formId, (CharSequence)this.getPageCache().get(AppConfigPropEnum.DATA_ROLE_RIGHTAUTH_FORM.getKey()))) {
            this.sendMessage(formId, (IContext)new EpbsContext("treeNodeClick", param));
        } else {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setCustomParams(param);
            formShowParameter.setFormId(formId);
            formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
            formShowParameter.setCustomParam("leftTreeEntityNumber", (Object)entityNumber);
            formShowParameter.getOpenStyle().setTargetKey("splitpanelap1");
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.setPageId(InteractivePageUtil.getPageIdAndCache((IPageCache)this.getPageCache(), (String)formShowParameter.getFormId()));
            this.getPageCache().put(AppConfigPropEnum.DATA_ROLE_RIGHTAUTH_FORM.getKey(), formShowParameter.getFormId());
            this.getPageCache().put("pageIdList", formShowParameter.getPageId());
            this.getView().showForm(formShowParameter);
        }
        this.getPageCache().put("focusNodeId", nodeId);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initLeftTree();
        DataRoleUtils.createModelTabManagerCache((long)this.getRoleId(), (IPageCache)this.getPageCache());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Cancel.getValue() == result.getValue()) {
            return;
        }
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "btn_edit": {
                this.openEditPage();
                break;
            }
            case "btn_delete": {
                this.deleteNode(false);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (("btn_addnew".equals(actionId) || "btn_edit".equals(actionId)) && closedCallBackEvent.getReturnData() != null) {
            TreeNode resNode = (TreeNode)closedCallBackEvent.getReturnData();
            switch (actionId) {
                case "btn_addnew": {
                    ArrayList addList = new ArrayList(10);
                    new TreeChangneHelper(this.getTreeView()).addAfterRefreshOp(focusNode -> DataRoleLeftTreePlugin.rightAuthFlexChange(focusNode, this.getPageCache(), this.getView())).mergeNode(resNode, null, (insertNode, parentNode) -> {
                        addList.add(insertNode);
                        if (insertNode.getData() != null && insertNode.getData().toString().contains("epbs_model")) {
                            AuthSetUtils.copyDefaultAuthSet2Model((Long)IDUtils.toLong((Object)insertNode.getId()));
                        }
                    });
                    if (addList.isEmpty()) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b0\u589e\u8282\u70b9\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\u3002", (String)"DataRoleLeftTreePlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.getView().getPageCache().put("DATA_CHANGED", "1");
                    break;
                }
            }
        }
    }

    private void removeHistoryData(String originalBusinessModelId, String businessModelId, TreeNode rootWithCache, String originalModelId, String modelId) {
        if (StringUtils.isNotEmpty((CharSequence)originalBusinessModelId) && !originalBusinessModelId.equals(businessModelId)) {
            rootWithCache.deleteChildNode(originalBusinessModelId);
            this.deleteAuthData();
        } else if (StringUtils.isNotEmpty((CharSequence)originalModelId) && !originalModelId.equals(modelId)) {
            rootWithCache.deleteChildNode(originalModelId);
            this.deleteAuthData();
        }
    }

    private void deleteAuthData() {
    }
}

