/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.epm.epbs.business.permission.data.DataPermRoleHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.enums.AuthTypeEnum;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.formplugin.grouptree.BaseTreeWithGroupListPlugin;
import kd.epm.epbs.formplugin.permission.data.f7.DataRoleF7Helper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class DataRoleListPlugin
extends BaseTreeWithGroupListPlugin {
    @Override
    protected String getLeftEntity() {
        return "epbs_dataperm_rolegroup";
    }

    @Override
    protected String getRightEntity() {
        return "epbs_dataperm_role";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addSetFilterListener(this::setFilter);
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.validateModelAdmin(e);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "bar_new": {
                DataPermRoleHelper.openDataPermRoleEdit((AbstractFormPlugin)this, (String)itemKey, null, k -> {
                    k.setCustomParam("group", (Object)this.getGroupId());
                    k.setCustomParam("parent", (Object)this.getRightSelectId());
                });
                break;
            }
            case "bar_assignuser": {
                DataRoleF7Helper.openAssignUserForm(false, itemKey, this.getRightSelectId(), (AbstractFormPlugin)this);
                break;
            }
            case "bar_assignusergrp": {
                DataRoleF7Helper.openAssignUserForm(true, itemKey, this.getRightSelectId(), (AbstractFormPlugin)this);
                break;
            }
            case "bar_copy": {
                Long rightSelectId = this.getRightSelectId();
                if (rightSelectId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u590d\u5236\u7684\u89d2\u8272\u3002", (String)"DataRoleListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long roleId = this.getRightSelectId();
                if (!DataRoleF7Helper.checkRoleUsePerm(roleId, this.getView())) break;
                Long newRoleId = DataPermRoleHelper.copyRole((long)roleId);
                DataPermRoleHelper.openDataPermRoleEdit((AbstractFormPlugin)this, (String)itemKey, null, k -> {
                    k.setCustomParam("roleId", (Object)newRoleId);
                    k.setStatus(OperationStatus.EDIT);
                    k.setCustomParam("isCopy", (Object)"1");
                });
                break;
            }
            default: {
                super.itemClick(evt);
            }
        }
    }

    @Override
    protected void rightEdit(Long editId) {
        DataPermRoleHelper.openDataPermRoleEdit((AbstractFormPlugin)this, (String)"bar_edit", (Long)editId, k -> {
            k.setStatus(OperationStatus.EDIT);
            k.setCustomParam("roleId", (Object)editId);
        });
    }

    @Override
    public void treeNodeClick(TreeNodeEvent evt) {
        this.refreshBillList();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter qFilter = new QFilter("type", "=", (Object)"0");
        Long groupId = this.getGroupId();
        if (groupId != null && groupId > 0L) {
            qFilter.and("group", "=", (Object)groupId);
        }
        e.getQFilters().add(qFilter);
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Long pkValue = NumberUtils.toLong((String)billList.getFocusRowPkId().toString());
        this.checkOperationPerm("tblupdate");
        this.rightEdit(pkValue);
        args.setCancel(true);
    }

    @Override
    protected Long getRightSelectId() {
        BillList billList = (BillList)this.getControl("billlistap");
        if (CollectionUtils.isNotEmpty((Collection)billList.getSelectedRows()) && billList.getFocusRowPkId() != null) {
            return NumberUtils.toLong((String)billList.getFocusRowPkId().toString());
        }
        return 0L;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Optional<AuthTypeEnum> first;
        String actionId = closedCallBackEvent.getActionId();
        if (closedCallBackEvent.getReturnData() != null && (first = Arrays.stream(AuthTypeEnum.values()).filter(e -> actionId.contains(e.name().toLowerCase())).findFirst()).isPresent()) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataRoleListPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), first.get().getDesc().getLocaleString()));
            return;
        }
        if (actionId.equals("bar_new") || actionId.equals("bar_copy") || actionId.equals("bar_edit")) {
            this.refreshBillList();
            return;
        }
        super.closedCallBack(closedCallBackEvent);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("bar_delete".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            DataPermRoleHelper.delete(Collections.singleton(this.getRightSelectId()));
            this.writeLog("epbs_dataperm_role", (IOperationTypeInfo)OperationTypeEnum.DELETE, new Object[]{this.getRightSelectId()});
            this.refreshBillList();
        } else {
            super.confirmCallBack(messageBoxClosedEvent);
        }
    }
}

