/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.permission.data.DataRoleSaveOp;
import kd.epm.epbs.business.spi.inet.InetPluginProviderService;
import kd.epm.epbs.common.configuration.enums.AppConfigPropEnum;
import kd.epm.epbs.common.enums.ModelUserTypeEnum;
import kd.epm.epbs.common.page.InteractivePageUtil;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.util.EpbsOperationResult;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.MutexServiceHelper;
import kd.epm.epbs.common.util.NumberGenHelper;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.formplugin.permission.data.f7.DataRoleF7Helper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class DataRolePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
InetPluginProviderService<Map<String, Object>, DynamicObjectCollection> {
    private static final Log log = LogFactory.getLog(DataRolePlugin.class);
    private static final String ROLE_GROUP = "role_group";
    private static final String PAGE_LOCK = "epbs.pageLock";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit group = (BasedataEdit)this.getControl(ROLE_GROUP);
        group.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_save": {
                this.actionSave(false);
                break;
            }
            case "bar_assignuser": {
                DataRoleF7Helper.openAssignUserForm(false, itemKey, this.getDataRoleId(), this);
                break;
            }
            case "bar_assignusergrp": {
                DataRoleF7Helper.openAssignUserForm(true, itemKey, this.getDataRoleId(), this);
                break;
            }
        }
    }

    protected void printPageLog() {
        Map all = this.getPageCache().getAll();
        log.info("\u6570\u636e\u6743\u9650\u7236\u9875\u9762\u7f13\u5b58pageclass\uff1a" + this.getPageCache().toString());
        all.forEach((k, v) -> {
            if (k.contains("tab_dimension") || k.contains("tab_mange")) {
                log.info("\u6570\u636e\u6743\u9650pageMap\uff1a" + (StringUtils.isEmpty((String)v) ? "[]" : ObjectSerialUtil.toJson((Object)ObjectSerialUtil.deSerializedBytes((String)v))));
            }
        });
    }

    protected boolean actionSave(boolean isExit) {
        String formId = this.getPageCache().get(AppConfigPropEnum.DATA_ROLE_RIGHTAUTH_FORM.getKey());
        this.printPageLog();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)formId) && !this.resetPageCache()) {
            return false;
        }
        this.printPageLog();
        return new DataRoleSaveOp(this.getView()).save(isExit);
    }

    public boolean resetPageCache() {
        boolean flag = true;
        String formId = this.getPageCache().get(AppConfigPropEnum.DATA_ROLE_RIGHTAUTH_FORM.getKey());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)formId)) {
            EpbsOperationResult result = InteractivePageUtil.invokeCustomEvent((IFormView)this.getView(), (String)formId, (String)"save", Arrays.asList("1", "2"));
            flag = result.getData() != null && ((Collection)result.getData()).stream().anyMatch(e -> e);
            this.getPageCache().saveChanges();
            this.getView().addService(IPageCache.class, (Object)new PageCache(this.getView().getPageId()));
        }
        return flag;
    }

    private long getDataRoleId() {
        String roleId = this.getPageCache().get("roleId");
        if (roleId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u89d2\u8272\u3002", (String)"DataRolePlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        return NumberUtils.toLong((String)roleId);
    }

    private TreeView getTreeView() {
        return (TreeView)this.getView().getControl("treeviewap");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        this.initData();
        if (status == OperationStatus.ADDNEW) {
            Object groupId;
            String codeNumber = new NumberGenHelper("epbs_dataperm_role").genCode();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)codeNumber)) {
                this.getModel().setValue("role_number", (Object)codeNumber);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"role_number"});
            }
            if ((groupId = formShowParameter.getCustomParam("group")) != null) {
                this.getModel().setValue(ROLE_GROUP, groupId);
            }
        }
        String authTypeId = (String)this.getView().getFormShowParameter().getCustomParam("authTypeId");
        ModelUserTypeEnum dataRoleType = ModelUserTypeEnum.indexOfVal((String)((String)this.getView().getFormShowParameter().getCustomParam("dataRoleType")));
        if (dataRoleType != null) {
            this.getModel().setValue("type", (Object)dataRoleType.getVal());
            this.getModel().setValue(dataRoleType.name().toLowerCase(Locale.ENGLISH), (Object)authTypeId);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_assignuser", "bar_assignusergrp"});
        }
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT && this.getView().getFormShowParameter().getCustomParam("isCopy") == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"role_number"});
        }
        this.setPageLock();
        this.getModel().setDataChanged(false);
    }

    protected void setPageLock() {
        String type = (String)this.getModel().getValue("type");
        String pkId = null;
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)type, (CharSequence)ModelUserTypeEnum.USER.getVal()) || org.apache.commons.lang3.StringUtils.equals((CharSequence)type, (CharSequence)ModelUserTypeEnum.USERGROUP.getVal())) {
            pkId = (String)this.getView().getFormShowParameter().getCustomParam("authTypeId");
        } else if (this.getView().getFormShowParameter().getCustomParam("roleId") != null) {
            pkId = this.getView().getFormShowParameter().getCustomParam("roleId") + "";
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pkId)) {
            Optional require = MutexServiceHelper.requestMutex((String)pkId, (String)"epbs_dataperm_role", (String)"modify");
            if (require.isPresent()) {
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().showErrorNotification((String)require.get());
            } else {
                this.getView().setStatus(OperationStatus.EDIT);
                this.getPageCache().put(PAGE_LOCK, pkId);
            }
        }
    }

    private void initData() {
        if (this.getView().getFormShowParameter().getCustomParam("roleId") != null) {
            long roleId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("roleId"));
            this.getPageCache().put("roleId", "" + roleId);
            DynamicObject role = QueryServiceHelper.queryOne((String)"epbs_dataperm_role", (String)"number,name,group,description", (QFilter[])new QFilter("id", "=", (Object)roleId).toArray());
            DataEntityPropertyCollection properties = role.getDataEntityType().getProperties();
            properties.forEach(p -> this.getModel().setValue("role_" + p.getName(), p.getValueFast((Object)role)));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((Control)beforeF7SelectEvent.getSource()).getKey();
        if ("group".equals(key)) {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getListFilterParameter().setOrderBy("createtime");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        TreeView treeView = this.getTreeView();
        TreeNode rootWithCache = AbstractTreeBuilder.getRootWithCache((TreeView)treeView);
        if (rootWithCache == null || CollectionUtils.isEmpty((Collection)rootWithCache.getChildren())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u6570\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"DataRolePlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("saveExit".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && !this.actionSave(true)) {
                return;
            }
            this.getPageCache().remove("DATA_CHANGED");
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if ("1".equals(this.getPageCache().get("DATA_CHANGED"))) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5b58\u5728\u53d8\u66f4\uff0c\u662f\u5426\u4fdd\u5b58\u3002", (String)"DataRolePlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("saveExit", (IFormPlugin)this));
            return;
        }
        if (this.getPageCache().get(PAGE_LOCK) != null) {
            MutexServiceHelper.release((String)this.getPageCache().get(PAGE_LOCK), (String)"epbs_dataperm_role", (String)"modify");
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        long roleId;
        Optional<String> optional;
        super.preOpenForm(e);
        if (e.getFormShowParameter().getCustomParam("roleId") != null && (optional = DataRoleF7Helper.checkRoleUseNoPerm(roleId = IDUtils.toLong((Object)e.getFormShowParameter().getCustomParam("roleId")).longValue())).isPresent()) {
            e.setCancel(true);
            e.setCancelMessage(optional.get());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.getView().getPageCache().put("DATA_CHANGED", "1");
    }
}

