/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.OperationTypeInfo;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.UserTypeEnum;
import kd.epm.epbs.common.member.f7.BosListF7Utils;
import kd.epm.epbs.formplugin.AbstractBaseFormPlugin;
import kd.epm.epbs.formplugin.permission.data.f7.DataRoleF7Helper;

public class EpbsDataPermRoleAssUser
extends AbstractBaseFormPlugin
implements BeforeF7SelectListener {
    private static final String BARITEM_ADD = "baritem_add";
    private static final String BARITEM_GP_ADD = "baritem_gp_add";
    private static final String BARITEM_SAVE = "baritem_save";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "toolbar_ass", "toolbar_gp_ass"});
        BasedataEdit datarole = (BasedataEdit)this.getControl("datarole");
        datarole.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter formShowParameter = e.getFormShowParameter();
        Object isGroup = formShowParameter.getCustomParam("isGroup");
        if (isGroup != null && ((Boolean)isGroup).booleanValue()) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u89d2\u8272\u5206\u914d\u7528\u6237\u7ec4", (String)"EpbsDataPermRoleAssUser_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        } else {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u89d2\u8272\u5206\u914d\u7528\u6237", (String)"EpbsDataPermRoleAssUser_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        super.preOpenForm(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean isGroup = this.isGroup();
        this.getView().setVisible(Boolean.valueOf(!isGroup), new String[]{"usrinfo"});
        this.getView().setVisible(Boolean.valueOf(isGroup), new String[]{"usrgrpinfo"});
        Object datarole = this.getView().getFormShowParameter().getCustomParam("datarole");
        if (datarole != null) {
            this.getModel().setValue("datarole", datarole);
        }
        this.initUserList();
    }

    private boolean isGroup() {
        Object isGroup = this.getView().getFormShowParameter().getCustomParam("isGroup");
        return isGroup != null && (Boolean)isGroup != false;
    }

    private void initUserList() {
        String entity = "user_entry";
        String usertype = "user";
        if (this.isGroup()) {
            entity = "user_gp_entry";
            usertype = "usergp";
        }
        this.getModel().deleteEntryData(entity);
        DynamicObject datarole = (DynamicObject)this.getModel().getValue("datarole");
        if (datarole != null) {
            QFilter qFilter = new QFilter("role", "=", (Object)datarole.getLong("id"));
            qFilter.and(new QFilter("usertype", "=", (Object)(usertype.equals("user") ? UserTypeEnum.USER.getEntityNum() : UserTypeEnum.USERGROUP.getEntityNum())));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epbs_dataperm_roleuser", (String)"user", (QFilter[])qFilter.toArray());
            if (!dynamicObjects.isEmpty()) {
                IDataModel dataModel = this.getModel();
                int[] rows = this.getModel().batchCreateNewEntryRow(entity, dynamicObjects.size());
                for (int i = 0; i < dynamicObjects.size(); ++i) {
                    dataModel.setValue(usertype, (Object)((DynamicObject)dynamicObjects.get(i)).getLong("user"), rows[i]);
                }
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("datarole".equals(name)) {
            this.initUserList();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BARITEM_ADD.equals(itemKey)) {
            Set<Long> users = this.getUserData();
            ListShowParameter lsp = EpbsDataPermRoleAssUser.getUserF7ListShowParameter(users);
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeCallBack_add"));
            this.getView().showForm((FormShowParameter)lsp);
        } else if (BARITEM_GP_ADD.equals(itemKey)) {
            Set<Long> users = this.getUserGpData();
            ListShowParameter lsp = BosListF7Utils.createListShowParameter((String)"bos_usergroup", (boolean)true, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "closeCallBack_add"));
            lsp.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", users));
            lsp.setHasRight(true);
            this.getView().showForm((FormShowParameter)lsp);
        } else if (BARITEM_SAVE.equals(itemKey)) {
            DynamicObject datarole = (DynamicObject)this.getModel().getValue("datarole");
            if (datarole == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u89d2\u8272\u3002", (String)"EpbsDataPermRoleAssUser_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            String entity = "user_entry";
            String usertype = "user";
            if (this.isGroup()) {
                entity = "user_gp_entry";
                usertype = "usergp";
            }
            UserTypeEnum userTypeEnum = usertype.equals("user") ? UserTypeEnum.USER : UserTypeEnum.USERGROUP;
            DynamicObjectCollection users = this.getModel().getEntryEntity(entity);
            ArrayList<DynamicObject> saveDatas = new ArrayList<DynamicObject>(users.size());
            for (DynamicObject user : users) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"epbs_dataperm_roleuser");
                dynamicObject.set("role", (Object)datarole);
                dynamicObject.set("user", (Object)user.getDynamicObject(usertype).getLong("id"));
                dynamicObject.set("usertype", (Object)userTypeEnum.getEntityNum());
                saveDatas.add(dynamicObject);
            }
            QFilter qFilter = new QFilter("role", "=", (Object)datarole.getLong("id"));
            qFilter.and(new QFilter("usertype", "=", (Object)userTypeEnum.getEntityNum()));
            DeleteServiceHelper.delete((String)"epbs_dataperm_roleuser", (QFilter[])qFilter.toArray());
            SaveServiceHelper.save((DynamicObject[])saveDatas.toArray(new DynamicObject[0]));
            this.writeLog((IOperationTypeInfo)new OperationTypeInfo(userTypeEnum.getEntityNum(), userTypeEnum.getName()), new MultiLangEnumBridge("\u6570\u636e\u89d2\u8272\u3010%s\u3011\u5206\u914d\u6210\u529f\u3002", "EpbsDataPermRoleAssUser_3", "epm-epbs-formplugin", new Object[]{datarole.getString("number")}));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"EpbsDataPermRoleAssUser_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (!(returnData instanceof ListSelectedRowCollection)) {
            return;
        }
        ListSelectedRowCollection lsrc = (ListSelectedRowCollection)returnData;
        if ("datarolef7".equals(actionId) && CollectionUtils.isNotEmpty((Collection)lsrc)) {
            this.getModel().setValue("datarole", lsrc.get(0).getPrimaryKeyValue());
            return;
        }
        if ("closeCallBack_add".equals(actionId)) {
            List selIdSet = lsrc.stream().map(e -> (Long)e.getPrimaryKeyValue()).collect(Collectors.toList());
            IDataModel dataModel = this.getModel();
            String entity = "user_entry";
            String usertype = "user";
            if (this.isGroup()) {
                entity = "user_gp_entry";
                usertype = "usergp";
            }
            int[] rows = this.getModel().batchCreateNewEntryRow(entity, selIdSet.size());
            for (int i = 0; i < selIdSet.size(); ++i) {
                dataModel.setValue(usertype, selIdSet.get(i), rows[i]);
            }
        }
    }

    public static ListShowParameter getUserF7ListShowParameter(Set<Long> curUserIds) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true, (int)0);
        if (curUserIds == null) {
            curUserIds = new HashSet<Long>(16);
        }
        curUserIds.add(RequestContext.get().getCurrUserId());
        List qFilters = lsp.getListFilterParameter().getQFilters();
        QFilter qFilter = new QFilter("id", "not in", curUserIds).and("usertype", "!=", (Object)"6").and("enable", "=", (Object)"1").and("isforbidden", "=", (Object)"0");
        qFilters.add(qFilter);
        lsp.setListFilterParameter(new ListFilterParameter(qFilters, null));
        if (PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
            lsp.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
        }
        lsp.setCustomParam("externalUserType", (Object)"all");
        return lsp;
    }

    protected Set<Long> getUserData() {
        DynamicObjectCollection datas = this.getModel().getEntryEntity("user_entry");
        return datas.stream().map(e -> (Long)e.get("user_id")).collect(Collectors.toSet());
    }

    protected Set<Long> getUserGpData() {
        DynamicObjectCollection datas = this.getModel().getEntryEntity("user_gp_entry");
        return datas.stream().map(e -> (Long)e.get("usergp_id")).collect(Collectors.toSet());
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beforeF7SelectEvent.getSourceMethod().equals("click")) {
            Object[] objectArray;
            beforeF7SelectEvent.setCancel(true);
            DynamicObject datarole = (DynamicObject)this.getModel().getValue("datarole");
            if (datarole == null) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = datarole.get("id");
            }
            Object[] pkIds = objectArray;
            DataRoleF7Helper.openSelectDataRoleF7Page(this, pkIds, false);
        } else {
            beforeF7SelectEvent.getCustomQFilters().add(DataRoleF7Helper.getDataPermRoleF7QFilter());
        }
    }
}

