/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.bd.model.UserDistributeServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.OperationTypeInfo;
import kd.epm.epbs.common.enums.ModelUserTypeEnum;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.UserTypeEnum;
import kd.epm.epbs.common.util.EpbsOperationResult;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.TXUtils;
import kd.epm.epbs.formplugin.AbstractBaseFormPlugin;
import kd.epm.epbs.formplugin.permission.data.f7.DataRoleF7Helper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class UserAssignDataRolePlugin
extends AbstractBaseFormPlugin {
    private static final String ROLE_CACHE = "roleIdsCache";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object control = evt.getSource();
        if (control instanceof Control && "btnok".equals(((Control)control).getKey())) {
            DynamicObjectCollection assignRoles = this.getModel().getEntryEntity("entryentity");
            String userType = this.getUserType();
            Long authTypeId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("authTypeId"));
            ArrayList saveData = new ArrayList(10);
            String roleIdstr = this.getPageCache().get(ROLE_CACHE);
            Set oldroleIds = StringUtils.isEmpty((CharSequence)roleIdstr) ? Collections.emptySet() : Arrays.stream(roleIdstr.split(",")).map(e -> IDUtils.toLong((Object)e)).collect(Collectors.toSet());
            assignRoles.forEach(role -> {
                long roleId;
                if (role != null && role.getDynamicObject("number") != null && !oldroleIds.remove(roleId = role.getDynamicObject("number").getLong("id"))) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"epbs_dataperm_roleuser");
                    dynamicObject.set("id", (Object)DB.genGlobalLongId());
                    dynamicObject.set("user", (Object)authTypeId);
                    dynamicObject.set("usertype", (Object)userType);
                    dynamicObject.set("role", (Object)roleId);
                    dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
                    dynamicObject.set("createtime", (Object)TimeServiceHelper.now());
                    saveData.add(dynamicObject);
                }
            });
            TXUtils.required(tx -> {
                if (!oldroleIds.isEmpty()) {
                    Optional<String> s = DataRoleF7Helper.checkRoleUseNoPerms(oldroleIds);
                    if (s.isPresent()) {
                        this.getView().showTipNotification(s.get());
                        return;
                    }
                    QFilter qFilter = new QFilter("user", "=", (Object)authTypeId);
                    qFilter.and("usertype", "=", (Object)userType).and("role", "in", (Object)oldroleIds);
                    DeleteServiceHelper.delete((String)"epbs_dataperm_roleuser", (QFilter[])qFilter.toArray());
                }
                SaveServiceHelper.save((DynamicObject[])saveData.toArray(new DynamicObject[0]));
            });
            this.getView().returnDataToParent((Object)new EpbsOperationResult());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UserAssignDataRolePlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            String number = UserDistributeServiceHelper.getUserOrUserGroup2Number((ModelUserTypeEnum)ModelUserTypeEnum.indexOfType((String)userType), (Long)authTypeId);
            this.writeLog((IOperationTypeInfo)new OperationTypeInfo(userType, UserTypeEnum.getEnum((String)userType).getName()), new MultiLangEnumBridge("\u3010%s\u3011\u5206\u914d\u6570\u636e\u89d2\u8272\u6210\u529f\u3002", "UserAssignDataRolePlugin_2", "epm-epbs-formplugin", new Object[]{number}));
            this.getView().close();
        }
    }

    protected DynamicObjectCollection queryUseAssignRecords() {
        long authTypeId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("authTypeId"));
        QFilter qFilter = new QFilter("user", "=", (Object)authTypeId);
        qFilter.and("userType", "=", (Object)this.getUserType()).and("role.type", "=", (Object)"0");
        return QueryServiceHelper.query((String)"epbs_dataperm_roleuser", (String)"role", (QFilter[])qFilter.toArray());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObjectCollection assignRoles = this.queryUseAssignRecords();
        if (CollectionUtils.isNotEmpty((Collection)assignRoles)) {
            this.getView().getPageCache().put(ROLE_CACHE, assignRoles.stream().map(a -> a.getString("role")).collect(Collectors.joining(",")));
            this.getModel().batchCreateNewEntryRow("entryentity", assignRoles.size());
            for (int i = 0; i < assignRoles.size(); ++i) {
                DynamicObject assignRole = (DynamicObject)assignRoles.get(i);
                this.getModel().setValue("number", assignRole.get("role"), i);
            }
        }
    }

    private String getUserType() {
        String authType = (String)this.getView().getFormShowParameter().getCustomParam("authType");
        return "user".equals(authType) ? "bos_user" : "bos_usergroup";
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("donothing".equals(afterDoOperationEventArgs.getOperateKey())) {
            DataRoleF7Helper.openSelectDataRoleF7Page(this, null, true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("datarolef7".equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            List returnData = (List)closedCallBackEvent.getReturnData();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            Set selectIds = entryEntity.stream().map(dy -> dy.getLong("number_id")).collect(Collectors.toSet());
            returnData.stream().forEach(e -> {
                if (!selectIds.contains(e.getPrimaryKeyValue())) {
                    int rowIndex = this.getModel().createNewEntryRow("entryentity");
                    this.getModel().setValue("number", e.getPrimaryKeyValue(), rowIndex);
                }
            });
        }
    }
}

