/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.data.authset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.list.ListShowParameter;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.epm.epbs.business.permission.data.AuthBizBean;
import kd.epm.epbs.common.bean.tab.TabInfo;
import kd.epm.epbs.common.bean.tab.TabManager;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.AuthTypeEnum;
import kd.epm.epbs.common.enums.AuthTypeTabEnum;
import kd.epm.epbs.common.member.f7.BosListF7Utils;
import kd.epm.epbs.common.page.InteractivePageUtil;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.formplugin.permission.data.authset.AuthSetFormPlugin;

public class AuthSetF7Helper {
    public static String CLOSECALLBACK = "commonAuthDecorator";
    public static final String SELECT_MODEL_CACHE = "selectModelId";
    public static final String AUTHSET_DIM_NUMS = "authsetdimnum";
    public static final String AUTHSET_TAB_TYPE = "authset_tab_type";

    public static boolean isFormPermControl(IFormView view, Consumer<Map<String, Object>> handler) {
        IFormView parentView = view.getParentView();
        if (parentView != null && "epbs_auth_set_form".equals(parentView.getEntityId())) {
            handler.accept(view.getFormShowParameter().getCustomParams());
            return true;
        }
        return false;
    }

    public static Long getModelId(IFormView view) {
        return IDUtils.toLong((Object)view.getPageCache().get(SELECT_MODEL_CACHE));
    }

    public static Set<String> getAppNumsFromAuthSet(AuthTypeEnum authTypeEnum) {
        QFilter[] qfs = null;
        if (authTypeEnum != null) {
            if (authTypeEnum == AuthTypeEnum.ADMIN) {
                qfs = new QFilter("type", "like", (Object)"%,3,%").toArray();
            } else if (authTypeEnum == AuthTypeEnum.BIZ) {
                qfs = new QFilter("type", "like", (Object)"%,2,%").toArray();
            } else if (authTypeEnum == AuthTypeEnum.DIM) {
                qfs = new QFilter("biztype", "=", (Object)"0").toArray();
            }
        }
        return QueryServiceHelper.query((String)"epbs_auth_bizset", (String)"appnum", qfs).stream().map(e -> e.getString("appnum")).collect(Collectors.toSet());
    }

    public static void openAuthSetEntryF7(IFormView view, TabManager<TabInfo<AuthBizBean>> tabManager) {
        AuthBizBean bean = (AuthBizBean)tabManager.getSelectedTabInfo().getData();
        AuthSetF7Helper.OpenF7(view, bean, k -> {
            Long modelId = AuthSetF7Helper.getModelId(view);
            AuthTypeEnum authType = AuthSetF7Helper.getAuthType(view);
            k.setCustomParam(AUTHSET_TAB_TYPE, (Object)bean.getAuthbiz());
            if ("epbs_auth_bizset".equals(k.getBillFormId())) {
                QFilter qFilter = new QFilter("appnum", "=", (Object)ModelCacheHelper.getModel((long)modelId).getSrcAppNum());
                qFilter.and("biztype", "=", (Object)"1");
                if (bean.getAuthType() == AuthTypeEnum.ADMIN.getType()) {
                    qFilter.and("type", "like", (Object)"%,3,%");
                }
                k.setCustomParam("appnums", (Object)ModelCacheHelper.getModel((long)modelId).getAppNums().stream().collect(Collectors.joining(",")));
                k.getListFilterParameter().setFilter(qFilter);
            } else {
                AuthBizBean single;
                k.setCustomParam("model", (Object)modelId);
                String dimnums = null;
                if (authType == AuthTypeEnum.DIM && (single = (AuthBizBean)((TabInfo)tabManager.getTabs().get(0)).getData()) != null && single.getDatas() != null) {
                    dimnums = single.getDatas().values().stream().flatMap(e -> e.getDetails().stream()).map(e -> e.getDimNumber()).collect(Collectors.joining(","));
                }
                k.setCustomParam(AUTHSET_DIM_NUMS, dimnums);
                if (AuthSetF7Helper.isDefaultSet(view)) {
                    k.setCustomParam("fromSource", (Object)"1");
                }
            }
        });
    }

    public static QFilter getDimNumsForQF(boolean isDefualtSet, long modelId, IFormView formView) {
        Collection dimnums;
        Long grId = IDUtils.toLong((Object)formView.getFormShowParameter().getCustomParam(AUTHSET_TAB_TYPE));
        String customParam = (String)formView.getFormShowParameter().getCustomParam(AUTHSET_DIM_NUMS);
        Collection collection = dimnums = StringUtils.isEmpty((String)customParam) ? new ArrayList() : (Collection)Arrays.stream(customParam.split(",")).collect(Collectors.toList());
        if (AuthTypeTabEnum.SINGLE_DIM.getBizId() == grId.longValue()) {
            if (CollectionUtils.isEmpty(dimnums)) {
                return null;
            }
            return new QFilter("number", "not in", dimnums);
        }
        if (AuthTypeTabEnum.Multi_DIM.getBizId() == grId.longValue()) {
            return new QFilter("number", "in", dimnums);
        }
        QFilter qf = new QFilter("authbiz", "=", (Object)AuthTypeTabEnum.SINGLE_DIM.getBizId());
        qf.and("appnum", "=", (Object)ModelCacheHelper.getModel((long)modelId).getSrcAppNum());
        qf.and("model", "in", Arrays.asList(0L, modelId));
        qf.and("enable", "=", (Object)"1");
        qf.and("authtype", "=", (Object)(AuthTypeEnum.DIM.getType() + ""));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"epbs_auth_set", (String)"id,authbiz_id,model_id,authtype,enable,entryentity.entitynumber,entryentity.dimnumber,entryentity.seq,entryentity.group,entryentity.hasperm", (QFilter[])qf.toArray());
        if (!isDefualtSet) {
            dimnums = dys.stream().filter(e -> e.getLong("model_id") == modelId).map(e -> e.getString("entryentity.dimnumber")).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(dimnums)) {
            dimnums = dys.stream().filter(e -> e.getLong("model_id") == 0L).map(e -> e.getString("entryentity.dimnumber")).collect(Collectors.toList());
        }
        return new QFilter("number", "in", dimnums);
    }

    public static AuthTypeEnum getAuthType(IFormView view) {
        return AuthTypeEnum.indexof((byte)Byte.parseByte((String)view.getFormShowParameter().getCustomParam("authtype")));
    }

    private static void OpenF7(IFormView view, AuthBizBean bean, Consumer<ListShowParameter> consumer) {
        AuthTypeEnum authType = AuthSetF7Helper.getAuthType(view);
        boolean isMultiSelect = false;
        if (AuthTypeEnum.DIM == authType && AuthTypeTabEnum.Multi_DIM.getBizId() == bean.getAuthbiz()) {
            isMultiSelect = true;
        } else if (AuthTypeEnum.BIZ == authType) {
            isMultiSelect = true;
        }
        String op = AuthSetF7Helper.isDefaultSet(view) ? "authTypeSetdefaultOp" : "authTypeSetOp";
        CloseCallBack closeCallBack = new CloseCallBack(AuthSetFormPlugin.class.getName(), CLOSECALLBACK + "_" + op);
        ListShowParameter listShowParameter = BosListF7Utils.createListShowParameter((String)bean.getEntityNumber(), (boolean)isMultiSelect, (CloseCallBack)closeCallBack);
        String pageIdAndCache = InteractivePageUtil.getPageIdAndCache((IPageCache)view.getPageCache(), (String)listShowParameter.getFormId(), (boolean)true);
        listShowParameter.setPageId(pageIdAndCache);
        consumer.accept(listShowParameter);
        view.showForm((FormShowParameter)listShowParameter);
    }

    public static boolean isDefaultSet(IFormView view) {
        return "1".equals(view.getFormShowParameter().getCustomParam("fromSource"));
    }
}

