/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.data.authset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.epm.epbs.business.permission.data.AuthBizBean;
import kd.epm.epbs.business.permission.data.AuthSetDetailBean;
import kd.epm.epbs.business.permission.data.AuthSetRowBean;
import kd.epm.epbs.business.permission.data.AuthSetSaveOp;
import kd.epm.epbs.business.permission.model.ModelPermHelper;
import kd.epm.epbs.business.permission.util.AuthSetUtils;
import kd.epm.epbs.business.spi.IConsumerService;
import kd.epm.epbs.common.bean.IContext;
import kd.epm.epbs.common.bean.tab.TabInfo;
import kd.epm.epbs.common.bean.tab.TabManager;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.enums.AuthTypeEnum;
import kd.epm.epbs.common.enums.AuthTypeTabEnum;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.tree.DynamicTreeContext;
import kd.epm.epbs.common.tree.NoParentDynamicTreeBuilder;
import kd.epm.epbs.common.util.EpbsOperationResult;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.common.util.ModelUtil;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.formplugin.permission.data.authset.AuthSetF7Helper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.math3.util.Pair;

public class AuthSetFormPlugin
extends AbstractFormPlugin
implements TabSelectListener,
TreeNodeClickListener,
IConsumerService {
    private static final String TABAP_KEY = "tabap";
    private static final String TABPAGE_SUFFIX = "_tabpageap";
    private static final String WILL_SELECT_MODEL_CACHE = "willSelectModelId";
    private TabManager<TabInfo<AuthBizBean>> authTabManager;
    private Long modelId;

    protected long getModelId() {
        if (this.modelId == null) {
            this.modelId = AuthSetF7Helper.getModelId(this.getView());
            if (this.modelId == null || this.modelId < 1L) {
                TreeView treeView = (TreeView)this.getControl("treeviewap");
                String modelIdStr = treeView.getTreeState().getFocusNodeId();
                this.modelId = StringUtils.isEmpty((String)modelIdStr) ? 0L : Long.parseLong(modelIdStr);
            }
        }
        return this.modelId;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initLeftTree();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap", "left_subflexcontainer"});
    }

    private TabManager<TabInfo<AuthBizBean>> getTabManager() {
        if (this.authTabManager == null) {
            String s = this.getPageCache().get("key_tab_manager_cache");
            this.authTabManager = StringUtils.isNotEmpty((String)s) ? (TabManager)ObjectSerialUtil.deSerializedBytes((String)s) : new TabManager();
        }
        return this.authTabManager;
    }

    private void cacheTabManager() {
        if (this.authTabManager != null) {
            this.getPageCache().put("key_tab_manager_cache", ObjectSerialUtil.toByteSerialized(this.authTabManager));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"btnsetting", "adddimtab", "deldimtab", "single_dimtext", "admin_biztext", "admin_dimtext", "biztext", "multi_dimtext", "btnok", "btncancel"});
        Tab tabap = (Tab)this.getView().getControl(TABAP_KEY);
        tabap.addTabSelectListener((TabSelectListener)this);
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        TabInfo selectedTabInfo = this.getTabManager().getSelectedTabInfo();
        if (selectedTabInfo == null || StringUtils.isEmpty((String)((AuthBizBean)selectedTabInfo.getData()).getEntityNumber())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u76f8\u5173\u8bbe\u7f6e\u6570\u636e\u3002", (String)"AuthSetFormPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (evt.getItemKey().equals("bar_addrow") && !this.bizControlStyle(true)) {
            if (((AuthBizBean)selectedTabInfo.getData()).getAuthbiz() == AuthTypeTabEnum.SINGLE_DIM.getBizId()) {
                this.fillEntryEntityToTabInfo();
            }
            AuthSetF7Helper.openAuthSetEntryF7(this.getView(), this.getTabManager());
        }
    }

    private boolean bizControlStyle(boolean isadd) {
        TabInfo selectedTabInfo = this.getTabManager().getSelectedTabInfo();
        AuthTypeEnum authType = this.getAuthType();
        if (authType == AuthTypeEnum.BIZ && !((AuthBizBean)selectedTabInfo.getData()).getType().contains(",1,")) {
            if (this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").isEmpty()) {
                if (isadd) {
                    AuthTypeTabEnum tabEnum = AuthTypeTabEnum.indexofBizAuthId((Long)((AuthBizBean)selectedTabInfo.getData()).getAuthbiz());
                    int row = this.getModel().createNewEntryRow("entryentity");
                    this.getModel().setValue("group", (Object)GlobalIdUtil.genGlobalLongId(), row);
                    this.getModel().setValue(tabEnum.name().toLowerCase() + "text", (Object)"", row);
                    this.getModel().setValue("authbiztype", (Object)selectedTabInfo.getName(), row);
                    this.formatBizTypeRow(row);
                    this.getView().updateView("entryentity");
                    this.getModel().setDataChanged(true);
                }
                this.getView().setEnable(Boolean.valueOf(!isadd), new String[]{"bar_addrow"});
            }
            return true;
        }
        return false;
    }

    private AuthTypeEnum getAuthType() {
        return AuthSetF7Helper.getAuthType(this.getView());
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("adddimtab".equals(key) || "deldimtab".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("epbs_authtype_select");
            TreeView treeView = (TreeView)this.getControl("treeviewap");
            Long modelId = Long.parseLong(treeView.getTreeState().getFocusNodeId());
            formShowParameter.setCustomParam("appnum", (Object)ModelUtil.getAppType((Long)modelId).getAppNum());
            formShowParameter.setCustomParam("authtype", (Object)(this.getAuthType().getType() + ""));
            String isappend = "adddimtab".equals(key) ? "1" : "0";
            formShowParameter.setCustomParam("isappend", (Object)isappend);
            List collect = this.getTabManager().getTabs().stream().map(e -> e.getTabKey().substring(0, e.getTabKey().length() - TABPAGE_SUFFIX.length())).collect(Collectors.toList());
            formShowParameter.setCustomParam("numbers", collect);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u7c7b\u578b\u8bbe\u7f6e", (String)"AuthSetFormPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "authtype_select" + isappend));
            this.getView().showForm(formShowParameter);
        } else if ("btnok".equals(key) && this.validateData() && this.beforeSave(0)) {
            this.saveWithExit();
        }
    }

    private void saveWithExit() {
        this.saveData();
        this.getView().returnDataToParent((Object)new EpbsOperationResult(true, null, null));
        this.getView().close();
    }

    private void saveWithSwitchModel() {
        this.saveData();
        this.getPageCache().put("selectModelId", this.getPageCache().get(WILL_SELECT_MODEL_CACHE));
        this.createReportTab();
        this.getModel().setDataChanged(false);
    }

    private boolean validateData() {
        this.fillEntryEntityToTabInfo();
        this.cacheTabManager();
        List tabs = this.getTabManager().getTabs();
        if (AuthSetF7Helper.getModelId(this.getView()) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\uff0c\u4fee\u6539\u540e\u4fdd\u5b58\u3002", (String)"AuthSetFormPlugin_21", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        int skip = this.getAuthType() == AuthTypeEnum.BIZ ? 1 : 0;
        HashMap dim2BinaryPosMap = new HashMap(16);
        String msg = null;
        block0: for (TabInfo tab : tabs) {
            AuthBizBean bizData = (AuthBizBean)tab.getData();
            if (bizData.getDatas() == null || bizData.getDatas().isEmpty()) continue;
            List sums = bizData.getDatas().values().stream().map(e -> {
                int sum = e.getDetails().stream().skip(skip).mapToInt(a -> dim2BinaryPosMap.computeIfAbsent(a.getDimNumber(), k -> 1 << dim2BinaryPosMap.size())).sum();
                return Pair.create((Object)sum, (Object)e.getDetails().stream().map(a -> a.getName()).collect(Collectors.joining(";")));
            }).collect(Collectors.toList());
            for (int i = 0; i < sums.size() - 1; ++i) {
                for (int j = i + 1; j < sums.size(); ++j) {
                    if (((Pair)sums.get(i)).getKey() == ((Pair)sums.get(j)).getKey()) {
                        msg = String.format(ResManager.loadKDString((String)"%1$s\u7684\u7b2c%2$s\u884c\u6570\u636e\u548c\u7b2c%3$s\u884c\u6570\u636e\u4e0d\u53ef\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"AuthSetFormPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]), ((AuthBizBean)tab.getData()).getName(), i + 1, j + 1);
                        break block0;
                    }
                    int c = (Integer)((Pair)sums.get(i)).getKey() & (Integer)((Pair)sums.get(j)).getKey();
                    if (c != (Integer)((Pair)sums.get(i)).getKey() && c != (Integer)((Pair)sums.get(j)).getKey() || c == 0) continue;
                    msg = String.format(ResManager.loadKDString((String)"%1$s\u7684\u7b2c%s\u884c\u6570\u636e\u3010%2$s\u3011\u548c\u7b2c%3$s\u884c\u6570\u636e\u3010%4$s\u3011\u5b58\u5728\u5305\u542b\u5173\u7cfb\uff0c\u4e0d\u53ef\u540c\u65f6\u5b58\u5728\u3002", (String)"AuthSetFormPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]), ((AuthBizBean)tab.getData()).getName(), i + 1, ((Pair)sums.get(i)).getValue(), j + 1, ((Pair)sums.get(j)).getValue());
                    break block0;
                }
            }
        }
        if (StringUtils.isNotEmpty(msg)) {
            this.getView().showTipNotification(msg);
            return false;
        }
        HashMap singleDimMap = new HashMap(16);
        ArrayList dimNoExists = new ArrayList(1);
        if (this.getAuthType() == AuthTypeEnum.BIZ) {
            List singleDimBeans = AuthSetUtils.queryAuthSets((AuthTypeEnum)AuthTypeEnum.DIM, (long)this.getModelId(), (int)(this.isDefaultSet() ? 0 : 1), (QFilter)new QFilter("authbiz", "=", (Object)AuthTypeTabEnum.SINGLE_DIM.getBizId()));
            ((AuthBizBean)singleDimBeans.get(0)).getDatas().values().forEach(e -> e.getDetails().forEach(a -> {
                singleDimMap.put(a.getDimNumber(), e.isHasPerm());
                if (StringUtils.isEmpty((String)a.getName())) {
                    dimNoExists.add(a.getDimNumber());
                }
            }));
            HashSet dims = new HashSet(16);
            tabs.forEach(e -> ((AuthBizBean)e.getData()).getDatas().values().stream().skip(1L).flatMap(a -> a.getDetails().stream()).filter(a -> singleDimMap.getOrDefault(a, Boolean.FALSE)).forEach(a -> dims.add(a.getDimNumber())));
            if (!dims.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u7b26\u5408\u8981\u6c42,\u7ef4\u5ea6\u7ec4\u5408\u914d\u7f6e\u5fc5\u987b\u662f\u9ed8\u8ba4\u65e0\u6743\uff0c%s", (String)"AuthSetFormPlugin_10", (String)"epm-epbs-formplugin", (Object[])new Object[0]), dims.stream().collect(Collectors.joining(","))));
                return false;
            }
        } else if (this.getAuthType() == AuthTypeEnum.DIM) {
            ((AuthBizBean)((TabInfo)tabs.get(0)).getData()).getDatas().values().forEach(e -> e.getDetails().forEach(a -> {
                singleDimMap.put(a.getDimNumber(), e.isHasPerm());
                if (StringUtils.isEmpty((String)a.getName())) {
                    dimNoExists.add(a.getDimNumber());
                }
            }));
            if (tabs.size() > 1) {
                for (AuthSetRowBean bean : ((AuthBizBean)((TabInfo)tabs.get(1)).getData()).getDatas().values()) {
                    long count = bean.getDetails().stream().map(e -> singleDimMap.getOrDefault(e, Boolean.FALSE) == false).distinct().count();
                    if (count != 2L) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u7b26\u5408\u8981\u6c42,\u7ef4\u5ea6\u7ec4\u5408\u5fc5\u987b\u90fd\u662f\u65e0\u6743\u6216\u6709\u6743\uff0c%s", (String)"AuthSetFormPlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]), bean.getDetails().stream().map(e -> e.getName()).collect(Collectors.joining("\uff1b"))));
                    return false;
                }
            }
            if (!dimNoExists.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u3010%s\u3011\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u5220\u9664\u3002", (String)"AuthSetFormPlugin_9", (String)"epm-epbs-formplugin", (Object[])new Object[0]), dimNoExists.stream().collect(Collectors.joining(","))));
                return false;
            }
        }
        return true;
    }

    private boolean beforeSave(int source) {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and("authtype", "=", (Object)(this.getAuthType().getType() + ""));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"epbs_auth_set", (String)"entryentity.group", (QFilter[])qFilter.toArray());
        Set oldGroupIds = dys.stream().map(e -> e.get("entryentity.group")).collect(Collectors.toSet());
        Set newGroupIds = this.getTabManager().getTabs().stream().flatMap(e -> ((AuthBizBean)e.getData()).getDatas().keySet().stream()).collect(Collectors.toSet());
        oldGroupIds.removeAll(newGroupIds);
        if (!oldGroupIds.isEmpty() && AuthSetUtils.groupCheck((long)(this.isDefaultSet() ? 0L : this.getModelId()), oldGroupIds)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fdd\u5b58\u540e\u88ab\u5220\u884c\u7684\u6388\u6743\u8bbe\u7f6e\u7684\u6743\u9650\u5c06\u88ab\u5220\u9664\u3002", (String)"AuthSetFormPlugin_18", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("validateSave_" + source, (IFormPlugin)this));
            return false;
        }
        return true;
    }

    private void saveData() {
        long modelId = this.getModelId();
        if (modelId != 0L) {
            List collect = this.getTabManager().getTabs().stream().map(e -> (AuthBizBean)e.getData()).collect(Collectors.toList());
            new AuthSetSaveOp(this.isDefaultSet() ? 0L : modelId, ModelUtil.getAppType((Long)modelId).getAppNum(), this.getAuthType()).genDys(collect).save();
        }
    }

    protected boolean isDefaultSet() {
        return AuthSetF7Helper.isDefaultSet(this.getView());
    }

    private void initLeftTree() {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        DynamicTreeContext context = new DynamicTreeContext("epbs_model");
        context.setFocusTreeId(treeView.getTreeState().getFocusNodeId());
        context.setSelectFields("id,shownumber as number,name");
        context.setOrderby("modifytime desc");
        context.setRootName(ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"AuthSetFormPlugin_11", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        if (this.isDefaultSet()) {
            context.setqFilters(new QFilter("srcappnum", "=", this.getView().getFormShowParameter().getCustomParam("appnum")).toArray());
        } else {
            Set<String> appnums = AuthSetF7Helper.getAppNumsFromAuthSet(this.getAuthType());
            Set modelids = ModelPermHelper.getLimitedModelListByUser((AppTypeEnum[])((AppTypeEnum[])appnums.stream().map(e -> AppTypeEnum.getEnumByAppnum((String)e)).toArray(AppTypeEnum[]::new)));
            context.setqFilters(new QFilter("id", "in", (Object)modelids).toArray());
        }
        new NoParentDynamicTreeBuilder(context).buildTree(treeView).nodeClick();
    }

    public void fillEntryEntityToTabInfo() {
        TabInfo selectedTabInfo = this.getTabManager().getSelectedTabInfo();
        if (selectedTabInfo != null) {
            DynamicObjectCollection dys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            int prefix = this.getAuthType() == AuthTypeEnum.BIZ ? 1 : 0;
            AuthTypeTabEnum tabEnum = AuthTypeTabEnum.indexofBizAuthId((Long)((AuthBizBean)selectedTabInfo.getData()).getAuthbiz());
            String textField = tabEnum.name().toLowerCase() + "text";
            AuthBizBean bean = (AuthBizBean)selectedTabInfo.getData();
            bean.getDatas().clear();
            for (int i = 0; i < dys.size(); ++i) {
                String values = ((DynamicObject)dys.get(i)).getString("authsetvalue");
                Long groupId = ((DynamicObject)dys.get(i)).getLong("group");
                boolean hasperm = ((DynamicObject)dys.get(i)).getBoolean("hasperm");
                if (!StringUtils.isNotEmpty((String)values)) continue;
                String[] split = values.split(",");
                String[] names = ((DynamicObject)dys.get(i)).getString(textField).split(";", split.length);
                for (int j = 0; j < split.length; ++j) {
                    if (j - prefix >= 0) {
                        bean.addData(groupId, AuthSetDetailBean.createInstance((String)split[j], (String)names[j - prefix]), hasperm);
                        continue;
                    }
                    bean.addData(groupId, AuthSetDetailBean.createInstance((String)split[j], null), hasperm);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals("hasperm")) {
            this.getModel().setDataChanged(true);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void tabSelected(TabSelectEvent evnt) {
        this.tabSelected(evnt.getTabKey());
    }

    private void tabSelected(String tabKey) {
        TabInfo tabInfo = this.getTabManager().getTabInfo(tabKey);
        if (!tabInfo.isSelected()) {
            boolean dataChanged = this.getModel().getDataChanged();
            this.fillEntryEntityToTabInfo();
            this.getModel().deleteEntryData("entryentity");
            AuthTypeTabEnum tabEnum = AuthTypeTabEnum.indexofBizAuthId((Long)((AuthBizBean)tabInfo.getData()).getAuthbiz());
            String textField = tabEnum.name().toLowerCase() + "text";
            if (((AuthBizBean)tabInfo.getData()).getDatas() != null && !((AuthBizBean)tabInfo.getData()).getDatas().isEmpty()) {
                this.getModel().batchCreateNewEntryRow("entryentity", ((AuthBizBean)tabInfo.getData()).getDatas().size());
                Map datas = ((AuthBizBean)tabInfo.getData()).getDatas();
                String authbiztype = null;
                int skip = 0;
                if (this.getAuthType() == AuthTypeEnum.BIZ) {
                    authbiztype = tabInfo.getName().getLocaleValue();
                    skip = 1;
                }
                int i = 0;
                for (Map.Entry entry : datas.entrySet()) {
                    this.getModel().setValue("authsetvalue", (Object)((AuthSetRowBean)entry.getValue()).getDetails().stream().map(e -> e.getEntityNumber() + "#" + e.getDimNumber()).collect(Collectors.joining(",")), i);
                    this.getModel().setValue(textField, (Object)((AuthSetRowBean)entry.getValue()).getDetails().stream().skip(skip).map(e -> e.getName()).collect(Collectors.joining(";")), i);
                    this.getModel().setValue("group", entry.getKey(), i);
                    this.getModel().setValue("hasperm", (Object)(((AuthSetRowBean)entry.getValue()).isHasPerm() ? "1" : "0"), i);
                    this.getModel().setValue("authbiztype", (Object)authbiztype, i++);
                }
            }
            this.getTabManager().selectTabInfo(tabKey);
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            AuthTypeEnum authType = this.getAuthType();
            grid.setColumnProperty("authbiztype", "visible", (Object)(authType == AuthTypeEnum.BIZ ? 1 : 0));
            boolean flag = this.isBizBindingDim((TabInfo<AuthBizBean>)tabInfo) || tabEnum == AuthTypeTabEnum.ADMIN_BIZ;
            boolean showHasPermControl = tabEnum == AuthTypeTabEnum.SINGLE_DIM && !this.isDefaultSet() && ParamSettingServiceHelper.getBoolean((long)this.getModelId(), (String)"EPM006");
            for (AuthTypeTabEnum t : AuthTypeTabEnum.values()) {
                if (t == tabEnum) {
                    grid.setColumnProperty(textField, "visible", (Object)flag);
                    continue;
                }
                grid.setColumnProperty(t.name().toLowerCase() + "text", "visible", (Object)false);
            }
            boolean flag2 = !flag && ((AuthBizBean)tabInfo.getData()).getDatas() != null && ((AuthBizBean)tabInfo.getData()).getDatas().size() > 0;
            this.getView().setEnable(Boolean.valueOf(!flag2), new String[]{"bar_addrow"});
            grid.setColumnProperty("hasperm", "visible", (Object)showHasPermControl);
            this.cacheTabManager();
            this.getModel().setDataChanged(dataChanged);
        }
    }

    private boolean isBizBindingDim(TabInfo<AuthBizBean> tabInfo) {
        String type = ((AuthBizBean)tabInfo.getData()).getType();
        return type.contains(",1,") || type.contains(",4,");
    }

    public void createReportTab() {
        TabManager<TabInfo<AuthBizBean>> tabManager = this.getTabManager();
        tabManager.releaseAll();
        AuthTypeEnum authType = this.getAuthType();
        long modelId = AuthSetF7Helper.getModelId(this.getView());
        if (!this.isDefaultSet()) {
            AuthSetUtils.copyDefaultAuthSet2Model((Long)modelId);
        }
        List tabList = AuthSetUtils.queryAuthSets((AuthTypeEnum)authType, (long)modelId, (int)(this.isDefaultSet() ? 0 : 1), null);
        for (AuthBizBean bean : tabList) {
            TabInfo tabInfo = new TabInfo(bean.getNumber().toLowerCase() + TABPAGE_SUFFIX, new LocaleString(bean.getName()));
            tabInfo.setData((Object)bean);
            tabManager.addTabInfo(tabInfo);
        }
        this.initEntryEntityControl();
        if (CollectionUtils.isNotEmpty((Collection)this.getTabManager().getTabs())) {
            this.tabSelected(((TabInfo)this.getTabManager().getTabs().get(0)).getTabKey());
        }
        this.getView().setVisible(Boolean.valueOf(modelId != 0L), new String[]{"advconap", "left_subflexcontainer"});
        this.getView().setVisible(Boolean.valueOf(authType == AuthTypeEnum.BIZ), new String[]{"deldimtab", "adddimtab"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof DeleteEntry) {
            EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryentity.getSelectRows();
            List group = Arrays.stream(selectRows).mapToObj(row -> this.getModel().getValue("group", row)).collect(Collectors.toList());
            if (AuthSetUtils.groupCheck((long)(this.isDefaultSet() ? 0L : this.getModelId()), group)) {
                args.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6240\u9009\u6388\u6743\u65b9\u5f0f\u5df2\u7ecf\u5b58\u5728\u6570\u636e\u6743\u9650\u6388\u6743\u8bb0\u5f55\uff0c\u5220\u9664\u8be5\u6388\u6743\u65b9\u5f0f\u540e\uff0c\u6743\u9650\u8bb0\u5f55\u5c06\u88ab\u6e05\u9664\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AuthSetFormPlugin_19", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("deleteRow", (IFormPlugin)this));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("newentry")) {
            EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryentity.getSelectRows();
            this.getModel().setValue("group", (Object)GlobalIdUtil.genGlobalLongId(), selectRows[0]);
            if (this.getAuthType() == AuthTypeEnum.BIZ) {
                TabInfo selectedTabInfo = this.getTabManager().getSelectedTabInfo();
                AuthTypeTabEnum tabEnum = AuthTypeTabEnum.indexofBizAuthId((Long)((AuthBizBean)selectedTabInfo.getData()).getAuthbiz());
                this.getModel().setValue(tabEnum.name().toLowerCase() + "text", (Object)"", selectRows[0]);
                this.getModel().setValue("authbiztype", (Object)selectedTabInfo.getName(), selectRows[0]);
                this.formatBizTypeRow(selectRows[0]);
                this.getView().updateView("entryentity");
                this.getModel().setDataChanged(true);
            }
        } else if (args.getOperateKey().equals("deleteentry")) {
            this.bizControlStyle(false);
            this.getModel().setDataChanged(true);
        }
    }

    private void formatBizTypeRow(int rowIndex) {
        TabInfo selectedTabInfo = this.getTabManager().getSelectedTabInfo();
        DynamicObject dy = QueryServiceHelper.queryOne((String)"epbs_auth_bizset", (String)"id,name,number,entitynumber", (QFilter[])new QFilter("id", "=", (Object)((AuthBizBean)selectedTabInfo.getData()).getAuthbiz()).toArray());
        this.getModel().setValue("authsetvalue", (Object)(dy.getString("entitynumber") + "#" + dy.getString("number")), rowIndex);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getActionId().startsWith("authtype_select") && event.getReturnData() != null) {
            String isAppend = event.getActionId().substring("authtype_select".length());
            EpbsOperationResult res = (EpbsOperationResult)event.getReturnData();
            String authBizNumber = (String)res.getData();
            if ("1".equals(isAppend)) {
                DynamicObjectCollection bizDys = this.getBizDys();
                String dimEntityNumber = bizDys.stream().filter(e -> e.getString("biztype").equals("0")).map(e -> e.getString("entitynumber")).findFirst().orElseGet(() -> null);
                Optional<DynamicObject> f = bizDys.stream().filter(e -> e.getString("number").equals(authBizNumber)).findFirst();
                if (f.isPresent()) {
                    DynamicObject dy = f.get();
                    AuthBizBean bean = new AuthBizBean(dy.getLong("id"), dy.getString("number"), dy.getString("name"), dimEntityNumber);
                    bean.setType(dy.getString("type"));
                    TabInfo tabInfo = new TabInfo(bean.getNumber().toLowerCase() + TABPAGE_SUFFIX, new LocaleString(bean.getName()));
                    tabInfo.setData((Object)bean);
                    this.getTabManager().addTabInfo(tabInfo);
                    this.initEntryEntityControl();
                    this.getModel().setDataChanged(true);
                }
            } else {
                TabInfo tabInfo = this.getTabManager().getTabInfo(authBizNumber.toLowerCase() + TABPAGE_SUFFIX);
                if (tabInfo != null && !((AuthBizBean)tabInfo.getData()).getDatas().isEmpty()) {
                    String actionId = "deletetabpage" + tabInfo.getTabKey();
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6240\u9009\u6388\u6743\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728\u6570\u636e\u6743\u9650\u6388\u6743\u8bb0\u5f55\uff0c\u5220\u9664\u8be5\u6388\u6743\u7c7b\u578b\u540e\uff0c\u6743\u9650\u8bb0\u5f55\u5c06\u88ab\u6e05\u9664\uff0c\u5c06\u4e0d\u518d\u6821\u9a8c\u8be5\u6388\u6743\u7c7b\u578b\u7684\u8bfb\u5199\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AuthSetFormPlugin_20", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(actionId, (IFormPlugin)this));
                    return;
                }
                if (tabInfo != null) {
                    this.removeTabPage(tabInfo.getTabKey());
                }
            }
            this.getModel().setDataChanged(true);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        String lastModelId = this.getView().getPageCache().get("selectModelId");
        if ("#".equals(evt.getParentNodeId()) && nodeId.equals(lastModelId)) {
            return;
        }
        if (this.getModel().getDataChanged()) {
            this.getPageCache().put(WILL_SELECT_MODEL_CACHE, nodeId);
            HashMap<Integer, String> btnNames = new HashMap<Integer, String>(16);
            TreeNode root = AbstractTreeBuilder.getRootWithCache((TreeView)((TreeView)this.getControl("treeviewap")));
            TreeNode treeNode = root.getTreeNode(lastModelId);
            String notSaveExit = ResManager.loadKDString((String)"\u4e0d\u4fdd\u5b58", (String)"AuthSetFormPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
            String save = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AuthSetFormPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
            btnNames.put(7, notSaveExit);
            btnNames.put(6, save);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4f53\u7cfb\u201c%1$s\u201d\u7684\u6570\u636e\u6709\u66f4\u6539\uff0c\u662f\u5426\u4fdd\u5b58\u5bf9\u4f53\u7cfb\u201c%2$s\u201d\u7684\u66f4\u6539\uff1f\u3010\u4fdd\u5b58\u3011\u5219\u4fdd\u5b58\u66f4\u6539\u5e76\u5207\u6362\uff0c\u3010\u4e0d\u4fdd\u5b58\u3011\u5219\u4e0d\u4fdd\u5b58\u66f4\u6539\u5e76\u5207\u6362\uff0c\u3010\u53d6\u6d88\u3011\u5219\u505c\u7559\u539f\u4f53\u7cfb\u9875\u9762\u4e0d\u505a\u53d8\u52a8\u3002", (String)"AuthSetFormPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[]{treeNode.getText(), treeNode.getText()}), "", MessageBoxOptions.YesNoCancel, ConfirmTypes.Default, new ConfirmCallBackListener("switchModelId", (IFormPlugin)this), btnNames);
            return;
        }
        this.getPageCache().put("selectModelId", nodeId);
        this.createReportTab();
        this.getModel().setDataChanged(false);
    }

    private DynamicObjectCollection getBizDys() {
        QFilter qFilter = new QFilter("appnum", "=", (Object)ModelCacheHelper.getModel((long)AuthSetF7Helper.getModelId(this.getView())).getSrcAppNum());
        return QueryServiceHelper.query((String)"epbs_auth_bizset", (String)"id,name,number,type,entitynumber,biztype", (QFilter[])qFilter.toArray());
    }

    private void initEntryEntityControl() {
        TabInfo selectedTabInfo = this.getTabManager().getSelectedTabInfo();
        if (selectedTabInfo == null && CollectionUtils.isNotEmpty((Collection)this.getTabManager().getTabs())) {
            selectedTabInfo = (TabInfo)this.getTabManager().getTabs().get(0);
        }
        this.cacheTabManager();
        TabAp tabAp = this.getTabManager().createTabAp(TABAP_KEY);
        this.getView().updateControlMetadata(TABAP_KEY, tabAp.createControl());
        Tab tab = (Tab)this.getControl(TABAP_KEY);
        if (selectedTabInfo != null) {
            tab.activeTab(selectedTabInfo.getTabKey());
        } else {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    private void removeTabPage(String tabKey) {
        this.getTabManager().releaseByKey(tabKey);
        this.initEntryEntityControl();
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        MessageBoxResult callBackResult = evt.getResult();
        if (evt.getCallBackId().startsWith("deletetabpage")) {
            if (callBackResult == MessageBoxResult.Yes) {
                String tabKey = evt.getCallBackId().substring("deletetabpage".length());
                this.removeTabPage(tabKey);
            }
        } else if (evt.getCallBackId().equals("switchModelId")) {
            if (callBackResult == MessageBoxResult.Yes) {
                if (this.validateData()) {
                    if (this.beforeSave(1)) {
                        this.saveWithSwitchModel();
                    } else {
                        return;
                    }
                }
                this.getPageCache().put("selectModelId", this.getPageCache().get(WILL_SELECT_MODEL_CACHE));
            } else if (callBackResult == MessageBoxResult.No) {
                this.getPageCache().put("selectModelId", this.getPageCache().get(WILL_SELECT_MODEL_CACHE));
                this.createReportTab();
                this.getModel().setDataChanged(false);
            }
            TreeView treeView = (TreeView)this.getControl("treeviewap");
            TreeNode treeNode = AbstractTreeBuilder.getRootWithCache((TreeView)treeView).getTreeNode(this.getView().getPageCache().get("selectModelId"));
            treeView.focusNode(treeNode);
            treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
            this.getPageCache().remove(WILL_SELECT_MODEL_CACHE);
        } else if (evt.getCallBackId().equals("deleteRow")) {
            if (callBackResult == MessageBoxResult.Yes) {
                EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
                int[] selectRows = entryentity.getSelectRows();
                this.getModel().deleteEntryRows("entryentity", selectRows);
                this.getModel().setDataChanged(true);
            }
        } else if (evt.getCallBackId().startsWith("validateSave") && callBackResult == MessageBoxResult.Yes) {
            if (evt.getCallBackId().equals("validateSave_0")) {
                this.saveWithExit();
            } else {
                this.saveWithSwitchModel();
                TreeView treeView = (TreeView)this.getControl("treeviewap");
                TreeNode treeNode = AbstractTreeBuilder.getRootWithCache((TreeView)treeView).getTreeNode(this.getView().getPageCache().get("selectModelId"));
                treeView.focusNode(treeNode);
                treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
                this.getPageCache().remove(WILL_SELECT_MODEL_CACHE);
            }
        }
    }

    public EpbsOperationResult receiveMessage(IContext context) {
        if ("setEntry".equals(context.getOpKey())) {
            List resList = (List)context.getData();
            EpbsOperationResult validate = this.validate(resList);
            if (CollectionUtils.isNotEmpty((Collection)resList) && validate.isSuccess()) {
                int row = this.getModel().createNewEntryRow("entryentity");
                TabInfo selectedTabInfo = this.getTabManager().getSelectedTabInfo();
                AuthTypeTabEnum tabEnum = AuthTypeTabEnum.indexofBizAuthId((Long)((AuthBizBean)selectedTabInfo.getData()).getAuthbiz());
                String val = resList.stream().map(e -> e.getEntityNumber() + "#" + e.getDimNumber()).collect(Collectors.joining(","));
                this.getModel().setValue(tabEnum.name().toLowerCase() + "text", (Object)resList.stream().map(e -> e.getName()).collect(Collectors.joining(";")), row);
                if (this.getAuthType() == AuthTypeEnum.BIZ) {
                    this.formatBizTypeRow(row);
                    String authsetvalue = (String)this.getModel().getValue("authsetvalue", row);
                    val = authsetvalue.split(",")[0] + "," + val;
                }
                this.getModel().setValue("group", (Object)GlobalIdUtil.genGlobalLongId(), row);
                this.getModel().setValue("hasperm", (Object)"0", row);
                this.getModel().setValue("authsetvalue", (Object)val, row);
                this.getView().updateView("entryentity");
                this.getModel().setValue("authbiztype", (Object)selectedTabInfo.getName(), row);
                this.getView().updateView("entryentity");
                this.getModel().setDataChanged(true);
            }
            return validate;
        }
        return new EpbsOperationResult();
    }

    private EpbsOperationResult validate(Collection<AuthSetDetailBean> resList) {
        TabInfo selectedTabInfo = this.getTabManager().getSelectedTabInfo();
        AuthTypeTabEnum tabEnum = AuthTypeTabEnum.indexofBizAuthId((Long)((AuthBizBean)selectedTabInfo.getData()).getAuthbiz());
        if (this.getAuthType() != AuthTypeEnum.BIZ && CollectionUtils.isEmpty(resList)) {
            if (tabEnum == AuthTypeTabEnum.ADMIN_BIZ) {
                return new EpbsOperationResult(false, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u8bb0\u5f55\u6570\u636e\uff0c\u7136\u540e\u786e\u5b9a\u3002", (String)"AuthSetFormPlugin_12", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
            return new EpbsOperationResult(false, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u6570\u636e\uff0c\u7136\u540e\u786e\u5b9a\u3002", (String)"AuthSetFormPlugin_14", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        if (((AuthBizBean)selectedTabInfo.getData()).getAuthbiz() == AuthTypeTabEnum.Multi_DIM.getBizId() && resList.size() < 2) {
            return new EpbsOperationResult(false, ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408\u5fc5\u987b\u591a\u9009\uff0c\u4e0d\u53ef\u5355\u9009\u6216\u4e0d\u9009\u3002", (String)"AuthSetFormPlugin_13", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        LinkedHashMap dim2BinaryMap = new LinkedHashMap(16);
        int sum = resList.stream().mapToInt(e -> dim2BinaryMap.computeIfAbsent(e.getEntityNumber() + "#" + e.getDimNumber(), k -> 1 << dim2BinaryMap.size())).sum();
        DynamicObjectCollection dys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        int skip = this.getAuthType() == AuthTypeEnum.BIZ ? 1 : 0;
        ArrayList list = new ArrayList(10);
        Optional<EpbsOperationResult> option = dys.stream().filter(dy -> {
            String val = dy.getString("authsetvalue");
            if (StringUtils.isNotEmpty((String)val)) {
                int tempsum = Arrays.stream(val.split(",")).skip(skip).mapToInt(a -> dim2BinaryMap.computeIfAbsent(a, k -> 1 << dim2BinaryMap.size())).sum();
                list.add(tempsum);
                if (tempsum == 0 && sum == 0 || tempsum > 0 && sum > 0 && ((tempsum & sum) == sum || (tempsum & sum) == tempsum)) {
                    return true;
                }
            }
            return false;
        }).map(e -> new EpbsOperationResult(false, ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u6570\u636e\u5b58\u5728\u91cd\u590d\u6027\uff0c\u4e0d\u53ef\u5f55\u5165\u3002", (String)"AuthSetFormPlugin_15", (String)"epm-epbs-formplugin", (Object[])new Object[0]))).findFirst();
        if (option.isPresent()) {
            return option.get();
        }
        if (resList.size() > 2) {
            if ((list.stream().mapToInt(e -> e).sum() & sum) == sum) {
                return new EpbsOperationResult(false, ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u6570\u636e\u5b58\u5728\u5faa\u73af\u5f15\u7528\uff0c\u4e0d\u53ef\u5f55\u5165\u3002", (String)"AuthSetFormPlugin_17", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
            String[] keys = dim2BinaryMap.keySet().toArray(new String[0]);
            List collect = list.stream().map(e -> e & sum).filter(e -> !dim2BinaryMap.values().contains(e)).collect(Collectors.toList());
            if (!collect.isEmpty()) {
                return new EpbsOperationResult(false, ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u6570\u636e\u540c\u65f6\u5b58\u5728\u4e24\u4e2a\u7ef4\u5ea6\u7ec4\u5408\u4ee5\u4e0a\u76f8\u540c\u7684\u6570\u636e\uff0c\u4e0d\u53ef\u5f55\u5165\u3002", (String)"AuthSetFormPlugin_16", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
        }
        return new EpbsOperationResult();
    }
}

