/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.data.authset;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.multilingual.MetadataKsqlBuilder;
import kd.epm.epbs.business.permission.data.AuthSetDetailBean;
import kd.epm.epbs.business.permission.util.AuthSetUtils;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.enums.AuthTypeEnum;
import kd.epm.epbs.common.util.AppUtils;
import kd.epm.epbs.formplugin.permission.data.authset.IAuthSetF7Plugin;

public class AuthTypeSetListPlugin
extends AbstractListPlugin
implements IAuthSetF7Plugin {
    @Override
    public void initialize() {
        super.initialize();
        IAuthSetF7Plugin.super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("btn_bizset".equals(evt.getItemKey()) || "btn_adminset".equals(evt.getItemKey()) || "btn_dimset".equals(evt.getItemKey())) {
            if (!this.validate()) {
                return;
            }
            AuthTypeEnum authTypeEnum = Arrays.stream(AuthTypeEnum.values()).filter(e -> evt.getItemKey().contains(e.name().toLowerCase())).findFirst().orElseGet(() -> AuthTypeEnum.DIM);
            AuthSetUtils.openF7((IFormView)this.getView(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, "authset"), (AuthTypeEnum)authTypeEnum, e -> {
                e.setCustomParam("fromSource", (Object)"1");
                e.setCustomParam("appnum", (Object)this.getSelectRow().getString("appnum"));
            });
        } else if ("btn_exportksql".equals(evt.getItemKey()) && this.validate()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5168\u91cf\u5bfc\u51fa(\u662f\uff1a\u6309\u5e94\u7528\u5bfc\u51fa\uff1b\u5426\uff1a\u6309\u52fe\u9009\u8bb0\u5f55\u5bfc\u51fa)", (String)"AuthTypeSetListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, new ConfirmCallBackListener("exportksql", (IFormPlugin)this));
        }
    }

    private boolean validate() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u9009\u9ed8\u8ba4\u8bbe\u7f6e\u3002", (String)"AuthTypeSetListPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bb0\u5f55\u3002", (String)"AuthTypeSetListPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private DynamicObject getSelectRow() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        return BusinessDataServiceHelper.loadSingle((Object)selectedRows.getPrimaryKeyValues()[0], (String)"epbs_auth_bizset");
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if ("exportksql".equals(event.getCallBackId())) {
            MessageBoxResult res = event.getResult();
            if (MessageBoxResult.Cancel == res) {
                return;
            }
            QFilter qf = null;
            if (MessageBoxResult.Yes == res) {
                qf = new QFilter("appnum", "=", (Object)this.getSelectRow().getString("appnum"));
                this.getView().download(new MetadataKsqlBuilder("epbs_auth_set").setFilter(new QFilter[]{new QFilter("model", "=", (Object)0L), qf}).genKsqlDownloadUrl());
            } else if (MessageBoxResult.No == res) {
                qf = new QFilter("id", "=", (Object)this.getSelectRow().getLong("id"));
            }
            this.getView().download(new MetadataKsqlBuilder("epbs_auth_bizset").setFilter(qf == null ? null : qf.toArray()).genKsqlDownloadUrl());
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getActionId().equals("authset") && event.getReturnData() != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AuthTypeSetListPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            BillList control = (BillList)this.getControl("billlistap");
            control.refresh();
        }
    }

    @Override
    public Collection<AuthSetDetailBean> formatAuthSetRecord(ListSelectedRowCollection cols) {
        return QueryServiceHelper.query((String)((ListView)this.getView()).getBillFormId(), (String)"id,name,number,entitynumber", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)cols.getPrimaryKeyValues())}).stream().map(e -> new AuthSetDetailBean(e.getString("entitynumber"), e.getString("number"), e.getString("name"))).collect(Collectors.toList());
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        final IFormView view = this.getView();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public void setListFields(List<ListField> listFields) {
                String appnums = (String)view.getFormShowParameter().getCustomParam("appnums");
                List list = null;
                if (StringUtils.isNotEmpty((String)appnums)) {
                    list = Arrays.stream(appnums.split(",")).map(e -> AppTypeEnum.getEnumByAppnum((String)e)).filter(e -> e != null).collect(Collectors.toList());
                }
                ListField listField = listFields.stream().filter(e -> Objects.equals("appnum", e.getKey())).findFirst().orElseGet(() -> null);
                AppUtils.buildValueMapItems((ListField)listField, list);
                super.setListFields(listFields);
            }
        });
    }
}

