/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.data.authset;

import java.util.Collection;
import java.util.function.Consumer;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.epm.epbs.business.permission.data.AuthSetDetailBean;
import kd.epm.epbs.business.spi.IPluginProviderService;
import kd.epm.epbs.common.bean.EpbsContext;
import kd.epm.epbs.common.bean.IContext;
import kd.epm.epbs.common.util.EpbsOperationResult;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.formplugin.permission.data.authset.AuthSetF7Helper;

public interface IAuthSetF7Plugin
extends IPluginProviderService {
    default public void initialize() {
        AuthSetF7Helper.isFormPermControl(this.getView(), k -> {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.addSetFilterListener(setFilterEvent -> AuthSetF7Helper.isFormPermControl(this.getView(), a -> this.setAuthSetQFilter(AuthSetF7Helper.isDefaultSet(this.getView()), setFilterEvent)));
            billList.addListRowDoubleClickListener(new ListRowClickListener(){

                public void listRowDoubleClick(ListRowClickEvent evt) {
                    IAuthSetF7Plugin.this.sendResult(k -> evt.setCancel(true));
                }
            });
            Control c = this.getView().getControl("btnok");
            if (c instanceof ISuportClick) {
                ((ISuportClick)c).addClickListener(new ClickListener(){

                    public void beforeClick(BeforeClickEvent evt) {
                        IAuthSetF7Plugin.this.sendResult(k -> evt.setCancel(true));
                    }
                });
            }
        });
    }

    default public void setAuthSetQFilter(boolean isDefaultSet, SetFilterEvent e) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (!billList.getBillFormId().equals("epbs_auth_bizset")) {
            Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            if (isDefaultSet) {
                qFilter.and("issysdimension", "=", (Object)"1");
            }
            qFilter.and(AuthSetF7Helper.getDimNumsForQF(isDefaultSet, modelId, this.getView()));
            e.getQFilters().add(qFilter);
        }
    }

    default public void sendResult(Consumer consumer) {
        AuthSetF7Helper.isFormPermControl(this.getView(), k -> {
            EpbsOperationResult res;
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows().getBillListSelectedRowCollection();
            if (!selectedRows.isEmpty() && (res = this.sendMessage("epbs_auth_set_form", (IContext)new EpbsContext("setEntry", this.formatAuthSetRecord(selectedRows)))) != null && !res.isSuccess()) {
                this.getView().showTipNotification(res.getMsg());
                consumer.accept(null);
            }
        });
    }

    public Collection<AuthSetDetailBean> formatAuthSetRecord(ListSelectedRowCollection var1);
}

