/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.data.f7;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.permission.model.ModelPermHelper;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.tree.NoParentDynamicTreeBuilder;
import kd.epm.epbs.formplugin.treelist.TreeListF7Context;
import kd.epm.epbs.formplugin.treelist.TreeListSelectedF7Helper;

public class DataRoleF7Helper {
    public static final String DATAROLE_CLOSEID = "datarolef7";

    public static void openSelectDataRoleF7Page(AbstractFormPlugin formPlugin, Object[] pkIds, boolean isMuilt) {
        TreeListF7Context context = new TreeListF7Context("epbs_dataperm_rolegroup", "epbs_dataperm_role");
        context.setSelectFields("id,name,number");
        context.setTreeBuilderClazz(NoParentDynamicTreeBuilder.class.getName());
        context.setRootQueryAllChilds(true);
        TreeListSelectedF7Helper.createListShowParameter("epbs_dataperm_rolef7", context, (Consumer<ListShowParameter>)((Consumer)listShowParameter -> {
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, DATAROLE_CLOSEID));
            listShowParameter.setMultiSelect(isMuilt);
            if (pkIds != null && pkIds.length > 0) {
                listShowParameter.setSelectedRows(pkIds);
            }
            listShowParameter.getListFilterParameter().getQFilters().add(DataRoleF7Helper.getDataPermRoleF7QFilter());
            formPlugin.getView().showForm((FormShowParameter)listShowParameter);
        }));
    }

    public static QFilter getDataPermRoleF7QFilter() {
        QFilter qf = new QFilter("id", "not in", DataRoleF7Helper.getNoPermDataRoleIds());
        qf.and("type", "=", (Object)"0");
        return qf;
    }

    public static Collection<Long> getNoPermDataRoleIds() {
        Set limitedModelListByUser = ModelPermHelper.getLimitedModelListByUser((AppTypeEnum[])new AppTypeEnum[0]);
        QFilter qf = new QFilter("model", "not in", (Object)limitedModelListByUser);
        qf.and("entitynumber", "=", (Object)"epbs_model");
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"epbs_dataperm_tree", (String)"id,role_id", (QFilter[])qf.toArray());
        return dys.stream().map(e -> e.getLong("role_id")).collect(Collectors.toSet());
    }

    public static Optional<String> checkRoleUseNoPerms(Collection<Long> roleIds) {
        Set adminModelIds = ModelPermHelper.getLimitedModelListByUser((AppTypeEnum[])new AppTypeEnum[0]);
        if (!adminModelIds.isEmpty()) {
            QFilter qFilter = new QFilter("role", "in", roleIds);
            qFilter.and("entitynumber", "=", (Object)"epbs_model");
            Map collect = QueryServiceHelper.query((String)"epbs_dataperm_tree", (String)"model,role_id", (QFilter[])qFilter.toArray()).stream().filter(e -> !adminModelIds.contains(e.getLong("model"))).collect(Collectors.groupingBy(dy -> dy.getLong("model"), Collectors.mapping(e -> e.getLong("role_id"), Collectors.toList())));
            if (!collect.isEmpty()) {
                String msg = QueryServiceHelper.query((String)"epbs_model", (String)"name", (QFilter[])new QFilter("id", "in", collect.keySet()).toArray()).stream().map(e -> e.getString("name")).collect(Collectors.joining(","));
                return Optional.of(ResManager.loadKDString((String)"\u89d2\u8272\u5b58\u5728\u4f53\u7cfb\u3010%s\u3011\u65e0\u7ba1\u7406\u6743\uff0c\u65e0\u64cd\u4f5c\u6743\u9650\u3002", (String)"DataRoleF7Helper_1", (String)"epm-epbs-formplugin", (Object[])new Object[]{msg}));
            }
        } else {
            return Optional.of(ResManager.loadKDString((String)"\u89d2\u8272\u65e0\u7ba1\u7406\u6743\uff0c\u65e0\u64cd\u4f5c\u6743\u9650\u3002", (String)"DataRoleF7Helper_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    public static Optional<String> checkRoleUseNoPerm(long roleId) {
        return DataRoleF7Helper.checkRoleUseNoPerms(Collections.singleton(roleId));
    }

    public static boolean checkRoleUsePerm(long roleId, IFormView view) {
        Optional<String> optional = DataRoleF7Helper.checkRoleUseNoPerm(roleId);
        if (optional.isPresent()) {
            view.showErrorNotification(optional.get());
        }
        return !optional.isPresent();
    }

    public static void openAssignUserForm(boolean isGroup, String itemKey, Long dataRoleId, AbstractFormPlugin plugin) {
        if (DataRoleF7Helper.checkRoleUsePerm(dataRoleId, plugin.getView())) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setStatus(OperationStatus.EDIT);
            formShowParameter.setFormId("epbs_dataperm_role2user");
            formShowParameter.setHasRight(true);
            formShowParameter.setCustomParam("isGroup", (Object)isGroup);
            formShowParameter.setCustomParam("datarole", (Object)dataRoleId);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, itemKey));
            plugin.getView().showForm(formShowParameter);
        }
    }
}

