/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.fun;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.permission.model.ModelPermHelper;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.util.AppUtils;
import org.apache.commons.collections4.CollectionUtils;

public interface CommonPermService {
    default public void initFormShowParameter(PreOpenFormEventArgs e) {
        e.getFormShowParameter().setCustomParam("FormShowParam_appNum", (Object)String.join((CharSequence)",", this.getAppNums(e)));
        e.getFormShowParameter().setCustomParam("FormShowParam_dimension", (Object)"DIM_EPBS_MODEL");
    }

    default public Collection<String> getAppNums(PreOpenFormEventArgs e) {
        Collection<String> appNums;
        String appId = e.getFormShowParameter().getAppId();
        AppTypeEnum appType = AppTypeEnum.getEnumByAppnum((String)appId);
        boolean isAdmin = true;
        Set modelScope = null;
        switch (appType) {
            case RPT: {
                appNums = Lists.newArrayList((Object[])new String[]{appId});
                modelScope = ModelPermHelper.getLimitedModelListByUser((AppTypeEnum[])new AppTypeEnum[]{AppTypeEnum.RPT, AppTypeEnum.CM});
                break;
            }
            case EPBS: {
                appNums = AppUtils.getAppNumsByMetadataCache().stream().filter(a -> !AppTypeEnum.isCMApp((String)a) && !AppTypeEnum.isEbApp((String)a)).collect(Collectors.toList());
                appNums.add(AppTypeEnum.EPBS.getAppNum());
                appNums.remove(AppTypeEnum.RPT.getAppNum());
                AppTypeEnum[] array = (AppTypeEnum[])appNums.stream().map(a -> AppTypeEnum.getEnumByAppnum((String)a)).toArray(AppTypeEnum[]::new);
                modelScope = ModelPermHelper.getLimitedModelListByUser((AppTypeEnum[])array);
                Collections.swap((List)appNums, ((List)appNums).indexOf(AppTypeEnum.EPBS.getAppNum()), 0);
                break;
            }
            default: {
                appNums = Collections.emptyList();
            }
        }
        String tip = CollectionUtils.isNotEmpty(modelScope) ? null : ResManager.loadKDString((String)"\u8be5\u7528\u6237\u4e0d\u662f\u4f53\u7cfb\u7ba1\u7406\u5458\uff0c\u65e0\u6743\u9650\u64cd\u4f5c", (String)"CommonPermService_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
        e.getFormShowParameter().setCustomParam("formShowParm_show_unableInfo", (Object)tip);
        e.getFormShowParameter().setCustomParam("FormShowParam_ShowForSpecialUser", (Object)Boolean.toString(isAdmin));
        if (modelScope != null && !modelScope.isEmpty()) {
            Set set = modelScope.stream().map(Object::toString).collect(Collectors.toSet());
            e.getFormShowParameter().setCustomParam("CustomFilter_DimObjIds", (Object)SerializationUtils.toJsonString((Object)modelScope));
            e.getFormShowParameter().setCustomParam("FormShowParam_dimensionObjIds", (Object)String.join((CharSequence)",", set));
            e.getFormShowParameter().setCustomParam("FormShowParam_curDimNullShow", (Object)"0");
        }
        return appNums;
    }

    default public boolean addPermByModel(String modelId, Map<String, List<String>> entityPermItemMap, String userId) {
        DynamicObjectCollection old = QueryServiceHelper.query((String)"perm_userperm", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.valueOf(modelId)), new QFilter("user", "=", (Object)Long.valueOf(userId))});
        DynamicObject userPermObj = null;
        if (old != null && old.size() > 0) {
            String id = ((DynamicObject)old.get(0)).getString("id");
            userPermObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"perm_userperm");
        } else {
            userPermObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userperm");
            userPermObj.set("org", (Object)modelId);
            userPermObj.set("user", (Object)userId);
        }
        DynamicObjectCollection userPermEntry = userPermObj.getDynamicObjectCollection("entryentity");
        for (Map.Entry<String, List<String>> entry : entityPermItemMap.entrySet()) {
            ArrayList pitems = new ArrayList(entry.getValue());
            for (int i = 0; i < userPermEntry.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)userPermEntry.get(i);
                if (!entry.getKey().equals(dynamicObject.getString("entitytype.id")) || !pitems.contains(dynamicObject.getString("permitem.id"))) continue;
                pitems.remove(pitems.indexOf(dynamicObject.getString("permitem.id")));
                if (pitems.size() == 0) break;
            }
            for (String permitemId : pitems) {
                DynamicObject newRow = new DynamicObject(userPermEntry.getDynamicObjectType());
                newRow.set("entitytype", (Object)entry.getKey());
                newRow.set("permitem", (Object)permitemId);
                newRow.set("controlmode", (Object)"10");
                userPermEntry.add((Object)newRow);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userPermObj});
        return true;
    }
}

