/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.fun;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.formplugin.plugin.RoleEditNewPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.log.funperm.FunctionPermLogHelper;
import kd.epm.epbs.business.log.funperm.FunctionPermLogMultiLangEnum;
import kd.epm.epbs.business.log.funperm.RoleStatusChangeHandler;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;
import kd.epm.epbs.formplugin.permission.fun.util.EpbsAllFuncPermTreeUtil;
import kd.epm.epbs.formplugin.permission.fun.util.NewEbAppUtil;

public class EpbsRoleEditNewPlugin
extends RoleEditNewPlugin {
    private static final WatchLogger log = EpbsLogFactory.getWatchLogInstance(EpbsRoleEditNewPlugin.class);
    private static final String PERMITEMMAP_CACHE = "permItemMap";
    private static final String nodeMapTreeOldCache = "nodeMap$tree_funcpermOld";
    private static final String currentNodeMapTreeCache = "nodeMap$tree_funcperm";
    private static final String PERM_CACHE_LIST = "role_perm_cache_list";
    private static Long RoleModelId = 17299999999L;

    public void initialize() {
        this.initialVariable();
        String showOldEb = (String)this.getView().getFormShowParameter().getCustomParam("showOldEb");
        this.allFuncPermTreeUtil = new EpbsAllFuncPermTreeUtil(this.allFuncPermTreeView, this.permPageCacheUtil.get("FormShowParam_appNum"), this.getPermDimType(), true, !"true".equals(showOldEb) && NewEbAppUtil.isNewEb());
        this.addListener();
        this.initializeDataPermCache();
        if (StringUtils.isEmpty((String)this.getPageCache().get(PERMITEMMAP_CACHE))) {
            this.initPermKeys();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        this.getPageCache().put(PERM_CACHE_LIST, SerializationUtils.toJsonString(this.getRolePermission()));
    }

    private void initPermKeys() {
        if (StringUtils.isEmpty((String)this.getPageCache().get(PERMITEMMAP_CACHE))) {
            HashMap map1 = new HashMap(1500);
            BusinessDataServiceHelper.loadFromCache((String)"perm_permitem", (String)"number,name", (QFilter[])new QFilter[0]).values().stream().forEach(k -> map1.put(k.getString("id"), k.getString("name")));
            this.getPageCache().put(PERMITEMMAP_CACHE, SerializationUtils.toJsonString(map1));
        }
    }

    protected void initializeDataPermCache() {
        super.initializeDataPermCache();
        this.setPermCache();
    }

    private String getPermDimType() {
        String permDimType = this.permPageCacheUtil.get("FormShowParam_dimension");
        if (StringUtils.isEmpty((String)permDimType) && StringUtils.isEmpty((String)(permDimType = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_dimension_edit")))) {
            IFormView parentView;
            permDimType = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_dimension");
            if (StringUtils.isEmpty((String)permDimType) && (parentView = this.getView().getParentView()) != null) {
                permDimType = (String)parentView.getFormShowParameter().getCustomParam("FormShowParam_dimension");
            }
            if (StringUtils.isEmpty((String)permDimType)) {
                permDimType = "bos_org";
            }
        }
        return permDimType;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        Boolean success = Boolean.FALSE;
        OperationResult operationResult = e.getOperationResult();
        if (e.getOperationResult() != null) {
            success = operationResult.isSuccess();
        }
        String number = this.getModel().getDataEntity().getString("number");
        Object name = this.getModel().getDataEntity().get("name");
        String remark = number + " " + name + ",";
        if ("enable".equalsIgnoreCase(e.getOperateKey()) || "disable".equalsIgnoreCase(e.getOperateKey())) {
            OperationTypeEnum status;
            boolean isenable = "enable".equalsIgnoreCase(e.getOperateKey());
            OperationTypeEnum operationTypeEnum = status = isenable ? OperationTypeEnum.ENABLE : OperationTypeEnum.DISABLE;
            if (success.booleanValue()) {
                RoleStatusChangeHandler.logHandler((Collection)Sets.newHashSet((Object[])new Object[]{this.getModel().getDataEntity().get("id")}), (boolean)isenable, (String)this.getView().getFormShowParameter().getAppId());
                OperationLogUtil.writeLog((String)this.getView().getEntityId(), (IOperationTypeInfo)status, (MultiLangEnumBridge)OperationMsgUtil.getSaveSucTipWithNumber((String)number));
            } else {
                OperationLogUtil.writeLog((String)this.getView().getEntityId(), (IOperationTypeInfo)status, (MultiLangEnumBridge)OperationMsgUtil.getSaveFialTipWithNumber((String)number));
            }
        }
        if ("save".equalsIgnoreCase(e.getOperateKey())) {
            if (success.booleanValue()) {
                this.writePermLogs();
                OperationLogUtil.writeLog((String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.SAVE, (MultiLangEnumBridge)OperationMsgUtil.getSaveSucTipWithNumber((String)number));
            } else {
                OperationLogUtil.writeLog((String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.SAVE, (MultiLangEnumBridge)OperationMsgUtil.getSaveFialTipWithNumber((String)number));
            }
        }
    }

    protected void writePermLogs() {
        String usernumber = this.getModel().getValue("number").toString();
        String username = this.getModel().getValue("name").toString();
        if (StringUtils.isEmpty((String)usernumber) || StringUtils.isEmpty((String)username)) {
            return;
        }
        String permItemMapString = this.getPageCache().get(PERMITEMMAP_CACHE);
        if (permItemMapString == null) {
            return;
        }
        Map permItemMap = (Map)SerializationUtils.fromJsonString((String)permItemMapString, Map.class);
        List nodeMapOld = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(PERM_CACHE_LIST), List.class);
        List<String> nodeMapNew = this.getRolePermission();
        ArrayList nodeMapOldTemp = Lists.newArrayListWithCapacity((int)nodeMapOld.size());
        Collections.addAll(nodeMapOldTemp, new String[nodeMapOld.size()]);
        Collections.copy(nodeMapOldTemp, nodeMapOld);
        ArrayList addMapNewTemp = Lists.newArrayListWithCapacity((int)nodeMapNew.size());
        Collections.addAll(addMapNewTemp, new String[nodeMapNew.size()]);
        Collections.copy(addMapNewTemp, nodeMapNew);
        nodeMapOld.removeAll(nodeMapNew);
        addMapNewTemp.removeAll(nodeMapOldTemp);
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>();
        if (nodeMapOld.size() > 0) {
            this.setLogs(logs, usernumber, username, permItemMap, nodeMapOld, 0);
        }
        if (addMapNewTemp.size() > 0) {
            this.setLogs(logs, usernumber, username, permItemMap, addMapNewTemp, 1);
        }
        if (logs.size() > 0) {
            try {
                FunctionPermLogHelper.batchInsertFunctionPermLog(logs);
                this.clearPermCache();
                this.setPermCache();
                this.getPageCache().put(PERM_CACHE_LIST, SerializationUtils.toJsonString(nodeMapNew));
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
        }
    }

    private String getPermEntity(String permItemString) {
        return permItemString.split("\\|")[0];
    }

    private String getPermItem(String permItemString) {
        String[] first = permItemString.split("\\|");
        return first[1].split("@")[0];
    }

    private void setLogs(ArrayList<DynamicObject> logs, String usernumber, String username, Map<String, String> permItemMap, List<String> nodeMap, int operatType) {
        String appId = this.getView().getFormShowParameter().getAppId();
        for (String permitem : nodeMap) {
            String entityNumber = this.getPermEntity(permitem);
            String permNumber = this.getPermItem(permitem);
            String entityName = "";
            try {
                entityName = MetadataServiceHelper.getDataEntityType((String)entityNumber).getDisplayName().getLocaleValue();
            }
            catch (KDException e) {
                log.error("MetadataServiceHelper.getDataEntityType is failed on SetLogs");
                continue;
            }
            String opration = FunctionPermLogMultiLangEnum.RoleEite_DelDistribute.getOperateName();
            if (operatType == 1) {
                opration = FunctionPermLogMultiLangEnum.RoleEite_Distribute.getOperateName();
            }
            DynamicObject log1 = FunctionPermLogHelper.newFunctionPermLog((Long)RoleModelId, (String)usernumber, (String)username, (String)entityName, (String)permItemMap.get(permNumber), (String)"", (String)opration, (String)appId);
            logs.add(log1);
        }
    }

    private void clearPermCache() {
        this.getPageCache().remove(nodeMapTreeOldCache);
    }

    protected String getPageNumber() {
        return "epbs_perm_role";
    }

    private void setPermCache() {
        String pageId = this.getView().getPageId();
        if (pageId != null && !pageId.contains(this.getPageNumber()) && StringUtils.isEmpty((String)this.getPageCache().get("isHavCreated")) && this.getPageCache().get(nodeMapTreeOldCache) == null) {
            this.getPageCache().put(nodeMapTreeOldCache, "{}");
            this.getPageCache().put("isHavCreated", "1");
            return;
        }
        if (this.getPageCache().get(nodeMapTreeOldCache) == null && this.getPageCache().get(currentNodeMapTreeCache) != null) {
            this.getPageCache().put(nodeMapTreeOldCache, this.getPageCache().get(currentNodeMapTreeCache));
        }
    }

    private List<String> getRolePermission() {
        String roleId = (String)this.getModel().getDataEntity().getPkValue();
        DynamicObject role = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_roleperm", (QFilter[])new QFilter[]{new QFilter("roleid", "=", (Object)roleId)});
        if (Objects.isNull(role)) {
            return Collections.EMPTY_LIST;
        }
        String fid = role.getString("id");
        return (List)DB.query((DBRoute)DBRoute.permission, (String)String.format("select fpermitemid,fentitytypeid from t_perm_rolepermdetial  where fid = '%s'", fid), rs -> {
            ArrayList res = Lists.newArrayListWithCapacity((int)100);
            while (rs.next()) {
                res.add(rs.getString("fentitytypeid") + "|" + rs.getString("fpermitemid"));
            }
            return res;
        });
    }
}

