/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.fun;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.Algo;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.enums.PermCtrlTypeEnum;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class EpbsSystemPermData
extends AbstractReportListDataPlugin {
    private static final Log log = LogFactory.getLog(EpbsSystemPermData.class);
    private static final String DIM_DM_MODEL = "DIM_DM_MODEL";
    private static final String DIM_EPM_MODEL = "DIM_EPM_MODEL";
    private static final String DM_MODEL = "fidm_model";
    private final String algoKey = ((Object)((Object)this)).getClass().getName();
    private static final String ID = "id";
    private static final String ISBYUSER = "isbyuser";
    private static final String MODEL = "model";
    private static final String USERS = "users";
    private static final String APPID = "appid";
    private static final String USERNUMBER = "usernumber";
    private static final String USERID = "userid";
    private static final String USERNAME = "username";
    private static final String ENTITYNAME = "entityname";
    private static final String PERMITEMID = "permitemid";
    private static final String PERMITEMNAME = "permitemname";
    private static final String SOURCEROLE = "sourcerole";
    private static final String TEMPID = "tempid";
    private static final String SOURCEUSERNAME = "sourceusername";
    private static final String ROLEREMARK = "roleremark";
    private static final String ROLENUMBER = "rolenumber";
    private static final String ROLENAME = "rolename";
    private static final String ROLEID = "roleid";
    private static final String DIMTYPE = "dimtype";
    private static final String BIZAPP = "bizapp";
    private static final String ORG = "org";
    private static final String USER_ID = "user.id";
    private static final String PERMITEM_ID = "permitem.id";
    private static final String PERM_DISFUNPERM = "perm_disfunperm";
    private static final String ISDISABLED = "isdisabled";
    private static final String SOURCEUSERNUMBER = "sourceusernumber";
    private static final String MODELNUMBER = "modelnumber";
    private static final String ROLE_ID = "role.id";
    private static final String ROLEPERM_BIZAPP = "roleperm.bizapp";
    private static final String ROLE_BIZDOMAIN = "role.bizdomain";
    private static final String PERM_USERROLE = "perm_userrole";
    private static final String PERM_ROLEPERM = "perm_roleperm";
    private static final String PERMITEMSEL = "permitemsel";
    private static final String ROLES = "roles";
    private static final String PERM_USERPERM = "perm_userperm";
    private static final String ENTRYENTITY_BIZAPP = "entryentity.bizapp";
    private static final String SEPARATOR = ";\n";
    private static final String BYUSER = "byuser";
    private static final String PERMITEMIDEXPRESSION = "entitynumber+' '+'('+permitemid+')' as permitemid";
    private static final String TEMPIDEXPRESSION = "cast(userid as String)+'_'+entitynumber+'_'+permitemid as tempid";
    private static final String START_TIME_EXPRESSION = "case when starttime is null then '' else rolenumber+':' +cast(starttime as String) end as rolestarttime";
    private static final String END_TIME_EXPRESSION = "case when endtime is null then '' else rolenumber+':' + cast(endtime as String) end as roleendtime";
    private static final String ROLE_START_TIME = "rolestarttime";
    private static final String ROLE_END_TIME = "roleendtime";
    private static final String START_TIME = "starttime";
    private static final String END_TIME = "endtime";
    private int maxCount = Integer.MAX_VALUE;
    private int resCount = 0;

    private boolean getSystemParam(String key) {
        AppParam appParam = new AppParam();
        appParam.setAppId(AppMetadataCache.getAppInfoByNumber((String)"base").getId());
        appParam.setViewType("15");
        appParam.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        appParam.setActBookId(Long.valueOf(0L));
        Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        return MapUtils.isNotEmpty((Map)paramMap) && Boolean.parseBoolean(paramMap.get(key).toString());
    }

    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        FilterInfo filterInfo = queryParam.getFilter();
        long modelId = filterInfo.getDynamicObject(MODEL).getLong(ID);
        if (modelId == 0L) {
            return this.returnEmptyDataSet();
        }
        DynamicObjectCollection users = filterInfo.getDynamicObjectCollection(USERS);
        List<Long> userIds = null;
        if (users != null && !users.isEmpty()) {
            userIds = this.getIdList(users);
        }
        DynamicObjectCollection roles = filterInfo.getDynamicObjectCollection(ROLES);
        List<String> roleIds = null;
        if (roles != null && !roles.isEmpty()) {
            roleIds = this.getIdStirngList(roles);
        }
        DynamicObjectCollection permitemsels = filterInfo.getDynamicObjectCollection(PERMITEMSEL);
        List<String> permIds = null;
        if (permitemsels != null && !permitemsels.isEmpty()) {
            permIds = this.getIdStirngList(permitemsels);
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epbs_model", (String)"shownumber,srcappnum", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)modelId)});
        String modelShowNumber = "";
        String appNum = "";
        if (dynamicObject != null) {
            modelShowNumber = dynamicObject.getString("shownumber");
            appNum = AppTypeEnum.BG.getAppNum().equals(dynamicObject.getString("srcappnum")) ? AppTypeEnum.EB.getAppNum() : dynamicObject.getString("srcappnum");
        }
        String isbyuser = (String)queryParam.getCustomParam().get(ISBYUSER);
        if (filterInfo.getDynamicObject(MODEL) == null) {
            return null;
        }
        ArrayList<String> appIds = new ArrayList<String>();
        appIds.add(AppMetadataCache.getAppInfoByNumber((String)AppTypeEnum.EPBS.getAppNum()).getId());
        appIds.add(AppMetadataCache.getAppInfoByNumber((String)appNum).getId());
        ArrayList<String> dimTypes = new ArrayList<String>();
        dimTypes.add(PermCtrlTypeEnum.DIM_EPBS_MODEL.name());
        dimTypes.add(PermCtrlTypeEnum.DIM_EPBS_MODEL.getBizObjectId());
        if (AppTypeEnum.isCMApp((String)appNum)) {
            dimTypes.add(PermCtrlTypeEnum.DIM_BCM_MODEL.name());
            dimTypes.add(PermCtrlTypeEnum.DIM_BCM_MODEL.getBizObjectId());
        } else if (AppTypeEnum.isFarApp((String)appNum)) {
            dimTypes.add(PermCtrlTypeEnum.DIM_DM_MODEL.name());
            dimTypes.add(PermCtrlTypeEnum.DIM_DM_MODEL.getBizObjectId());
        } else {
            dimTypes.add(PermCtrlTypeEnum.DIM_EPM_MODEL.name());
            dimTypes.add(PermCtrlTypeEnum.DIM_EPM_MODEL.getBizObjectId());
        }
        if (StringUtils.equals((CharSequence)BYUSER, (CharSequence)isbyuser)) {
            return this.querySysPermByUser(modelId, userIds, permIds, appIds, modelShowNumber, dimTypes);
        }
        return this.querySysPermByRole(modelId, roleIds, permIds, appIds, modelShowNumber, dimTypes);
    }

    private DataSet querySysPermByUser(Long modelId, List<Long> userIds, List<String> permIds, List<String> appIds, String modelShowNumber, List<String> dimTypes) {
        int mCount;
        DataSet userRoleDetail;
        DataSet result;
        block61: {
            result = null;
            QFilter directPermFilter = new QFilter(DIMTYPE, "in", dimTypes);
            directPermFilter.and(ENTRYENTITY_BIZAPP, "in", appIds);
            directPermFilter.and("org.id", "=", (Object)modelId);
            if (userIds != null && !userIds.isEmpty()) {
                directPermFilter.and(USER_ID, "in", userIds);
            }
            if (permIds != null && !permIds.isEmpty()) {
                directPermFilter.and("entryentity.permitem.id", "in", permIds);
            }
            String userPermSelectFields = "id,org.id as sysid,user.id as userid,user.name as username,user.number as usernumber,entryentity.entitytype.name as entityname,entryentity.permitem.name as permitemname,entryentity.entitytype.number as entitynumber,entryentity.permitem.id as permitemid";
            try (DataSet userPermDataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)PERM_USERPERM, (String)userPermSelectFields, (QFilter[])new QFilter[]{directPermFilter}, null).distinct().select(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, PERMITEMIDEXPRESSION});){
                this.checkCount(userPermDataSet, (boolean)Boolean.TRUE);
                result = userPermDataSet.addField(ResManager.loadKDString((String)"'\u76f4\u63a5\u6388\u6743'", (String)"EpbsSystemPermData_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), SOURCEROLE);
                result = result.select(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, SOURCEROLE, PERMITEMID});
            }
            QFilter userRoleFilter = new QFilter(DIMTYPE, "in", dimTypes);
            userRoleFilter.and(ROLE_BIZDOMAIN, "in", appIds);
            userRoleFilter.and("role.enable", "=", (Object)"1");
            userRoleFilter.and(ORG, "=", (Object)modelId);
            if (userIds != null) {
                userRoleFilter.and(USER_ID, "in", userIds);
            }
            userRoleDetail = null;
            String userRoleSelectFields = "id,role.id as roleid,role.name as rolename,role.number as rolenumber,user.id as userid,user.name as username,user.number as usernumber,starttime,endtime";
            try (DataSet userRole = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)PERM_USERROLE, (String)userRoleSelectFields, (QFilter[])new QFilter[]{userRoleFilter}, null).select(new String[]{ID, ROLEID, ROLENUMBER, USERID, USERNAME, USERNUMBER, START_TIME, END_TIME});){
                HashSet<String> rolesIdSet = new HashSet<String>();
                for (Row row : userRole.copy()) {
                    rolesIdSet.add(row.getString(ROLEID));
                }
                if (rolesIdSet.isEmpty()) break block61;
                this.checkCount(rolesIdSet.size(), (boolean)Boolean.FALSE);
                QFilter roleDetailFilter = new QFilter(ROLEID, "in", rolesIdSet);
                roleDetailFilter.and(ROLEPERM_BIZAPP, "in", appIds);
                if (permIds != null) {
                    roleDetailFilter.and("roleperm.permitem.id", "in", permIds);
                }
                String rolePermSelectFields = "id,roleperm.entity.name as entityname,roleperm.permitem.name as permitemname,roleperm.permitem.id as permitemid,roleperm.entity.number as entitynumber,roleid";
                try (DataSet rolePermDetail = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)PERM_ROLEPERM, (String)rolePermSelectFields, (QFilter[])new QFilter[]{roleDetailFilter}, null);){
                    userRoleDetail = userRole.select(new String[]{USERID, USERNAME, USERNUMBER, ROLENUMBER, ROLEID, START_TIME, END_TIME}).join(rolePermDetail, JoinType.INNER).on(ROLEID, ROLEID).select(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, "rolenumber as sourcerole", PERMITEMIDEXPRESSION, START_TIME_EXPRESSION, END_TIME_EXPRESSION}).finish().distinct().select(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, SOURCEROLE, PERMITEMID, ROLE_START_TIME, ROLE_END_TIME});
                }
            }
        }
        if (userRoleDetail != null && (mCount = userRoleDetail.copy().count(USERID, Boolean.FALSE.booleanValue())) > 0) {
            this.checkCount(mCount, (boolean)Boolean.TRUE);
            result = result.addField("\"\"", ROLE_START_TIME);
            result = result.addField("\"\"", ROLE_END_TIME);
            result = result.union(userRoleDetail).groupBy(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, PERMITEMID}).agg((CustomAggFunction)new GroupConcat(SEPARATOR), SOURCEROLE, SOURCEROLE).agg((CustomAggFunction)new GroupConcat(SEPARATOR), ROLE_START_TIME, ROLE_START_TIME).agg((CustomAggFunction)new GroupConcat(SEPARATOR), ROLE_END_TIME, ROLE_END_TIME).finish().select(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, SOURCEROLE, PERMITEMID, ROLE_START_TIME, ROLE_END_TIME});
        }
        QFilter disfunFilter = new QFilter(DIMTYPE, "in", dimTypes);
        disfunFilter.and(BIZAPP, "in", appIds);
        disfunFilter.and(ORG, "=", (Object)modelId);
        if (userIds != null) {
            disfunFilter.and(USER_ID, "in", userIds);
        }
        if (permIds != null) {
            disfunFilter.and(PERMITEM_ID, "in", permIds);
        }
        String disfunPermSelectFields = "id,user.id as userid,user.name as username,user.number as usernumber,entitytype.name as entityname,permitem.name as permitemname,entitytype.number as entitynumber,permitem.id as permitemid";
        DataSet disfunPerm = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)PERM_DISFUNPERM, (String)disfunPermSelectFields, (QFilter[])new QFilter[]{disfunFilter}, (String)"").distinct().select(new String[]{ID, USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, PERMITEMIDEXPRESSION, "cast(userid as String)+'_'+entitynumber+' '+'('+permitemid+')' as tempid"}).addField("1", ISDISABLED);
        Object object = null;
        try {
            int mCount2 = disfunPerm.copy().count(ID, Boolean.FALSE.booleanValue());
            if (mCount2 > 0) {
                this.checkCount(mCount2, (boolean)Boolean.TRUE);
                result = result.select(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, SOURCEROLE, PERMITEMID, "cast(userid as String)+'_'+permitemid as tempid", ROLE_START_TIME, ROLE_END_TIME});
                result = result.leftJoin(disfunPerm).on(TEMPID, TEMPID).select(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, SOURCEROLE, PERMITEMID, TEMPID, ISDISABLED, ROLE_START_TIME, ROLE_END_TIME}).finish().filter("isdisabled<>1");
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (disfunPerm != null) {
                if (object != null) {
                    try {
                        disfunPerm.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    disfunPerm.close();
                }
            }
        }
        result = result.addField(String.format("\"%s\"", modelShowNumber), MODELNUMBER);
        if (!this.getSystemParam("enablepermvalidatetime")) {
            ArrayList fields = Lists.newArrayList((Object[])result.getRowMeta().getFieldNames());
            if (fields.contains(ROLE_START_TIME)) {
                result = result.removeFields(new String[]{ROLE_START_TIME});
            }
            if (fields.contains(ROLE_END_TIME)) {
                result = result.removeFields(new String[]{ROLE_END_TIME});
            }
        }
        return result;
    }

    private DataSet querySysPermByRole(Long modelId, List<String> roleIds, List<String> permIds, List<String> appIds, String modelShowNumber, List<String> dimTypes) {
        Throwable throwable;
        QFilter userRoleFilter = new QFilter(DIMTYPE, "in", dimTypes).and(ROLE_BIZDOMAIN, "in", appIds).and("role.enable", "=", (Object)"1").and(ORG, "=", (Object)modelId);
        if (roleIds != null) {
            userRoleFilter.and(ROLE_ID, "in", roleIds);
        }
        QFilter roleDetailFilter = new QFilter(ROLEPERM_BIZAPP, "in", appIds);
        if (roleIds != null) {
            roleDetailFilter.and(ROLEID, "in", roleIds);
        }
        if (permIds != null) {
            roleDetailFilter.and("roleperm.permitem.id", "in", permIds);
        }
        DataSet result = null;
        HashSet<Long> userIds = new HashSet<Long>();
        String userRoleSelectFields = "id,role.id as roleid,role.name as rolename,role.number as rolenumber,role.remark as roleremark,user.id as userid,user.name as username,user.number as usernumber";
        try (DataSet userRole = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)PERM_USERROLE, (String)userRoleSelectFields, (QFilter[])new QFilter[]{userRoleFilter}, null).select(new String[]{USERID, "username as sourceusername", "usernumber as sourceusernumber", ROLENAME, ROLENUMBER, ROLEID, ROLEREMARK});){
            throwable = null;
            try (DataSet rolePermDetail = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)PERM_ROLEPERM, (String)"id,roleperm.entity.name as entityname,roleperm.permitem.name as permitemname,roleperm.permitem.id as permitemid,roleperm.entity.number as entitynumber,roleid", (QFilter[])new QFilter[]{roleDetailFilter}, null);){
                for (Row row : userRole.copy()) {
                    userIds.add(row.getLong(USERID));
                }
                this.checkCount(userIds.size(), (boolean)Boolean.FALSE);
                DataSet userRoleDetail = userRole.join(rolePermDetail, JoinType.INNER).on(ROLEID, ROLEID).select(new String[]{USERID, SOURCEUSERNAME, SOURCEUSERNUMBER, ROLEID, ROLENAME, ROLENUMBER, ROLEREMARK, ENTITYNAME, PERMITEMNAME, PERMITEMIDEXPRESSION, TEMPIDEXPRESSION}).finish().distinct();
                this.checkCount(userRoleDetail, (boolean)Boolean.FALSE);
                result = userRoleDetail;
            }
            catch (Throwable userRoleDetail) {
                throwable = userRoleDetail;
                throw userRoleDetail;
            }
        }
        QFilter disFunFilter = new QFilter(DIMTYPE, "in", dimTypes).and(BIZAPP, "in", appIds);
        if (modelId != 0L) {
            disFunFilter.and(ORG, "=", (Object)modelId);
        }
        if (!userIds.isEmpty()) {
            disFunFilter.and(USER_ID, "in", userIds);
        }
        if (permIds != null) {
            disFunFilter.and(PERMITEM_ID, "in", permIds);
        }
        String disFunPermSelectFields = "id,user.id as userid,user.name as username,user.number as usernumber,entitytype.name as entityname,permitem.name as permitemname,entitytype.number as entitynumber,permitem.id as permitemid";
        throwable = null;
        try (DataSet disfunPerm = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)PERM_DISFUNPERM, (String)disFunPermSelectFields, (QFilter[])new QFilter[]{disFunFilter}, (String)"").distinct().select(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, PERMITEMIDEXPRESSION, TEMPIDEXPRESSION}).addField("1", ISDISABLED);){
            int mCount = disfunPerm.copy().count(USERID, Boolean.TRUE.booleanValue());
            if (mCount > 0) {
                this.checkCount(mCount, (boolean)Boolean.TRUE);
                result = result.select(new String[]{USERID, SOURCEUSERNAME, SOURCEUSERNUMBER, ROLENAME, ROLEID, ROLENUMBER, ROLEREMARK, ENTITYNAME, PERMITEMNAME, PERMITEMID, TEMPID});
                result = result.leftJoin(disfunPerm).on(TEMPID, TEMPID).select(new String[]{USERID, SOURCEUSERNAME, SOURCEUSERNUMBER, ROLEID, ROLENAME, ROLENUMBER, ROLEREMARK, ENTITYNAME, PERMITEMNAME, PERMITEMID, TEMPID, "roleid+'_'+permitemid as newtempid", ISDISABLED}).finish().filter("isdisabled<>1");
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        result = result.distinct().groupBy(new String[]{ROLENAME, ROLENUMBER, ROLEREMARK, ENTITYNAME, PERMITEMNAME, PERMITEMID}).agg((CustomAggFunction)new GroupConcat(SEPARATOR), SOURCEUSERNAME, SOURCEUSERNAME).agg((CustomAggFunction)new GroupConcat(SEPARATOR), SOURCEUSERNUMBER, SOURCEUSERNUMBER).finish().addField("\"" + modelShowNumber + "\"", MODELNUMBER);
        return result;
    }

    private DataSet returnEmptyDataSet() {
        ArrayList coll = new ArrayList();
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[0], (DataType[])new DataType[0]);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private List<Long> getIdList(DynamicObjectCollection objList) {
        ArrayList<Long> idList = new ArrayList<Long>(objList.size());
        for (DynamicObject object : objList) {
            idList.add(object.getLong(ID));
        }
        return idList;
    }

    private List<String> getIdStirngList(DynamicObjectCollection objList) {
        ArrayList<String> idList = new ArrayList<String>(objList.size());
        for (DynamicObject object : objList) {
            idList.add(object.getString(ID));
        }
        return idList;
    }

    private void checkCount(DataSet ds, boolean isAdd) {
        RowMeta rowMeta = ds.getRowMeta();
        if (rowMeta.getFields().length > 0) {
            int count = ds.copy().count(ds.getRowMeta().getField(0).getName(), Boolean.FALSE.booleanValue());
            this.checkCount(count, isAdd);
        }
    }

    private void checkCount(int count, boolean isAdd) {
        this.maxCountHandler();
        if (count > this.maxCount) {
            this.throwCountOutErr(count, this.maxCount);
        }
        if (isAdd) {
            this.resCount += count;
        }
        if (this.resCount > this.maxCount) {
            this.throwCountOutErr(this.resCount, this.maxCount);
        }
    }

    private void maxCountHandler() {
        Pattern pattern = Pattern.compile("[0-9]*");
        String textCfg = ParamSettingServiceHelper.getString((long)0L, (String)"PSystemPermReportLimit");
        if (StringUtils.isNotEmpty((CharSequence)textCfg)) {
            Matcher isNum = pattern.matcher(textCfg);
            if (isNum.matches()) {
                try {
                    this.maxCount = Integer.parseInt(textCfg);
                }
                catch (Exception e) {
                    log.error("\u5b57\u7b26\u4e32\u53c2\u6570\u5f3a\u8f6cInteger\u6570\u5b57\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u5185\u5bb9\uff1a" + e.getMessage());
                }
            } else {
                log.error("\u53c2\u6570\u5185\u5bb9\u5305\u542b\u975e\u6570\u5b57");
            }
        }
    }

    private void throwCountOutErr(int resCount, int maxCount) {
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u9650\u5206\u914d\u8bb0\u5f55\u8fc7\u591a,\u8bf7\u6dfb\u52a0\u67e5\u8be2\u6761\u4ef6\u67e5\u8be2\u3002(\u5f53\u524d:%1$s,\u9650\u5236:%2$s)", (String)"EpbsSystemPermData_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), resCount, maxCount));
    }

    static class GroupConcat
    extends CustomAggFunction<String> {
        private String separator;

        public GroupConcat(String separator) {
            super("group_concat", (DataType)DataType.StringType);
            this.separator = separator;
        }

        public String newAggValue() {
            return "";
        }

        public String addValue(String aggValue, Object value) {
            return aggValue + this.separator + value;
        }

        public String combineAggValue(String aggValue, String aggValue2) {
            return aggValue + aggValue2;
        }

        public Object getResult(String aggValue) {
            if (StringUtils.isEmpty((CharSequence)aggValue)) {
                return aggValue;
            }
            return aggValue.substring(1);
        }
    }
}

