/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.fun;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.bd.model.ModelF7ParamContext;
import kd.epm.epbs.business.bd.model.ModelListHelper;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.epm.epbs.business.permission.model.ModelPermHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.PermItemBean;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.configuration.register.PermItemListRegister;
import kd.epm.epbs.common.configuration.register.PropRegisterFactory;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;
import kd.epm.epbs.formplugin.permission.admin.ModelAdminAssignHelper;
import org.apache.commons.lang3.StringUtils;

public class EpbsSystemPermPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String PERMITEMSEL = "permitemsel";
    private static final String USERS = "users";
    private static final String ID = "id";
    private static final String MODEL = "model";
    private static final String QUERYSELECT = "queryselect";
    private static final String BYUSER = "byuser";
    private static final String ISBYUSER = "isbyuser";
    private static final String ROLES = "roles";
    private static final String USER_ID = "user.id";
    private static final String BCM_MODEL = "bcm_model";
    private static final String EPBS_MODEL = "epbs_model";
    private static final String ORG_ID = "org.id";
    private static final String APPID = "appid";
    private static final String BYROLE = "byrole";
    private static final String REPORTLISTAP = "reportlistap";
    private static final String PERM_USERPERM = "perm_userperm";
    private static final String PERM_USERROLE = "perm_userrole";
    private static final String TOOLBARAP = "toolbarap";
    private static final String DIMTYPEID = "dimtypeid";
    private static final String UNIONREPORT = "unionreport";
    private static final String FUNCTIONPERMLOG = "functionpermlog";
    private static final String BCM_UNIONPERMREPORT = "bcm_unionperm_report";
    private static final String ISINCLUDEALLSUB = "isIncludeAllSub";
    private static final String BIZDOMAIN = "bizdomain";
    private static final String FORMSHOWPARAM_DIMENSION = "FormShowParam_dimension";
    private static final String RPT = "rpt";
    private static final String REPORTTYPE = "ReportType";
    private static final String EXPORTEXCEL = "exportexcel";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{USERS});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ROLES});
        this.getModel().setValue(QUERYSELECT, (Object)BYUSER);
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        if (model != null) {
            String modelId = model.getString(ID);
            Set modelIds = ModelPermHelper.getLimitedModelListByUser((AppTypeEnum[])AppTypeEnum.values());
            if (modelIds.contains(Long.parseLong(modelId))) {
                this.getModel().setValue(MODEL, (Object)Long.valueOf(modelId));
            }
        }
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        String queryselect = (String)this.getModel().getValue(QUERYSELECT);
        if (StringUtils.equals((CharSequence)BYUSER, (CharSequence)queryselect)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{USERS});
            this.getView().setVisible(Boolean.FALSE, new String[]{ROLES});
        } else if (StringUtils.equals((CharSequence)BYROLE, (CharSequence)queryselect)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{USERS});
            this.getView().setVisible(Boolean.TRUE, new String[]{ROLES});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit permitemsel = (BasedataEdit)this.getControl(PERMITEMSEL);
        permitemsel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit users = (BasedataEdit)this.getControl(USERS);
        users.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit roles = (BasedataEdit)this.getControl(ROLES);
        roles.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(MODEL);
        if (null != basedataEdit) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)UNIONREPORT, (CharSequence)key)) {
            IFormView mainPageView = this.getView().getMainView();
            IFormView parentView = this.getView().getParentView();
            String pageId = this.getView().getPageId() + BCM_UNIONPERMREPORT;
            if (mainPageView.getView(pageId) == null) {
                ReportShowParameter form = new ReportShowParameter();
                form.setFormId(BCM_UNIONPERMREPORT);
                form.setPageId(pageId);
                form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                form.getOpenStyle().setTargetKey("_submaintab_");
                form.setCustomParam(MODEL, (Object)this.getPageCache().get(MODEL));
                parentView.showForm((FormShowParameter)form);
                this.getView().sendFormAction(parentView);
            } else {
                IFormView childFormView = mainPageView.getView(pageId);
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            }
        } else if (StringUtils.equals((CharSequence)FUNCTIONPERMLOG, (CharSequence)key)) {
            IFormView mainPageView = this.getView().getMainView();
            IFormView parentView = this.getView().getParentView();
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model == null) {
                this.getView().showTipNotification(ModelListHelper.getDelMessage());
                return;
            }
            String pageId = this.getView().getPageId() + "epbs_functionpermlog_list";
            if (mainPageView.getView(pageId) == null) {
                FormShowParameter form = new FormShowParameter();
                form.setFormId("epbs_functionpermlog_list");
                form.setPageId(pageId);
                form.setCustomParam("KEY_MODEL_ID", (Object)model.getString(ID));
                form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                form.getOpenStyle().setTargetKey("_submaintab_");
                parentView.showForm(form);
                this.getView().sendFormAction(parentView);
            } else {
                IFormView childFormView = mainPageView.getView(pageId);
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        String appId;
        HashMap<String, Object> customParam = new HashMap<String, Object>(10);
        String appNumber = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && StringUtils.isNotEmpty((CharSequence)(appId = AppMetadataCache.getAppInfo((String)appNumber).getId()))) {
            customParam.put(APPID, appId);
        }
        customParam.put(ISBYUSER, this.getModel().getValue(QUERYSELECT));
        queryParam.setCustomParam(customParam);
    }

    private List<Long> getIdList(DynamicObjectCollection objList) {
        ArrayList<Long> idList = new ArrayList<Long>(objList.size());
        for (DynamicObject object : objList) {
            idList.add(object.getLong(ID));
        }
        return idList;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        if (StringUtils.isEmpty((CharSequence)filterInfo.getString(MODEL)) || this.getModel().getValue(MODEL) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u4f53\u7cfb\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"EpbsSystemPermPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.getView().getFormShowParameter().getAppId()) || StringUtils.isEmpty((CharSequence)AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"appid\u4e3a\u7a7a\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u8bd5", (String)"EpbsSystemPermPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getPageCache().put(MODEL, ((DynamicObject)filterInfo.getValue(MODEL)).getString(ID));
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            this.getModel().setValue(USERS, null);
            this.getModel().setValue(ROLES, null);
            this.getModel().setValue(PERMITEMSEL, null);
            if (this.getModel().getValue(MODEL) != null) {
                String appNum = this.getModel2AppNum();
                this.getView().setVisible(Boolean.valueOf(AppTypeEnum.isCMApp((String)appNum)), new String[]{UNIONREPORT});
            }
        }
        if (StringUtils.equals((CharSequence)QUERYSELECT, (CharSequence)key)) {
            String queryselect = (String)this.getModel().getValue(QUERYSELECT);
            if (StringUtils.equals((CharSequence)BYUSER, (CharSequence)queryselect)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{USERS});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ROLES});
            } else if (StringUtils.equals((CharSequence)BYROLE, (CharSequence)queryselect)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{USERS});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{ROLES});
            }
            ItemClickEvent itemClickEvent = new ItemClickEvent((Object)this.getView().getControl(TOOLBARAP), "refresh", "refresh");
            this.itemClick(itemClickEvent);
            this.getControl(REPORTLISTAP).getView().updateView();
        }
    }

    private String getModel2AppNum() {
        return ModelCacheHelper.getModel((long)IDUtils.toLong2((Object)this.getModel().getValue(MODEL))).getSrcAppNum();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (e.getSource() instanceof ReportView && this.getModel().getValue(MODEL) != null) {
            String appNum = this.getModel2AppNum();
            this.getView().setVisible(Boolean.valueOf(AppTypeEnum.isCMApp((String)appNum)), new String[]{UNIONREPORT});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = ((BasedataEdit)event.getSource()).getKey();
        if (PERMITEMSEL.equals(key)) {
            PermItemListRegister instance = (PermItemListRegister)PropRegisterFactory.createInstance(PermItemListRegister.class);
            HashSet<String> permIds = new HashSet<String>();
            EpbsSystemPermPlugin.addPermIds((Map)instance.getResult(AppTypeEnum.EPBS.getAppNum()), permIds);
            if (this.getModel().getValue(MODEL) != null) {
                Object result;
                String appNum = this.getModel2AppNum();
                if (AppTypeEnum.isCMApp((String)appNum)) {
                    result = instance.getResultWithRemote(AppTypeEnum.CM.getAppNum());
                    EpbsSystemPermPlugin.addPermIds((Map<String, Map<String, PermItemBean>>)result, permIds, "bcm_");
                }
                if (AppTypeEnum.isFarApp((String)appNum)) {
                    result = instance.getResultWithRemote(AppTypeEnum.FAR.getAppNum());
                    EpbsSystemPermPlugin.addPermIds((Map<String, Map<String, PermItemBean>>)result, permIds, "fidm_", "far_");
                }
                if (AppTypeEnum.isEbApp((String)appNum)) {
                    EpbsSystemPermPlugin.addPermIds(instance.getResultWithRemote(AppTypeEnum.EB.getAppNum()), permIds);
                }
            }
            QFilter qFilter = new QFilter(ID, "in", permIds);
            event.addCustomQFilter(qFilter);
        }
        if (MODEL.equals(key) && StringUtils.isNotEmpty((CharSequence)MODEL) && this.getControl(MODEL) != null) {
            ModelF7ParamContext modelF7Param = this.getModelF7Param();
            event.addCustomQFilter(modelF7Param.genQFilter());
            event.getFormShowParameter().setCustomParam("f7params", (Object)ObjectSerialUtil.toByteSerialized((Object)modelF7Param));
        }
        if (USERS.equals(key)) {
            if (this.getModel().getValue(MODEL) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u4f53\u7cfb\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"EpbsSystemPermPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            event.getFormShowParameter().setCustomParam("isOrgBaseAdmin", (Object)ParamSettingServiceHelper.getBoolean((long)0L, (String)"P006"));
            Long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID);
            DynamicObjectCollection permUserperm = QueryServiceHelper.query((String)PERM_USERPERM, (String)USER_ID, (QFilter[])new QFilter[]{new QFilter(ORG_ID, "=", (Object)modelId)});
            HashSet<Long> userIds = new HashSet<Long>(16);
            for (Object dy : permUserperm) {
                userIds.add(dy.getLong(USER_ID));
            }
            DynamicObjectCollection permUserrole = QueryServiceHelper.query((String)PERM_USERROLE, (String)USER_ID, (QFilter[])new QFilter[]{new QFilter(ORG_ID, "=", (Object)modelId)});
            for (DynamicObject dy2 : permUserrole) {
                userIds.add(dy2.getLong(USER_ID));
            }
            QFilter qFilter3 = new QFilter(ID, "in", userIds);
            ArrayList<QFilter> qfList2 = new ArrayList<QFilter>(1);
            qfList2.add(qFilter3);
            event.setCustomQFilters(qfList2);
            event.getFormShowParameter().setCustomParam(ISINCLUDEALLSUB, (Object)true);
        }
        if (ROLES.equals(key)) {
            if (this.getModel().getValue(MODEL) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u4f53\u7cfb\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"EpbsSystemPermPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            ArrayList<QFilter> qfList4 = new ArrayList<QFilter>(1);
            String appId = this.getView().getFormShowParameter().getAppId();
            String string = appId = StringUtils.isNotEmpty((CharSequence)appId) ? appId : AppTypeEnum.EPBS.getAppNum();
            if (AppTypeEnum.EPBS.getAppNum().equals(appId)) {
                qfList4.add(new QFilter(BIZDOMAIN, "!=", (Object)AppMetadataCache.getAppInfo((String)AppTypeEnum.RPT.getAppNum()).getId()));
            } else {
                qfList4.add(new QFilter(BIZDOMAIN, "=", (Object)AppMetadataCache.getAppInfo((String)appId).getId()));
            }
            qfList4.add(new QFilter(DIMTYPEID, "=", (Object)"3Y7TLY6RBS2M"));
            event.setCustomQFilters(qfList4);
            event.getFormShowParameter().setCustomParams(this.getView().getFormShowParameter().getCustomParams());
            event.getFormShowParameter().setCustomParam(FORMSHOWPARAM_DIMENSION, (Object)EPBS_MODEL);
        }
    }

    private static void addPermIds(Map<String, Map<String, PermItemBean>> result, Set<String> permIds) {
        result.forEach((k, v) -> v.forEach((k1, v1) -> permIds.add(v1.getPermItemId())));
    }

    private static void addPermIds(Map<String, Map<String, PermItemBean>> result, Set<String> permIds, String ... prefix) {
        result.forEach((k, v) -> {
            for (String p : prefix) {
                if (!k.startsWith(p)) continue;
                v.forEach((k1, v1) -> permIds.add(v1.getPermItemId()));
            }
        });
    }

    public void afterQuery(ReportQueryParam queryParam) {
        if (this.getModel().getValue(MODEL) != null) {
            OperationLogUtil.writeLog((String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.QUERY, (MultiLangEnumBridge)OperationMsgUtil.getSucStatus());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        if (StringUtils.equals((CharSequence)EXPORTEXCEL, (CharSequence)key)) {
            OperationLogUtil.writeLog((String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.EXPORT, (MultiLangEnumBridge)OperationMsgUtil.getSucStatus());
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        ModelAdminAssignHelper.validateModelAdmin(e);
    }

    private ModelF7ParamContext getModelF7Param() {
        return ModelListHelper.createModelF7Ctx((IFormView)this.getView());
    }
}

