/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.fun;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.epm.epbs.business.log.funperm.FunctionPermLogHelper;
import kd.epm.epbs.business.log.funperm.FunctionPermLogMultiLangEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epbs.formplugin.permission.fun.CommonPermService;
import org.apache.commons.collections.CollectionUtils;

public class EpbsUserAssignRolePlugin
extends AbstractBaseListPlugin
implements ItemClickListener,
CommonPermService {
    private static final WatchLogger log = EpbsLogFactory.getWatchLogInstance(EpbsUserAssignRolePlugin.class);
    private static String OldOrgMapCache = "oldOrgMapCache";
    private static String OldRoleMapCache = "oldRoleMapCache";
    private static String isHavNotTrue = "isHavNotTrue";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (!"epm_roleorguser".equals(this.getView().getEntityId())) {
            Tab tab = (Tab)this.getControl("tab_assign_roleperm");
            tab.addItemClickListener((ItemClickListener)this);
        } else {
            this.addItemClickListeners(new String[]{"baritem_save"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"user"});
        this.getPageCache().put("CustomFilter_DimObjIds", (String)this.getView().getFormShowParameter().getCustomParam("CustomFilter_DimObjIds"));
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("tabpage_assign_role_batch".equals(itemKey) || "baritem_save".equals(itemKey)) {
            DynamicObjectCollection list_org = this.getModel().getEntryEntity("list_org");
            if (CollectionUtils.isEmpty((Collection)list_org)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"EpbsUserAssignRolePlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
            EntryGrid orglist = (EntryGrid)this.getControl("list_org");
            int[] selectRows = orglist.getSelectRows();
            if (selectRows.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"EpbsUserAssignRolePlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
        }
        if ("baritem_save".equals(evt.getItemKey())) {
            this.writePermLogs();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPermCache();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("user".equals(e.getProperty().getName())) {
            this.clearPermCache();
            this.setPermCache();
        }
    }

    private void clearPermCache() {
        this.getPageCache().remove(OldOrgMapCache);
        this.getPageCache().remove(OldRoleMapCache);
    }

    private void setPermCache() {
        if (this.getPageCache().get(OldOrgMapCache) == null) {
            HashMap initRolesMapCache = new HashMap();
            HashMap initModelAndRoleMapCache = new HashMap();
            this.getModel().getEntryEntity("list_org").forEach(v -> {
                String modelId = v.getString("dim_identity");
                DynamicObjectCollection dt = (DynamicObjectCollection)v.get("list_role");
                ArrayList<String> roleIds = new ArrayList<String>(dt.size());
                for (DynamicObject d : dt) {
                    roleIds.add(d.getString("role_identity"));
                    HashMap<String, String> role = new HashMap<String, String>(2);
                    role.put("number", d.getString("role_number.number"));
                    role.put("name", d.getString("role_number.name"));
                    initRolesMapCache.put(d.getString("role_identity"), role);
                }
                initModelAndRoleMapCache.put(modelId, roleIds);
            });
            this.getPageCache().put(OldOrgMapCache, SerializationUtils.toJsonString(initModelAndRoleMapCache));
            this.getPageCache().put(OldRoleMapCache, SerializationUtils.toJsonString(initRolesMapCache));
        }
    }

    private Map<String, List<String>> getCurrentMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        this.getModel().getEntryEntity("list_org").forEach(v -> {
            String modelId = v.getString("dim_identity");
            DynamicObjectCollection dt = (DynamicObjectCollection)v.get("list_role");
            ArrayList<String> roleIds = new ArrayList<String>(dt.size());
            for (DynamicObject d : dt) {
                roleIds.add(d.getString("role_identity"));
            }
            map.put(modelId, roleIds);
        });
        return map;
    }

    protected void writePermLogs() {
        DynamicObject user = (DynamicObject)this.getModel().getValue("user");
        String usernumber = user.getString("number");
        String username = user.getString("name");
        HashMap<String, DynamicObject> newUsersMap = new HashMap<String, DynamicObject>();
        HashMap mapNew = new HashMap();
        this.getModel().getEntryEntity("list_org").forEach(v -> {
            String modelId = v.getString("dim_identity");
            DynamicObjectCollection roleDC = (DynamicObjectCollection)v.get("list_role");
            ArrayList<String> userIds = new ArrayList<String>(roleDC.size());
            for (DynamicObject role : roleDC) {
                userIds.add(role.getString("role_identity"));
                newUsersMap.put(role.getString("role_identity"), (DynamicObject)role.get("role_number"));
            }
            mapNew.put(modelId, userIds);
        });
        String oldOrgMapCache = this.getPageCache().get(OldOrgMapCache);
        HashMap mapOld = (HashMap)SerializationUtils.fromJsonString((String)oldOrgMapCache, Map.class);
        String oldRoleMapCache = this.getPageCache().get(OldRoleMapCache);
        HashMap mapOldRole = (HashMap)SerializationUtils.fromJsonString((String)oldRoleMapCache, Map.class);
        Set oldModelIds = mapOld.keySet();
        Set currentModelIds = mapNew.keySet();
        Set currentModleEntries = mapNew.entrySet();
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>();
        if (mapNew.size() > 0) {
            for (Map.Entry entry : currentModleEntries) {
                String modelId = (String)entry.getKey();
                Long modelID = Long.parseLong(modelId);
                List currentRoleIds = (List)entry.getValue();
                if (currentRoleIds.size() == 0) {
                    this.getPageCache().put(isHavNotTrue, "1");
                    break;
                }
                if (oldModelIds.contains(modelId)) {
                    List oldRoleIds = (List)mapOld.get(modelId);
                    currentRoleIds.removeAll(oldRoleIds);
                    if (currentRoleIds.size() > 0) {
                        this.setNewAddLogs(logs, modelID, currentRoleIds, newUsersMap, usernumber, username);
                    }
                    Map<String, List<String>> currentMap = this.getCurrentMap();
                    List<String> userIdsNewTemp = currentMap.get(modelId);
                    oldRoleIds.removeAll(userIdsNewTemp);
                    if (oldRoleIds.size() <= 0) continue;
                    this.setDelLogs(logs, modelID, oldRoleIds, mapOldRole, usernumber, username);
                    continue;
                }
                this.setNewAddLogs(logs, modelID, currentRoleIds, newUsersMap, usernumber, username);
            }
        }
        oldModelIds.removeAll(currentModelIds);
        if (oldModelIds.size() > 0) {
            for (String oldModel : oldModelIds) {
                List roleIds = (List)mapOld.get(oldModel);
                this.setDelLogs(logs, Long.parseLong(oldModel), roleIds, mapOldRole, usernumber, username);
            }
        }
        if (!logs.isEmpty() && this.getPageCache().get(isHavNotTrue) == null) {
            try {
                FunctionPermLogHelper.batchInsertFunctionPermLog(logs);
                this.clearPermCache();
                this.setPermCache();
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
        }
        this.getPageCache().remove(isHavNotTrue);
    }

    private void setNewAddLogs(ArrayList<DynamicObject> logs, Long modelId, List<String> currentRoleIds, HashMap<String, DynamicObject> newUsersMap, String usernumber, String username) {
        String appId = this.getView().getFormShowParameter().getAppId();
        for (String roleId : currentRoleIds) {
            DynamicObject role = newUsersMap.get(roleId);
            String role_number = role.getString("number");
            String role_name = role.getString("name");
            String memgerInfo = this.memgerRoleInfo(role_number, role_name);
            DynamicObject log1 = FunctionPermLogHelper.newRolePermLog((Long)modelId, (String)usernumber, (String)username, (String)(FunctionPermLogMultiLangEnum.Role_Distribute.getOperateName() + memgerInfo), (String)appId);
            logs.add(log1);
        }
    }

    private void setDelLogs(ArrayList<DynamicObject> logs, Long modelId, List<String> oldRoleIds, HashMap<String, Map<String, String>> mapOldRole, String usernumber, String username) {
        String appId = this.getView().getFormShowParameter().getAppId();
        for (String roleId : oldRoleIds) {
            LinkedHashMap userItems = (LinkedHashMap)mapOldRole.get(roleId);
            String role_number = (String)userItems.get("number");
            String role_name = (String)userItems.get("name");
            String memgerInfo = this.memgerRoleInfo(role_number, role_name);
            DynamicObject log1 = FunctionPermLogHelper.newRolePermLog((Long)modelId, (String)usernumber, (String)username, (String)(FunctionPermLogMultiLangEnum.Role_DelDistribute.getOperateName() + memgerInfo), (String)appId);
            logs.add(log1);
        }
    }

    private String memgerRoleInfo(String role_number, String role_name) {
        if (role_name == null || role_number == null) {
            return "";
        }
        return "(" + role_number + "/" + role_name + ")";
    }
}

