/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.fun;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.formplugin.plugin.UserDirectAssignPermPlugin;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.log.funperm.FunctionPermLogHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.formplugin.permission.fun.CommonPermService;
import kd.epm.epbs.formplugin.permission.fun.util.EpbsAllFuncPermTreeUtil;
import org.apache.commons.lang.StringUtils;

public class EpbsUserDirectAssignPermPlugin
extends UserDirectAssignPermPlugin
implements RowClickEventListener,
BeforeF7SelectListener,
CommonPermService {
    protected static WatchLogger log = EpbsLogFactory.getWatchLogInstance((boolean)true, EpbsUserDirectAssignPermPlugin.class);

    public void initialize() {
        super.initialize();
        EntryGrid eg = (EntryGrid)this.getControl("orglist");
        eg.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addClickListeners(new String[]{"btn_addnode"});
        BasedataEdit user = (BasedataEdit)this.getControl("user");
        user.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void initialVariable() {
        super.initialVariable();
        this.allFuncPermTreeUtil = new EpbsAllFuncPermTreeUtil(this.allFuncPermTreeView, this.permPageCacheUtil.get("FormShowParam_appNum"), "DIM_EPBS_MODEL", this.getCurSelDimObjId());
    }

    private Long getCurSelDimObjId() {
        int focusRow = this.getModel().getEntryCurrentRowIndex("orglist");
        if (focusRow == -1) {
            return -1L;
        }
        String strDimObjId = (String)this.getModel().getValue("org_id", focusRow);
        if (StringUtils.isNotEmpty((String)strDimObjId)) {
            return Long.parseLong(strDimObjId);
        }
        return -1L;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String clickKey = control.getKey();
        if (!"btn_addnode".equals(clickKey)) {
            return;
        }
        Long curSelDimObjId = this.getCurSelDimObjId();
        DynamicObject modelObj = QueryServiceHelper.queryOne((String)"epbs_model", (String)"srcappnum", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)curSelDimObjId)});
        if (modelObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u4f53\u7cfb\u4fe1\u606f\u3002", (String)"EpbsUserDirectAssignPermPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        String appnum = modelObj.getString("srcappnum");
        AppTypeEnum applicationType = AppTypeEnum.getEnumByAppnum((String)appnum);
        if (applicationType == AppTypeEnum.BGMD) {
            return;
        }
        List selectedNodes = this.allFuncPermTreeView.getTreeState().getSelectedNodes();
        String ebAppNodeId = this.getAppId(AppTypeEnum.EB.getAppNum());
        String cloudNodeId = "";
        boolean containEbEntity = false;
        boolean containEbAppNode = false;
        boolean containCloudNode = false;
        for (Map node : selectedNodes) {
            String nodeId = node.get("id").toString();
            if (nodeId.indexOf("#cloud") > 0) {
                containCloudNode = true;
                cloudNodeId = nodeId;
                continue;
            }
            if (ebAppNodeId.equals(nodeId)) {
                containEbAppNode = true;
                continue;
            }
            String parentId = node.get("parentid").toString();
            if (!ebAppNodeId.equals(parentId)) continue;
            containEbEntity = true;
        }
        if (containEbAppNode) {
            if (containCloudNode) {
                this.allFuncPermTreeView.uncheckNode(cloudNodeId);
                this.allFuncPermTreeView.uncheckNode("root#FIRST");
            }
            this.allFuncPermTreeView.uncheckNode(ebAppNodeId);
            if (!containEbEntity) {
                ((EpbsAllFuncPermTreeUtil)this.allFuncPermTreeUtil).queryTreeNodeChildren(new TreeNodeEvent((Object)this, (Object)cloudNodeId, (Object)ebAppNodeId), true);
                this.allFuncPermTreeView.collapse(ebAppNodeId);
            }
        } else if (containCloudNode) {
            this.allFuncPermTreeView.uncheckNode(cloudNodeId);
            this.allFuncPermTreeView.uncheckNode("root#FIRST");
            this.allFuncPermTreeUtil.queryTreeNodeChildren(new TreeNodeEvent((Object)this, (Object)"", (Object)cloudNodeId));
            this.allFuncPermTreeView.expand(cloudNodeId);
            ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>(16);
            appNodes.add(new TreeNode(cloudNodeId, this.getAppId(AppTypeEnum.BGC.getAppNum()), ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236", (String)"EpbsUserDirectAssignPermPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), true));
            this.allFuncPermTreeView.checkNodes(appNodes);
            ((EpbsAllFuncPermTreeUtil)this.allFuncPermTreeUtil).queryTreeNodeChildren(new TreeNodeEvent((Object)this, (Object)cloudNodeId, (Object)ebAppNodeId), true);
            if (!containEbEntity) {
                this.allFuncPermTreeView.collapse(ebAppNodeId);
            }
            this.allFuncPermTreeView.collapse(cloudNodeId);
        }
    }

    private String getAppId(String appNum) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNum);
        return appInfo.getId() + "#app";
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        arg0.getFormShowParameter().setHasRight(true);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (modelId == null) {
            return;
        }
        DynamicObject user = (DynamicObject)this.getModel().getValue("user");
        String key = evt.getItemKey();
        try {
            Class<?> uDAPClass = Class.forName("kd.bos.permission.formplugin.plugin.UserDirectAssignPermPlugin");
            Set methods = Arrays.stream(uDAPClass.getDeclaredMethods()).map(Method::getName).collect(Collectors.toSet());
            if ("baritem_save".equals(key) && !methods.contains("taskCallBack")) {
                OperationLogUtil.writeLog((String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.SAVE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u7528\u6237\u76f4\u63a5\u6388\u6743", "EpbsUserDirectAssignPermPlugin_3", "epm-epbs-formplugin"));
                if (this.isMergeControl()) {
                    HashMap<String, List<String>> entityPermItemMap = new HashMap<String, List<String>>();
                    entityPermItemMap.put("bcm_report_list", Arrays.asList("4730fc9f000026ae", "4730fc9f000025ae"));
                    entityPermItemMap.put("bcm_convertschemelist", Collections.singletonList("4730fc9f000025ae"));
                    this.addPermByModel(modelId, entityPermItemMap, user.getString("id"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        if (evt.getRow() < 0) {
            return;
        }
        DynamicObjectCollection dyc = this.getModel().getEntryEntity("orglist");
        DynamicObject selectDynamicObject = (DynamicObject)dyc.get(evt.getRow());
        String modelId = selectDynamicObject.getString("org_id");
        this.getPageCache().put("KEY_MODEL_ID", modelId);
        String models = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_dimensionObjIds");
        this.getView().setEnable(Boolean.valueOf(models.contains(modelId)), new String[]{"btn_addnode", "btn_delnode", "delete_org"});
        if (kd.bos.util.StringUtils.isEmpty((String)this.getPageCache().get("beforeSaveUserOrgsPermItems"))) {
            this.setDefaultUserOrgsPermCache();
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        log.info("FunctionPermLogHelper-clientCallBack \u5f02\u6b65\u65b9\u6cd5\u6b63\u5728\u6267\u884c");
        if (kd.bos.util.StringUtils.isEmpty((String)this.getPageCache().get("beforeSaveUserOrgsPermItems"))) {
            this.setDefaultUserOrgsPermCache();
        }
    }

    private void setDefaultUserOrgsPermCache() {
        Map afterSaveMap = FunctionPermLogHelper.getAfterSaveOrgPermItems((IFormView)this.getView());
        this.getPageCache().put("beforeSaveUserOrgsPermItems", SerializationUtils.toJsonString((Object)afterSaveMap));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("user".equals(e.getProperty().getName())) {
            DynamicObject user = (DynamicObject)this.getModel().getValue("user");
            if (user != null && user.getLong("id") != RequestContext.getOrCreate().getCurrUserId()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"baritem_save"});
            }
            this.clearPermCache();
            this.setDefaultUserOrgsPermCache();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"dim_num", "dim_name"});
    }

    private void clearPermCache() {
        this.getPageCache().remove("beforeSaveUserOrgsPermItems");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (StringUtils.equals((String)actionId, (String)"taskcloseback") && returnData instanceof Map) {
            Map dataMap;
            String dataType;
            Map result = (Map)returnData;
            String taskInfoStr = (String)result.get("taskinfo");
            if (StringUtils.isBlank((String)taskInfoStr)) {
                return;
            }
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
            if (taskInfo.isTaskEnd() && Objects.equals(dataType = String.valueOf((dataMap = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class)).get("msgType")), "successNotice")) {
                String modelId = this.getPageCache().get("KEY_MODEL_ID");
                if (modelId == null) {
                    return;
                }
                try {
                    FunctionPermLogHelper.writeUserDirectAssignPermLog((IFormView)this.getView());
                }
                catch (Exception expt) {
                    log.error("FunctionPermLogHelper-itemClick-writeFunPermLog() \u6267\u884c\u5931\u8d25");
                }
                boolean isMergeControl = this.isMergeControl();
                if (isMergeControl) {
                    HashMap<String, List<String>> entityPermItemMap = new HashMap<String, List<String>>();
                    entityPermItemMap.put("bcm_report_list", Arrays.asList("4730fc9f000026ae", "4730fc9f000025ae"));
                    entityPermItemMap.put("bcm_convertschemelist", Collections.singletonList("4730fc9f000025ae"));
                    this.addPermByModel(modelId, entityPermItemMap, ((DynamicObject)this.getModel().getValue("user")).getString("id"));
                }
            }
        }
    }

    private boolean isMergeControl() {
        boolean isMergeControl = false;
        TreeView treeView = (TreeView)this.getControl("tree_allfunctionperm");
        List checkedNodes = treeView.getTreeState().getCheckedNodes();
        for (Map map : checkedNodes) {
            if (!map.get("id").toString().contains("bcm_mergecontrol") && (!map.get("parentid").toString().contains("bcm_mergecontrol") || !map.get("parentid").toString().contains("/=NAJMRI3LY0") && !map.get("parentid").toString().contains("/=NALZ=PRF4B"))) continue;
            isMergeControl = true;
            break;
        }
        return isMergeControl;
    }

    protected TreeView showTreeView(String treeKey, TreeNode tn) {
        if ("tree_allfunctionperm".equals(treeKey)) {
            String modelAppNum = ModelCacheHelper.getModel((long)this.getCurSelDimObjId()).getSrcAppNum();
            if (!AppTypeEnum.BGMD.getAppNum().equals(modelAppNum)) {
                tn.deleteChildNode(AppMetadataCache.getAppInfoByNumber((String)AppTypeEnum.BGRP.getAppNum()).getCloudId() + "#cloud");
            }
        }
        return super.showTreeView(treeKey, tn);
    }
}

