/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.fun;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.epm.epbs.business.log.funperm.FunctionPermLogHelper;
import kd.epm.epbs.business.log.funperm.FunctionPermLogMultiLangEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.formplugin.permission.fun.PermUserAssignRolePlugin;
import kd.epm.epbs.formplugin.permission.fun.util.RolePermUtils;

public class PermAssignUserRolePlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final WatchLogger log = EpbsLogFactory.getWatchLogInstance(PermUserAssignRolePlugin.class);
    private static final String OldUserAndModelCache = "oldUserAndModelMapCache";
    private static final String OldUserMapCache = "oldUserMapCache";
    private static final String HavOldUserAndOrgSetCache = "havOldOrgAndUserSetCache";
    private static final String MODEL_ID = "org_id_temp";
    private static final String USER_LIST = "userlist";
    private static final String ORG_LIST = "orglist";
    private static final String USER_ID = "user.id";
    private static final String isHavNotTrue = "isHavNotTrue";
    private static final String isLatesVersion = "isLatesVersion";
    private static final String ORG = "orglist_visiable";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid eg = (EntryGrid)this.getControl(USER_LIST);
        eg.addRowClickListener((RowClickEventListener)this);
        EntryGrid orgEg = (EntryGrid)this.getControl(ORG);
        orgEg.addRowClickListener((RowClickEventListener)this);
        this.itemClickListeners();
    }

    private void itemClickListeners() {
        Toolbar userToolBar = (Toolbar)this.getControl("toolbar_user");
        userToolBar.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().getPageCache().put("CustomFilter_DimObjIds", (String)this.getView().getFormShowParameter().getCustomParam("CustomFilter_DimObjIds"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPermCache();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("role_number".equals(e.getProperty().getName())) {
            this.clearPermCache();
            this.setPermCache();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("bar_save".equals(evt.getItemKey())) {
            this.writePermLogs();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int[] selectedRows = ((EntryGrid)this.getView().getControl(USER_LIST)).getEntryState().getSelectedRows();
        EntryGrid source = (EntryGrid)evt.getSource();
        String entryKey = source.getEntryKey();
        if (USER_LIST.equals(entryKey)) {
            for (int selectedRow : selectedRows) {
                RolePermUtils.isInitHavOrgOrUserFlag(selectedRow, this.getView(), USER_LIST, USER_ID, OldUserMapCache, HavOldUserAndOrgSetCache);
            }
        }
    }

    private void clearPermCache() {
        this.getPageCache().remove(OldUserAndModelCache);
        this.getPageCache().remove(OldUserMapCache);
        this.getPageCache().remove(HavOldUserAndOrgSetCache);
        this.getPageCache().put(isLatesVersion, "0");
    }

    private void setPermCache() {
        this.getPageCache().put(isLatesVersion, "0");
        if (this.getPageCache().get(OldUserAndModelCache) == null) {
            HashMap initUsersMapCache = new HashMap(12);
            HashMap initModelAndUserMapCache = new HashMap(12);
            HashSet havLoadOrgsSet = new HashSet(12);
            this.getModel().getEntryEntity(USER_LIST).stream().forEach(v -> {
                String userId = v.getString(USER_ID);
                HashMap<String, String> user = new HashMap<String, String>(2);
                user.put("number", v.getString("user.number"));
                user.put("name", v.getString("user.name"));
                initUsersMapCache.put(userId, user);
                DynamicObjectCollection dt = (DynamicObjectCollection)v.get(ORG_LIST);
                ArrayList<String> models = new ArrayList<String>(dt.size());
                for (DynamicObject d : dt) {
                    models.add(d.getString(MODEL_ID));
                }
                initModelAndUserMapCache.put(userId, models);
                if (models.size() == 0) {
                    this.getPageCache().put(isLatesVersion, "1");
                } else {
                    havLoadOrgsSet.add(userId);
                }
            });
            this.getPageCache().put(OldUserAndModelCache, SerializationUtils.toJsonString(initModelAndUserMapCache));
            this.getPageCache().put(OldUserMapCache, SerializationUtils.toJsonString(initUsersMapCache));
            this.getPageCache().put(HavOldUserAndOrgSetCache, SerializationUtils.toJsonString(havLoadOrgsSet));
        }
    }

    private void writePermLogs() {
        DynamicObject role_number1 = (DynamicObject)this.getModel().getValue("role_number");
        String role_number = role_number1.getString("number");
        String role_name = role_number1.getString("name");
        String memgerInfo = "(" + role_number + "/" + role_name + ")";
        String appId = this.getView().getFormShowParameter().getAppId();
        HashMap newUsersMap = new HashMap();
        HashMap mapNew = new HashMap();
        this.getModel().getEntryEntity(USER_LIST).stream().forEach(v -> {
            String userId = v.getString(USER_ID);
            HashMap<String, String> user = new HashMap<String, String>(2);
            user.put("number", v.getString("user.number"));
            user.put("name", v.getString("user.name"));
            newUsersMap.put(userId, user);
            DynamicObjectCollection dt = (DynamicObjectCollection)v.get(ORG_LIST);
            ArrayList<String> models = new ArrayList<String>(dt.size());
            for (DynamicObject d : dt) {
                models.add(d.getString(MODEL_ID));
            }
            mapNew.put(userId, models);
        });
        String oldOrgLists = this.getPageCache().get(OldUserAndModelCache);
        HashMap mapOld = (HashMap)SerializationUtils.fromJsonString((String)oldOrgLists, Map.class);
        boolean latesVersion = RolePermUtils.isLatesVersion(this.getView(), isLatesVersion);
        HashSet<String> oldHavOrgSet = new HashSet(12);
        if (latesVersion) {
            String havOldOrg = this.getPageCache().get(HavOldUserAndOrgSetCache);
            oldHavOrgSet = (Set)SerializationUtils.fromJsonString((String)havOldOrg, Set.class);
            this.getSelectRowOrgUsers(oldHavOrgSet, mapOld);
        }
        String oldUserLists = this.getPageCache().get(OldUserMapCache);
        HashMap mapOldUser = (HashMap)SerializationUtils.fromJsonString((String)oldUserLists, Map.class);
        Set oldUserIds = mapOld.keySet();
        Set newUserIds = mapNew.keySet();
        Set entrySet = mapNew.entrySet();
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>();
        if (mapNew.size() > 0) {
            for (Map.Entry entry : entrySet) {
                String userId = (String)entry.getKey();
                if (latesVersion && oldUserIds.contains(userId) && !oldHavOrgSet.contains(userId)) continue;
                List modelIdsNew = (List)entry.getValue();
                if (modelIdsNew.size() == 0) {
                    this.getPageCache().put(isHavNotTrue, "1");
                    break;
                }
                Map user = (Map)newUsersMap.get(userId);
                String usernumber = (String)user.get("number");
                String username = (String)user.get("name");
                if (oldUserIds.contains(userId)) {
                    List modelIdsOld = (List)mapOld.get(userId);
                    modelIdsNew.removeAll(modelIdsOld);
                    if (modelIdsNew.size() > 0) {
                        for (String modelId : modelIdsNew) {
                            DynamicObject log1 = FunctionPermLogHelper.newRolePermLog((Long)Long.parseLong(modelId), (String)usernumber, (String)username, (String)(FunctionPermLogMultiLangEnum.Role_Distribute.getOperateName() + memgerInfo), (String)appId);
                            logs.add(log1);
                        }
                    }
                    Map<String, List<String>> currentMap = this.getCurrentMap();
                    List<String> userIdsNewTemp = currentMap.get(userId);
                    modelIdsOld.removeAll(userIdsNewTemp);
                    if (modelIdsOld.size() <= 0) continue;
                    Iterator iterator = modelIdsOld.iterator();
                    while (iterator.hasNext()) {
                        String modelId = (String)iterator.next();
                        DynamicObject log1 = FunctionPermLogHelper.newRolePermLog((Long)Long.parseLong(modelId), (String)usernumber, (String)username, (String)(FunctionPermLogMultiLangEnum.Role_DelDistribute.getOperateName() + memgerInfo), (String)appId);
                        logs.add(log1);
                    }
                    continue;
                }
                for (String modelId : modelIdsNew) {
                    DynamicObject log1 = FunctionPermLogHelper.newRolePermLog((Long)Long.parseLong(modelId), (String)usernumber, (String)username, (String)(FunctionPermLogMultiLangEnum.Role_Distribute.getOperateName() + memgerInfo), (String)appId);
                    logs.add(log1);
                }
            }
        }
        oldUserIds.removeAll(newUserIds);
        if (oldUserIds.size() > 0) {
            for (String oldUserId : oldUserIds) {
                Map user = (Map)mapOldUser.get(oldUserId);
                String usernumber = (String)user.get("number");
                String username = (String)user.get("name");
                List oldModels = (List)mapOld.get(oldUserId);
                for (String modelId : oldModels) {
                    DynamicObject log1 = FunctionPermLogHelper.newRolePermLog((Long)Long.parseLong(modelId), (String)usernumber, (String)username, (String)(FunctionPermLogMultiLangEnum.Role_DelDistribute.getOperateName() + memgerInfo), (String)appId);
                    logs.add(log1);
                }
            }
        }
        if (logs.size() > 0 && this.getPageCache().get(isHavNotTrue) == null) {
            try {
                FunctionPermLogHelper.batchInsertFunctionPermLog(logs);
                this.clearPermCache();
                this.setPermCache();
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
        }
        this.getPageCache().remove(isHavNotTrue);
    }

    private void getSelectRowOrgUsers(Set<String> userIds, final Map<String, List<String>> userOrgMapCache) {
        DynamicObject role = (DynamicObject)this.getModel().getValue("role_number");
        String roleId = (String)role.getPkValue();
        String sql1 = "SELECT t1.fuserid,t1.forgid from t_perm_userrole t1 where t1.froleid = ? and t1.fuserid in (" + RolePermUtils.getPlaceholder(userIds) + ")";
        Object[] params = new Object[]{roleId};
        DB.query((DBRoute)DBRoute.base, (String)sql1, (Object[])params, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String forgid = rs.getString("forgid");
                    String fuserid = rs.getString("fuserid");
                    List orgList = (List)userOrgMapCache.get(fuserid);
                    orgList.add(forgid);
                    userOrgMapCache.put(fuserid, orgList);
                }
                return null;
            }
        });
    }

    private Map<String, List<String>> getCurrentMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        this.getModel().getEntryEntity(USER_LIST).stream().forEach(v -> {
            String userId = v.getString(USER_ID);
            DynamicObjectCollection dt = (DynamicObjectCollection)v.get(ORG_LIST);
            ArrayList<String> models = new ArrayList<String>(dt.size());
            for (DynamicObject d : dt) {
                models.add(d.getString(MODEL_ID));
            }
            map.put(userId, models);
        });
        return map;
    }
}

