/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.permission.fun;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.epm.epbs.business.log.funperm.FunctionPermLogHelper;
import kd.epm.epbs.business.log.funperm.FunctionPermLogMultiLangEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.formplugin.permission.fun.util.RolePermUtils;

public class PermUserAssignRolePlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final WatchLogger log = EpbsLogFactory.getWatchLogInstance(PermUserAssignRolePlugin.class);
    private final String OldOrgMapCache = "oldOrgMapCache";
    private final String OldUseMapCache = "oldUseMapCache";
    private final String HavOldOrgAndUserSetCache = "havOldOrgAndUserSetCache";
    private final String MODEL_ID = "org_id_temp";
    private final String USER_LIST = "userlist";
    private final String ORG_LIST = "orglist";
    private final String isHavNotTrue = "isHavNotTrue";
    private final String isLatesVersion = "isLatesVersion";
    private final String USER = "userlist_visiable";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        ((EntryGrid)this.getControl("orglist")).addRowClickListener((RowClickEventListener)this);
        ((EntryGrid)this.getControl("userlist_visiable")).addRowClickListener((RowClickEventListener)this);
        this.itemClickListeners();
    }

    private void itemClickListeners() {
        Toolbar orgToolBar = (Toolbar)this.getControl("toolbar_org");
        orgToolBar.addItemClickListener((ItemClickListener)this);
        Toolbar userToolBar = (Toolbar)this.getControl("toolbar_user");
        userToolBar.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().getPageCache().put("CustomFilter_DimObjIds", (String)this.getView().getFormShowParameter().getCustomParam("CustomFilter_DimObjIds"));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("bar_save".equals(evt.getItemKey())) {
            this.writePermLogs();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPermCache();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("role_number".equals(e.getProperty().getName())) {
            this.clearPermCache();
            this.setPermCache();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int[] selectedRows = ((EntryGrid)this.getView().getControl("orglist")).getEntryState().getSelectedRows();
        EntryGrid source = (EntryGrid)evt.getSource();
        String entryKey = source.getEntryKey();
        if ("orglist".equals(entryKey)) {
            for (int selectedRow : selectedRows) {
                RolePermUtils.isInitHavOrgOrUserFlag(selectedRow, this.getView(), "orglist", "org_id_temp", "oldOrgMapCache", "havOldOrgAndUserSetCache");
            }
        }
    }

    private void clearPermCache() {
        this.getPageCache().remove("oldOrgMapCache");
        this.getPageCache().remove("oldUseMapCache");
        this.getPageCache().remove("havOldOrgAndUserSetCache");
        this.getPageCache().put("isLatesVersion", "0");
    }

    private void setPermCache() {
        this.getPageCache().put("isLatesVersion", "0");
        if (this.getPageCache().get("oldOrgMapCache") == null) {
            HashMap initUsersMapCache = new HashMap(12);
            HashMap initModelAndUserMapCache = new HashMap(12);
            HashSet havLoadOrgsSet = new HashSet(12);
            this.getModel().getEntryEntity("orglist").stream().forEach(v -> {
                String modelId = v.getString("org_id_temp");
                DynamicObjectCollection dt = (DynamicObjectCollection)v.get("userlist");
                ArrayList<String> userIds = new ArrayList<String>(dt.size());
                for (DynamicObject d : dt) {
                    userIds.add(d.getString("user.id"));
                    HashMap<String, String> user = new HashMap<String, String>(2);
                    user.put("number", d.getString("user.number"));
                    user.put("name", d.getString("user.name"));
                    initUsersMapCache.put(d.getString("user.id"), user);
                }
                initModelAndUserMapCache.put(modelId, userIds);
                if (userIds.size() == 0) {
                    this.getPageCache().put("isLatesVersion", "1");
                } else {
                    havLoadOrgsSet.add(modelId);
                }
            });
            this.getPageCache().put("oldOrgMapCache", SerializationUtils.toJsonString(initModelAndUserMapCache));
            this.getPageCache().put("oldUseMapCache", SerializationUtils.toJsonString(initUsersMapCache));
            this.getPageCache().put("havOldOrgAndUserSetCache", SerializationUtils.toJsonString(havLoadOrgsSet));
        }
    }

    private void writePermLogs() {
        DynamicObject role_number1 = (DynamicObject)this.getModel().getValue("role_number");
        String role_number = role_number1.getString("number");
        String role_name = role_number1.getString("name");
        String memgerInfo = "(" + role_number + "/" + role_name + ")";
        HashMap newUsersMap = new HashMap(12);
        HashMap mapNew = new HashMap(12);
        this.getModel().getEntryEntity("orglist").stream().forEach(v -> {
            String modelId = v.getString("org_id_temp");
            DynamicObjectCollection dt = (DynamicObjectCollection)v.get("userlist");
            ArrayList<String> userIds = new ArrayList<String>(dt.size());
            for (DynamicObject d : dt) {
                userIds.add(d.getString("user.id"));
                newUsersMap.put(d.getString("user.id"), (DynamicObject)d.get("user"));
            }
            mapNew.put(modelId, userIds);
        });
        String oldOrgMapCache = this.getPageCache().get("oldOrgMapCache");
        HashMap mapOld = (HashMap)SerializationUtils.fromJsonString((String)oldOrgMapCache, Map.class);
        boolean latesVersion = RolePermUtils.isLatesVersion(this.getView(), "isLatesVersion");
        HashMap mapOldUser = new HashMap(12);
        HashSet<String> oldHavOrgSet = new HashSet(12);
        if (latesVersion) {
            mapOldUser = new HashMap();
            String havOldOrg = this.getPageCache().get("havOldOrgAndUserSetCache");
            oldHavOrgSet = (Set)SerializationUtils.fromJsonString((String)havOldOrg, Set.class);
            this.getSelectRowOrgUsers(oldHavOrgSet, mapOld, mapOldUser);
        } else {
            String oldUserLists = this.getPageCache().get("oldUseMapCache");
            mapOldUser = (HashMap)SerializationUtils.fromJsonString((String)oldUserLists, Map.class);
        }
        Set oldModels = mapOld.keySet();
        Set newModels = mapNew.keySet();
        Set currentModleEntries = mapNew.entrySet();
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(12);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (mapNew.size() > 0) {
            for (Map.Entry entry : currentModleEntries) {
                String modelId = (String)entry.getKey();
                if (latesVersion && oldModels.contains(modelId) && !oldHavOrgSet.contains(modelId)) continue;
                List userIdsNew = (List)entry.getValue();
                if (userIdsNew.size() == 0) {
                    this.getPageCache().put("isHavNotTrue", "1");
                    break;
                }
                if (oldModels.contains(modelId)) {
                    List userIdsOld = (List)mapOld.get(modelId);
                    userIdsNew.removeAll(userIdsOld);
                    if (userIdsNew.size() > 0) {
                        for (String dn : userIdsNew) {
                            DynamicObject user = (DynamicObject)newUsersMap.get(dn);
                            String usernumber = user.getString("number");
                            String username = user.getString("name");
                            long modelid = Long.parseLong(modelId);
                            DynamicObject log1 = FunctionPermLogHelper.newRolePermLog((Long)modelid, (String)usernumber, (String)username, (String)(FunctionPermLogMultiLangEnum.Role_Distribute.getOperateName() + memgerInfo), (String)appId);
                            logs.add(log1);
                        }
                    }
                    Map<String, List<String>> currentMap = this.getCurrentMap();
                    List<String> userIdsNewTemp = currentMap.get(modelId);
                    userIdsOld.removeAll(userIdsNewTemp);
                    if (userIdsOld.size() <= 0) continue;
                    userIdsOld = userIdsOld.stream().distinct().collect(Collectors.toList());
                    for (String delt : userIdsOld) {
                        LinkedHashMap userItems = (LinkedHashMap)mapOldUser.get(delt);
                        String userNumber = (String)userItems.get("number");
                        String userName = (String)userItems.get("name");
                        long modelid = Long.parseLong(modelId);
                        DynamicObject log1 = FunctionPermLogHelper.newRolePermLog((Long)Long.parseLong(modelId), (String)userNumber, (String)userName, (String)(FunctionPermLogMultiLangEnum.Role_DelDistribute.getOperateName() + memgerInfo), (String)appId);
                        logs.add(log1);
                    }
                    continue;
                }
                for (String dadd : userIdsNew) {
                    DynamicObject user = (DynamicObject)newUsersMap.get(dadd);
                    String usernumber = user.getString("number");
                    String username = user.getString("name");
                    long modelid = Long.parseLong(modelId);
                    DynamicObject log1 = FunctionPermLogHelper.newRolePermLog((Long)Long.parseLong(modelId), (String)usernumber, (String)username, (String)(FunctionPermLogMultiLangEnum.Role_Distribute.getOperateName() + memgerInfo), (String)appId);
                    logs.add(log1);
                }
            }
        }
        oldModels.removeAll(newModels);
        if (oldModels.size() > 0) {
            for (String oldModel : oldModels) {
                List userIds = (List)mapOld.get(oldModel);
                for (String userid : userIds) {
                    LinkedHashMap userItems = (LinkedHashMap)mapOldUser.get(userid);
                    String userNumber = (String)userItems.get("number");
                    String userName = (String)userItems.get("name");
                    long modelid = Long.parseLong(oldModel);
                    DynamicObject log1 = FunctionPermLogHelper.newRolePermLog((Long)modelid, (String)userNumber, (String)userName, (String)(FunctionPermLogMultiLangEnum.Role_DelDistribute.getOperateName() + memgerInfo), (String)appId);
                    logs.add(log1);
                }
            }
        }
        if (logs.size() > 0 && this.getPageCache().get("isHavNotTrue") == null) {
            try {
                FunctionPermLogHelper.batchInsertFunctionPermLog(logs);
                this.clearPermCache();
                this.setPermCache();
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
        }
        this.getPageCache().remove("isHavNotTrue");
    }

    private void getSelectRowOrgUsers(Set<String> orgIds, final Map<String, List<String>> orgUserMapCache, final Map<String, LinkedHashMap<String, String>> usersMapCache) {
        DynamicObject role = (DynamicObject)this.getModel().getValue("role_number");
        String roleId = (String)role.getPkValue();
        String sql1 = "SELECT t1.fuserid,t1.forgid,t2.fnumber,t2.ftruename from t_perm_userrole t1 JOIN t_sec_user t2 ON t1.fuserid = t2.fid  where t1.froleid = ? and t1.forgid in (" + RolePermUtils.getPlaceholder(orgIds) + ")";
        Object[] params = new Object[]{roleId};
        DB.query((DBRoute)DBRoute.base, (String)sql1, (Object[])params, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String forgid = rs.getString("forgid");
                    String fuserid = rs.getString("fuserid");
                    List userList = (List)orgUserMapCache.get(forgid);
                    userList.add(fuserid);
                    orgUserMapCache.put(forgid, userList);
                    LinkedHashMap<String, String> user = new LinkedHashMap<String, String>(2);
                    user.put("number", rs.getString("fnumber"));
                    user.put("name", rs.getString("ftruename"));
                    usersMapCache.put(fuserid, user);
                }
                return null;
            }
        });
    }

    private Map<String, List<String>> getCurrentMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        this.getModel().getEntryEntity("orglist").stream().forEach(v -> {
            String modelId = v.getString("org_id_temp");
            DynamicObjectCollection dt = (DynamicObjectCollection)v.get("userlist");
            ArrayList<String> userIds = new ArrayList<String>(dt.size());
            for (DynamicObject d : dt) {
                userIds.add(d.getString("user.id"));
            }
            map.put(modelId, userIds);
        });
        return map;
    }
}

