/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.treelist;

import java.util.EventObject;
import java.util.Map;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.BillList;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.tree.DynamicTreeContext;
import kd.epm.epbs.common.tree.SimpleDynamicTreeBuilder;
import kd.epm.epbs.formplugin.listf7.AbstractListF7Plugin;

public abstract class AbstractTreeListF7Plugin<T extends DynamicTreeContext>
extends AbstractListF7Plugin
implements TreeNodeClickListener {
    protected static String NODE_ID = "nodeId";
    public static final String TREEVIEWAP = "treeviewap";

    public void initialize() {
        super.initialize();
        TreeView tv = (TreeView)this.getView().getControl(TREEVIEWAP);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
    }

    protected final void initTree() {
        TreeView tv = (TreeView)this.getView().getControl(TREEVIEWAP);
        String focusNodeId = tv.getTreeState().getFocusNodeId();
        T context = this.getDynamicTreeContext();
        if (!StringUtils.isNotEmpty((String)context.getFocusTreeId())) {
            context.setFocusTreeId(focusNodeId);
        }
        AbstractTreeBuilder treeBuilder = this.getTreeBuilder(context);
        treeBuilder.buildTree(tv).nodeClick();
    }

    protected abstract <T extends DynamicTreeContext> T getDynamicTreeContext();

    protected AbstractTreeBuilder getTreeBuilder(T context) {
        return new SimpleDynamicTreeBuilder(context);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        BillList billList = (BillList)this.getControl("billlistap");
        Object nodeId = evt.getNodeId();
        this.getPageCache().put(NODE_ID, (String)nodeId);
        this.refreshLeftBillIst(billList);
    }

    protected void refreshLeftBillIst(BillList billList) {
        billList.clearSelection();
        billList.refresh();
    }

    protected Map<String, Object> getNodeData(String nodeId) {
        TreeNode treeNode;
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        TreeNode root = AbstractTreeBuilder.getRootWithCache((TreeView)tree);
        Map nodeData = null;
        if (root != null && (treeNode = root.getTreeNode(nodeId)) != null) {
            nodeData = (Map)treeNode.getData();
        }
        return nodeData;
    }

    protected String getFocusNodeId() {
        TreeView tree = (TreeView)this.getControl(TREEVIEWAP);
        String focusNodeId = tree.getTreeState().getFocusNodeId();
        if (focusNodeId == null) {
            focusNodeId = this.getPageCache().get(NODE_ID);
        }
        return focusNodeId;
    }
}

