/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.treelist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.ListCache;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowSelectAllEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.formplugin.member.f7.base.AbstractSelectedF7;
import kd.epm.epbs.formplugin.treelist.ICommonSelectedF7Cache;
import kd.epm.epbs.formplugin.treelist.TreeListF7Context;
import kd.epm.epbs.formplugin.treelist.TreeListSelectedF7Helper;
import org.apache.commons.collections4.CollectionUtils;

public class CommonSelectedF7Plugin
extends AbstractSelectedF7
implements ICommonSelectedF7Cache<List<ListSelectedRow>> {
    private TreeListF7Context _ctx;

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setCustomParam("enableListSelected", (Object)1);
    }

    protected TreeListF7Context getCtx() {
        if (this._ctx == null) {
            this._ctx = TreeListSelectedF7Helper.getCtx(this.getView().getFormShowParameter());
        }
        return this._ctx;
    }

    public BillList getBillList() {
        return (BillList)this.getControl("billlistap");
    }

    @Override
    protected void initData() {
        Collection<Object> selectRecords = this.getCtx().getSelectRecords();
        if (CollectionUtils.isNotEmpty(selectRecords)) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", selectRecords)};
            DynamicObjectCollection dys = QueryServiceHelper.query((String)this.getBillList().getBillFormId(), (String)"id,name,number", (QFilter[])filters);
            ArrayList list = new ArrayList(dys.size());
            this.buildSelectedMember((Collection)dys, (id, number, name) -> {
                ListSelectedRow listSelectedRow = new ListSelectedRow();
                listSelectedRow.setPrimaryKeyValue(id);
                listSelectedRow.setNumber(number);
                listSelectedRow.setName(name);
                list.add(listSelectedRow);
            });
            this.cacheSelectMember(this.getPageCache(), list);
            this.updateSelected();
        }
    }

    @Override
    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        this.rowClick(evt);
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        List selected;
        super.listRowDoubleClick(evt);
        this.rowClick(evt);
        if (!(this.getBillList().isMulti() || !CollectionUtils.isNotEmpty((Collection)(selected = (List)this.getSelectedIdsFromCache(this.getPageCache()))) && this.getBillList().isMulti())) {
            this.returnSelectedData(selected);
        }
    }

    protected void returnSelectedData(List<ListSelectedRow> selectData) {
        if (this.getBillList().isMulti() && (selectData == null || selectData.isEmpty())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"CommonSelectedF7Plugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent(selectData);
        this.getView().close();
    }

    @Override
    public void ListRowSelectAllEvent(ListRowSelectAllEvent event) {
        super.ListRowSelectAllEvent(event);
        BillList billList = (BillList)event.getSource();
        this.cacheSelectMember(this.getPageCache(), billList.getSelectedRows());
        this.updateSelected();
    }

    @Override
    public void ListRowClearAllEvent(EventObject event) {
        super.ListRowClearAllEvent(event);
        this.cacheSelectMember(this.getPageCache(), null);
        this.updateSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rowClick(ListRowClickEvent evt) {
        CommonSelectedF7Plugin commonSelectedF7Plugin = this;
        synchronized (commonSelectedF7Plugin) {
            BillList billList;
            ListSelectedRowCollection selectedIds = (ListSelectedRowCollection)this.getSelectedIdsFromCacheWithDefault(this.getPageCache(), () -> Collections.emptyList());
            selectedIds = new ArrayList(selectedIds);
            if (!this.getBillList().isMulti()) {
                selectedIds.clear();
            }
            if (evt.getSource() instanceof BillList && (billList = (BillList)evt.getSource()) != null) {
                ListSelectedRowCollection _selectedIds;
                selectedIds = _selectedIds = evt.getListSelectedRowCollection();
            }
            this.cacheSelectMember(this.getPageCache(), selectedIds);
        }
        this.updateSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectRowsChange(SelectRowsEvent evt) {
        super.selectRowsChange(evt);
        CommonSelectedF7Plugin commonSelectedF7Plugin = this;
        synchronized (commonSelectedF7Plugin) {
            ArrayList selectedIds = new ArrayList((Collection)this.getSelectedIdsFromCacheWithDefault(this.getPageCache(), () -> Collections.emptyList()));
            if (!this.getBillList().isMulti()) {
                selectedIds.clear();
            }
            this.cacheSelectMember(this.getPageCache(), selectedIds);
        }
        this.updateSelected();
    }

    @Override
    public void RemoveClick(F7SelectedListRemoveEvent evt) {
        super.RemoveClick(evt);
        this.f7Select_remove_click(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void f7Select_remove_click(F7SelectedListRemoveEvent evt) {
        Object _param = evt.getParam();
        if (_param == null) {
            this.cacheSelectMember(this.getPageCache(), null);
            this.removeSelectRowState(null);
        } else {
            String removeId = _param.toString();
            CommonSelectedF7Plugin commonSelectedF7Plugin = this;
            synchronized (commonSelectedF7Plugin) {
                ArrayList<ListSelectedRow> selectedIds = new ArrayList<ListSelectedRow>((Collection)this.getSelectedIdsFromCacheWithDefault(this.getPageCache(), () -> Collections.emptyList()));
                selectedIds.removeIf(a -> removeId.equals(a.getPrimaryKeyValue() + ""));
                this.cacheSelectMember(this.getPageCache(), selectedIds);
            }
            this.removeSelectRowState(removeId);
        }
    }

    protected void removeSelectRowState(String rowId) {
        BillList list = (BillList)this.getControl("billlistap");
        if (rowId == null) {
            list.clearSelection();
        } else {
            list.restoreSelection(rowId);
            new ListCache(this.getPageCache()).savePageCache();
        }
    }

    protected void updateSelected() {
        F7SelectedList selectedF7 = (F7SelectedList)this.getControl("rightselect");
        List selectedMembers = (List)this.getSelectedIdsFromCacheWithDefault(this.getPageCache(), () -> Collections.emptyList());
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(10);
        for (ListSelectedRow member : selectedMembers) {
            valueTextItems.add(new ValueTextItem(member.getPrimaryKeyValue() + "", member.getName() + "(" + member.getNumber() + ")"));
        }
        selectedF7.addItems(valueTextItems);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            List selectedIdsFromCache = (List)this.getSelectedIdsFromCache(this.getPageCache());
            if (CollectionUtils.isEmpty((Collection)selectedIdsFromCache)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"CommonSelectedF7Plugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent((Object)selectedIdsFromCache);
            this.getView().close();
        }
    }
}

